/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DynamicObjectUtils {
    public static void setDynamicObjectLPkValue(DynamicObject data, String name, long pkValue) {
        data.set(String.join((CharSequence)"_", name, "id"), (Object)pkValue);
    }

    public static DynamicObject getDynamicObjectByNumber(String easnumber, String entityName) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("number", "=", (Object)easnumber).toArray());
    }

    public static DynamicObject getDynamicObjectById(Object id, String entityName) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)"id");
    }

    public static int getInt(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return 0;
        }
        return item.getInt(key);
    }

    public static long getLong(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return 0L;
        }
        return item.getLong(key);
    }

    public static Object getObjectLong(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        long id = DynamicObjectUtils.getPkValue(item, key);
        return id > 0L ? Long.valueOf(id) : null;
    }

    public static long getPkValue(DynamicObject item, String key) {
        Object o = DynamicObjectUtils.get(item, key);
        if (o instanceof DynamicObject) {
            return ((DynamicObject)o).getLong("id");
        }
        if (o instanceof Long || o instanceof String) {
            return Long.parseLong(o.toString());
        }
        if (item != null && item.getDynamicObjectType().getProperties().containsKey((Object)key)) {
            return item.getLong(String.join((CharSequence)"_", key, "id"));
        }
        return 0L;
    }

    public static long getPkValue(DynamicObject item) {
        return DynamicObjectUtils.getLong(item, "id");
    }

    public static String getStrPkValue(DynamicObject item, String key) {
        return DynamicObjectUtils.getStrPkValue(DynamicObjectUtils.getDynamicObject(item, key));
    }

    public static String getStrPkValue(DynamicObject item) {
        return DynamicObjectUtils.getString(item, "id");
    }

    public static String getString(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return "";
        }
        return item.getString(key);
    }

    public static DynamicObject getDynamicObject(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.getDynamicObject(key);
    }

    public static BigDecimal getBigDecimal(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return BigDecimal.ZERO;
        }
        return item.getBigDecimal(key);
    }

    public static Object get(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.get(key);
    }

    public static boolean getBoolean(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return false;
        }
        return item.getBoolean(key);
    }

    public static DynamicObjectCollection getDynamicObjectCollection(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.get(key) == null) {
            return null;
        }
        return item.getDynamicObjectCollection(key);
    }

    public static Date getDate(DynamicObject item, String key) {
        if (item == null || !item.getDynamicObjectType().getProperties().containsKey((Object)key) || item.getDate(key) == null) {
            return null;
        }
        return item.getDate(key);
    }

    public static boolean contain(DynamicObject obj, String key) {
        return obj != null && obj.getDynamicObjectType().getProperties().containsKey((Object)key);
    }

    public static List<Long> getIdList(DynamicObjectCollection collection) {
        ArrayList<Long> idList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            return collection.stream().map(s -> (Long)s.getPkValue()).collect(Collectors.toList());
        }
        return idList;
    }

    public static List<DynamicObject> convertDynamicObjList(ExtendedDataEntity[] datas) {
        if (datas == null || datas.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(datas.length);
        for (ExtendedDataEntity data : datas) {
            list.add(data.getDataEntity());
        }
        return list;
    }

    public static DynamicObject[] convertArrays(ExtendedDataEntity[] datas) {
        if (datas == null || datas.length == 0) {
            return new DynamicObject[0];
        }
        List<DynamicObject> list = DynamicObjectUtils.convertDynamicObjList(datas);
        return list.toArray(new DynamicObject[list.size()]);
    }

    public static List<DynamicObject> convertDynamicObjList(DynamicObject[] datas) {
        if (datas == null || datas.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(datas.length);
        for (DynamicObject dynObj : datas) {
            list.add(dynObj);
        }
        return list;
    }

    public static void setBaseDataByPkValue(IDataModel model, String key, Object pkValue) {
        if (pkValue != null) {
            long pkId = Long.parseLong(pkValue.toString().trim());
            if (pkId != 0L) {
                model.setValue(key, (Object)pkId);
            } else {
                model.setValue(key, null);
            }
        } else {
            model.setValue(key, null);
        }
    }

    public static void setBaseDataByPkValue(IDataModel model, String key, Object pkValue, int index) {
        if (pkValue != null) {
            long pkId = Long.parseLong(pkValue.toString().trim());
            if (pkId != 0L) {
                model.setValue(key, (Object)pkId, index);
            } else {
                model.setValue(key, null, index);
            }
        } else {
            model.setValue(key, null, index);
        }
    }
}

