/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DapBuildVoucherLocalCache;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class DapBuildVoucherCommonUtil {
    private static Log logger = LogFactory.getLog(DapBuildVoucherCommonUtil.class);
    private static final String DapConfigCacheKey = "fi-ai-dapconfigs";
    private static final String algoKey = "kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil";
    public static final String HAS_DAPW_DAPN_TABLE = "has_dapw_dapn_table";
    public static final String ISBIZVOUCHER = "isbizvoucher";
    public static final String HASEVENT = "haseventtogeneratevoucher";

    public static Map<String, String> getBuildVoucherOptFromBill(String billtype) {
        String key = "getBuildVoucherOptFromBill" + billtype;
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.ACCOUNT_BOOK_VERSION, DapConfigCacheKey, key);
        HashMap<String, String> result = new HashMap<String, String>();
        Map cachedata = DapBuildVoucherLocalCache.get(cacheKey, Map.class);
        if (cachedata == null) {
            if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)billtype)) {
                return result;
            }
            List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)billtype);
            for (Map entryOperate : dataEntityOperate) {
                Map operCol;
                Object reloper;
                if (!"generatevoucher".equals(entryOperate.get("type")) || !(entryOperate.get("parameter") instanceof Map)) continue;
                Map operate = (Map)entryOperate.get("parameter");
                if (operate.get("parameter") == null || (reloper = (operCol = (Map)SerializationUtils.fromJsonString((String)((String)operate.get("parameter")), Map.class)).get("reloper")) == null) break;
                Map reloperMap = (Map)SerializationUtils.fromJsonString((String)reloper.toString(), Map.class);
                reloperMap.entrySet().stream().forEach(v -> result.put(v.getKey().toString(), v.getValue() != null ? v.getValue().toString() : null));
                break;
            }
            DapBuildVoucherLocalCache.put(cacheKey, result);
        } else {
            result.putAll(cachedata);
        }
        return result;
    }

    public static List<ComboItem> getAllOperationFromBill(String billType, Boolean needFilterOper) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(16);
        HashSet<String> opers = new HashSet<String>();
        if (QueryServiceHelper.exists((String)"bos_entityobject", (Object)(billType = DapBuildVoucherCommonUtil.getSourceBillType(billType, 10)))) {
            Set<String> filterOperMap = DapBuildVoucherCommonUtil.filterOperations();
            if (!needFilterOper.booleanValue()) {
                filterOperMap.clear();
            }
            Map<String, String> operMap = DapBuildVoucherCommonUtil.getFormOperMap(billType);
            for (Map.Entry<String, String> entry : operMap.entrySet()) {
                if (DapBuildVoucherCommonUtil.match(filterOperMap, entry.getKey())) continue;
                ComboItem citem = new ComboItem();
                LocaleString name = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)entry.getValue()), LocaleString.class);
                citem.setCaption(name);
                citem.setValue(entry.getKey());
                result.add(citem);
                opers.add(citem.getValue());
            }
            if (!opers.contains("audit")) {
                Map autditOp = null;
                try {
                    autditOp = EntityMetadataCache.getDataEntityOperate((String)billType, (String)"audit");
                }
                catch (Exception entry) {
                    // empty catch block
                }
                if (autditOp != null) {
                    ComboItem citem = new ComboItem();
                    citem.setCaption((LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(autditOp.get("name")), LocaleString.class));
                    citem.setValue("audit");
                    result.add(citem);
                    opers.add("audit");
                }
            }
        }
        return result;
    }

    public static Map<Long, Boolean> loadBatchAppParameByOrgToIsBizvoucher(List<Long> orgIds) {
        long start = System.currentTimeMillis();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(8);
        String sql = "select a.fdata parm,a.forgid org from T_bas_sysparameter a left join t_bas_sysparaconsole b on a.fparamid = b.fid where a.fviewtypeid = '10' and b.fappid = '83bfebc8000017ac'";
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            Iterator iterator = queryDataSet.iterator();
            HashSet<Long> orgIdSet = new HashSet<Long>(orgIds);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String data = row.getString("parm");
                Long orgId = row.getLong("org");
                if (data == null || !orgIdSet.contains(orgId)) continue;
                Map fromJsonString = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                Object isbizvoiucher = fromJsonString.get(ISBIZVOUCHER);
                boolean rr = isbizvoiucher != null ? (Boolean)isbizvoiucher : false;
                result.put(orgId, rr);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("--DAP--\u8bb0\u5f55\u672c\u6b21\u83b7\u53d6\u5168\u90e8\u53c2\u6570\u7684\u65f6\u95f4\uff0c\u7ec4\u7ec7\u6570\u91cf\uff1a" + orgIds.size() + ";\u65f6\u95f4:" + (end - start));
        return result;
    }

    private static Boolean isBillEntityData(String billtype) {
        String key = "dap_check_billentity_" + billtype;
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.ACCOUNT_BOOK_VERSION, DapConfigCacheKey, key);
        Boolean result = DapBuildVoucherLocalCache.get(cacheKey, Boolean.class);
        if (result == null) {
            boolean exists = QueryServiceHelper.exists((String)"bos_entityobject", (Object)billtype);
            result = exists;
            DapBuildVoucherLocalCache.put(cacheKey, result);
        }
        return result;
    }

    public static Boolean executeWriteBillDBOperation(String billtype, String oper, List<Long> billids, executeType executeType2) {
        if (StringUtils.isBlank((CharSequence)billtype) || billids.isEmpty()) {
            return true;
        }
        if (!DapBuildVoucherCommonUtil.isBillEntityData(billtype).booleanValue()) {
            return false;
        }
        HashMap<Long, Long> billAndMainOrgId = new HashMap<Long, Long>(billids.size());
        String mainOrg = EntityMetadataCache.getDataEntityType((String)billtype).getMainOrg();
        if (!StringUtils.isBlank((CharSequence)mainOrg)) {
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)billtype, (String)(mainOrg + "_id," + mainOrg + ",id"), (QFilter[])new QFilter("id", "in", billids).toArray(), null);
            for (Row row : queryDataSet) {
                Long mainOrgId = row.getLong(mainOrg + "_id");
                Long id = row.getLong("id");
                billAndMainOrgId.put(id, mainOrgId);
            }
        }
        return DapBuildVoucherCommonUtil.executeWriteBillDBOperation(billtype, oper, billids, billAndMainOrgId, executeType2);
    }

    public static Boolean executeWriteBillDBOperation(String billtype, String oper, List<Long> billids, Map<Long, Long> billAndMainOrgId, executeType executeType2) {
        if (StringUtils.isBlank((CharSequence)billtype) || billids.isEmpty()) {
            return true;
        }
        if (!DapBuildVoucherCommonUtil.isBillEntityData(billtype).booleanValue()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)oper)) {
            oper = "audit";
        }
        return executeType.DELETEWRITE == executeType2 ? DapBuildVoucherCommonUtil.executeWriteBillDeleteOperation(billtype, oper, billids, billAndMainOrgId) : DapBuildVoucherCommonUtil.executeWriteBillInsertOperation(billtype, oper, billids, billAndMainOrgId);
    }

    private static Boolean executeWriteBillDeleteOperation(String billtype, String oper, List<Long> billids, Map<Long, Long> billAndMainOrgId) {
        if (!DapBuildVoucherCommonUtil.getDistributeHasDapWBill(billtype).booleanValue()) {
            return false;
        }
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName(billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey(billtype);
        String sql = "DELETE FROM " + tableName + " WHERE FSOURCEBILLID = ? AND FBILLTYPE = ? AND FOPER = ? AND FORGID = ?";
        List<List<Long>> batchids = DapBuildVoucherCommonUtil.splitbatch(billids, 2000);
        for (List<Long> ids : batchids) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
            ids.stream().forEach(v -> params.add(new Object[]{v, billtype, oper, billAndMainOrgId.get(v) == null ? Long.valueOf(0L) : billAndMainOrgId.get(v)}));
            if (params.isEmpty()) continue;
            DapBuildVoucherCommonUtil.exceteBatchSql(sql, params, dbRouteKey);
        }
        return true;
    }

    private static Boolean executeWriteBillInsertOperation(String billtype, String oper, List<Long> billids, Map<Long, Long> billAndMainOrgId) {
        if (!DapBuildVoucherCommonUtil.getDistributeHasDapWBill(billtype).booleanValue()) {
            return false;
        }
        billids = DapBuildVoucherCommonUtil.distinctWriteBill(billtype, oper, billids, billAndMainOrgId);
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName(billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey(billtype);
        String sql = "INSERT INTO " + tableName + "(FID,FCREATETIME,FSOURCEBILLID,FBILLTYPE,FOPER,FORGID) VALUES (?,?,?,?,?,?)";
        List<List<Long>> batchids = DapBuildVoucherCommonUtil.splitbatch(billids, 2000);
        for (List<Long> ids : batchids) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
            Timestamp ts = new Timestamp(new Date().getTime());
            long[] tad = DB.genLongIds((String)tableName, (int)(ids.size() + 1));
            int i = 1;
            for (Long id : ids) {
                params.add(new Object[]{tad[i], ts, id, billtype, oper, billAndMainOrgId.get(id) == null ? Long.valueOf(0L) : billAndMainOrgId.get(id)});
                ++i;
            }
            if (params.isEmpty()) continue;
            DapBuildVoucherCommonUtil.exceteBatchSql(sql, params, dbRouteKey);
        }
        return true;
    }

    public static <T> List<List<T>> splitbatch(List<T> billids, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        int MaxSize = billids.size();
        if (MaxSize <= batchSize) {
            result.add(billids);
        } else {
            int rowindex = 0;
            do {
                int firstIndex = rowindex;
                rowindex = (rowindex += batchSize) > MaxSize ? MaxSize : rowindex;
                List<T> subList = billids.subList(firstIndex, rowindex);
                result.add(subList);
            } while (rowindex != MaxSize);
        }
        return result;
    }

    public static Boolean exceteBatchSql(String sql, List<Object[]> params, String dbroute) {
        int[] executeBatch;
        if (!params.isEmpty() && (executeBatch = DB.executeBatch((DBRoute)DBRoute.of((String)dbroute), (String)sql, params)).length > 0) {
            return true;
        }
        return true;
    }

    private static Set<String> filterOperations() {
        HashSet<String> filterMap = new HashSet<String>(23);
        filterMap.add("close");
        filterMap.add("refresh");
        filterMap.add("import");
        filterMap.add("export");
        filterMap.add("voucher");
        return filterMap;
    }

    private static Map<String, String> getFormOperMap(String formNumber) {
        HashMap<String, String> operMap = new HashMap<String, String>();
        String langStr = "zh_CN";
        Lang lang = RequestContext.get().getLang();
        if (lang != null) {
            langStr = lang.toString();
        }
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)formNumber);
        for (Map map : dataEntityOperate) {
            LinkedHashMap textmap = (LinkedHashMap)map.get("name");
            String operName = (String)textmap.get(langStr);
            operMap.put((String)map.get("type"), operName);
        }
        return operMap;
    }

    private static void iterateFormOperData(Map<String, String> operMap, Map<String, Object> formOperMap) {
        String langStr = "zh_CN";
        Lang lang = RequestContext.get().getLang();
        if (lang != null) {
            langStr = lang.toString();
        }
        if (formOperMap.get("items") != null && formOperMap.get("items") instanceof List) {
            List list = (List)formOperMap.get("items");
            for (int i = 0; i < list.size(); ++i) {
                LinkedHashMap textmap;
                String operName = "";
                String operValue = "";
                LinkedHashMap map = (LinkedHashMap)list.get(i);
                if (map.get("text") != null) {
                    textmap = (LinkedHashMap)map.get("text");
                    operName = (String)textmap.get(langStr);
                } else if (map.get("title") != null) {
                    textmap = (LinkedHashMap)map.get("title");
                    operName = (String)textmap.get(langStr);
                }
                if (map.get("opk") != null) {
                    operValue = (String)map.get("opk");
                } else if (map.get("operationKey") != null) {
                    operValue = (String)map.get("operationKey");
                }
                if (!"".equals(operName) && !"".equals(operValue)) {
                    operMap.put(operValue, operName);
                }
                DapBuildVoucherCommonUtil.iterateFormOperData(operMap, map);
            }
        }
    }

    private static boolean match(Set<String> set, String key) {
        for (String str : set) {
            if (key.indexOf(str) < 0) continue;
            return true;
        }
        return false;
    }

    public static String getWriteTableName(String billtype) {
        return DapBuildVoucherCommonUtil.getBillTable(billtype).get("tablename") + "_DAPW";
    }

    public static String getBlackTableName(String billtype) {
        return DapBuildVoucherCommonUtil.getBillTable(billtype).get("tablename") + "_DAPN";
    }

    public static String getDBRouteKey(String billtype) {
        return DapBuildVoucherCommonUtil.getBillTable(billtype).get("dbroute");
    }

    public static String getSourceBillType(String billtype, int maxsize) {
        String querysql = "select fmasterid from t_meta_entitydesign where fnumber = ?";
        Object[] param = new Object[]{billtype};
        boolean needGet = false;
        Object newId = null;
        try (DataSet queryDataSet = DB.queryDataSet((String)querysql, (DBRoute)DBRoute.of((String)"sys.meta"), (String)querysql, (Object[])param);){
            for (Row row : queryDataSet) {
                Object masterid = row.get("fmasterid");
                if (!StringUtils.isNotBlank((Object)masterid) || "0".equals(masterid)) continue;
                needGet = true;
                newId = masterid;
            }
        }
        if (needGet) {
            String qs = "select fnumber from t_meta_entitydesign where fid = ?";
            Object[] parama = new Object[]{newId};
            String newbilltype = "";
            try (DataSet queryDataSet = DB.queryDataSet((String)querysql, (DBRoute)DBRoute.of((String)"sys.meta"), (String)qs, (Object[])parama);){
                for (Row row : queryDataSet) {
                    newbilltype = row.getString("fnumber");
                }
            }
            return DapBuildVoucherCommonUtil.getSourceBillType(newbilltype, --maxsize);
        }
        return billtype;
    }

    public static Boolean getDistributeHasDapWBill(String billtype) {
        String key;
        boolean result = true;
        DistributeCache DCache = CacheHelper.getDistributeCache(CacheModule.HASDAPW_DAPN_TABLE);
        Map<String, Boolean> CacheResult = new HashMap(16);
        String serResult = DCache.get(HAS_DAPW_DAPN_TABLE);
        if (StringUtils.isNotBlank((CharSequence)serResult)) {
            CacheResult = (Map)SerializationUtils.fromJsonString((String)serResult, Map.class);
        }
        if (CacheResult.get(key = "getDistributeHasDapWBill_" + billtype) == null) {
            Boolean billEntityData = DapBuildVoucherCommonUtil.isBillEntityData(billtype);
            if (billEntityData.booleanValue()) {
                String writeTableName = DapBuildVoucherCommonUtil.getWriteTableName(billtype);
                boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey(billtype)), (String)writeTableName);
                logger.info("--DAP--getDistributeHasDapWBill:" + writeTableName + ":" + exitsTable);
                result = exitsTable;
            } else {
                result = false;
            }
            CacheResult.put(key, result);
            DCache.put(HAS_DAPW_DAPN_TABLE, SerializationUtils.toJsonString(CacheResult));
        } else {
            result = (Boolean)CacheResult.get(key);
        }
        return result;
    }

    private static List<Long> distinctWriteBill(String billtype, String oper, List<Long> billids, Map<Long, Long> billAndMainOrgId) {
        if (!DapBuildVoucherCommonUtil.getDistributeHasDapWBill(billtype).booleanValue() || billids == null || billids.isEmpty()) {
            return new ArrayList<Long>(8);
        }
        ArrayList<Long> result = new ArrayList<Long>(billids);
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName(billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey(billtype);
        List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(billids, 5000);
        for (List<Long> newIds : splitbatch) {
            List collect = newIds.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
            String join = String.join((CharSequence)",", collect);
            String sql = "SELECT FID,FORGID FROM " + tableName + " WHERE FSOURCEBILLID IN (" + join + ") AND FBILLTYPE = '" + billtype + "' AND FOPER = '" + oper + "'";
            DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)dbRouteKey), (String)sql);
            Throwable throwable = null;
            try {
                for (Row row : queryDataSet) {
                    Object fid = row.get("FID");
                    Object forgid = row.get("FORGID");
                    Long fneworgid = billAndMainOrgId.get(fid) != null ? billAndMainOrgId.get(fid) : Long.valueOf(0L);
                    if (!fneworgid.equals(forgid)) continue;
                    result.remove(fid);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (queryDataSet == null) continue;
                if (throwable != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                queryDataSet.close();
            }
        }
        return result;
    }

    public static Boolean getEnableBizVoucherSystemParam(Long orgId) {
        Object isbizvoucher = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("83bfebc8000017ac", "10", orgId, Long.valueOf(0L)), (String)ISBIZVOUCHER);
        return isbizvoucher != null ? (Boolean)isbizvoucher : false;
    }

    public static Boolean getEnableBizVoucherSystemParam() {
        Boolean result = false;
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.ISBIZVOUCHER);
        String json = distributeCache.get(ISBIZVOUCHER);
        if (json != null) {
            result = (Boolean)SerializationUtils.fromJsonString((String)json, Boolean.class);
            return result;
        }
        String sql = "select forgid from T_ORG_Structure where FViewID = 10";
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)sql);
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                Long id = row.getLong("forgid");
                orgIds.add(id);
            }
        }
        catch (Throwable iterator) {
            object = iterator;
            throw iterator;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)object).addSuppressed(iterator);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        Map<Long, Boolean> allSystemParams = DapBuildVoucherCommonUtil.loadBatchAppParameByOrgToIsBizvoucher(orgIds);
        for (Boolean sp : allSystemParams.values()) {
            if (!sp.booleanValue()) continue;
            result = sp;
            break;
        }
        distributeCache.put(ISBIZVOUCHER, SerializationUtils.toJsonString((Object)result));
        return result;
    }

    public static Boolean checkHasEventToGenerateVoucher(String billtype, String oper) {
        String zxoper = "\"operation\":\"generatevoucher\"";
        Boolean result = false;
        String key = billtype + "-" + oper;
        Map<String, Boolean> cache = new HashMap(16);
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.HASEVENT);
        String json = distributeCache.get(HASEVENT);
        if (json != null && (cache = (Map)SerializationUtils.fromJsonString((String)json, Map.class)).get(key) != null) {
            return (Boolean)cache.get(key);
        }
        ArrayList<Long> eventIds = new ArrayList<Long>(16);
        String sql = "select fid from t_evt_event where fentity = '" + billtype + "' and fopernumber = '" + oper + "'";
        try (DataSet queryDataSet = DB.queryDataSet((String)sql, (DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey("evt_event")), (String)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                eventIds.add(((Row)iterator.next()).getLong("fid"));
            }
        }
        if (!eventIds.isEmpty()) {
            DynamicObject[] enevtEntries;
            QFilter eventQF = new QFilter("event", "in", eventIds);
            QFilter statuQF = new QFilter("status", "=", (Object)"1");
            for (DynamicObject enevt : enevtEntries = BusinessDataServiceHelper.load((String)"evt_subscription", (String)"serviceconfig", (QFilter[])new QFilter[]{eventQF, statuQF})) {
                Object sconfig = enevt.get("serviceconfig");
                if (sconfig == null || !sconfig.toString().contains(zxoper)) continue;
                result = true;
                break;
            }
        }
        cache.put(key, result);
        distributeCache.put(HASEVENT, SerializationUtils.toJsonString(cache));
        return result;
    }

    public static Boolean createDapTableToBill(String billtype) {
        Boolean result = true;
        if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)billtype)) {
            return false;
        }
        String table_b = DapBuildVoucherCommonUtil.getBlackTableName(billtype);
        StringBuilder sbf_b = new StringBuilder();
        sbf_b.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(table_b).append("') CREATE TABLE ").append(table_b).append("( ").append(" fid bigint DEFAULT 0 not null primary key, ").append(" fcreatetime datetime, ").append(" fsourcebillid bigint default 0 not null, ").append(" fsourcebillno varchar(30) default(' ') not null, ").append(" forgid bigint default 0 not null, ").append(" fcreatorid bigint default 0 not null, ").append(" fbilltype varchar(50)  default(' ') not null").append(")");
        StringBuilder sbf_b_index = new StringBuilder();
        String sbf_b_index_key = "IDX" + table_b + "_BINDEX";
        sbf_b_index.append("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '").append(sbf_b_index_key).append("') CREATE INDEX ").append(sbf_b_index_key).append(" ON ").append(table_b).append(" ( fsourcebillid,fbilltype ) ");
        StringBuilder sbf_b_index_t = new StringBuilder();
        String sbf_b_index_key2 = "IDX" + table_b + "_T_BINDEX";
        sbf_b_index_t.append("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '").append(sbf_b_index_key2).append("') CREATE INDEX ").append(sbf_b_index_key2).append(" ON ").append(table_b).append(" ( fbilltype,forgid,fcreatetime,fsourcebillno,fcreatorid ) ");
        String table_w = DapBuildVoucherCommonUtil.getWriteTableName(billtype);
        StringBuilder sbf_w = new StringBuilder();
        sbf_w.append("IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append(table_w).append("') CREATE TABLE ").append(table_w).append("( ").append(" fid bigint DEFAULT 0 not null primary key, ").append(" fcreatetime datetime, ").append(" fsourcebillid bigint default 0 not null, ").append(" forgid bigint default 0 not null, ").append(" fbilltype varchar(50)  default(' ') not null, ").append(" foper varchar(50)  default(' ') not null").append(")");
        StringBuilder sbf_w_index = new StringBuilder();
        String sbf_w_index_key = "IDX" + table_w + "_WINDEX";
        sbf_w_index.append("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '").append(sbf_w_index_key).append("') CREATE INDEX ").append(sbf_w_index_key).append(" ON ").append(table_w).append(" ( fsourcebillid,fbilltype,foper ) ");
        StringBuilder sbf_w_index_t = new StringBuilder();
        String sbf_w_index_key2 = "IDX" + table_w + "_T_WINDEX";
        sbf_w_index_t.append("IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '").append(sbf_w_index_key2).append("') CREATE INDEX ").append(sbf_w_index_key2).append(" ON ").append(table_w).append(" ( fsourcebillid,fbilltype,foper,forgid ) ");
        String dbRouteKey = EntityMetadataCache.getDataEntityType((String)billtype).getDBRouteKey();
        try (TXHandle h = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_b.toString());
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_b_index.toString());
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_b_index_t.toString());
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_w.toString());
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_w_index.toString());
                DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sbf_w_index_t.toString());
            }
            catch (Throwable e) {
                result = false;
                logger.error(e.getMessage());
                h.markRollback();
            }
        }
        DapBuildVoucherCommonUtil.updateDistributeCache(billtype);
        return result;
    }

    private static void updateDistributeCache(String billtype) {
        DistributeCache DCache = CacheHelper.getDistributeCache(CacheModule.HASDAPW_DAPN_TABLE);
        String serResult = DCache.get(HAS_DAPW_DAPN_TABLE);
        Map<String, Boolean> CacheResult = new HashMap(16);
        if (serResult != null) {
            CacheResult = (Map)SerializationUtils.fromJsonString((String)serResult, Map.class);
        }
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey(billtype)), (String)DapBuildVoucherCommonUtil.getWriteTableName(billtype));
        CacheResult.put(billtype, exitsTable);
        DCache.put(HAS_DAPW_DAPN_TABLE, SerializationUtils.toJsonString(CacheResult));
    }

    public static Boolean registerDapWriteAndBlackOpService(Boolean isopen, String billtype) {
        Boolean result = true;
        Map<String, String> buildVoucherOptFromBill = DapBuildVoucherCommonUtil.getBuildVoucherOptFromBill(billtype);
        ArrayList<String> needBuildOps = new ArrayList<String>(buildVoucherOptFromBill.keySet());
        Set<String> notBuildOps = new HashSet<String>(buildVoucherOptFromBill.values());
        notBuildOps = notBuildOps.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (needBuildOps.isEmpty() && notBuildOps.isEmpty()) {
            needBuildOps.add("audit");
            notBuildOps.add("unaudit");
        }
        needBuildOps.addAll(DapBuildVoucherCommonUtil.getOpBizRuleSet(billtype, "DapBusinessCanCreateVoucher"));
        notBuildOps.addAll(DapBuildVoucherCommonUtil.getOpBizRuleSet(billtype, "DapBusinessNotBuildVoucher"));
        if (isopen.booleanValue()) {
            notBuildOps.add("delete");
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)billtype, (String)"DapBusinessCanCreateVoucher", needBuildOps.stream().distinct().collect(Collectors.toList()));
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)billtype, (String)"DapBusinessNotBuildVoucher", notBuildOps.stream().distinct().collect(Collectors.toList()));
            result = DapBuildVoucherCommonUtil.createDapTableToBill(billtype);
        } else {
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billtype, (String)"DapBusinessCanCreateVoucher");
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)billtype, (String)"DapBusinessNotBuildVoucher");
        }
        return result;
    }

    private static Map<String, String> getBillTable(String billtype) {
        String key = "getBillTable" + billtype;
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey(CacheKeyPrefix.ACCOUNT_BOOK_VERSION, DapConfigCacheKey, key);
        HashMap<String, String> result = new HashMap<String, String>(2);
        Map cachedata = DapBuildVoucherLocalCache.get(cacheKey, Map.class);
        if (cachedata == null) {
            String sql = "select a.ftablename tn,b.fdbroute dr from t_meta_mainentityinfo a left join t_meta_bizapp b on a.fbizappid = b.fid where a.fid = ?";
            String tableName = "";
            String dbRoute = "";
            try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql, (Object[])new Object[]{billtype});){
                for (Row row : queryDataSet) {
                    tableName = row.getString("tn");
                    dbRoute = row.getString("dr");
                }
            }
            result.put("tablename", tableName);
            result.put("dbroute", dbRoute);
            DapBuildVoucherLocalCache.put(cacheKey, result);
        } else {
            result.putAll(cachedata);
        }
        return result;
    }

    private static List<String> getOpBizRuleSet(String entityNumber, String opKey) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select foperationkey from t_meta_opbizrulesetentry where fid in (select fid from t_meta_opbizruleset where fobjecttypeid = ? and fopbizrule = ?)";
        Object[] param = new Object[]{entityNumber, opKey};
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql, (Object[])param);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                result.add(((Row)iterator.next()).getString("foperationkey"));
            }
        }
        return result;
    }

    public static enum executeType {
        INSERTWRITE,
        DELETEWRITE;

    }
}

