/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DapOperationResultHelper {
    private static final Log log = LogFactory.getLog(DapOperationResultHelper.class);

    public static OperationResult buildResult(Object[] billIds, String error, OperationResult result, Date start) {
        return DapOperationResultHelper.buildResult(Arrays.asList(billIds).stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toList()), error, result, start, false);
    }

    public static OperationResult buildResult(Object[] billIds, String error, OperationResult result, Date start, boolean preBuild) {
        return DapOperationResultHelper.buildResult(Arrays.asList(billIds).stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toList()), error, result, start, preBuild);
    }

    private static OperationResult buildResult(List<Long> billIds, String error, OperationResult result, Date start, boolean preBuild) {
        log.info("####buildResult--error:" + error + ";boolean:" + StringUtils.isNotBlank((CharSequence)error) + ";preBuild:" + preBuild + ";billSize:" + billIds.size());
        List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(billIds, 2000);
        HashSet<Long> additionMessageBillids = new HashSet<Long>(billIds);
        for (List<Long> bills : splitbatch) {
            QFilter qFilter = new QFilter("fsourcebillid", "in", bills).and(new QFilter("createtime", ">=", (Object)start));
            if (!preBuild) {
                qFilter.and(new QFilter("buildvouchertype", "!=", (Object)"4"));
            }
            DataSet ds = QueryServiceHelper.queryDataSet((String)DapOperationResultHelper.class.getName(), (String)"ai_buildreport", (String)"id,sourcebillno,fsourcebillid,buildstate,entryentity.message,entryentity.errlevel,entryentity.seq,errorresult,isexceptionreport", (QFilter[])qFilter.toArray(), (String)"buildstate asc,createtime desc");
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    Long billid = row.getLong("fsourcebillid");
                    if (!additionMessageBillids.contains(billid)) continue;
                    if ("0".equals(row.getString("buildstate"))) {
                        result.getSuccessPkIds().add(billid);
                        additionMessageBillids.remove(billid);
                        continue;
                    }
                    String message = null;
                    if (row.getBoolean("isexceptionreport").booleanValue()) {
                        String errorsult = row.getString("errorresult");
                        message = errorsult.isEmpty() || errorsult.length() > 50 ? ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u5f02\u5e38\u5806\u6808\u4fe1\u606f\u6216\u8005\u8054\u7cfb\u5bf9\u5e94\u5f00\u53d1\u5904\u7406\u3002", (String)"DapOperationResultHelper_3", (String)"bos-ext-fi", (Object[])new Object[0]) : errorsult;
                    } else if ("2".equalsIgnoreCase(row.getString("entryentity.errlevel").trim())) {
                        message = row.getString("entryentity.message");
                    }
                    if (message == null) continue;
                    additionMessageBillids.remove(billid);
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setLevel(ErrorLevel.Error);
                    errorInfo.setMessage(message);
                    errorInfo.setPkValue((Object)billid);
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"DapOperationResultHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                    result.addErrorInfo(errorInfo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        for (Long id : additionMessageBillids) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Warning);
            errorInfo.setMessage(StringUtils.isNotBlank((CharSequence)error) ? error : ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"DapOperationResultHelper_2", (String)"bos-ext-fi", (Object[])new Object[0]));
            errorInfo.setPkValue((Object)id);
            errorInfo.setTitle(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"DapOperationResultHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            result.addErrorInfo(errorInfo);
        }
        return result;
    }
}

