/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.v2.fah.dto.FahRegBillDTO;
import kd.bos.ext.fi.ai.v2.fah.dto.FahRegBillEntryDTO;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FahRegBillDao {
    private static final String algoKey = "kd.fi.v2.fah.dao.event.RegBillDao";
    private static final String THREAD_CACHE_KEY = "FahRegBillDao.FahRegBillDTOAndFahRegBillEntryDTO";
    private static final String[] selectField = new String[]{"id", "enable", "srcbilltype", "srcapp", "srcbillorgfield", "srcbillstatusfield", "writebackplugin", "keyfieldentry.srcbillstatusval", "keyfieldentry.srcbilldatefieldnum", "keyfieldentry.evtstatusfieldnum"};

    private static Map<String, FahRegBillDTO> getDtoThreadCache() {
        return (Map)ThreadCache.get((Object)THREAD_CACHE_KEY, HashMap::new);
    }

    private static DynamicObjectCollection batchQueryRegBillInfo(QFilter[] filters) {
        return QueryServiceHelper.query((String)"fah_regbill", (String)StringUtils.join((Object[])selectField, (String)","), (QFilter[])filters);
    }

    private static Map<String, FahRegBillDTO> batchDoToDto(DynamicObjectCollection doCollection) {
        HashMap<String, FahRegBillDTO> billToDTO = new HashMap<String, FahRegBillDTO>(doCollection.size());
        for (DynamicObject dto : doCollection) {
            FahRegBillDTO fahRegBillDTO = billToDTO.computeIfAbsent(dto.getString("srcbilltype"), btKey -> {
                FahRegBillDTO newDTO = new FahRegBillDTO();
                newDTO.setId(dto.getLong("id"));
                newDTO.setEnable(dto.getString("enable"));
                newDTO.setSrcBillType(dto.getString("srcbilltype"));
                newDTO.setSrcAppId(dto.getString("srcapp"));
                newDTO.setSrcBillOrgField(dto.getString("srcbillorgfield"));
                newDTO.setSrcBillStatusField(dto.getString("srcbillstatusfield"));
                newDTO.setWriteBackPlugin(dto.getString("writebackplugin"));
                ArrayList<FahRegBillEntryDTO> entry = new ArrayList<FahRegBillEntryDTO>(2);
                newDTO.setEntry(entry);
                return newDTO;
            });
            FahRegBillEntryDTO entryDTO = new FahRegBillEntryDTO(dto.getString("keyfieldentry.srcbillstatusval"), dto.getString("keyfieldentry.srcbilldatefieldnum"), dto.getString("keyfieldentry.evtstatusfieldnum"));
            fahRegBillDTO.addEntryDTO(entryDTO);
        }
        return billToDTO;
    }

    public static List<FahRegBillDTO> batchQueryRegBillByBillType(Collection<String> billTypes) {
        if (billTypes == null || billTypes.isEmpty()) {
            return new ArrayList<FahRegBillDTO>(2);
        }
        Map<String, FahRegBillDTO> regBillDtoCache = FahRegBillDao.getDtoThreadCache();
        ArrayList<FahRegBillDTO> dtoList = new ArrayList<FahRegBillDTO>(billTypes.size());
        ArrayList<String> notInCacheBillTypes = new ArrayList<String>(billTypes.size());
        for (String string : billTypes) {
            FahRegBillDTO fahRegBillDTO = regBillDtoCache.get(string);
            if (fahRegBillDTO == null) {
                notInCacheBillTypes.add(string);
                continue;
            }
            dtoList.add(fahRegBillDTO);
        }
        if (!notInCacheBillTypes.isEmpty()) {
            DynamicObjectCollection dtos = FahRegBillDao.batchQueryRegBillInfo(new QFilter[]{new QFilter("srcbilltype", "in", billTypes)});
            if (dtos == null || dtos.isEmpty()) {
                for (String notInCacheBillType : notInCacheBillTypes) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                }
                return dtoList;
            }
            Map<String, FahRegBillDTO> map = FahRegBillDao.batchDoToDto(dtos);
            if (map.isEmpty()) {
                for (String notInCacheBillType : notInCacheBillTypes) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                }
                return dtoList;
            }
            for (String notInCacheBillType : notInCacheBillTypes) {
                FahRegBillDTO fahRegBillDTO = map.get(notInCacheBillType);
                if (fahRegBillDTO == null) {
                    regBillDtoCache.put(notInCacheBillType, new FahRegBillDTO());
                    continue;
                }
                dtoList.add(fahRegBillDTO);
                regBillDtoCache.put(notInCacheBillType, fahRegBillDTO);
            }
        }
        return dtoList;
    }

    public static Map<Object, DynamicObject> queryBillInfoByIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new HashMap<Object, DynamicObject>(2);
        }
        QFilter filter = new QFilter("id", "in", ids);
        Map id2Obj = BusinessDataServiceHelper.loadFromCache((String)"fah_regbill", (String)"id,srcbilltype,enable", (QFilter[])filter.toArray());
        return id2Obj;
    }

    public static List<FahRegBillDTO> queryAllEnableInfo() {
        DynamicObjectCollection regBillCol = FahRegBillDao.batchQueryRegBillInfo(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Map<String, FahRegBillDTO> billToDtoMap = FahRegBillDao.batchDoToDto(regBillCol);
        if (billToDtoMap.isEmpty()) {
            return new ArrayList<FahRegBillDTO>(2);
        }
        Map<String, FahRegBillDTO> dtoThreadCache = FahRegBillDao.getDtoThreadCache();
        dtoThreadCache.putAll(billToDtoMap);
        return new ArrayList<FahRegBillDTO>(billToDtoMap.values());
    }

    public static Set<String> getRegBillNumbers() {
        HashSet<String> billTypes = new HashSet<String>(16);
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.queryAllEnableInfo();
        for (FahRegBillDTO dto : fahRegBillDTOS) {
            billTypes.add(dto.getSrcBillType());
        }
        return billTypes;
    }

    public static Tuple<String, List<String>> queryAllowBillStatus(String billType) {
        if (billType == null || billType.isEmpty()) {
            return new Tuple((Object)"", new ArrayList(2));
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(billType));
        if (fahRegBillDTOS.isEmpty()) {
            return new Tuple((Object)"", new ArrayList(2));
        }
        FahRegBillDTO fahRegBillDTO = fahRegBillDTOS.get(0);
        return new Tuple((Object)fahRegBillDTO.getSrcBillStatusField(), fahRegBillDTO.getEntry().stream().map(FahRegBillEntryDTO::getSrcBillStatusVal).collect(Collectors.toList()));
    }

    public static Map<String, List<String>> getBillType2Status(Collection<String> billTypes) {
        List<FahRegBillDTO> regBillDTOs = FahRegBillDao.batchQueryRegBillByBillType(billTypes);
        Map<String, List<String>> result = regBillDTOs.stream().collect(Collectors.toMap(FahRegBillDTO::getSrcBillType, dto -> dto.getEntry().stream().map(FahRegBillEntryDTO::getSrcBillStatusVal).collect(Collectors.toList())));
        return result;
    }

    public static String querySrcDate(String srcBillType) {
        if (srcBillType == null || srcBillType.isEmpty()) {
            return "";
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(srcBillType));
        if (fahRegBillDTOS.isEmpty()) {
            return "";
        }
        return fahRegBillDTOS.get(0).getEntry().get(0).getSrcBillDateFieldNum();
    }

    public static Map<String, String> batchQuerySrcDate(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, String>(2);
        }
        HashMap<String, String> dateMap = new HashMap<String, String>(2);
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            dateMap.put(fahRegBillDTO.getSrcBillType(), fahRegBillDTO.getEntry().get(0).getSrcBillDateFieldNum());
        }
        return dateMap;
    }

    public static String querySrcOrg(String srcBillType) {
        if (srcBillType == null || srcBillType.isEmpty()) {
            return "";
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(Collections.singleton(srcBillType));
        if (fahRegBillDTOS.isEmpty()) {
            return "";
        }
        return fahRegBillDTOS.get(0).getSrcBillOrgField();
    }

    public static Map<String, String> batchQuerySrcOrg(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, String>(2);
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        HashMap<String, String> orgMap = new HashMap<String, String>(4);
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            orgMap.put(fahRegBillDTO.getSrcBillType(), fahRegBillDTO.getSrcBillOrgField());
        }
        return orgMap;
    }

    public static Map<String, Tuple<String, String>> batchQuerySrcDateAndSrcOrg(Collection<String> srcBillTypes) {
        if (srcBillTypes == null || srcBillTypes.isEmpty()) {
            return new HashMap<String, Tuple<String, String>>(2);
        }
        List<FahRegBillDTO> fahRegBillDTOS = FahRegBillDao.batchQueryRegBillByBillType(srcBillTypes);
        HashMap<String, Tuple<String, String>> map = new HashMap<String, Tuple<String, String>>();
        for (FahRegBillDTO fahRegBillDTO : fahRegBillDTOS) {
            List<FahRegBillEntryDTO> entry = fahRegBillDTO.getEntry();
            if (entry == null || entry.isEmpty()) {
                map.put(fahRegBillDTO.getSrcBillType(), (Tuple<String, String>)new Tuple((Object)"", (Object)fahRegBillDTO.getSrcBillOrgField()));
                continue;
            }
            map.put(fahRegBillDTO.getSrcBillType(), (Tuple<String, String>)new Tuple((Object)fahRegBillDTO.getEntry().get(0).getSrcBillDateFieldNum(), (Object)fahRegBillDTO.getSrcBillOrgField()));
        }
        return map;
    }
}

