/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class ReverseGLAndAcctJE
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final Log logger = LogFactory.getLog(ReverseGLAndAcctJE.class);
    private static final int batch = 1000;

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!LicenseServiceHelper.getLicenseModules().contains("2FMS=8GUFGGN")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BuildVoucher_21", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        Set<Long> selectedBillIds = this.getSelectedBillIds();
        String realEntity = this.getEntityId();
        if ("ai_event".equals(this.getEntityId())) {
            if (selectedBillIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff0c\u5916\u90e8\u6570\u636e\u4ec5\u652f\u6301\u5217\u8868\u9009\u62e9\u5355\u636e\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u3002", (String)"ReverseGLAndAcctJE_1", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(selectedBillIds);
            if (billTypeGroups.containsKey("ai_event")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e7\u6a21\u578b\u5916\u90e8\u6570\u636e\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u3002", (String)"ReverseGLAndAcctJE_2", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            if (billTypeGroups.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u6a21\u578b\u5916\u90e8\u6570\u636e\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u3002", (String)"ReverseGLAndAcctJE_3", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            Iterator<String> iterator = billTypeGroups.keySet().iterator();
            while (iterator.hasNext()) {
                String billType;
                realEntity = billType = iterator.next();
            }
        }
        return this.invokeReverseGlAndAcctJETask(selectedBillIds, realEntity);
    }

    public String getConfirmMessage() {
        this.setConfirmTypes(ConfirmTypes.Delete);
        return ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u5417\uff1f", (String)"ReverseGLAndAcctJE_4", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    protected int getBatchSize() {
        return 1000;
    }

    private boolean invokeReverseGlAndAcctJETask(Set<Long> selectedBillIds, String billType) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fah_build_xla_gl_tip");
        param.setCaption(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55", (String)"ReverseGLAndAcctJE_5", (String)"bos-ext-fi", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getCustomParams().put("ids", FahSerializeHelper.getInstance().toJSONString(selectedBillIds));
        param.getCustomParams().put("entityId", billType);
        param.getCustomParams().put("pageId", this.getView().getPageId());
        param.getCustomParams().put("operateKey", this.getOperateKey());
        param.getCustomParams().put("isReverse", "true");
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_reverse_glandacct"));
        this.getView().showForm(param);
        return false;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        logger.info("reverseGlAndAcctJE_closedCallBack,ActionId:{}, returnData: {}", (Object)evt.getActionId(), returnData);
        if ("fah_reverse_glandacct".equals(evt.getActionId())) {
            String data = (String)evt.getReturnData();
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (null != map) {
                String error = (String)map.get("error");
                String result = (String)map.get("operationResult");
                IFormView view = SessionManager.getCurrent().getView((String)map.get("pageId"));
                if (null != result) {
                    OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)result, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                    if (opResult.isSuccess()) {
                        view.showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u6210\u529f\u3002", (String)"ReverseGLAndAcctJE_6", (String)"bos-ext-fi", (Object[])new Object[0]), Integer.valueOf(15000));
                        this.refreshData(view);
                    } else {
                        view.showOperationResult(opResult, ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55", (String)"ReverseGLAndAcctJE_7", (String)"bos-ext-fi", (Object[])new Object[0]));
                        this.refreshData(view);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)error)) {
                    view.showTipNotification(error);
                } else {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u4e8b\u4ef6\u53ca\u4f1a\u8ba1\u5206\u5f55\u6210\u529f\u3002", (String)"ReverseGLAndAcctJE_6", (String)"bos-ext-fi", (Object[])new Object[0]));
                    this.refreshData(view);
                }
            }
        }
    }

    private void refreshData(IFormView view) {
        if (view instanceof IListView) {
            ((IListView)view).refreshWithSelected();
        } else {
            view.invokeOperation("refresh");
        }
    }

    protected Set<Long> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }
}

