/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.bei.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.bei.ocr.impl.ScanServiceImpl;
import kd.bos.ext.fi.bei.ocr.invoke.ScanSystemFactory;
import kd.bos.ext.fi.bei.service.PrintServiceCopy;
import kd.bos.ext.fi.bei.util.BeiPrintHelper;
import kd.bos.ext.fi.bei.util.EmptyUtil;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.ext.fi.evp.model.TicketType;
import kd.bos.ext.fi.evp.service.IBizevpDataService;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ElecBillArchiveService
implements IBizevpDataService {
    private static final Log logger = LogFactory.getLog(ElecBillArchiveService.class);
    public static final String FORMAT_YM = "yyyy-MM";
    private static final String[] elcReceipts = new String[]{"cas_paybill", "cas_recbill", "cas_agentpaybill", "fca_transupbill", "fca_transdownbill", "cas_transferapply", "cas_bankjournal"};

    @Override
    public Map<Long, List<JSONObject>> getEvpJsonList(PullevpDataParam pullevpDataParam) {
        String billType = pullevpDataParam.getBillType();
        Long accorgid = pullevpDataParam.getAccorgid();
        Set<Long> billIds = pullevpDataParam.getBillIds();
        if (StringUtils.isEmpty((CharSequence)billType) || billIds == null || billIds.size() == 0) {
            return null;
        }
        List<String> elcReceiptsList = Arrays.asList(elcReceipts);
        Map<Long, List<JSONObject>> result = null;
        if (elcReceiptsList.contains(billType)) {
            if ("cas_transferapply".equals(billType)) {
                return result;
            }
            result = this.findArchiveByReceipt(billType, DBServiceHelper.genStringId(), billIds, accorgid);
        } else if (StringUtils.equals((CharSequence)billType, (CharSequence)"bei_elecstatement")) {
            result = this.findArchiveByStatement(billType, billIds);
        }
        return result;
    }

    @Override
    public List<Long> getBkrsids(Long orgid, Date startdate, Date enddate) {
        QFilter qFilter = new QFilter("accountcompany", "=", (Object)orgid);
        qFilter.and("period", ">=", (Object)startdate);
        qFilter.and("period", "<=", (Object)enddate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_elecstatement", (String)"id,accountbank.id accountbank,currency.id currency,period,datasource", (QFilter[])qFilter.toArray());
        Map collect = query.stream().collect(Collectors.groupingBy(s -> "" + s.get("accountbank") + s.get("currency") + DateUtils.formatString((Date)s.get("period"), FORMAT_YM), Collectors.toList()));
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Map.Entry entry : collect.entrySet()) {
            Map datasource = entry.getValue().stream().collect(Collectors.groupingBy(s -> s.get("datasource").toString(), Collectors.toList()));
            if (datasource.containsKey("frombank")) {
                ids.add(((DynamicObject)datasource.get("frombank").get(0)).getLong("id"));
                continue;
            }
            if (datasource.containsKey("fileimport")) {
                ids.add(((DynamicObject)datasource.get("fileimport").get(0)).getLong("id"));
                continue;
            }
            if (!datasource.containsKey("import")) continue;
            ids.add(((DynamicObject)datasource.get("import").get(0)).getLong("id"));
        }
        return ids;
    }

    public List<JSONObject> getElecReceiptDataById(List<Long> ids) {
        DynamicObject[] receipts;
        ArrayList<JSONObject> returnData = new ArrayList<JSONObject>(ids.size());
        for (DynamicObject receipt : receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password,validcode,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,amount,currency,createtime", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            JSONObject ticketBill = new JSONObject();
            ticketBill.put("org", (Object)"");
            ticketBill.put("bookdate", (Object)DateUtils.formatString(receipt.getDate("createtime"), "yyyy-MM-dd"));
            ticketBill.put("tickettype", (Object)TicketType.BKER_RECEIVER.getValue());
            ticketBill.put("identifyingcode", (Object)receipt.getString("receiptno"));
            ticketBill.put("seqno", (Object)receipt.getString("receiptno"));
            ticketBill.put("contractnumber", (Object)"");
            BigDecimal amountPayAndRec = BigDecimal.ZERO;
            ticketBill.put("payandrevamount", (Object)amountPayAndRec.toPlainString());
            ticketBill.put("hasbeenclaimed", (Object)"");
            ticketBill.put("hasbeenreconciled", (Object)"");
            ticketBill.put("hasbeentransfer", (Object)"");
            List<String> pdfUrls = this.getPdfUrl(DBServiceHelper.genStringId(), receipt);
            if (pdfUrls.size() > 0) {
                ticketBill.put("fileurl", (Object)pdfUrls.get(0));
            } else {
                ticketBill.put("fileurl", (Object)"");
            }
            ticketBill.put("billid", (Object)receipt.getPkValue().toString());
            ticketBill.put("currency", (Object)(receipt.getDynamicObject("currency") == null ? "" : receipt.getDynamicObject("currency").getPkValue().toString()));
            ticketBill.put("transactionamountinfigure", (Object)(receipt.getBigDecimal("amount") == null ? BigDecimal.ZERO.toPlainString() : receipt.getBigDecimal("amount").toPlainString()));
            returnData.add(ticketBill);
        }
        return returnData;
    }

    private Map<Long, List<JSONObject>> findArchiveByStatement(String billType, Set<Long> ids) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Long, List<JSONObject>> returnData = new HashMap<Long, List<JSONObject>>(bills.length);
        for (DynamicObject bill : bills) {
            ArrayList<JSONObject> ticekBills = new ArrayList<JSONObject>(1);
            JSONObject ticketBill = new JSONObject();
            ticketBill.put("seqno", (Object)("" + bill.getLong("id")));
            ticketBill.put("bookdate", (Object)DateUtils.formatString(bill.getDate("period"), "yyyy-MM-dd"));
            ticketBill.put("identificationorg", (Object)bill.getString("identificationissuer"));
            ticketBill.put("bankbranchnumber", (Object)bill.getString("bankbranchnumber"));
            ticketBill.put("currency", (Object)(EmptyUtil.isEmpty(bill.getDynamicObject("currency")) ? "" : bill.getDynamicObject("currency").getPkValue().toString()));
            ticketBill.put("settlementaccount", (Object)(EmptyUtil.isEmpty(bill.getDynamicObject("accountbank")) ? "" : bill.getDynamicObject("accountbank").getString("bankaccountnumber")));
            ticketBill.put("accountname", (Object)bill.getString("accountbankname"));
            ticketBill.put("bankcustomernumber", (Object)bill.getString("bankcustomercode"));
            Date date = bill.getDate("period");
            int year = DateUtils.getYear(date);
            int month = DateUtils.getMonth(date);
            ticketBill.put("reconyear", (Object)(year + ""));
            ticketBill.put("reconmonth", (Object)(month + ""));
            ticketBill.put("printtimes", (Object)bill.getLong("printcount"));
            ticketBill.put("printdate", (Object)(EmptyUtil.isEmpty(bill.getDate("printdate")) ? "" : DateUtils.formatString(bill.getDate("printdate"), "yyyy-MM-dd")));
            ticketBill.put("accountbal", (Object)(EmptyUtil.isEmpty(bill.getBigDecimal("endacctamount")) ? "" : bill.getBigDecimal("endacctamount").toPlainString()));
            ticketBill.put("reservebal", (Object)(EmptyUtil.isEmpty(bill.getBigDecimal("endretainamount")) ? "" : bill.getBigDecimal("endretainamount").toPlainString()));
            ticketBill.put("frozenbal", (Object)(EmptyUtil.isEmpty(bill.getBigDecimal("endfreezeamount")) ? "" : bill.getBigDecimal("endfreezeamount").toPlainString()));
            ticketBill.put("overdraftbal", (Object)(EmptyUtil.isEmpty(bill.getBigDecimal("endoverdraftamount")) ? "" : bill.getBigDecimal("endoverdraftamount").toPlainString()));
            ticketBill.put("availablebal", (Object)(EmptyUtil.isEmpty(bill.getBigDecimal("endavailableamount")) ? "" : bill.getBigDecimal("endavailableamount").toPlainString()));
            ticketBill.put("tickettype", (Object)TicketType.BKRS.getValue());
            ticketBill.put("billid", (Object)("" + bill.getLong("id")));
            ticketBill.put("org", (Object)bill.getDynamicObject("accountcompany").getLong("id"));
            DynamicObjectCollection checkDetails = bill.getDynamicObjectCollection("entryentity");
            JSONArray entryEntityJson = new JSONArray();
            for (DynamicObject checkDetail : checkDetails) {
                JSONObject checkDetail1 = new JSONObject();
                checkDetail1.put("ebookdate", (Object)(EmptyUtil.isEmpty(checkDetail.getDate("e_bookdate")) ? "" : DateUtils.formatString(checkDetail.getDate("e_bookdate"), "yyyy-MM-dd")));
                checkDetail1.put("businessproductstype", (Object)checkDetail.getString("e_bizproduct"));
                checkDetail1.put("sourcevouchertype", (Object)checkDetail.getString("e_sourcedocument"));
                checkDetail1.put("sourcevouchernumber", (Object)checkDetail.getString("e_sourcedocumentno"));
                checkDetail1.put("electronicreceiptinfo", (Object)checkDetail.getString("e_remark"));
                BigDecimal debitAmount = checkDetail.getBigDecimal("e_debitamount");
                BigDecimal creditAmount = checkDetail.getBigDecimal("e_creditamount");
                if (debitAmount != null && creditAmount != null) {
                    checkDetail1.put("transactionamount", (Object)(debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount.toPlainString() : debitAmount.toPlainString()));
                } else {
                    checkDetail1.put("transactionamount", (Object)(debitAmount == null ? creditAmount.toPlainString() : debitAmount.toPlainString()));
                }
                checkDetail1.put("creditordebit", checkDetail.get("e_creditmark"));
                checkDetail1.put("balancedirect", (Object)checkDetail.getString("e_balancedirection"));
                checkDetail1.put("accountbalance", (Object)(EmptyUtil.isEmpty(checkDetail.getBigDecimal("e_acctamount")) ? "" : checkDetail.getBigDecimal("e_acctamount").toPlainString()));
                checkDetail1.put("transactioncode", (Object)checkDetail.getString("e_transactioncode"));
                checkDetail1.put("counterpartyaccount", (Object)checkDetail.getString("e_oppositeacct"));
                checkDetail1.put("counterpartyname", (Object)checkDetail.getString("e_oppositeacctname"));
                checkDetail1.put("depositorybank", (Object)checkDetail.getString("e_oppositebank"));
                checkDetail1.put("bookkeeper", (Object)checkDetail.getString("e_bookkeeper"));
                Date bookTime = checkDetail.getDate("e_booktime");
                checkDetail1.put("booktime", (Object)(EmptyUtil.isEmpty(bookTime) ? "" : DateUtils.formatString(bookTime, "HH-mm-ss")));
                checkDetail1.put("accountjournal", (Object)checkDetail.getString("e_bookjournal"));
                checkDetail1.put("otherinfo", (Object)checkDetail.getString("e_otherbookinfo"));
                checkDetail1.put("electronicreceiptnumber", (Object)checkDetail.getString("e_elecreceiptno"));
                checkDetail1.put("businessserialnumber", (Object)checkDetail.getString("e_businessserialnumber"));
                entryEntityJson.add((Object)checkDetail1);
            }
            ticketBill.put("entryentity", (Object)entryEntityJson);
            String collect = bill.getDynamicObjectCollection("urlentry").stream().map(s -> s.getString("e_fileservicepath")).collect(Collectors.joining(";"));
            ticketBill.put("fileurl", (Object)collect);
            ticekBills.add(ticketBill);
            returnData.put(bill.getLong("id"), ticekBills);
        }
        return returnData;
    }

    private Map<Long, List<JSONObject>> findArchiveByReceipt(String billType, String pageId, Set<Long> ids, Long accorgid) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        List<Object> bills = new ArrayList(10);
        if (EmptyUtil.isNoEmpty(accorgid)) {
            if (Arrays.asList("cas_paybill", "cas_recbill", "cas_agentpaybill").contains(billType)) {
                bills = Arrays.stream(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)).filter(b -> accorgid.equals(b.get("openorg.id"))).collect(Collectors.toList());
            } else if (Arrays.asList("fca_transupbill", "fca_transdownbill").contains(billType)) {
                bills = Arrays.stream(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)).filter(b -> accorgid.equals(b.get("accountbank.openorg.id"))).collect(Collectors.toList());
            } else {
                Map<Long, List<DynamicObject>> voucherIdGroup = Arrays.stream(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)).filter(b -> "gl_voucher".equals(b.getString("sourcebilltype"))).collect(Collectors.groupingBy(b -> b.getLong("sourcebillid")));
                Set<Long> voucherIds = voucherIdGroup.keySet();
                DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,org.id", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds).and("org.id", "=", (Object)accorgid)});
                List voucherIDByAccorgIds = vouchers.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                for (Map.Entry<Long, List<DynamicObject>> entry2 : voucherIdGroup.entrySet()) {
                    if (!voucherIDByAccorgIds.contains(entry2.getKey())) continue;
                    bills.addAll((Collection)entry2.getValue());
                }
            }
        } else {
            bills = Arrays.stream(BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)).collect(Collectors.toList());
        }
        if (bills.size() == 0) {
            return null;
        }
        HashMap<Long, List<JSONObject>> returnData = new HashMap<Long, List<JSONObject>>(bills.size());
        ArrayList<DynamicObject> billsListBankCheck = new ArrayList<DynamicObject>(10);
        HashSet<Long> detailIds = new HashSet<Long>(10);
        for (DynamicObject dynamicObject : bills) {
            Set<Long> idsSet = this.getBotpRtansDetails(dynamicObject.getLong("id"), billType);
            if (idsSet.size() > 0) {
                detailIds.addAll(idsSet);
            }
            if (idsSet.size() != 0) continue;
            billsListBankCheck.add(dynamicObject);
        }
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        List list2 = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        list2 = list2.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<Object> bankCheckFlags0 = new ArrayList(10);
        if (StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transupbill") || StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transdownbill")) {
            for (DynamicObject dynamicObject : billsListBankCheck) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entrys");
                for (DynamicObject bankcheck : dynamicObjectCollection) {
                    String bankCheckFlag = bankcheck.getString("bankcheckflag");
                    bankCheckFlags0.add(bankCheckFlag);
                }
            }
        } else {
            bankCheckFlags0 = billsListBankCheck.stream().map(bill -> bill.getString("bankcheckflag")).collect(Collectors.toList());
        }
        List<Object> bankCheckFlags = new ArrayList(bankCheckFlags0.size());
        for (String string : bankCheckFlags0) {
            if (string.contains(",")) {
                String[] stringArray = string.split(",");
                Collections.addAll(bankCheckFlags, stringArray);
                continue;
            }
            bankCheckFlags.add(string);
        }
        bankCheckFlags = bankCheckFlags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password,validcode,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,amount,currency,createtime", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", bankCheckFlags).or(new QFilter("receiptno", "in", list2))});
        for (DynamicObject dynamicObject : bills) {
            String bankCheckFlag = "";
            if (StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transupbill") || StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transdownbill")) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entrys");
                for (DynamicObject bankcheck : dynamicObjectCollection) {
                    String bankCheckFlag1 = bankcheck.getString("bankcheckflag");
                    if (StringUtils.isNotEmpty((CharSequence)bankCheckFlag)) {
                        bankCheckFlag = bankCheckFlag + "," + bankCheckFlag1;
                        continue;
                    }
                    bankCheckFlag = bankCheckFlag1;
                }
            } else {
                bankCheckFlag = dynamicObject.getString("bankcheckflag");
            }
            ArrayList<String> splitBankCheckFlag = new ArrayList<String>(5);
            String[] split = bankCheckFlag.split(",");
            if (StringUtils.isNotBlank((CharSequence)split[0])) {
                splitBankCheckFlag.addAll(Arrays.asList(split));
            }
            Set<Long> idsSet = this.getBotpRtansDetails(dynamicObject.getLong("id"), billType);
            List<Object> tickBills = new ArrayList(8);
            if (idsSet.size() > 0) {
                logger.info(dynamicObject.getPkValue() + "\u5b58\u5728botp\u5173\u8054\u7684\u4ea4\u6613\u660e\u7ec6");
                DynamicObject[] detailsTemp = this.getDetails(idsSet);
                List receiptno = Stream.of(detailsTemp).map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
                List<DynamicObject> receiptList = Stream.of(dynamicObjectArray).filter(receipt -> receiptno.contains(receipt.getString("receiptno"))).collect(Collectors.toList());
                tickBills = this.getJsonReturnData(receiptList, dynamicObject, billType, pageId, accorgid);
            }
            if ((idsSet.size() == 0 || tickBills.size() == 0) && splitBankCheckFlag.size() > 0) {
                ArrayList<DynamicObject> receiptList = new ArrayList<DynamicObject>(dynamicObjectArray.length);
                for (DynamicObject receipt2 : dynamicObjectArray) {
                    DynamicObjectCollection matchdetailentry = receipt2.getDynamicObjectCollection("matchdetailentry");
                    List existsFlag = matchdetailentry.stream().filter(entry -> splitBankCheckFlag.contains(String.valueOf(entry.get("e_bankcheckflag")))).collect(Collectors.toList());
                    if (existsFlag.size() <= 0) continue;
                    receiptList.add(receipt2);
                }
                logger.info(dynamicObject.getPkValue() + "\u6ca1\u6709\u5173\u8054\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u901a\u8fc7\u5bf9\u8d26\u6807\u8bc6\u7801\u67e5\u8be2BankCheckFlag:" + bankCheckFlag);
                tickBills = this.getJsonReturnData(receiptList, dynamicObject, billType, pageId, accorgid);
            }
            if (tickBills.size() <= 0) continue;
            returnData.put(dynamicObject.getLong("id"), tickBills);
        }
        return returnData;
    }

    private List<JSONObject> getJsonReturnData(List<DynamicObject> receiptList, DynamicObject bill, String billType, String pageId, Long accorgid) {
        ArrayList<JSONObject> tickBills = new ArrayList<JSONObject>(8);
        for (DynamicObject receipt : receiptList) {
            DynamicObject[] bankJournals;
            JSONObject ticketBill = new JSONObject();
            ticketBill.put("org", (Object)accorgid);
            ticketBill.put("bookdate", (Object)DateUtils.formatString(receipt.getDate("createtime"), "yyyy-MM-dd"));
            ticketBill.put("tickettype", (Object)TicketType.BKER_RECEIVER.getValue());
            ticketBill.put("identifyingcode", (Object)receipt.getString("validcode"));
            ticketBill.put("seqno", (Object)receipt.getString("receiptno"));
            DynamicObjectCollection dynamicObjectCollection = null;
            if (!StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transupbill") && !StringUtils.equals((CharSequence)billType, (CharSequence)"fca_transdownbill")) {
                dynamicObjectCollection = bill.getDynamicObjectCollection("entry");
            }
            if (dynamicObjectCollection != null && ("cas_paybill".equals(billType) || "cas_recbill".equals(billType))) {
                String contractNumberStr = StringUtils.join((Object[])dynamicObjectCollection.stream().map(dyObj -> dyObj.getString("contractnumber")).toArray(), (String)",");
                ticketBill.put("contractnumber", (Object)contractNumberStr);
            } else {
                ticketBill.put("contractnumber", (Object)"");
            }
            BigDecimal amountPayAndRec = BigDecimal.ZERO;
            if (dynamicObjectCollection != null) {
                if ("cas_paybill".equals(billType)) {
                    for (DynamicObject dyObj2 : dynamicObjectCollection) {
                        amountPayAndRec = amountPayAndRec.add(dyObj2.getBigDecimal("e_payableamt"));
                    }
                } else if ("cas_recbill".equals(billType)) {
                    for (DynamicObject dyObj2 : dynamicObjectCollection) {
                        amountPayAndRec = amountPayAndRec.add(dyObj2.getBigDecimal("e_receivableamt"));
                    }
                }
            }
            ticketBill.put("payandrevamount", (Object)amountPayAndRec.toPlainString());
            ticketBill.put("hasbeenclaimed", (Object)"");
            boolean ischeck = true;
            QFilter filter1 = new QFilter("sourcebilltype", "=", (Object)billType);
            QFilter filter2 = new QFilter("sourcebillid", "=", (Object)bill.getLong("id"));
            for (DynamicObject bankJournal : bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,ischeck", (QFilter[])new QFilter[]{filter1, filter2})) {
                if (!bankJournal.getBoolean("ischeck")) continue;
                ischeck = false;
                break;
            }
            ticketBill.put("hasbeenreconciled", (Object)ischeck);
            ticketBill.put("hasbeentransfer", (Object)"");
            List<String> pdfUrls = this.getPdfUrl(pageId, receipt);
            if (pdfUrls.size() > 0) {
                ticketBill.put("fileurl", (Object)pdfUrls.get(0));
            } else {
                ticketBill.put("fileurl", (Object)"");
            }
            ticketBill.put("billid", (Object)receipt.getPkValue().toString());
            ticketBill.put("currency", (Object)(receipt.getDynamicObject("currency") == null ? "" : receipt.getDynamicObject("currency").getPkValue().toString()));
            ticketBill.put("transactionamountinfigure", (Object)(receipt.getBigDecimal("amount") == null ? BigDecimal.ZERO.toPlainString() : receipt.getBigDecimal("amount").toPlainString()));
            tickBills.add(ticketBill);
        }
        return tickBills;
    }

    private List<String> getPdfUrl(String pageId, DynamicObject receipt) {
        ArrayList<String> returnUrls = new ArrayList<String>(10);
        if (receipt.getBoolean("fileflag")) {
            logger.info("\u8bbe\u7f6eusername-------" + receipt.getString("username"));
            System.setProperty("ereceipt.authuser", receipt.getString("username"));
            String uploadfilename = this.getRealUploadUrl(receipt);
            String fileserverurl = receipt.getString("fileserverurl");
            if (!EmptyUtil.isEmpty(fileserverurl)) {
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObjectCollection userObj = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
                DynamicObjectCollection configObj = QueryServiceHelper.query((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter("enable", "=", (Object)"A").toArray());
                String imgsysUrl = "";
                if (EmptyUtil.isNoEmpty(configObj)) {
                    ScanSystemFactory.getScanService();
                    imgsysUrl = ScanServiceImpl.getImgsysUrl(((DynamicObject)configObj.get(0)).getString("clientid"), ((DynamicObject)configObj.get(0)).getString("clientsecret"), ((DynamicObject)configObj.get(0)).getString("imageurl"), ((DynamicObject)userObj.get(0)).getString("phone"), fileserverurl);
                }
                logger.info("imgsysUrl==========================" + imgsysUrl);
                returnUrls.add(imgsysUrl);
            } else {
                returnUrls.add(uploadfilename);
            }
        } else {
            String strReceiptID = receipt.getString("id");
            Long receiptID = Long.valueOf(strReceiptID);
            try {
                PrintServiceCopy printService = new PrintServiceCopy("bei_elecreceipt", RequestContext.get().getUserId());
                Map<Object, List<Object>> templateForm = printService.getTemplateIdByPK(Collections.singletonList(receiptID));
                templateForm.remove("");
                if (templateForm.size() > 0) {
                    for (Object templateId : templateForm.keySet()) {
                        String templateFormId = MetadataDao.getNumberById((String)templateId.toString());
                        String url = PrintServiceHelper.createPdfUrl((String)pageId, (String)"bei_elecreceipt", (String)templateFormId, (Object[])new Long[]{receiptID});
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            url = url.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(url);
                            continue;
                        }
                        PrtAttach attach = BeiPrintHelper.doNewPrint(pageId, "bei_elecreceipt", (String)templateId, receipt.getPkValue());
                        if (!Objects.nonNull(attach)) continue;
                        List attachDetail = attach.getAttachDetail();
                        for (PrtAttach.AttachDetail detail : attachDetail) {
                            String filePath = detail.getFilePath();
                            filePath = filePath.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(filePath);
                        }
                    }
                } else {
                    logger.info("none printTemplete");
                }
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return returnUrls;
    }

    private Set<Long> getBotpRtansDetails(Long pkId, String entityId) {
        Set<Long> oldRecsrcBill = this.getSrcBillByDestBill(pkId, entityId, "bei_intelrec");
        Set<Long> oldPaysrcBill = this.getSrcBillByDestBill(pkId, entityId, "bei_intelpay");
        Set<Long> newsrcBill = this.getSrcBillByDestBill(pkId, entityId, "bei_transdetail");
        Set<Long> handsrcBill = this.getSrcBillByDestBill(pkId, entityId, "bei_transdetail_cas");
        Set<Long> idsSet = this.mergerSet(oldPaysrcBill, oldRecsrcBill, newsrcBill);
        if (EmptyUtil.isNoEmpty(handsrcBill)) {
            idsSet.addAll(handsrcBill);
        }
        return idsSet;
    }

    private Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>();
        if (EmptyUtil.isNoEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (EmptyUtil.isNoEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (EmptyUtil.isNoEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }

    private DynamicObject[] getDetails(Set<Long> idsSet) {
        return BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,company,accountbank,currency,receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", idsSet)});
    }

    private String getRealUploadUrl(DynamicObject receipt) {
        String uploadFilName = receipt.getString("uploadfilename");
        String realPath = "";
        if (StringUtils.isNotEmpty((CharSequence)uploadFilName)) {
            realPath = uploadFilName;
            if (!uploadFilName.contains(".") && !uploadFilName.contains("/")) {
                try {
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    realPath = attachmentFileService.getFileServiceExt().getRealPath(uploadFilName);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return realPath;
    }

    private Set<Long> getSrcBillByDestBill(Long destBillId, String destEntityKey, String srcEntityKey) {
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)destEntityKey, (Long[])new Long[]{destBillId});
        Set entrySet = srcBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!srcEntityKey.equals(key)) continue;
            return value;
        }
        return null;
    }
}

