/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SystemStatusCtrolHelper {
    private static final Log logger = LogFactory.getLog(SystemStatusCtrolHelper.class);

    public static boolean isFinishInit(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return false;
        }
        return systemStatusCtrol.getBoolean("isfinishinit");
    }

    public static boolean isFinishInitSetting(long orgId) {
        try {
            DynamicObject standardCurrency = SystemStatusCtrolHelper.getStandardCurrency(orgId);
            return standardCurrency != null;
        }
        catch (KDBizException e) {
            return false;
        }
    }

    public static DynamicObject getCurrentPeriod(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return null;
        }
        return systemStatusCtrol.getDynamicObject("currentperiod");
    }

    public static DynamicObject getPeriodType(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        return systemStatusCtrol == null ? null : systemStatusCtrol.getDynamicObject("periodtype");
    }

    public static DynamicObject getStartPeriod(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("startperiod") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("startperiod");
    }

    public static DynamicObject getStandardCurrency(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("standardcurrency") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("standardcurrency");
    }

    public static DynamicObject getExrateTable(long orgId) {
        DynamicObject systemStatusCtrol = SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null || systemStatusCtrol.getDynamicObject("exratetable") == null) {
            logger.info("\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01" + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8fdb\u884c\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return systemStatusCtrol.getDynamicObject("exratetable");
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static DynamicObject loadCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.size() == 0) {
            return null;
        }
        DynamicObject cashMgtInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
        return cashMgtInit;
    }
}

