/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.cal.common.enums.DischargeTypeEnum;
import kd.bos.ext.fi.cal.common.model.CustomValue;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import org.apache.commons.lang3.StringUtils;

public class CalSysParamsPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final long ID = 683799445774680063L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "costsumbilltype", "handcostadjustbilltype");
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public static DynamicObject getSettingObj() {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((Object)683799445774680063L, (String)"cal_setting");
        return setting;
    }

    public static boolean isNewBalance() {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
    }

    public static String getDivideBasisStr() {
        DynamicObject setting = CalSysParamsPlugin.getSettingObj();
        String divideBasisStr = setting.getString("dividebasiscols");
        if (divideBasisStr.startsWith(",")) {
            divideBasisStr = divideBasisStr.substring(1, divideBasisStr.length());
        }
        if (divideBasisStr.endsWith(",")) {
            divideBasisStr = divideBasisStr.substring(0, divideBasisStr.length() - 1);
        }
        return divideBasisStr;
    }

    public static String getCalDimensionStr() {
        DynamicObject setting = CalSysParamsPlugin.getSettingObj();
        String calDimensionStr = setting.getString("caldimensioncols");
        if (calDimensionStr.startsWith(",")) {
            calDimensionStr = calDimensionStr.substring(1, calDimensionStr.length());
        }
        if (calDimensionStr.endsWith(",")) {
            calDimensionStr = calDimensionStr.substring(0, calDimensionStr.length() - 1);
        }
        return calDimensionStr;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String colsStr;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("costsumbiztype".equals(key) || "costsumbilltype".equals(key) && this.getModel().getValue("costsumbilltype") == null) {
            String biztype = (String)this.getModel().getValue("costsumbiztype");
            DynamicObject setting = CalSysParamsPlugin.getSettingObj();
            if ("A".equals(biztype)) {
                this.setInBillTypes("costsumbilltype", setting);
            } else if ("B".equals(biztype)) {
                this.setOutBillTypes("costsumbilltype", setting);
            } else {
                this.getModel().setValue("costsumbiztype", (Object)"B");
            }
        } else if ("handcostadjustbiztype".equals(key) || "handcostadjustbilltype".equals(key) && this.getModel().getValue("handcostadjustbilltype") == null) {
            String biztype = (String)this.getModel().getValue("handcostadjustbiztype");
            DynamicObject setting = CalSysParamsPlugin.getSettingObj();
            if ("A".equals(biztype)) {
                this.setInBillTypes("handcostadjustbilltype", setting);
            } else if ("B".equals(biztype)) {
                this.setOutBillTypes("handcostadjustbilltype", setting);
            } else {
                this.getModel().setValue("handcostadjustbiztype", (Object)"A");
            }
        } else if ("maxnumberentries".equals(key)) {
            int maxNumberEntries = (Integer)this.getModel().getValue("maxnumberentries");
            if (maxNumberEntries > 400000) {
                this.getModel().setValue("maxNumberEntries", (Object)1000);
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u5927\u5206\u5f55\u6570\u4e0d\u80fd\u8d85\u8fc740\u4e07", (String)"CalSysParamsPlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            if (maxNumberEntries <= 0) {
                this.getModel().setValue("maxNumberEntries", (Object)1000);
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u5927\u5206\u5f55\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1", (String)"CalSysParamsPlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
        } else if ("dischargetype".equals(key)) {
            String dischargetype = (String)this.getModel().getValue("dischargetype");
            if (!"B".equals(dischargetype)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"initbill_need_repeattemp"});
                this.getModel().setValue("initbill_need_repeattemp", (Object)false);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"initbill_need_repeattemp"});
            }
        } else if ("multifactoryaccount".equals(key)) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (null == oldValue) {
                oldValue = false;
            }
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (oldValue != null && newValue != null) {
                Boolean oldValueflag = Boolean.valueOf(oldValue.toString());
                Boolean newValueflag = Boolean.valueOf(newValue.toString());
                if (!oldValueflag.booleanValue() && newValueflag.booleanValue()) {
                    CustomValue customValue = new CustomValue(key, newValue.toString(), oldValue.toString());
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u3010\u591a\u5de5\u5382\u6838\u7b97\u3011\u6539\u4e3a\u662f\u540e\uff0c\u5219\u6309\u5e93\u5b58\u7ec4\u7ec7\u8fdb\u884c\u7ef4\u62a4\u6807\u51c6\u6210\u672c\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"CalSysParamsPlugin_6", (String)"bos-ext-fi", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(key, (IFormPlugin)this), null, JSON.toJSONString((Object)customValue));
                }
            }
        } else if ("ap_estimation".equals(key)) {
            boolean apEstimation = (Boolean)this.getModel().getValue("ap_estimation");
            if (apEstimation) {
                this.getModel().setValue("issameperiodwriteback", (Object)Character.valueOf('B'));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"issameperiodwriteback"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"issameperiodwriteback"});
            }
        } else if ("diffalloccols".equals(key) && !StringUtils.isEmpty((CharSequence)(colsStr = (String)this.getModel().getValue("diffalloccols")))) {
            String location;
            String storageorgunit;
            String[] colsStrs = colsStr.split(",");
            StringBuilder sb = new StringBuilder();
            for (String col : colsStrs) {
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                sb.append(col);
                sb.append(",");
            }
            colsStr = sb.toString();
            String calorg = this.checkCoupleItem(colsStr, "storageorgunit", "calorg");
            if (calorg != null) {
                colsStr = calorg;
            }
            if ((storageorgunit = this.checkCoupleItem(colsStr, "warehouse", "storageorgunit")) != null) {
                colsStr = storageorgunit;
            }
            if ((location = this.checkCoupleItem(colsStr, "location", "warehouse")) != null) {
                colsStr = location;
            }
            if (storageorgunit != null || calorg != null || location != null) {
                this.getModel().setValue("diffalloccols", (Object)colsStr);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"multifactoryaccount")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            String customVauleStr = messageBoxClosedEvent.getCustomVaule();
            CustomValue customValue = (CustomValue)JSON.parseObject((String)customVauleStr, CustomValue.class);
            String value = result == MessageBoxResult.Yes ? customValue.getNewValue() : customValue.getOldValue();
            IDataModel model = this.getModel();
            model.beginInit();
            model.setValue(customValue.getPropertyName(), (Object)value);
            model.endInit();
            this.getView().updateView(customValue.getPropertyName());
            boolean multifactoryaccount = (Boolean)this.getModel().getValue("multifactoryaccount");
            if (multifactoryaccount) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"multifactoryaccount"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"multifactoryaccount"});
            }
        }
    }

    private void setOutBillTypes(String string, DynamicObject setting) {
        DynamicObjectCollection calOutBillTypes = setting.getDynamicObjectCollection("caloutbilltypes");
        DynamicObject outBillType = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"im_SalOutBill_STD_BT_S")})[0];
        boolean isContain = false;
        if (calOutBillTypes.size() >= 1) {
            for (DynamicObject billtype : calOutBillTypes) {
                if (!outBillType.getString("id").equals(billtype.getDynamicObject("fbasedataid").getString("id"))) continue;
                isContain = true;
                break;
            }
            if (isContain) {
                this.getModel().setValue(string, (Object)outBillType);
            } else {
                this.getModel().setValue(string, (Object)((DynamicObject)calOutBillTypes.get(0)).getDynamicObject("fbasedataid").getLong("id"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u8d22\u52a1\u4e91--\u5b58\u8d27\u6838\u7b97--\u516c\u5171\u914d\u7f6e--\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u4e0b\u7ef4\u62a4\u51fa\u5e93\u6838\u7b97\u5355\u636e", (String)"CalSysParamsPlugin_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
    }

    private void setInBillTypes(String string, DynamicObject setting) {
        DynamicObjectCollection calInBillTypes = setting.getDynamicObjectCollection("calinbilltypes");
        DynamicObject inBillType = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"im_PurInBill_STD_BT_S")})[0];
        boolean isContain = false;
        if (calInBillTypes.size() >= 1) {
            for (DynamicObject billtype : calInBillTypes) {
                if (!inBillType.getString("id").equals(billtype.getDynamicObject("fbasedataid").getString("id"))) continue;
                isContain = true;
                break;
            }
            if (isContain) {
                this.getModel().setValue(string, (Object)inBillType);
            } else {
                this.getModel().setValue(string, (Object)((DynamicObject)calInBillTypes.get(0)).getDynamicObject("fbasedataid").getLong("id"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u8d22\u52a1\u4e91--\u5b58\u8d27\u6838\u7b97--\u516c\u5171\u914d\u7f6e--\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u4e0b\u7ef4\u62a4\u5165\u5e93\u6838\u7b97\u5355\u636e", (String)"CalSysParamsPlugin_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String dischargetype = (String)this.getModel().getValue("dischargetype");
        if (!"B".equals(dischargetype)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"initbill_need_repeattemp"});
            this.getModel().setValue("initbill_need_repeattemp", (Object)false);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"initbill_need_repeattemp"});
        }
        boolean apEstimation = (Boolean)this.getModel().getValue("ap_estimation");
        if (apEstimation) {
            this.getModel().setValue("issameperiodwriteback", (Object)Character.valueOf('B'));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"issameperiodwriteback"});
        }
        String divideFieldsStr = CalSysParamsPlugin.getDivideBasisStr();
        String caldimensionFieldsStr = CalSysParamsPlugin.getCalDimensionStr();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        this.getDiffAllocComboItems(divideFieldsStr, items);
        this.getDiffAllocComboItems(caldimensionFieldsStr, items);
        if (!items.isEmpty()) {
            ComboEdit co = (ComboEdit)this.getView().getControl("diffalloccols");
            co.setComboItems(items);
        }
        String colsStr = (String)this.getModel().getValue("diffalloccols");
        boolean colsStrIsNull = true;
        if (!StringUtils.isEmpty((CharSequence)colsStr)) {
            String[] colsStrs;
            for (String col : colsStrs = colsStr.split(",")) {
                if (StringUtils.isEmpty((CharSequence)col)) continue;
                colsStrIsNull = false;
                break;
            }
        }
        if (colsStrIsNull) {
            colsStr = ",calorg,";
            this.getModel().setValue("diffalloccols", (Object)colsStr);
        }
    }

    private void getDiffAllocComboItems(String calFieldsStr, List<ComboItem> items) {
        if (!StringUtils.isEmpty((CharSequence)calFieldsStr)) {
            String[] calFields;
            String balanceEntity = CalSysParamsPlugin.isNewBalance() ? "cal_bal" : "cal_balance";
            MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)balanceEntity);
            for (String calField : calFields = calFieldsStr.split(",")) {
                if (StringUtils.isEmpty((CharSequence)calField)) continue;
                IDataEntityProperty pro = entitytype.findProperty(calField);
                ComboItem item = new ComboItem(pro.getDisplayName(), pro.getName());
                items.add(item);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("costsumbilltype".equals(key)) {
            String costsumbiztype = (String)this.getModel().getValue("costsumbiztype");
            showParameter.getListFilterParameter().setFilter(this.getBillTypesFilter(costsumbiztype));
        } else if ("handcostadjustbilltype".equals(key)) {
            String handCostAdjustBizType = (String)this.getModel().getValue("handcostadjustbiztype");
            showParameter.getListFilterParameter().setFilter(this.getBillTypesFilter(handCostAdjustBizType));
        }
    }

    private QFilter getBillTypesFilter(String biztype) {
        DynamicObject setting = CalSysParamsPlugin.getSettingObj();
        if ("A".equals(biztype)) {
            DynamicObjectCollection calInBillTypes = setting.getDynamicObjectCollection("calinbilltypes");
            if (calInBillTypes.size() >= 1) {
                HashSet<Long> calInBillTypeIds = new HashSet<Long>();
                for (DynamicObject calInBillType : calInBillTypes) {
                    calInBillTypeIds.add(calInBillType.getDynamicObject("fbasedataid").getLong("id"));
                }
                return new QFilter("id", "in", calInBillTypeIds);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u8d22\u52a1\u4e91--\u5b58\u8d27\u6838\u7b97--\u516c\u5171\u914d\u7f6e--\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u4e0b\u7ef4\u62a4\u5165\u5e93\u6838\u7b97\u5355\u636e", (String)"CalSysParamsPlugin_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if ("B".equals(biztype)) {
            DynamicObjectCollection calOutBillTypes = setting.getDynamicObjectCollection("caloutbilltypes");
            if (calOutBillTypes.size() >= 1) {
                HashSet<Long> calOutBillTypeIds = new HashSet<Long>();
                for (DynamicObject calOutBillType : calOutBillTypes) {
                    calOutBillTypeIds.add(calOutBillType.getDynamicObject("fbasedataid").getLong("id"));
                }
                return new QFilter("id", "in", calOutBillTypeIds);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u8d22\u52a1\u4e91--\u5b58\u8d27\u6838\u7b97--\u516c\u5171\u914d\u7f6e--\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u4e0b\u7ef4\u62a4\u51fa\u5e93\u6838\u7b97\u5355\u636e", (String)"CalSysParamsPlugin_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u5355\u7c7b\u578b", (String)"CalSysParamsPlugin_4", (String)"bos-ext-fi", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean multifactoryaccount = (Boolean)this.getModel().getValue("multifactoryaccount");
        if (multifactoryaccount) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"multifactoryaccount"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"multifactoryaccount"});
        }
        String dischargetype = (String)this.getModel().getValue("dischargetype");
        if (!"B".equals(dischargetype)) {
            ComboEdit co = (ComboEdit)this.getView().getControl("dischargetype");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(DischargeTypeEnum.BILLCOMECLEAR.getDesc()), DischargeTypeEnum.BILLCOMECLEAR.getValue()));
            items.add(new ComboItem(new LocaleString(DischargeTypeEnum.UNCLEAR.getDesc()), DischargeTypeEnum.UNCLEAR.getValue()));
            co.setComboItems(items);
        }
        this.getPageCache().put("olddischargetype", dischargetype);
    }

    private String checkCoupleItem(String str, String hasVal, String addVal) {
        CharSequence[] items = str.split(",");
        int hasValIdx = -1;
        int addValIdx = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(hasVal)) {
                hasValIdx = i;
                continue;
            }
            if (!items[i].equals(addVal)) continue;
            addValIdx = i;
        }
        if (hasValIdx > -1 && addValIdx == -1) {
            items[hasValIdx] = hasVal + "," + addVal;
            return String.join((CharSequence)",", items) + ",";
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("donothing".equals(key)) {
            String newDischargetype = (String)this.getModel().getValue("dischargetype");
            String oldDischargetype = this.getPageCache().get("olddischargetype");
            if (StringUtils.isEmpty((CharSequence)newDischargetype) || newDischargetype.equals(oldDischargetype)) {
                return;
            }
            Long org = ((IParameterModel)this.getModel()).getOrgId();
            Set<Long> allEffectOrgIds = this.getEffectOrgIds(org);
            Map<Date, Set<Long>> curPeriodBeginDate2CostAccountIdMap = this.getCurBeginDate2EnableCostAccountMap(allEffectOrgIds);
            HashSet<Long> hasVoucherOrgIds = new HashSet<Long>(4);
            ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
            QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)true);
            voucherFilter.and("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill", "im_ospurinbill"});
            for (Map.Entry<Date, Set<Long>> entry : curPeriodBeginDate2CostAccountIdMap.entrySet()) {
                Date date = entry.getKey();
                Set<Long> costAccountIds = entry.getValue();
                QFilter filter = new QFilter("costaccount", "in", costAccountIds);
                filter.and("bookdate", ">=", (Object)date);
                OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", "calorg", new QFilter[]{filter, voucherFilter});
                inputs.add(input);
                if (inputs.size() < 5) continue;
                DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0])).distinct();
                for (Row row : dataSet) {
                    hasVoucherOrgIds.add(row.getLong("calorg"));
                }
            }
            if (inputs.size() > 0) {
                DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0])).distinct();
                for (Row row : dataSet) {
                    hasVoucherOrgIds.add(row.getLong("calorg"));
                }
            }
            if (!hasVoucherOrgIds.isEmpty()) {
                this.showErrMsg(hasVoucherOrgIds);
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : curPeriodBeginDate2CostAccountIdMap.entrySet()) {
                builder.append(((Date)entry.getKey()).getTime());
                builder.append(":");
                for (Long aLong : (Set)entry.getValue()) {
                    builder.append(aLong);
                    builder.append(",");
                }
                builder.append("#");
            }
            this.getPageCache().put("curPeriodBeginDate2CostAccountIdMap", builder.toString());
        }
    }

    private Map<Date, Set<Long>> getCurBeginDate2EnableCostAccountMap(Set<Long> calOrgids) {
        HashMap<Date, Set<Long>> map = new HashMap<Date, Set<Long>>(4);
        QFilter filter = new QFilter("entry.isenabled", "=", (Object)true);
        filter.and("entry.costaccount.enable", "=", (Object)true);
        if (calOrgids != null && !calOrgids.isEmpty()) {
            filter.and("org", "in", calOrgids);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_sysctrlentity", (String)"entry.currentperiod.begindate,entry.costaccount", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long costaccountid = row.getLong("entry.costaccount");
                Date curBegindate = row.getDate("entry.currentperiod.begindate");
                Set costaccountids = map.computeIfAbsent(curBegindate, k -> new HashSet(4));
                costaccountids.add(costaccountid);
            }
        }
        return map;
    }

    private void showErrMsg(Set<Long> hasVoucherOrgIds) {
        HashSet<String> calOrgNames = new HashSet<String>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "in", hasVoucherOrgIds).toArray(), null);){
            for (Row row : dataSet) {
                calOrgNames.add(row.getString("name"));
            }
        }
        String msg = ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u3010%1$s\u3011\u7684\u91c7\u8d2d\u3001\u59d4\u5916\u7c7b\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5b58\u8d27\u6682\u4f30\u65b9\u5f0f\u3002", (String)"CalSysParamsPlugin_5", (String)"bos-ext-fi", (Object[])new Object[0]);
        msg = String.format(msg, String.join((CharSequence)"; ", calOrgNames));
        throw new KDBizException(msg);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("donothing".equals(key)) {
            this.updateBillDischargetype();
            String newDischargetype = (String)this.getModel().getValue("dischargetype");
            this.getPageCache().put("olddischargetype", newDischargetype);
            this.getPageCache().put("curPeriodBeginDate2CostAccountIdMap", null);
        }
    }

    private void updateBillDischargetype() {
        String[] date2costAccoutStrs;
        String str = this.getPageCache().get("curPeriodBeginDate2CostAccountIdMap");
        HashMap bookdate2CostAccountMap = new HashMap(4);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return;
        }
        for (String date2costAccoutStr : date2costAccoutStrs = str.split("#")) {
            if (StringUtils.isEmpty((CharSequence)date2costAccoutStr)) continue;
            String[] dates = date2costAccoutStr.split(":");
            Date bookdate = new Date(Long.parseLong(dates[0]));
            HashSet<Long> costAccountids = new HashSet<Long>(4);
            for (String s : dates[1].split(",")) {
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                costAccountids.add(Long.valueOf(s));
            }
            bookdate2CostAccountMap.put(bookdate, costAccountids);
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(8);
        QFilter filter = new QFilter("bizentityobject", "in", (Object)new String[]{"im_purinbill", "im_mdc_ominbill", "im_ospurinbill"});
        for (Map.Entry entry : bookdate2CostAccountMap.entrySet()) {
            QFilter curFilter = new QFilter("costaccount", "in", entry.getValue());
            curFilter.and("bookdate", ">=", entry.getKey());
            curFilter.and(filter);
            OrmInput input = new OrmInput(((Object)((Object)this)).getClass().getName(), "cal_costrecord", "id,bookdate,costaccount", curFilter.toArray());
            inputs.add(input);
            if (inputs.size() < 5) continue;
            DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
            Object object = null;
            try {
                this.flush2DB(dataSet);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            inputs.clear();
        }
        if (inputs.size() >= 1) {
            try (DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(inputs.toArray(new Input[0]));){
                this.flush2DB(dataSet);
            }
        }
    }

    private void flush2DB(DataSet dataSet) {
        String newDischargetype = (String)this.getModel().getValue("dischargetype");
        String updateSql = "update t_cal_calcostrecord set fdischargetype = '" + newDischargetype + "' where fid in ";
        dataSet = dataSet.orderBy(new String[]{"costaccount", "bookdate"});
        HashSet<Long> costAccountIds = new HashSet<Long>(4);
        Date minBookdate = null;
        Date maxBookdate = null;
        HashSet<Long> ids = new HashSet<Long>(5000);
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            Long costAccountId = row.getLong("costaccount");
            Date bookdate = row.getDate("bookdate");
            if (minBookdate == null || minBookdate.after(bookdate)) {
                minBookdate = bookdate;
            }
            if (maxBookdate == null || maxBookdate.before(bookdate)) {
                maxBookdate = bookdate;
            }
            costAccountIds.add(costAccountId);
            ids.add(id);
            if (ids.size() < 5000) continue;
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)minBookdate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)maxBookdate)});){
                ctx.set();
                DB.execute((DBRoute)new DBRoute("cal"), (String)(updateSql + this.getIdInString(ids)));
            }
            ids.clear();
            minBookdate = null;
            maxBookdate = null;
            costAccountIds.clear();
        }
        if (ids.size() > 0) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, costAccountIds), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.ge, (Object)minBookdate), new ShardingHintContext.ShardingHintCondition("fbookdate", FilterType.le, (Object)maxBookdate)});){
                ctx.set();
                DB.execute((DBRoute)new DBRoute("cal"), (String)(updateSql + this.getIdInString(ids)));
            }
        }
    }

    private Set<Long> getEffectOrgIds(Long curOrgId) {
        List allChildOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", Collections.singletonList(curOrgId), (boolean)false);
        if (allChildOrgs.isEmpty()) {
            return Collections.singleton(curOrgId);
        }
        String sql = "SELECT DISTINCT FORGID FROM t_bas_sysparameter WHERE FPARAMID IN (SELECT FID FROM t_bas_sysparaconsole WHERE FFORMID = 'cal_params' AND FENABLED='1') AND FVIEWTYPEID= '10' ";
        String string = this.getIdInString(allChildOrgs);
        sql = sql + " AND FORGID IN " + string;
        ArrayList<Long> noEffectOrgIds = new ArrayList<Long>(10);
        try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("sys"), (String)sql);){
            for (Row row : ds) {
                Long id = row.getLong("FORGID");
                if (null == id) continue;
                noEffectOrgIds.add(id);
            }
        }
        List allNoEffectOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", noEffectOrgIds, (boolean)true);
        HashSet<Long> effectOrgIds = new HashSet<Long>(10);
        effectOrgIds.addAll(allChildOrgs);
        effectOrgIds.removeAll(allNoEffectOrgIds);
        effectOrgIds.add(curOrgId);
        return effectOrgIds;
    }

    private String getIdInString(Collection allChildOrgs) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        Iterator iterator = allChildOrgs.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(")");
        return builder.toString();
    }
}

