/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRule;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;

public class ArApSettleSchemeOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(ArApSettleSchemeOpAction.class);
    private static final Map<String, List<String>> isDoOperationMap = new HashMap<String, List<String>>();

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OpBizRule bizRule = this.getBizRule();
        String opName = (String)this.operateMeta.get("key");
        String entityName = e.getDataEntities()[0].getDataEntityType().getName();
        if (!isDoOperationMap.get(entityName).contains(opName)) {
            logger.info("not need do Operation\uff1a" + opName + "billEntity:" + entityName);
            return;
        }
        DynamicObject[] billDatas = e.getDataEntities();
        if (billDatas.length == 0) {
            logger.info("billDatas.length = 0");
            return;
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        List arsettleschemeids = (List)params.get("arsettleschemeids");
        List apsettleschemeids = (List)params.get("apsettleschemeids");
        Object[] arSchemes = BusinessDataServiceHelper.load((Object[])arsettleschemeids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_settlescheme"));
        Object[] apSchemes = BusinessDataServiceHelper.load((Object[])apsettleschemeids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ap_settlescheme"));
        boolean isAr = this.isAr(entityName);
        DynamicObject[] settleSchemes = isAr ? (DynamicObject[])ArrayUtils.addAll((Object[])arSchemes, (Object[])apSchemes) : (DynamicObject[])ArrayUtils.addAll((Object[])apSchemes, (Object[])arSchemes);
        this.invokeBizService(settleSchemes, e.getDataEntities());
    }

    private void invokeBizService(DynamicObject[] settleSchemes, DynamicObject[] dataEntities) {
        Set billNos = Arrays.stream(dataEntities).map(entity -> entity.getString("billno")).collect(Collectors.toSet());
        String entityName = dataEntities[0].getDataEntityType().getName();
        ThreadPools.executeOnceIncludeRequestContext((String)"invoke.schemeSettle", () -> {
            logger.info("invoke.schemeSettle begin");
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArApSchemeSettleActionService", (String)"schemeSettle", (Object[])new Object[]{settleSchemes, entityName, billNos});
                logger.info("invoke.schemeSettle success");
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }

    private boolean isAr(String entityName) {
        return "ar_finarbill".equals(entityName) || "cas_recbill".equals(entityName);
    }

    static {
        isDoOperationMap.put("ap_finapbill", Arrays.asList("submit", "audit"));
        isDoOperationMap.put("ar_finarbill", Arrays.asList("submit", "audit"));
        isDoOperationMap.put("cas_paybill", Collections.singletonList("pay"));
        isDoOperationMap.put("cas_recbill", Collections.singletonList("receivingrec"));
    }
}

