/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;

public class AntiClosePeriodService
extends EntityOperateService {
    protected void executeOperate(DynamicObject[] arg0) {
    }

    protected void writeLog(OperationResult opResult) {
        if ("gl_autocloseperiod".equalsIgnoreCase(this.getBillEntityType().getName())) {
            return;
        }
        if (this.getExtendDataEntitySet().FindByEntityKey(this.subEntityType.getName()).length > 1) {
            super.writeLog(opResult);
        } else {
            this.writeOneLog(opResult);
        }
    }

    private void writeOneLog(OperationResult opResult) {
        if (opResult.isCancelWriteLog()) {
            this.getOperateLog().info("EntityOperateService.writeLog: isCancelWriteLog");
            return;
        }
        this.getOperateLog().info("EntityOperateService.writeLog: begin");
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(10);
        IDataEntityProperty billNoProp = null;
        MainOrgProp mainOrgProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
            mainOrgProp = bdType.getMainOrgProperty();
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
            mainOrgProp = ((BillEntityType)this.subEntityType).getMainOrgProperty();
        }
        List errorInfos = opResult.getAllErrorOrValidateInfo();
        appLogInfoList = new ArrayList(10);
        HashSet<Long> errorIds = new HashSet<Long>();
        if (!errorInfos.isEmpty()) {
            ExtendedDataEntity[] billDataEntitys = this.getExtendDataEntitySet().FindByEntityKey(this.subEntityType.getName());
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(billDataEntitys.length);
            for (ExtendedDataEntity dataEntity : billDataEntitys) {
                map.put(dataEntity.getDataEntity().get("id"), dataEntity.getDataEntity());
            }
            for (IOperateInfo errorInfo : errorInfos) {
                Long mainOrgId = 0L;
                DynamicObject billObj = (DynamicObject)map.get(errorInfo.getPkValue());
                if (mainOrgProp != null && billObj != null) {
                    Object value = mainOrgProp.getValue((Object)billObj);
                    if (value instanceof DynamicObject) {
                        DynamicObject mainOrg = (DynamicObject)value;
                        mainOrgId = (Long)mainOrg.getPkValue();
                    }
                    errorIds.add(billObj.getLong("id"));
                }
                String message = this.appendMessage(errorInfo.getMessage(), billObj);
                AppLogInfo logInfo = this.buildLogInfo(message, mainOrgId);
                appLogInfoList.add(logInfo);
            }
            if (!appLogInfoList.isEmpty()) {
                logService.addBatchLog(appLogInfoList);
            }
        }
        for (DynamicObject successObj : this.getSuccessDataEntities()) {
            Object value;
            if (errorIds.contains(successObj.get("id"))) {
                return;
            }
            String msg = "";
            String billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)successObj);
            msg = StringUtils.isBlank((CharSequence)billNo) ? String.format(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"EntityOperateService_16", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getOpName()) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"EntityOperateService_17", (String)"bos-mservice-operation", (Object[])new Object[0]), billNo, this.getOpName());
            Long mainOrgId = 0L;
            if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)successObj)) instanceof DynamicObject) {
                DynamicObject mainOrg = (DynamicObject)value;
                mainOrgId = (Long)mainOrg.getPkValue();
            }
            AppLogInfo logInfo = this.buildLogInfo(msg, mainOrgId);
            appLogInfoList.add(logInfo);
            if (appLogInfoList.isEmpty()) continue;
            logService.addBatchLog(appLogInfoList);
        }
        opResult.setCancelWriteLog(true);
        this.getOperateLog().info("EntityOperateService.writeLog: end");
    }

    private String appendMessage(String message, DynamicObject billObj) {
        try {
            DynamicObject typeField = QueryServiceHelper.queryOne((String)"bd_accountbookregister", (String)"booktypefieldid", (QFilter[])new QFilter("bizapp", "=", (Object)this.billEntityType.getAppId()).toArray());
            String field = typeField.getString("booktypefieldid");
            if (StringUtils.isNotBlank((CharSequence)field)) {
                BasedataProp prop = (BasedataProp)billObj.getDataEntityType().getProperties().get((Object)field);
                DynamicObject typeName = QueryServiceHelper.queryOne((String)prop.getBaseEntityId(), (String)"name", (QFilter[])new QFilter("id", "=", billObj.get(field)).toArray());
                return typeName == null ? message : typeName.get("name") + ": " + message;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }
}

