/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodContext;
import kd.bos.ext.fi.operation.closeperiod.option.ClosePeriodOption;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.result.ClosePeriodResultServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public abstract class AbstractClosePeriodValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(AbstractClosePeriodValidator.class);
    private String appNumber;
    private BookRegisterInfo bookRegisterInfo;
    private ResultCollector collector;
    private boolean runInTX = false;
    private List<OperateErrorInfo> suggestions;

    public void initialize() {
        super.initialize();
        this.appNumber = ClosePeriodOption.getBizAppNumber(this.getOption(), this.getValidateContext().getBillEntityType().getBizAppNumber());
        this.bookRegisterInfo = BookRegisterService.queryByBizApp(this.appNumber);
        this.collector = new ResultCollector(this.getOption(), ClosePeriodOption.getCloseEventId(this.getOption()));
        LOG.info("Close period validator initialize: {},appNum: {}, bookRegisterInfo: {}.", new Object[]{((Object)((Object)this)).getClass().getName(), this.appNumber, this.bookRegisterInfo});
    }

    public void validate() {
        try {
            boolean validateInTX;
            ClosePeriodContext closePeriodContext = ClosePeriodContext.get();
            boolean bl = validateInTX = closePeriodContext != null && closePeriodContext.isValidateInTX();
            if (validateInTX == this.isRunInTX()) {
                LOG.info("Close period validator start: {}.", (Object)((Object)((Object)this)).getClass().getName());
                this.suggestions = new ArrayList<OperateErrorInfo>(this.dataEntities.length);
                this.doValidate();
            }
        }
        finally {
            LOG.info("Close period validator end: {}.", (Object)((Object)((Object)this)).getClass().getName());
            if (this.collector != null) {
                this.collector.close();
                this.collector = null;
            }
        }
    }

    public abstract void doValidate();

    public String getAppNumber() {
        return this.appNumber;
    }

    public BookRegisterInfo getBookRegisterInfo() {
        return this.bookRegisterInfo;
    }

    public boolean isRunInTX() {
        return this.runInTX;
    }

    public void setRunInTX(boolean runInTX) {
        this.runInTX = runInTX;
    }

    protected void addFlatError(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, String message) {
        this.addError(dataEntity, orgId, bookTypeId, message, message, ErrorLevel.FatalError);
    }

    protected void addError(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, String message) {
        this.addError(dataEntity, orgId, bookTypeId, message, message, ErrorLevel.Error);
    }

    protected void addError(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, String title, String message, ErrorLevel errorLevel) {
        CloseCheckItemResult closeCheckItemResult = CloseCheckItemResult.buildFailed(title, message);
        closeCheckItemResult.setErrorLevel(errorLevel);
        this.addCheckItemResult(dataEntity, orgId, bookTypeId, closeCheckItemResult);
    }

    protected void addCheckItemResult(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, CloseCheckItemResult itemResult) {
        this.recordItemResult(orgId, bookTypeId, itemResult);
        if ("0".equals(itemResult.getCheckState())) {
            if (StringUtils.isNotEmpty((String)itemResult.getCheckItem())) {
                this.addMessage(dataEntity, itemResult.getCheckItem(), itemResult.getMessage(), itemResult.getErrorLevel());
            } else {
                this.addMessage(dataEntity, itemResult.getMessage(), itemResult.getErrorLevel());
            }
        }
    }

    protected void addSuggestion(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, CloseCheckItemResult itemResult) {
        this.recordItemResult(orgId, bookTypeId, itemResult);
        if ("0".equals(itemResult.getCheckState())) {
            OperateErrorInfo errorInfo = new OperateErrorInfo(ClosePeriodErrorCode.SUGGESTION_0001.name(), ErrorLevel.Info, dataEntity.getBillPkId());
            errorInfo.setTitle(itemResult.getCheckItem());
            errorInfo.setMessage(itemResult.getMessage());
            this.suggestions.add(errorInfo);
        }
    }

    protected void addCheckResultWrapper(ExtendedDataEntity dataEntity, long orgId, long bookTypeId, CheckExecutionResult.CheckResultWrapper checkResultWrapper) {
        CloseCheckItemResult itemResult = CloseCheckItemResult.fromCheckResultWrapper(checkResultWrapper);
        if (!CheckItemDetail.SUGGEST_TYPE_ERR.equals(checkResultWrapper.getCheckItem().getSuggestType())) {
            this.addSuggestion(dataEntity, orgId, bookTypeId, itemResult);
        } else {
            this.addCheckItemResult(dataEntity, orgId, bookTypeId, itemResult);
        }
    }

    protected void recordItemResult(long orgId, long bookTypeId, CloseCheckItemResult itemResult) {
        if (bookTypeId > 0L) {
            this.collector.collect(orgId + "_" + bookTypeId, itemResult);
        } else {
            this.collector.collect(String.valueOf(orgId), itemResult);
        }
    }

    public List<OperateErrorInfo> getSuggestions() {
        if (this.suggestions == null) {
            return Collections.emptyList();
        }
        return this.suggestions;
    }

    private static class ResultCollector
    implements AutoCloseable {
        private final Map<String, List<CloseCheckItemResult>> results;
        private final OperateOption operateOption;
        private final String closeEventId;

        public ResultCollector(OperateOption operateOption, String closeEventId) {
            this.operateOption = operateOption;
            this.closeEventId = closeEventId;
            this.results = new HashMap<String, List<CloseCheckItemResult>>();
        }

        public void collect(String resultKey, CloseCheckItemResult result) {
            this.results.computeIfAbsent(resultKey, k -> new ArrayList(10)).add(result);
        }

        public void collect(String resultKey, Collection<CloseCheckItemResult> results) {
            this.results.computeIfAbsent(resultKey, k -> new ArrayList(10)).addAll(results);
        }

        @Override
        public void close() {
            String closeCacheKey = this.operateOption.getVariableValue("closeCacheKey", "");
            if (StringUtils.isNotEmpty((String)closeCacheKey)) {
                this.results.forEach((resultKey, resultList) -> ClosePeriodResultServiceHelper.recordItemResult(closeCacheKey, resultList));
            } else if (StringUtils.isNotEmpty((String)this.closeEventId)) {
                this.results.forEach((resultKey, resultList) -> ClosePeriodResultServiceHelper.recordItemResult(this.closeEventId + resultKey, resultList));
            }
        }
    }

    public static enum ClosePeriodErrorCode {
        SUGGESTION_0001;

    }
}

