/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodService;
import kd.bos.ext.fi.operation.closeperiod.option.ClosePeriodOption;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ReachPeriodValidator
extends AbstractClosePeriodValidator {
    private final Table<Long, Long, ClosePeriodService.CloseData> closeDataTable;
    private long reachPeriodId;
    private boolean isGLApp;
    private Table<Long, Long, List<Long>> glOpenedPeriodIds;

    public ReachPeriodValidator(Table<Long, Long, ClosePeriodService.CloseData> closeDataTable) {
        this.closeDataTable = closeDataTable;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.reachPeriodId = ClosePeriodOption.getReachPeriodId(this.getOption());
        this.isGLApp = "gl".equalsIgnoreCase(this.getAppNumber());
    }

    @Override
    public void doValidate() {
        this.glOpenedPeriodIds = this.initGLOpenedPeriodIds();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String orgProp = this.getBookRegisterInfo().getOrgFieldOnCloseEntity();
        String bookTypeProp = this.getBookRegisterInfo().getBookTypeFieldOnCloseEntity();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            long orgId = data.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? data.getLong(bookTypeProp + ".id") : 0L;
            ClosePeriodService.CloseData closeData = (ClosePeriodService.CloseData)this.closeDataTable.get((Object)orgId, (Object)bookTypeId);
            if (closeData == null) continue;
            long closePeriodId = closeData.getBookVO().getCurPeriodId();
            if (this.reachPeriodId > 0L) {
                long glOpenedPeriodId;
                if (this.isGLApp && (glOpenedPeriodId = this.getOpenedPeriodIdLessThanReachPeriodId(closeData)) > 0L) {
                    closePeriodId = glOpenedPeriodId;
                    closeData.setGLOpenedPeriod(true);
                } else if (!this.isLessThanReachPeriodId(closePeriodId)) {
                    CloseCheckItemResult closeCheckItemResult = CloseCheckItemResult.buildFailed(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u4e0d\u7b26", (String)"ReachPeriodValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5927\u4e8e\u6216\u7b49\u4e8e\u5f85\u7ed3\u8d26\u671f\u95f4", (String)"ReachPeriodValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]), "/icons/pc/entrance/cn_dianzihuidan_48_48.png", null, null);
                    closeCheckItemResult.setErrorLevel(ErrorLevel.FatalError);
                    this.addCheckItemResult(dataEntity, orgId, bookTypeId, closeCheckItemResult);
                    continue;
                }
            }
            closeData.setClosePeriodId(closePeriodId);
            if (closeData.isGLOpenedPeriod()) continue;
            Long nextPeriodId = this.getNextPeriodId(closeData.getClosePeriodId());
            if (nextPeriodId == 0L) {
                this.addFlatError(dataEntity, orgId, bookTypeId, ResManager.loadKDString((String)"\u7ed3\u8d26\u671f\u95f4\u7684\u4e0b\u4e00\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u524d\u5f80\u671f\u95f4\u57fa\u7840\u8d44\u6599\u7ef4\u62a4", (String)"ReachPeriodValidator_2", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            closeData.setNextPeriodId(nextPeriodId);
        }
    }

    private Long getNextPeriodId(Long closePeriodId) {
        List nextPeriodIds;
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)closePeriodId, (String)"bd_period");
        if (curPeriod == null) {
            return 0L;
        }
        long periodTypeId = curPeriod.getLong("periodtype.id");
        QFilter filter = new QFilter("id", ">", (Object)closePeriodId).and("periodtype", "=", (Object)periodTypeId);
        if (!this.isGLApp) {
            filter.and("isadjustperiod", "=", (Object)false);
        }
        if (!(nextPeriodIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filter.toArray(), (String)"id asc", (int)1)).isEmpty()) {
            return (long)((Long)nextPeriodIds.get(0));
        }
        return 0L;
    }

    private long getOpenedPeriodIdLessThanReachPeriodId(ClosePeriodService.CloseData closeData) {
        List periodIds = (List)this.glOpenedPeriodIds.get((Object)closeData.getBookVO().getOrgId(), (Object)closeData.getBookVO().getBookTypeId());
        return periodIds == null ? 0L : periodIds.stream().filter(this::isLessThanReachPeriodId).findFirst().orElse(0L);
    }

    private Table<Long, Long, List<Long>> initGLOpenedPeriodIds() {
        HashBasedTable result = HashBasedTable.create();
        if (this.isGLApp && this.reachPeriodId > 0L) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_openedperiod", (String)"org,booktype,period", (QFilter[])new QFilter("org", "in", (Object)this.closeDataTable.rowKeySet()).and("booktype", "in", (Object)this.closeDataTable.columnKeySet()).toArray(), (String)"org,booktype,period desc");){
                for (Row row : dataSet) {
                    Long bookTypeId;
                    Long orgId = row.getLong(0);
                    ArrayList<Long> periodIds = (ArrayList<Long>)result.get((Object)orgId, (Object)(bookTypeId = row.getLong(1)));
                    if (periodIds == null) {
                        periodIds = new ArrayList<Long>(2);
                    }
                    periodIds.add(row.getLong(2));
                    result.put((Object)orgId, (Object)bookTypeId, periodIds);
                }
            }
        }
        return result;
    }

    private boolean isLessThanReachPeriodId(long closePeriodId) {
        Long otherPeriodNumber;
        if (closePeriodId <= 100000000L) {
            return this.reachPeriodId > 100000000L;
        }
        if (this.reachPeriodId <= 100000000L || closePeriodId == this.reachPeriodId) {
            return false;
        }
        Long periodNumber = closePeriodId % 100000000L;
        return periodNumber.compareTo(otherPeriodNumber = Long.valueOf(this.reachPeriodId % 100000000L)) < 0;
    }
}

