/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;

public class BillNoRecalculateConvertPlugin
extends AbstractConvertPlugIn {
    private String targetEntityNumber;
    private String srcEntityNumber;

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
        this.srcEntityNumber = this.getSrcMainType().getName();
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        List<String> selectorSrcField = this.getSelector();
        for (String srcField : selectorSrcField) {
            e.addSrcField(srcField);
        }
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        BigDecimal qty;
        BigDecimal returnqty;
        BigDecimal remainjoinpriceqty;
        BigDecimal arjoinqty;
        BigDecimal e_invoicednotaxamt;
        BigDecimal e_invoicedqty;
        BigDecimal joinpayablepriceqty;
        BigDecimal verifyqty;
        Long entryId;
        super.afterGetSourceData(e);
        List srcRows = e.getSourceRows();
        if (ObjectUtils.isEmpty((Object)srcRows)) {
            return;
        }
        HashSet<Long> noRecalculateSrcEntryIds = new HashSet<Long>(srcRows.size());
        if ("ap_finapbill".equals(this.targetEntityNumber)) {
            if ("im_purinbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    verifyqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.verifyqty")).getName());
                    if (verifyqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    joinpayablepriceqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.joinpayablepriceqty")).getName());
                    if (joinpayablepriceqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("ap_busbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("entry.id")).getName());
                    e_invoicedqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_invoicedqty")).getName());
                    e_invoicednotaxamt = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_invoicednotaxamt")).getName());
                    BigDecimal e_unwoffqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_unwoffqty")).getName());
                    BigDecimal e_quantity = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_quantity")).getName());
                    BigDecimal e_unwoffnotaxamt = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_unwoffnotaxamt")).getName());
                    BigDecimal e_amount = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_amount")).getName());
                    if (e_invoicedqty.compareTo(BigDecimal.ZERO) != 0 || e_invoicednotaxamt.compareTo(BigDecimal.ZERO) != 0 || e_unwoffqty.compareTo(e_quantity) != 0 || e_unwoffnotaxamt.compareTo(e_amount) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("er_publicreimbursebill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("expenseentryentity.id")).getName());
                    BigDecimal iscreateappaycount = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("expenseentryentity.iscreateappaycount")).getName());
                    if (iscreateappaycount.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ap_busbill".equals(this.targetEntityNumber)) {
            if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    joinpayablepriceqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.joinpayablepriceqty")).getName());
                    if (joinpayablepriceqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_purinbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    verifyqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.verifyqty")).getName());
                    if (verifyqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ar_finarbill".equals(this.targetEntityNumber)) {
            if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    arjoinqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.arjoinqty")).getName());
                    if (arjoinqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_saloutbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    remainjoinpriceqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.remainjoinpriceqty")).getName());
                    returnqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.returnqty")).getName());
                    qty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.qty")).getName());
                    if (remainjoinpriceqty.subtract(returnqty).compareTo(qty) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("ar_busbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("entry.id")).getName());
                    e_invoicedqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_invoicedqty")).getName());
                    e_invoicednotaxamt = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_invoicednotaxamt")).getName());
                    BigDecimal e_relateinvqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_relateinvqty")).getName());
                    BigDecimal relateinvamt = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_relateinvamt")).getName());
                    BigDecimal e_unwoffqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_unwoffqty")).getName());
                    BigDecimal e_quantity = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_quantity")).getName());
                    BigDecimal e_unwoffnotaxamt = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_unwoffnotaxamt")).getName());
                    BigDecimal e_amount = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("entry.e_amount")).getName());
                    if (e_invoicedqty.compareTo(BigDecimal.ZERO) != 0 || e_invoicednotaxamt.compareTo(BigDecimal.ZERO) != 0 || e_relateinvqty.compareTo(BigDecimal.ZERO) != 0 || relateinvamt.compareTo(BigDecimal.ZERO) != 0 || e_unwoffqty.compareTo(e_quantity) != 0 || e_unwoffnotaxamt.compareTo(e_amount) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ar_busbill".equals(this.targetEntityNumber)) {
            if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    arjoinqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.arjoinqty")).getName());
                    if (arjoinqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_saloutbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = srcRow.getLong(((DynamicProperty)e.getFldProperties().get("billentry.id")).getName());
                    remainjoinpriceqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.remainjoinpriceqty")).getName());
                    returnqty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.returnqty")).getName());
                    qty = srcRow.getBigDecimal(((DynamicProperty)e.getFldProperties().get("billentry.qty")).getName());
                    if (remainjoinpriceqty.subtract(returnqty).compareTo(qty) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if (noRecalculateSrcEntryIds.size() > 0) {
            this.getOption().setVariableValue("noRecalculateSrcEntryIds", SerializationUtils.toJsonString(noRecalculateSrcEntryIds));
        }
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        if ("im_purinbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.verifyqty");
        }
        if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.joinpayablepriceqty");
        }
        if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
            selector.add("billentry.arjoinqty");
        }
        if ("im_saloutbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.remainjoinpriceqty");
            selector.add("billentry.returnqty");
            selector.add("billentry.qty");
        }
        if ("ap_busbill".equals(this.srcEntityNumber)) {
            selector.add("entry.e_invoicedqty");
            selector.add("entry.e_invoicednotaxamt");
            selector.add("entry.e_unwoffqty");
            selector.add("entry.e_quantity");
            selector.add("entry.e_unwoffnotaxamt");
            selector.add("entry.e_amount");
        }
        if ("ar_busbill".equals(this.srcEntityNumber)) {
            selector.add("entry.e_invoicedqty");
            selector.add("entry.e_invoicednotaxamt");
            selector.add("entry.e_relateinvqty");
            selector.add("entry.e_relateinvamt");
            selector.add("entry.e_unwoffqty");
            selector.add("entry.e_quantity");
            selector.add("entry.e_unwoffnotaxamt");
            selector.add("entry.e_amount");
        }
        if ("er_publicreimbursebill".equals(this.srcEntityNumber)) {
            selector.add("expenseentryentity.iscreateappaycount");
        }
        return selector;
    }
}

