/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.ArApConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.AsstactConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.enums.InvoiceBizTypeEnum;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.PriceTaxTotalCalculator;
import kd.bos.ext.fi.util.price.PriceTotalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillToBusApConvertPlugin
extends AbstractConvertPlugIn {
    private static final String bizId = "83bfebc8000002ac";
    private final Set<String> noRecalculateFieldKeys = Stream.of("e_unitprice", "e_taxunitprice", "e_actunitprice", "e_acttaxunitprice", "e_tax", "e_taxlocalamt", "e_discountamount", "e_discountlocalamt", "e_amount", "e_localamt", "e_pricetaxtotal", "e_pricetaxtotalbase").collect(Collectors.toSet());
    private Map<String, Boolean> ruleIsSettingMap = new HashMap<String, Boolean>(8);
    private final Map<Long, String> noRecalculateSrcEntryIdMap = new HashMap<Long, String>(8);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey("ap_busbill");
        ArApConvertHelper arApConvertHelper = new ArApConvertHelper();
        Map<Long, BigDecimal> farmRate = arApConvertHelper.getBatchFarmMaterial(entities);
        List<DynamicObject> busApBills = Stream.of(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        this.buildNoRecalculateInfo();
        HashMap<Long, List<DynamicObject>> billByOrgId = new HashMap<Long, List<DynamicObject>>(4);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List bills = billByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            bills.add(bill);
        }
        new InitConvertHelper("ap_init", this.getRule(), billByOrgId);
        QueryUtil queryUtil = new QueryUtil();
        AsstactConvertHelper.checkAsstactType(busApBills);
        for (DynamicObject apBusBill : busApBills) {
            DynamicObject org = apBusBill.getDynamicObject("org");
            DynamicObject payorg = apBusBill.getDynamicObject("payorg");
            if (ObjectUtils.isEmpty((Object)payorg) || !payorg.getBoolean("fisbankroll")) {
                apBusBill.set("payorg", (Object)org);
                payorg = org;
            }
            if (!ObjectUtils.isEmpty((Object)payorg) && !payorg.getBoolean("fisbankroll")) {
                apBusBill.set("payorg", null);
            }
            if (ObjectUtils.isEmpty((Object)org)) continue;
            this.farmDeductibleRate(apBusBill, farmRate);
            if (apBusBill.get("duedate") == null) {
                apBusBill.set("duedate", (Object)new Date());
            }
            apBusBill.set("srcfinbillid", (Object)0L);
            DynamicObjectCollection entries = apBusBill.getDynamicObjectCollection("entry");
            boolean includeTax = apBusBill.getBoolean("isincludetax");
            boolean ispricetotal = apBusBill.getBoolean("ispricetotal");
            DynamicObject currency = apBusBill.getDynamicObject("currency");
            DynamicObject basecurrency = apBusBill.getDynamicObject("basecurrency");
            int precision = currency.getInt("amtprecision");
            int baseprecision = basecurrency.getInt("amtprecision");
            BigDecimal exchangeRate = apBusBill.getBigDecimal("exchangerate");
            String quotation = apBusBill.getString("quotation");
            if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal taxlocal = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal e_baseunitqty;
                BigDecimal covertRate;
                boolean isPresent = entry.getBoolean("e_ispresent");
                BigDecimal price = entry.getBigDecimal("e_unitprice");
                BigDecimal priceTax = entry.getBigDecimal("e_taxunitprice");
                if (ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                    BigDecimal e_baseunitqty2;
                    BigDecimal covertRate2;
                    BigDecimal quantity = entry.getBigDecimal("e_quantity");
                    if (quantity == null) {
                        quantity = BigDecimal.ZERO;
                    }
                    boolean covertRateIsEmpty = (covertRate2 = entry.getBigDecimal("e_unitcoefficient")) == null || covertRate2.compareTo(BigDecimal.ZERO) == 0;
                    DynamicObject material = entry.getDynamicObject("e_material");
                    DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                    DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
                    if (!ObjectUtils.isEmpty((Object)material)) {
                        if (ObjectUtils.isEmpty((Object)baseUnit)) {
                            baseUnit = material.getDynamicObject("baseunit");
                            entry.set("e_baseunit", (Object)baseUnit);
                        }
                        if (measureUnit == null) {
                            measureUnit = baseUnit;
                        }
                        if (covertRateIsEmpty) {
                            covertRate2 = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                        }
                    } else if (covertRateIsEmpty) {
                        covertRate2 = BigDecimal.ONE;
                    }
                    if (covertRateIsEmpty) {
                        entry.set("e_unitcoefficient", (Object)covertRate2);
                    }
                    if ((e_baseunitqty2 = entry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                        entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate2, baseUnit));
                    }
                    entry.set("e_uninvoicedqty", (Object)quantity);
                    entry.set("e_unwoffqty", (Object)quantity);
                    this.reSetPresentAmountField(entry, isPresent);
                    continue;
                }
                Long e_sourcebillentryid = entry.getLong("e_srcentryid");
                String noRecalculate = this.noRecalculateSrcEntryIdMap.getOrDefault(e_sourcebillentryid, "false");
                AbstractPriceCalculator calculator = null;
                BigDecimal qty = entry.getBigDecimal("e_quantity");
                BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
                String discountMode = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if (includeTax) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                                entry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            entry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                            entry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        entry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
                if (includeTax && !ispricetotal) {
                    BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (!includeTax && !ispricetotal) {
                    BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (!includeTax && ispricetotal) {
                    BigDecimal entryAmount = entry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, entryAmount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (includeTax && ispricetotal) {
                    BigDecimal entryPriceTaxTotal = entry.getBigDecimal("e_pricetaxtotal");
                    calculator = new PriceTaxTotalCalculator(qty, entryPriceTaxTotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                }
                PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision, quotation);
                localCalculator.calculate();
                entry.set("e_uninvoicedqty", (Object)qty);
                entry.set("e_unwoffqty", (Object)qty);
                if ("true".equals(noRecalculate)) {
                    if (!this.ruleIsSettingMap.getOrDefault("e_unitprice", false).booleanValue()) {
                        entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_taxunitprice", false).booleanValue()) {
                        entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_actunitprice", false).booleanValue()) {
                        entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_acttaxunitprice", false).booleanValue()) {
                        entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_tax", false).booleanValue()) {
                        entry.set("e_tax", (Object)localCalculator.getTax());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_taxlocalamt", false).booleanValue()) {
                        entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                        entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_discountlocalamt", false).booleanValue()) {
                        entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_amount", false).booleanValue()) {
                        entry.set("e_amount", (Object)localCalculator.getAmount());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_localamt", false).booleanValue()) {
                        entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_pricetaxtotal", false).booleanValue()) {
                        entry.set("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_pricetaxtotalbase", false).booleanValue()) {
                        entry.set("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
                    }
                } else {
                    entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                    entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                    entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                    entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                    entry.set("e_tax", (Object)localCalculator.getTax());
                    entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                    entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                    entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                    entry.set("e_amount", (Object)localCalculator.getAmount());
                    entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                    entry.set("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
                    entry.set("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
                }
                this.reSetPresentAmountField(entry, isPresent);
                BigDecimal e_payAmount = entry.getBigDecimal("e_pricetaxtotal");
                BigDecimal e_amount = entry.getBigDecimal("e_amount");
                BigDecimal e_tax = entry.getBigDecimal("e_tax");
                BigDecimal e_taxlocal = entry.getBigDecimal("e_taxlocalamt");
                BigDecimal e_localamt = entry.getBigDecimal("e_localamt");
                BigDecimal e_pricetaxtotalbase = entry.getBigDecimal("e_pricetaxtotalbase");
                entry.set("e_uninvoicedamt", (Object)e_payAmount);
                entry.set("e_uninvoicedlocamt", (Object)e_pricetaxtotalbase);
                entry.set("e_unwoffamt", (Object)e_payAmount);
                entry.set("e_unwofflocamt", (Object)e_pricetaxtotalbase);
                entry.set("e_unwoffnotaxamt", (Object)e_amount);
                entry.set("e_unwoffnotaxlocamt", (Object)e_localamt);
                entry.set("e_unwofftax", (Object)e_tax);
                entry.set("e_unwofftaxlocal", (Object)e_taxlocal);
                entry.set("e_uninvnotaxamt", (Object)e_amount);
                entry.set("e_uninvnotaxlocalamt", (Object)e_localamt);
                payAmount = payAmount.add(e_payAmount);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                taxlocal = taxlocal.add(e_taxlocal);
                localamt = localamt.add(e_localamt);
                pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
                BigDecimal e_quantity = entry.getBigDecimal("e_quantity");
                if (e_quantity == null) {
                    e_quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate = entry.getBigDecimal("e_unitcoefficient")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        entry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if ((e_baseunitqty = entry.getBigDecimal("e_baseunitqty")) != null && e_baseunitqty.compareTo(BigDecimal.ZERO) != 0) continue;
                entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(e_quantity, covertRate, baseUnit));
            }
            apBusBill.set("pricetaxtotal", (Object)payAmount);
            apBusBill.set("amount", (Object)amount);
            apBusBill.set("tax", (Object)tax);
            apBusBill.set("taxlocamt", (Object)taxlocal);
            apBusBill.set("uninvoicedamt", (Object)payAmount);
            apBusBill.set("localamt", (Object)localamt);
            apBusBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            apBusBill.set("uninvoicedlocamt", (Object)pricetaxtotalbase);
            apBusBill.set("unwoffamt", (Object)payAmount);
            apBusBill.set("unwofflocamt", (Object)pricetaxtotalbase);
            apBusBill.set("unwoffnotaxamt", (Object)amount);
            apBusBill.set("unwoffnotaxlocamt", (Object)localamt);
            apBusBill.set("unwofftax", (Object)tax);
            apBusBill.set("unwofftaxlocal", (Object)taxlocal);
        }
        BillToBusApConvertPlugin.setAsstact(busApBills);
        BookDateHelper.setBookDate(busApBills.toArray(new DynamicObject[0]), false);
    }

    private void reSetPresentAmountField(DynamicObject entry, boolean isPresent) {
        if (isPresent) {
            entry.set("e_actunitprice", (Object)BigDecimal.ZERO);
            entry.set("e_acttaxunitprice", (Object)BigDecimal.ZERO);
            entry.set("e_tax", (Object)BigDecimal.ZERO);
            entry.set("e_taxlocalamt", (Object)BigDecimal.ZERO);
            entry.set("e_amount", (Object)BigDecimal.ZERO);
            entry.set("e_localamt", (Object)BigDecimal.ZERO);
            entry.set("e_pricetaxtotal", (Object)BigDecimal.ZERO);
            entry.set("e_pricetaxtotalbase", (Object)BigDecimal.ZERO);
            entry.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
            entry.set("e_uninvoicedlocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwofflocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffnotaxamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffnotaxlocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwofftax", (Object)BigDecimal.ZERO);
            entry.set("e_unwofftaxlocal", (Object)BigDecimal.ZERO);
            entry.set("e_uninvnotaxamt", (Object)BigDecimal.ZERO);
            entry.set("e_uninvnotaxlocalamt", (Object)BigDecimal.ZERO);
        }
    }

    private void buildNoRecalculateInfo() {
        Map variables = this.getOption().getVariables();
        String noRecalculateSrcEntryIds = (String)variables.get("noRecalculateSrcEntryIds");
        if (!ObjectUtils.isEmpty((Object)noRecalculateSrcEntryIds)) {
            List noRecalculateSrcEntryIdList = (List)SerializationUtils.fromJsonString((String)noRecalculateSrcEntryIds, List.class);
            for (Long entryId : noRecalculateSrcEntryIdList) {
                this.noRecalculateSrcEntryIdMap.put(entryId, "true");
            }
            this.ruleIsSettingMap = BOTPHelper.ruleIsSetting(this.getRule(), false, this.noRecalculateFieldKeys);
        }
    }

    private void chechOrgEnable(DynamicObject org, Map<Object, DynamicObject> orgs) {
        Long orgPk = org.getLong("id");
        DynamicObject orgInfo = orgs.get(orgPk);
        if (ObjectUtils.isEmpty((Object)orgInfo)) {
            return;
        }
        boolean isEnable = orgInfo.getBoolean("enable");
        if (!isEnable) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5230\u4e1a\u52a1\u5355\u5143\u542f\u7528\u540e\u518d\u8bd5\u3002", (String)"BillToBusApConvertPlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
        }
    }

    public void farmDeductibleRate(DynamicObject targetBill, Map<Long, BigDecimal> farmRate) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            BigDecimal deductibleRate = row.getBigDecimal("deductiblerate");
            if (deductibleRate != null && deductibleRate.compareTo(BigDecimal.ZERO) != 0) continue;
            Long materialId = row.getLong("e_material.id");
            if (materialId != null && materialId != 0L) {
                deductibleRate = farmRate.get(materialId);
            }
            if (deductibleRate != null) {
                row.set("deductiblerate", (Object)deductibleRate);
                continue;
            }
            row.set("deductiblerate", (Object)row.getBigDecimal("e_taxrate"));
        }
    }

    public static void setAsstact(List<DynamicObject> busApBills) {
        HashSet<Long> asstactIdSet = new HashSet<Long>(2);
        for (DynamicObject busBill : busApBills) {
            Long asstactId = busBill.getLong("asstact.id");
            if (asstactId == null || asstactId == 0L) continue;
            asstactIdSet.add(asstactId);
        }
        Map asstacts = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank,invoicecategory", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
        Set invoiceCategoryIdSet = asstacts.values().stream().map(t -> t.getLong("invoicecategory.id")).collect(Collectors.toSet());
        Map invoiceBizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("mulinvoicetype.fbasedataid", "in", invoiceCategoryIdSet).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        HashMap<Object, DynamicObject> invoiceTypeMap = new HashMap<Object, DynamicObject>(8);
        Map specInvoiceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)InvoiceBizTypeEnum.SP00002_S.getValue()).and("mulbiz.fbasedataid", "=", (Object)bizId)});
        for (Map.Entry asstactEntry : asstacts.entrySet()) {
            DynamicObject asst = (DynamicObject)asstactEntry.getValue();
            Long invoiceTypeId = asst.getLong("invoicecategory.id");
            if (invoiceTypeId == null || invoiceTypeId == 0L) continue;
            for (Map.Entry bizTypeIdEntry : invoiceBizTypeMap.entrySet()) {
                DynamicObject invoiceBizType = (DynamicObject)bizTypeIdEntry.getValue();
                DynamicObjectCollection mulInvoiceTypes = invoiceBizType.getDynamicObjectCollection("mulinvoicetype");
                Set invoiceTypeIds = mulInvoiceTypes.stream().map(t -> t.get("FBasedataId.id")).collect(Collectors.toSet());
                if (!invoiceTypeIds.contains(invoiceTypeId)) continue;
                invoiceTypeMap.put(asst.get("id"), invoiceBizType);
            }
        }
        for (DynamicObject busApBill : busApBills) {
            String asstactType;
            DynamicObject invoiceBizType = busApBill.getDynamicObject("invoicebiztype");
            if (invoiceBizType != null || !"bd_supplier".equals(asstactType = busApBill.getString("asstacttype"))) continue;
            Object asstactPk = busApBill.get("asstact.id");
            Object invoiceBizTypeId = invoiceTypeMap.get(asstactPk);
            if (invoiceBizTypeId == null) {
                busApBill.set("invoicebiztype", specInvoiceTypeMap.get(InvoiceBizTypeEnum.SP00002_S.getValue()));
                continue;
            }
            busApBill.set("invoicebiztype", invoiceBizTypeId);
        }
    }
}

