/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert.Plan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionInfo;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionSetting;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ConditionServiceHelper {
    public static Date getBasicDate(DynamicObject bill) {
        Date bizDate;
        String billEntityName = bill.getDataEntityType().getName();
        DynamicObject condition = bill.getDynamicObject("paycond");
        Date basicDate = bizDate = bill.getDate("bizdate");
        if (condition == null) {
            basicDate = bizDate;
        } else {
            String calculateDateType;
            Long conditionId = condition.getLong("id");
            String conditionType = condition.getDataEntityType().getName();
            ConditionSetting conditionSetting = ConditionSetting.getSettingByConditionTypeAndCalculateType(conditionType, calculateDateType = (condition = BusinessDataServiceHelper.loadSingleFromCache((Object)conditionId, (String)conditionType)).getString("calculatetime"));
            if (conditionSetting == null) {
                basicDate = bizDate;
            } else if (billEntityName.equals(conditionSetting.getEntityKey())) {
                basicDate = bill.getDate(conditionSetting.getDateProp());
            } else {
                String sourceBillType = bill.getString("sourcebilltype");
                if (sourceBillType == null || "".equals(sourceBillType)) {
                    basicDate = bizDate;
                } else {
                    Set<Long> sourceBillIds = ConditionServiceHelper.getSourceBillIds(bill);
                    if (sourceBillType.equals(conditionSetting.getEntityKey())) {
                        QFilter filter = new QFilter("id", "in", sourceBillIds);
                        DynamicObjectCollection srcBills = QueryServiceHelper.query((String)sourceBillType, (String)conditionSetting.getDateProp(), (QFilter[])filter.toArray(), (String)(conditionSetting.getDateProp() + " desc"));
                        if (!srcBills.isEmpty()) {
                            return ((DynamicObject)srcBills.get(0)).getDate(conditionSetting.getDateProp());
                        }
                    } else {
                        HashSet sourcePks0;
                        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)sourceBillType, (Long[])sourceBillIds.toArray(new Long[0]));
                        HashSet sourcePks = (HashSet)sourceBills.get(conditionSetting.getEntityKey());
                        if (sourcePks != null) {
                            QFilter filter = new QFilter("id", "in", (Object)sourcePks);
                            DynamicObjectCollection srcBills = QueryServiceHelper.query((String)conditionSetting.getEntityKey(), (String)conditionSetting.getDateProp(), (QFilter[])filter.toArray(), (String)(conditionSetting.getDateProp() + " desc"));
                            if (!srcBills.isEmpty()) {
                                return ((DynamicObject)srcBills.get(0)).getDate(conditionSetting.getDateProp());
                            }
                        }
                        Map sourceBillsByBus = null;
                        if ("ap_invoice".equals(sourceBillType)) {
                            sourceBillsByBus = BFTrackerServiceHelper.findSourceBills((String)"ap_busbill", (Long[])sourceBillIds.toArray(new Long[0]));
                        } else if ("ar_invoice".equals(sourceBillType)) {
                            sourceBillsByBus = BFTrackerServiceHelper.findSourceBills((String)"ar_busbill", (Long[])sourceBillIds.toArray(new Long[0]));
                        }
                        if (sourceBillsByBus != null && (sourcePks0 = (HashSet)sourceBillsByBus.get(conditionSetting.getEntityKey())) != null) {
                            QFilter filter = new QFilter("id", "in", (Object)sourcePks0);
                            DynamicObjectCollection srcBills = QueryServiceHelper.query((String)conditionSetting.getEntityKey(), (String)conditionSetting.getDateProp(), (QFilter[])filter.toArray(), (String)(conditionSetting.getDateProp() + " desc"));
                            if (!srcBills.isEmpty()) {
                                return ((DynamicObject)srcBills.get(0)).getDate(conditionSetting.getDateProp());
                            }
                        }
                    }
                }
            }
        }
        return basicDate;
    }

    public static List<ConditionInfo> loadConditionInfo(DynamicObject condition, Date basicDate) {
        String basis = condition.getString("basis");
        DynamicObjectCollection entries = condition.getDynamicObjectCollection("entry");
        ArrayList<ConditionInfo> conditionInfos = new ArrayList<ConditionInfo>(1);
        for (DynamicObject entry : entries) {
            if (!"A".equals(basis)) continue;
            BigDecimal rate = entry.getBigDecimal("rate");
            Date dueDate = ConditionServiceHelper.calculateDate(basicDate, entry);
            conditionInfos.add(new ConditionInfo(rate, dueDate));
        }
        return conditionInfos;
    }

    private static Set<Long> getSourceBillIds(DynamicObject bill) {
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String entityKey = bill.getDataEntityType().getName();
        if (entityKey.contains("ap_finapbill")) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                srcBillIds.add(row.getLong("e_sourcebillid"));
            }
        } else {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                srcBillIds.add(row.getLong("e_srcid"));
            }
        }
        return srcBillIds;
    }

    private static Date calculateDate(Date billDate, DynamicObject entry) {
        Map data;
        HashMap confirmTypeJson;
        Map detailInfo;
        String confirmType = entry.getString("confirmtype");
        String confirmTypeData = entry.getString("confirmtypedata");
        Date dueDate = billDate;
        if (StringUtils.isNotBlank((CharSequence)confirmType) && StringUtils.isNotBlank((CharSequence)confirmTypeData) && (detailInfo = (Map)(confirmTypeJson = (HashMap)SerializationUtils.fromJsonString((String)confirmTypeData, Map.class)).get("DETAIL")) != null && (data = (Map)detailInfo.get("DATA")) != null) {
            switch (confirmType) {
                case "A": {
                    dueDate = billDate;
                    break;
                }
                case "B": {
                    int odmonth = (Integer)data.get("odmonth");
                    int odday = (Integer)data.get("odday");
                    Calendar c = Calendar.getInstance();
                    c.setTime(billDate);
                    c.add(2, odmonth);
                    c.add(5, odday);
                    dueDate = c.getTime();
                    break;
                }
                case "C": {
                    int settleDay = (Integer)data.get("monsettlementday");
                    int monodmonth = (Integer)data.get("monodmonth");
                    int monodday = (Integer)data.get("monodday");
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime(billDate);
                    c1.add(2, monodmonth);
                    c1.add(5, monodday);
                    int day1 = c1.get(5);
                    if (settleDay < day1) {
                        c1.add(2, 1);
                    }
                    int actualMaximum = c1.getActualMaximum(5);
                    c1.set(5, Math.min(settleDay, actualMaximum));
                    dueDate = c1.getTime();
                    break;
                }
                case "D": {
                    break;
                }
            }
        }
        return dueDate;
    }
}

