/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.data.collect.model.DataCollect;
import kd.bos.data.collect.service.DataCollectServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class FIDataCheckUtil {
    private static final String DATACHECKTASKNO = "datachecktaskno";
    private static final String NUMBER = "number";
    private static final String APPID = "appid";
    private static Log logger = LogFactory.getLog(FIDataCheckUtil.class);

    public static boolean isStop() {
        Date date;
        int nowHour;
        int time = 5;
        HashMap<String, Object> map = FIDataCheckUtil.getParameters();
        if (!map.isEmpty() && StringUtils.isNotBlank((Object)map.get("stoptime"))) {
            time = (Integer)map.get("stoptime");
        }
        return (nowHour = (date = new Date()).getHours()) >= time;
    }

    public static void saveResult(String taskId, String appid, boolean isPass, String checkResult, String plugin) {
        if (!isPass) {
            String phone = null;
            DynamicObject taskObject = FIDataCheckUtil.getTask(taskId);
            if (taskObject != null && StringUtils.isNotBlank((CharSequence)taskObject.getString("phone"))) {
                phone = taskObject.getString("phone");
            } else {
                HashMap<String, Object> map = FIDataCheckUtil.getParameters();
                if (!map.isEmpty() && StringUtils.isNotBlank((Object)map.get("phone"))) {
                    phone = (String)map.get("phone");
                }
            }
            if (StringUtils.isNotBlank(phone) && StringUtils.isNotBlank((CharSequence)checkResult) && !checkResult.contains("FIDataCheckScheduleTask start") && !checkResult.contains("FIDataCheckScheduleTask end")) {
                FIDataCheckUtil.notice(null, null, phone, checkResult);
                FIDataCheckUtil.writeLog(taskId, appid, checkResult, plugin);
            }
        }
        FIDataCheckUtil.saveRecord(taskId, appid, isPass, checkResult);
    }

    private static void saveRecord(String taskId, String appid, boolean isPass, String checkResult) {
        DynamicObject[] object = new DynamicObject[1];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bd_datacheckrecord");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        dynamicObject.set(DATACHECKTASKNO, (Object)taskId);
        dynamicObject.set(APPID, (Object)appid);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("ispass", (Object)(isPass ? "1" : "0"));
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            Long rootId = OrgUnitServiceHelper.getRootOrgId();
            DynamicObject orgObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rootId)});
            if (orgObject != null) {
                String orgName = orgObject.getString("name");
                checkResult = "orgName:" + orgName + "," + checkResult;
            }
            if (checkResult.length() <= 255) {
                dynamicObject.set("checkresult_tag", (Object)checkResult);
                dynamicObject.set("checkresult", (Object)checkResult);
            } else {
                dynamicObject.set("checkresult_tag", (Object)checkResult);
                dynamicObject.set("checkresult", (Object)checkResult.substring(0, 255));
            }
        }
        object[0] = dynamicObject;
        SaveServiceHelper.save((DynamicObject[])object);
    }

    public static void postData() {
        QFilter dateFilter = new QFilter("createtime", ">=", (Object)DateUtils.getCurrentDate());
        QFilter stringFilter1 = new QFilter("checkresult", "not like", (Object)"%FIDataCheckScheduleTask start");
        QFilter stringFilter2 = new QFilter("checkresult", "not like", (Object)"%FIDataCheckScheduleTask end");
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bd_datacheckrecord", (String)"datachecktaskno,appid,createtime,ispass,checkresult_tag checkresult", (QFilter[])new QFilter[]{dateFilter, stringFilter1, stringFilter2});
        if (!collections.isEmpty()) {
            ArrayList<DataCollect> dataList = new ArrayList<DataCollect>(collections.size());
            for (DynamicObject object : collections) {
                DataCollect data = new DataCollect();
                data.setFormId("bd_datachecktask");
                data.setProjectId("cosmic");
                data.setStoreId("server_beacon");
                data.setEventName("fi_datacheck");
                data.setCreatTime(new Date());
                HashMap<String, String> cusMap = new HashMap<String, String>(1);
                String taskId = object.getString(DATACHECKTASKNO);
                cusMap.put(DATACHECKTASKNO, taskId);
                DynamicObject taskObject = FIDataCheckUtil.getTask(taskId);
                if (taskObject != null) {
                    cusMap.put("datachecktaskname", taskObject.getString("name"));
                }
                cusMap.put("checkresult", object.getString("checkresult"));
                cusMap.put("ispass", object.getString("ispass"));
                cusMap.put(APPID, object.getString(APPID));
                cusMap.put("checkdatetime", object.getString("createtime"));
                data.setCusData(cusMap);
                dataList.add(data);
            }
            DataCollectServiceHelper.addBatchData(dataList, null);
        }
    }

    public static void notice(String eid, String openid, String phone, String checkResult) {
        DynamicObject object = null;
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            QFilter phonefilter = new QFilter("phone", "=", (Object)phone);
            object = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{phonefilter});
        }
        if (object != null) {
            try {
                FIDataCheckUtil.sendSmsMsg(checkResult, object.getLong("id"), "yunzhijia");
                FIDataCheckUtil.sendSmsMsg(checkResult, object.getLong("id"), "sms");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeLog(String taskId, String appid, String checkResult, String plugin) {
        StringBuilder builder = new StringBuilder();
        builder.append("datacheckfailed:");
        builder.append(checkResult);
        builder.append("\n");
        builder.append("taskId:");
        builder.append(taskId);
        builder.append("\n");
        builder.append("appid:");
        builder.append(appid);
        builder.append("\n");
        builder.append("plugin:");
        builder.append(plugin);
        builder.append("\n");
        logger.error(builder.toString());
    }

    public static List<DynamicObject> sortTask() {
        DynamicObjectCollection list = new ArrayList(16);
        DynamicObject lastRecond = FIDataCheckUtil.getLastRecond();
        DynamicObject lastTask = FIDataCheckUtil.getLastTask();
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        if (lastRecond != null && lastTask != null && StringUtils.isNotBlank((CharSequence)lastRecond.getString(DATACHECKTASKNO)) && StringUtils.isNotBlank((CharSequence)lastTask.getString(NUMBER)) && !lastRecond.getString(DATACHECKTASKNO).equals(lastTask.getString(NUMBER))) {
            QFilter largeNumFilter = new QFilter(NUMBER, ">", (Object)lastRecond.getString(DATACHECKTASKNO));
            QFilter lessEqNumFilter = new QFilter(NUMBER, "<=", (Object)lastRecond.getString(DATACHECKTASKNO));
            DynamicObjectCollection list1 = QueryServiceHelper.query((String)"bd_datachecktask", (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{largeNumFilter, statusFilter}, (String)NUMBER);
            DynamicObjectCollection list2 = QueryServiceHelper.query((String)"bd_datachecktask", (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{lessEqNumFilter, statusFilter}, (String)NUMBER);
            list.addAll(list1);
            list.addAll(list2);
        } else {
            list = QueryServiceHelper.query((String)"bd_datachecktask", (String)"number,appid,plugin,name,cloudid", (QFilter[])new QFilter[]{statusFilter}, (String)NUMBER);
        }
        return list;
    }

    private static DynamicObject getLastRecond() {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bd_datacheckrecord", (String)DATACHECKTASKNO, null, (String)" createtime desc", (int)1);
        if (!list.isEmpty() && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    private static DynamicObject getLastTask() {
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bd_datachecktask", (String)NUMBER, (QFilter[])new QFilter[]{statusFilter}, (String)"number desc", (int)1);
        if (!list.isEmpty() && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    private static HashMap<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"bd_checkdata_parameter", (String)"phone,stoptime", null, (String)"modifydate desc", (int)1);
        if (!collections.isEmpty()) {
            DynamicObject object = (DynamicObject)collections.get(0);
            map.put("phone", object.get("phone"));
            map.put("stoptime", object.get("stoptime"));
        }
        return map;
    }

    private static void sendSmsMsg(String result, Long userId, String type) {
        MessageInfo info = new MessageInfo();
        info.setTitle(ResManager.loadKDString((String)"\u6570\u636e\u68c0\u67e5\u6709\u95ee\u9898", (String)"FIDataCheckUtil_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        StringBuilder sb = new StringBuilder();
        sb.append(result);
        info.setContent(sb.toString());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        info.setUserIds(userIds);
        info.setType("message");
        LocaleString messageTag = new LocaleString();
        messageTag.setLocaleValue_en("bec");
        messageTag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u7d27\u6025", (String)"FIDataCheckUtil_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        info.setMessageTag((ILocaleString)messageTag);
        info.setNotifyType(type);
        MessageCenterServiceHelper.sendMessage((MessageInfo)info);
    }

    private static DynamicObject getTask(String number) {
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)number);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bd_datachecktask", (String)"name,phone", (QFilter[])new QFilter[]{numberFilter, statusFilter});
        if (!list.isEmpty() && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }
}

