/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.iep.dao.FormDesignDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDaoNew;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.enums.FailRetryStrategy;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.task.IExceutor;
import kd.fi.iep.task.IExecuteLog;
import kd.fi.iep.task.IntellExecuteContext;
import kd.fi.iep.util.DateUtil;
import kd.fi.iep.util.IntellExecuteUtil;
import kd.fi.iep.util.LogORMHelper;
import kd.fi.iep.util.ThrowableHelper;

public abstract class AbstractExecute
implements IExceutor,
IExecuteLog {
    protected static final Log logger = LogFactory.getLog((String)AbstractExecute.class.getName());
    protected IntellExecuteContext ctx;
    protected String traceId;
    protected static final int BATCH_SIZE = 2000;
    private static final Map<Integer, Integer> execNumberToHour = new HashMap<Integer, Integer>(3){
        private static final long serialVersionUID = -1765539830514347862L;
        {
            this.put(0, 1);
            this.put(1, 5);
            this.put(2, 12);
        }
    };

    public AbstractExecute(IntellExecuteContext ctx) {
        this.ctx = ctx;
        this.traceId = ctx.getTraceId();
    }

    @Override
    public void execute() {
        this.execOperStarLog();
        this.doExecute();
        this.execOperEndLog();
    }

    protected abstract void doExecute();

    @Override
    public void execOperStarLog() {
        IntellSchemeExecInfo schemeExecInfo = this.ctx.getSchemeExecInfo();
        schemeExecInfo.setProgress(true);
        IntellExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        String operName = FormDesignDao.getOperationNameWithVoucher(exceOperInfo.getBussiness(), exceOperInfo.getOper());
        exceOperInfo.setOperName(operName);
        long operSumLogId = IntellAccountSchemaExecLogDao.insertOperSumLog(exceOperInfo.getSchemaId(), this.ctx.getSumLogId(), this.ctx.getExecstartdate(), exceOperInfo, 0, "");
        exceOperInfo.setOperLogId(operSumLogId);
        IntellSchemeExecInfo.execInfoWriteCache(schemeExecInfo);
    }

    @Override
    public void execOperEndLog() {
        IntellExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        IntellSchemeExecInfo schemeExecInfo = this.ctx.getSchemeExecInfo();
        schemeExecInfo.setOperTCC();
        IntellSchemeExecInfo.execInfoWriteCache(schemeExecInfo);
        String sql = "insert into t_iep_todaycompentry (fentryid,fid,fintelschemaid,fbusiness,fbusinessname,fopernumber,fopername,fexeccount,fexeccomptime) values (?,?,?,?,?,?,?,?,?);";
        ArrayList<Object> paramsList = new ArrayList<Object>(3);
        paramsList.add(DB.genLongId((String)"t_iep_todaycompentry"));
        paramsList.add(exceOperInfo.getSchemaId());
        paramsList.add(exceOperInfo.getSchemaId());
        paramsList.add(exceOperInfo.getBussiness());
        paramsList.add(FormDesignDao.getFormName(exceOperInfo.getBussiness()));
        paramsList.add(exceOperInfo.getOper());
        paramsList.add(exceOperInfo.getOperName());
        paramsList.add(exceOperInfo.getOperRTC());
        paramsList.add(new Date());
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])paramsList.toArray());
        IntellAccountSchemaExecLogDao.update2OperSumLog(exceOperInfo.getOperLogId(), exceOperInfo.getOperRTC() == 0 ? ExecuteStatus.FINISH.getStatus() : exceOperInfo.getExecuteStatus().getStatus(), new Date(), exceOperInfo.getExecDetails(), exceOperInfo.getOperRTC(), exceOperInfo.getOperRTSC(), exceOperInfo.getOperRTFC());
    }

    protected List<QFilter> getExceDataCollectionFilter() {
        String mainOrgField;
        IntellExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)exceOperInfo.getBussiness());
        ArrayList<QFilter> dataFilter = new ArrayList<QFilter>(16);
        QFilter datafilter = exceOperInfo.getDatafilter();
        if (datafilter != null) {
            dataFilter.add(datafilter);
        }
        if (StringUtils.isNotEmpty((String)(mainOrgField = type.getMainOrg())) && !this.ctx.getTargetInfoList().isEmpty()) {
            dataFilter.add(new QFilter(mainOrgField, "in", this.ctx.getTargetInfoList()));
        }
        return dataFilter;
    }

    public ExecuteStatus startExecOperation(long intelschemaId, int count, Date execstartdate, IntellExceOperInfo exceOperInfo, StringBuffer errorMessage, List<Long> processObj) {
        try {
            ExecuteStatus batchOperstatus = ExecuteStatus.FINISH;
            if (exceOperInfo.isSingle()) {
                for (Long billId : processObj) {
                    ExecuteStatus curOperstatus = this.exceOperAndExceLog(intelschemaId, execstartdate, count, new Object[]{billId});
                    if (ExecuteStatus.FAIL == curOperstatus) {
                        batchOperstatus = curOperstatus;
                    }
                    if (ExecuteStatus.STOP != curOperstatus) continue;
                    batchOperstatus = curOperstatus;
                    break;
                }
            } else {
                batchOperstatus = this.exceOperAndExceLog(intelschemaId, execstartdate, count, processObj.toArray());
            }
            return batchOperstatus;
        }
        catch (Exception e) {
            errorMessage.append(ThrowableHelper.toString(e)).append(';');
            logger.error("intelschemaId:" + intelschemaId + "\u6267\u884c\u5355\u636e\u64cd\u4f5c\u53d1\u751f\u9519\u8bef:", (Throwable)e);
            return ExecuteStatus.FAIL;
        }
    }

    private ExecuteStatus exceOperAndExceLog(Long intelschemaId, Date execstartdate, int count, Object[] objs) {
        IntellExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        if (IntellExecuteUtil.isStopExcute(this.ctx.getSchemeExecInfo())) {
            return ExecuteStatus.STOP;
        }
        OperationResult rtn = null;
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("gl_intellexecschema", intelschemaId.toString());
            option.setVariableValue("taskid", this.ctx.getTaskId());
            JSONObject params = exceOperInfo.getParams();
            if (params != null) {
                Iterator iterator = params.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    Object value = params.get((Object)(key = (String)iterator.next()));
                    option.setVariableValue(key, value == null ? "" : value.toString());
                }
            }
            logger.info(String.format("\u8fdb\u884c\u5355\u636e\u64cd\u4f5c\u8c03\u7528\uff0cintelschemaId\uff1a%d bill:%s  oper:%s curbatch:%s", intelschemaId, exceOperInfo.getBussiness(), exceOperInfo.getOper(), objs.length));
            long startTime = System.currentTimeMillis();
            rtn = this.invokeOperation(objs, option);
            long endTime = System.currentTimeMillis();
            Long seconds = endTime - startTime;
            logger.info(String.format("\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u8017\u65f6\uff1a%dms\uff0cintelschemaId\uff1a%d", seconds, intelschemaId));
        }
        catch (Exception e) {
            logger.error("\u667a\u80fd\u6838\u7b97\u5355\u636e\u64cd\u4f5c\u8c03\u7528\u62a5\u9519\uff1a" + ThrowableHelper.toString(e));
            IntellAccountSchemaExecLogDaoNew.batchInsertExceLog(exceOperInfo, count == 0 ? execstartdate : null, objs, "3", e.getMessage(), this.traceId);
            this.batchUpdateCache(0, objs.length, objs.length);
            throw e;
        }
        HashMap<Object, String> errorMap = new HashMap<Object, String>();
        this.billPKErrorMapping(errorMap, rtn.getAllErrorOrValidateInfo());
        if (!errorMap.isEmpty()) {
            logger.info("\u667a\u80fd\u65b9\u6848\u8c03\u7528\u660e\u7ec6\u8bb0\u5f55\u65e5\u5fd7\u5904\u7406: intelschemaId\uff1a{}\uff0cerrorMap\uff1a{}", (Object)intelschemaId, errorMap);
        }
        List successPkIds = rtn.getSuccessPkIds();
        ArrayList<Object> errorObjs = new ArrayList<Object>(errorMap.size());
        Set successPkIdStr = successPkIds.stream().map(String::valueOf).collect(Collectors.toSet());
        Set errorObjsStr = errorObjs.stream().map(String::valueOf).collect(Collectors.toSet());
        for (Object objId : objs) {
            String objIdStr;
            if (!Objects.nonNull(objId) || successPkIdStr.contains(objIdStr = String.valueOf(objId)) || errorObjsStr.contains(objIdStr)) continue;
            errorObjs.add(objId);
            String errorId = (String)errorMap.get(objId);
            if (!StringUtils.isNull((String)errorId)) continue;
            errorMap.put(Long.valueOf(objId.toString()), rtn.getMessage());
        }
        int successPkIdSize = successPkIds.size();
        int failPkIdSize = errorObjs.size();
        int failPkIdSizeSum = 0;
        if (!errorObjs.isEmpty()) {
            Set<Object> removeLogSuccess = exceOperInfo.getFailSrcBillIds();
            exceOperInfo.getFailSrcBillIds().retainAll(errorObjs);
            if (exceOperInfo.getFailSrcBillIds().size() > 0) {
                DynamicObjectCollection failSrcBillInfos = IntellAccountSchemaExecLogDaoNew.queryExceLog("id,execnumber,lastexectime", new QFilter[]{new QFilter("srcbillid", "in", exceOperInfo.getFailSrcBillIds()), new QFilter("bussiness", "=", (Object)exceOperInfo.getBussiness()), new QFilter("oper", "=", (Object)exceOperInfo.getOper())}, exceOperInfo.getFailSrcBillIds().size() * 100, 0);
                for (DynamicObject failSrcBillInfo : failSrcBillInfos) {
                    failSrcBillInfo.set("execnumber", (Object)(failSrcBillInfo.getInt("execnumber") + 1));
                    failSrcBillInfo.set("lastexectime", (Object)new Date());
                }
                IntellAccountSchemaExecLogDaoNew.updateExceLog((List<DynamicObject>)failSrcBillInfos);
            }
            errorObjs.removeAll(exceOperInfo.getFailSrcBillIds());
            IntellAccountSchemaExecLogDaoNew.batchInsertExceLog(exceOperInfo, count == 0 ? execstartdate : null, errorObjs.toArray(new Object[0]), "3", errorMap, this.traceId);
            failPkIdSizeSum += errorObjs.size();
        }
        if (successPkIds.size() > 0) {
            failPkIdSizeSum -= IntellAccountSchemaExecLogDaoNew.deleteExecLog(new QFilter[]{new QFilter("srcbillid", "in", (Object)successPkIds.toArray())});
        }
        this.batchUpdateCache(successPkIdSize, failPkIdSize, failPkIdSizeSum);
        return failPkIdSize == 0 ? ExecuteStatus.FINISH : ExecuteStatus.FAIL;
    }

    private synchronized void batchUpdateCache(int successPkIdSize, int failPkIdSize, int failPkIdSizeSum) {
        IntellSchemeExecInfo execInfo = this.ctx.getSchemeExecInfo();
        execInfo.appendExecRecord(successPkIdSize, failPkIdSize, failPkIdSizeSum);
        this.batchUpdateCache();
    }

    private void batchUpdateCache() {
        IntellSchemeExecInfo.execInfoWriteCache(this.ctx.getSchemeExecInfo());
    }

    private void billPKErrorMapping(Map<Object, String> pkErrorMap, List<IOperateInfo> errorInfoList) {
        for (IOperateInfo ori : errorInfoList) {
            Object pk = Optional.ofNullable(ori.getPkValue()).orElse("0");
            String error = ori.getMessage();
            String value = pkErrorMap.get(pk);
            if (value != null) {
                String newError = value + ";" + error;
                pkErrorMap.put(pk, newError);
                continue;
            }
            pkErrorMap.put(pk, error);
        }
    }

    protected abstract OperationResult invokeOperation(Object[] var1, OperateOption var2);

    protected static boolean removeFailBillId(Set<Long> awareIds, Set<Long> billIds, String business, IntellExceOperInfo operInfo) {
        AtomicBoolean isExistFailBill = new AtomicBoolean(false);
        ArrayList<Long> filterId = new ArrayList<Long>(billIds);
        HashSet<Object> failSrcbillIds = new HashSet<Object>(16);
        int batchCount = (int)Math.ceil((double)filterId.size() * 1.0 / 2000.0);
        for (int batchIndex = 0; batchIndex < batchCount; ++batchIndex) {
            int formIndex = batchIndex * 2000;
            int toIndex = Math.min(2000 * (batchIndex + 1), filterId.size());
            List curBatch = filterId.subList(formIndex, toIndex);
            SqlBuilder sqlBuilder = new SqlBuilder();
            QFilter bussinessFilter = new QFilter("bussiness", "=", (Object)business);
            QFilter operFilter = new QFilter("oper", "=", (Object)operInfo.getOper());
            QFilter srcbillidFilter = new QFilter("srcbillid", "in", new ArrayList(curBatch));
            DynamicObjectCollection rsColl = LogORMHelper.query("iep_intellexecdetaillog", "id,srcbillid,execnumber,createtime,lastexectime,opdate,opersumlogid", new QFilter[]{bussinessFilter, operFilter, srcbillidFilter}, curBatch.size() * 100, 0);
            for (DynamicObject rs : rsColl) {
                long fsrcbillid = rs.getLong("srcbillid");
                failSrcbillIds.add(fsrcbillid);
                Date date = rs.getDate("lastexectime");
                if (Objects.isNull(date) || date.compareTo(rs.getDate("createtime")) < 0) {
                    date = rs.getDate("createtime");
                }
                switch (operInfo.getFailRetryStrategy()) {
                    case IGNORE: {
                        awareIds.remove(fsrcbillid);
                        break;
                    }
                    case TRYAGAIN: 
                    case TRYAGAINTHREE: {
                        int fexecnumber = rs.getInt("execnumber");
                        if (operInfo.getFailRetryStrategy() == FailRetryStrategy.TRYAGAIN && fexecnumber >= 1) {
                            awareIds.remove(fsrcbillid);
                            break;
                        }
                        if (operInfo.getFailRetryStrategy() == FailRetryStrategy.TRYAGAINTHREE && fexecnumber > 2) {
                            awareIds.remove(fsrcbillid);
                            break;
                        }
                        int hour = execNumberToHour.get(fexecnumber);
                        if (new Date().compareTo(DateUtil.addHourByDate(date, hour)) >= 0) break;
                        awareIds.remove(fsrcbillid);
                    }
                }
                if (isExistFailBill.get()) continue;
                isExistFailBill.compareAndSet(false, true);
            }
            operInfo.addFilSrcBillId(failSrcbillIds);
        }
        return isExistFailBill.get();
    }

    protected static DataSet removeFailBillId(IntellExceOperInfo operInfo, AtomicBoolean isExistFailBill) {
        QFilter intelschemaidFilter = new QFilter("intelschemaid", "=", (Object)operInfo.getSchemaId());
        QFilter schemasumlogidFilter = new QFilter("schemasumlogid", "!=", (Object)operInfo.getSumLogId());
        QFilter opersumlogidFilter = new QFilter("opersumlogid", "!=", (Object)operInfo.getOperLogId());
        QFilter bussinessFilter = new QFilter("bussiness", "=", (Object)operInfo.getBussiness());
        QFilter operFilter = new QFilter("oper", "=", (Object)operInfo.getOper());
        DataSet rsColl = LogORMHelper.queryDataSet("iep_intellexecdetaillog", "id,srcbillid,execnumber,createtime,lastexectime,opdate,opersumlogid", new QFilter[]{intelschemaidFilter, schemasumlogidFilter, opersumlogidFilter, bussinessFilter, operFilter}, 1000000, 0);
        HashSet<Object> failSrcbillIds = new HashSet<Object>(16);
        Algo algo = Algo.create((String)"kd.fi.iep.task.AbstractExecute");
        Field[] fields = new Field[]{new Field("srcbillid", (DataType)DataType.LongType)};
        DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(fields));
        while (rsColl.hasNext()) {
            Row rs = rsColl.next();
            long fsrcbillid = rs.getLong("srcbillid");
            failSrcbillIds.add(fsrcbillid);
            Date date = rs.getDate("lastexectime");
            if (Objects.isNull(date) || date.compareTo(rs.getDate("createtime")) < 0) {
                date = rs.getDate("createtime");
            }
            switch (operInfo.getFailRetryStrategy()) {
                case IGNORE: {
                    builder.append(new Object[]{fsrcbillid});
                    break;
                }
                case TRYAGAIN: 
                case TRYAGAINTHREE: {
                    int fexecnumber = rs.getInteger("execnumber");
                    if (operInfo.getFailRetryStrategy() == FailRetryStrategy.TRYAGAIN && fexecnumber >= 1) {
                        builder.append(new Object[]{fsrcbillid});
                        break;
                    }
                    if (operInfo.getFailRetryStrategy() == FailRetryStrategy.TRYAGAINTHREE && fexecnumber > 2) {
                        builder.append(new Object[]{fsrcbillid});
                        break;
                    }
                    int hour = execNumberToHour.get(fexecnumber);
                    if (new Date().compareTo(DateUtil.addHourByDate(date, hour)) >= 0) break;
                    builder.append(new Object[]{fsrcbillid});
                }
            }
            if (isExistFailBill.get()) continue;
            isExistFailBill.compareAndSet(false, true);
        }
        operInfo.addFilSrcBillId(failSrcbillIds);
        return builder.build();
    }

    protected String getEntityOrgFieldName() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)this.ctx.getSchemeExecInfo().getExceOperInfo().getBussiness());
        return bizEntityType.getMainOrg();
    }

    protected String[] getGroupbys() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)this.ctx.getSchemeExecInfo().getExceOperInfo().getBussiness());
        Set fields = bizEntityType.getFields().keySet();
        String groupbys = this.ctx.getSchemeExecInfo().getExceOperInfo().getGroupbyscoll();
        return (String[])Arrays.stream(groupbys.split(",")).filter(fields::contains).distinct().toArray(String[]::new);
    }

    private static QFilter[] filterTransformation(QFilter filter, MainEntityType vmeta) {
        QFilter[] newFilter = filter.recombine();
        HashMap<Integer, QFilter> replaceFilter = new HashMap<Integer, QFilter>(2);
        for (int i = 0; i < newFilter.length; ++i) {
            String[] ps;
            DynamicProperty dp;
            String p;
            QFilter m = newFilter[i];
            List nests = m.getNests(false);
            if (nests.size() != 0 || (p = m.getProperty()).indexOf(46) == -1 || !((dp = vmeta.getProperty((ps = p.split("\\."))[0])) instanceof BasedataProp)) continue;
            BasedataProp bp = (BasedataProp)dp;
            QFilter baseQ = m.copy();
            baseQ.setProperty(p.substring(p.indexOf(46) + 1));
            List baseIds = QueryServiceHelper.queryPrimaryKeys((String)bp.getBaseEntityId(), (QFilter[])baseQ.toArray(), null, (int)-1);
            if (baseIds.size() >= 100000) continue;
            QFilter newQ = new QFilter(ps[0], "in", (Object)baseIds);
            replaceFilter.put(i, newQ);
        }
        for (Map.Entry me : replaceFilter.entrySet()) {
            newFilter[((Integer)me.getKey()).intValue()] = (QFilter)me.getValue();
        }
        return newFilter;
    }
}

