/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.imic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.CellStyle;
import kd.bos.ext.imsc.imic.util.DynamicObjectUtils;
import kd.bos.ext.imsc.imic.util.OpenPageUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class InitGuideFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
WizardStepsListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(InitGuideFormPlugin.class);
    private static final String INIT_ITEMS = "inititem";
    private static final String INIT_APPNUMBER = "initAppId";
    private static final String DIMENSION = "dimension";
    private static final String ORG = "org";
    private static final String INITIAL_SCHEME = "initialscheme";
    private static final String MARK_COMPLETE = "markcomplete";
    private static final String MARK_UN_COMPLETE = "markuncomplete";
    private static final String INIT_SUB_ITEMS_ENTRY = "inititemsentry";
    private static final String COMPLETE_STATUS = "completestatus";
    private static final String COMPLETE = "A";
    private static final String NOT_COMPLETE = "B";
    private static final String USEDIMENSION = "usedimension";
    private static final String COMPLETEDUSER = "completeduser";
    private static final String COMPLETEDTIME = "completedtime";
    private static final String PROGRESS_BAR = "progressbarap";
    private static final String WIZARDAP = "wizardap";
    private static final String ALL_PROGRESS = "allprogress";
    private static final String ALL_MUST_PROGRESS = "allmustprogress";
    private static final String STEP_PROGRESS = "stepprogress";
    private static final String STEP_MUST_PROGRESS = "stepmustprogress";
    private static final String ALL_LABEL = "alllabel";
    private static final String ALL_MUST_LABEL = "allmustlabel";
    private static final String STEP_LABEL = "steplabel";
    private static final String INIT_CONFIG_MUST_SET = "initconfigmustset";
    private static final String MUST_SET = "mustset";
    private static final String DEFAULT_CALIBER = "defaultcaliber";
    private static final String ALL_TASK = "A";
    private static final String MUST_TASK = "B";
    private static final String BOTH_TASK = "C";
    private static final String ALL_PROGRESS_FLEX = "allprogressflex";
    private static final String STEP_PROGRESS_FLEX = "stepprogressflex";
    private static final String SCHEDULE = "schedule";
    private static final String STEP_MUST_LABEL = "stepmustlabel";
    private static final String DEFAULT_ORG_ID = "defaultOrgId";
    private static final String BOS_ORG = "bos_org";
    private static final String FIELD_HASDATA = "hasdata";
    private static final String HASDATA = "A";
    private static final String NODATA = "B";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String IMIC_INITIAL_SCHEME = "imic_initialscheme";
    private static final String ITEM_GROUP = "itemgroup";
    private static final String INITENTRY_ITEMS = "imic_initentry_items";
    private static final String IMIC_PROGRESSUNIT = "imic_progressunit";
    private static final String PREVIEW = "preview";
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String INITIAL_SCHEME_ENTRY_ID = "initialschemeentryid";
    private static final String VIEW_STYLE = "defaultstyle";
    private static final String INITITEMENTRY_CARD = "inititementry_card";
    private static final String BIZ_APP_NUMBER = "bizAppNumber";
    private static final Pattern PATTERN = Pattern.compile("msvc://(\\w+\\.\\w+\\.\\w+\\.\\w+)");
    private static final String ALL_SELECT = "allselect";
    private static final String UN_SELECT = "unselect";
    private static final String ALL_ITEMS_ID = "allItemsId";
    private static final String MUST_ITEMS_ID = "mustItemsId";
    private static final String F7_ORGIDS = "orgids";
    private static final String DEFAULTCALIBER = "defaultcaliber";
    private static final String OP_BATCHMARKCOMPLETED = "batchmarkcomplete";
    private static final String OP_BATCHMARKUNCOMPLETED = "batchmarkuncomplete";
    private static final String IMIC_ASSIGNRECORD = "imic_assignrecord";
    private static final String ITEM_ENABLED = "itemenabled";
    private static final String COLOR_GREEN = "#26B175";
    private static final String COLOR_ORANGE = "#ED812B";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String appNumber = (String)formShowParameter.getCustomParam(INIT_APPNUMBER);
        appNumber = appNumber == null ? formShowParameter.getAppId() : appNumber;
        Object orgId = formShowParameter.getCustomParam(DEFAULT_ORG_ID);
        DynamicObject scheme = this.getScheme(appNumber, e.getFormShowParameter());
        if (orgId != null) {
            formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)orgId.toString());
        }
        if (scheme == null) {
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)appNumber)});
            String appName = bizApp.getLocaleString(NAME).getLocaleValue();
            String tip = String.format(ResManager.loadKDString((String)"\u60a8\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u672a\u627e\u5230%s\u5e94\u7528\u4e0b\u542f\u7528\u7684\u521d\u59cb\u5316\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u5b9e\u65bd\u670d\u52a1\u4e91-\u521d\u59cb\u5316\u7ba1\u7406\u4e2d\u5fc3\u4e2d\u8fdb\u884c\u521d\u59cb\u5316\u65b9\u6848\u8bbe\u7f6e\u3002", (String)"InitGuideFormPlugin_0", (String)"bos-ext-imsc", (Object[])new Object[0]), appName);
            e.setCancel(true);
            e.setCancelMessage(tip);
        } else {
            boolean isUseDmsn = scheme.getBoolean(USEDIMENSION);
            if (isUseDmsn) {
                DynamicObject dimensionType = scheme.getDynamicObject("dimensiontype");
                String typeNumber = dimensionType.getString(NUMBER);
                if (!BOS_ORG.equals(typeNumber)) {
                    String schemeName = scheme.getLocaleString(NAME).getLocaleValue();
                    String tip = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848%s\u7684\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u662f\u7ec4\u7ec7\u7c7b\u578b\uff0c\u6682\u4e0d\u652f\u6301\u975e\u7ec4\u7ec7\u7ef4\u5ea6\u7684\u521d\u59cb\u5316\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u5b9e\u65bd\u670d\u52a1\u4e91-\u521d\u59cb\u5316\u7ba1\u7406\u4e2d\u5fc3\u4e2d\u5bf9\u521d\u59cb\u5316\u65b9\u6848\u8fdb\u884c\u8c03\u6574\u3002", (String)"InitGuideFormPlugin_10", (String)"bos-ext-imsc", (Object[])new Object[0]), schemeName);
                    e.setCancel(true);
                    e.setCancelMessage(tip);
                }
            } else {
                e.getFormShowParameter().setCustomParam(DEFAULT_ORG_ID, null);
            }
            e.getFormShowParameter().setCustomParam("initSchemeId", scheme.getPkValue());
        }
    }

    private DynamicObject getScheme(String appNumber, FormShowParameter formShowParameter) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)IMIC_INITIAL_SCHEME);
        Object isPreView = formShowParameter.getCustomParam(PREVIEW);
        long curUserId = UserServiceHelper.getCurrentUserId();
        if (!Objects.isNull(isPreView)) {
            Object initSchemeId = formShowParameter.getCustomParam("initSchemeId");
            return BusinessDataServiceHelper.loadSingle((Object)initSchemeId, (DynamicObjectType)dataEntityType);
        }
        String appId = AppMetadataCache.getAppInfoByNumber((String)appNumber).getId();
        String formId = formShowParameter.getFormId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)curUserId, (String)appId, (String)formId, (String)"47150e89000000ac");
        List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
        if (!userHasPermOrgs.hasAllOrgPerm() && hasPermOrgs.isEmpty()) {
            return null;
        }
        Map customParams = formShowParameter.getCustomParams();
        Long orgId = (Long)customParams.get(DIMENSION);
        if (orgId != null) {
            Object schemePk = customParams.get(INITIAL_SCHEME);
            DynamicObject reportScheme = BusinessDataServiceHelper.loadSingle(schemePk, (DynamicObjectType)dataEntityType);
            boolean useDimension = reportScheme.getBoolean(USEDIMENSION);
            boolean isShare = reportScheme.getBoolean("isalluse");
            DynamicObject initGuideRecordDb = this.getInitGuideRecord(appNumber, curUserId);
            String style = initGuideRecordDb != null ? initGuideRecordDb.getString("style") : "";
            formShowParameter.setCustomParam("record_style", (Object)style);
            if (!useDimension || isShare) {
                formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)orgId.toString());
                return reportScheme;
            }
            if (userHasPermOrgs.hasAllOrgPerm()) {
                formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)orgId.toString());
                return reportScheme;
            }
            if (hasPermOrgs.contains(orgId)) {
                formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)orgId.toString());
                return reportScheme;
            }
            return null;
        }
        QFilter appFilter = new QFilter("bizapp.number", "=", (Object)appNumber);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        List enableSchemeIds = QueryServiceHelper.queryPrimaryKeys((String)IMIC_INITIAL_SCHEME, (QFilter[])new QFilter[]{appFilter, enableFilter}, null, (int)-1);
        if (!enableSchemeIds.isEmpty()) {
            long defaultOrg;
            String style;
            long loginOrgId = RequestContext.get().getOrgId();
            DynamicObject initGuideRecordDb = this.getInitGuideRecord(appNumber, curUserId);
            if (initGuideRecordDb != null) {
                style = initGuideRecordDb.getString("style");
                defaultOrg = initGuideRecordDb.getLong(ORG);
            } else {
                style = "";
                defaultOrg = loginOrgId;
            }
            formShowParameter.setCustomParam("record_style", (Object)style);
            DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])enableSchemeIds.toArray(), (DynamicObjectType)dataEntityType);
            ArrayList<DynamicObject> allotSchemes = new ArrayList<DynamicObject>(8);
            for (DynamicObject scheme : schemes) {
                boolean useDimension = scheme.getBoolean(USEDIMENSION);
                boolean isShare = scheme.getBoolean("isalluse");
                if (!useDimension) {
                    if (userHasPermOrgs.hasAllOrgPerm() || hasPermOrgs.contains(defaultOrg)) {
                        formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)String.valueOf(defaultOrg));
                    } else {
                        formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)String.valueOf(hasPermOrgs.get(0)));
                    }
                    return scheme;
                }
                if (isShare) {
                    List<String> orgViewTypeNumberList;
                    List<Long> hasOrgPermList = this.getHasOrgPermIds(userHasPermOrgs);
                    List<Long> viewOrgList = this.getOrgIdsByOrgViewNumbers(hasOrgPermList, orgViewTypeNumberList = this.getViewTypeNumberList(scheme), false);
                    if (viewOrgList.contains(defaultOrg)) {
                        formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)String.valueOf(defaultOrg));
                        return scheme;
                    }
                    if (!viewOrgList.isEmpty()) {
                        formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)String.valueOf(viewOrgList.get(0)));
                        return scheme;
                    }
                    return null;
                }
                DynamicObject dimensionType = scheme.getDynamicObject("dimensiontype");
                String typeNumber = dimensionType.getString(NUMBER);
                if (!BOS_ORG.equals(typeNumber)) {
                    return scheme;
                }
                allotSchemes.add(scheme);
            }
            if (!allotSchemes.isEmpty()) {
                List allotSchemeIds = allotSchemes.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                Long schemeId = null;
                QFilter allotSchemeFilter = new QFilter(INITIAL_SCHEME, "in", allotSchemeIds);
                QFilter defaultOrgFilter = new QFilter(ORG, "=", (Object)defaultOrg);
                DynamicObject loginOrgAllot = BusinessDataServiceHelper.loadSingle((String)IMIC_ASSIGNRECORD, (String)INITIAL_SCHEME, (QFilter[])new QFilter[]{allotSchemeFilter, defaultOrgFilter});
                if (loginOrgAllot != null && (userHasPermOrgs.hasAllOrgPerm() || hasPermOrgs.contains(defaultOrg))) {
                    formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)String.valueOf(defaultOrg));
                    schemeId = loginOrgAllot.getLong("initialscheme_id");
                }
                if (schemeId == null) {
                    QFilter allOrgFilter = null;
                    allOrgFilter = userHasPermOrgs.hasAllOrgPerm() ? allotSchemeFilter : allotSchemeFilter.and(new QFilter(ORG, "in", (Object)hasPermOrgs));
                    DynamicObject otherOrgAllot = QueryServiceHelper.queryOne((String)IMIC_ASSIGNRECORD, (String)"initialscheme.id, org.id", (QFilter[])allOrgFilter.toArray());
                    if (otherOrgAllot != null) {
                        schemeId = otherOrgAllot.getLong("initialscheme.id");
                        String defaultOrgId = otherOrgAllot.getString("org.id");
                        formShowParameter.setCustomParam(DEFAULT_ORG_ID, (Object)defaultOrgId);
                    }
                }
                for (DynamicObject scheme : allotSchemes) {
                    if (schemeId == null || !schemeId.equals(scheme.getPkValue())) continue;
                    return scheme;
                }
            }
        }
        return null;
    }

    private DynamicObject getInitGuideRecord(String appNumber, long curUserId) {
        QFilter appNumberFilter = new QFilter("bizappnumber", "=", (Object)appNumber);
        QFilter userFilter = new QFilter("user", "=", (Object)curUserId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"imic_initguide_record", (QFilter[])new QFilter[]{appNumberFilter, userFilter});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(INIT_SUB_ITEMS_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid cardEntryGrid = (EntryGrid)this.getView().getControl(INITITEMENTRY_CARD);
        cardEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        cardEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ORG);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Wizard wizard = (Wizard)this.getControl(WIZARDAP);
        wizard.addWizardStepsListener((WizardStepsListener)this);
        Vector cardWhite = (Vector)this.getControl("card_white");
        cardWhite.addClickListener((ClickListener)this);
        Vector listWhite = (Vector)this.getControl("list_white");
        listWhite.addClickListener((ClickListener)this);
        Label urlCardLabel = (Label)this.getControl("url_icon_card");
        urlCardLabel.addClickListener((ClickListener)this);
        Label selectAllLabel = (Label)this.getControl(ALL_SELECT);
        selectAllLabel.addClickListener((ClickListener)this);
        Label unSelectLabel = (Label)this.getControl(UN_SELECT);
        unSelectLabel.addClickListener((ClickListener)this);
        Button selectCard = (Button)this.getControl("select_card");
        selectCard.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object initSchemeId = this.getView().getFormShowParameter().getCustomParam("initSchemeId");
        log.info("\u5411\u5bfc\u65b9\u6848id\u4e3a\uff1a" + initSchemeId);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)IMIC_INITIAL_SCHEME, (QFilter[])new QFilter[]{new QFilter("id", "=", initSchemeId)});
        this.getModel().setValue(INITIAL_SCHEME, (Object)scheme);
        String recordStyle = (String)this.getView().getFormShowParameter().getCustomParam("record_style");
        String viewStyle = StringUtils.isBlank((CharSequence)recordStyle) ? scheme.getString(VIEW_STYLE) : recordStyle;
        this.getPageCache().put(VIEW_STYLE, viewStyle);
        this.getView().getPageCache().put("schemeFirstModifyTime", String.valueOf(scheme.getDate("modifytime").getTime()));
        this.getView().getPageCache().put("assignOrgSet", JSON.toJSONString(this.getAssignOrgSet()));
        String defaultOrgId = (String)this.getView().getFormShowParameter().getCustomParam(DEFAULT_ORG_ID);
        if (defaultOrgId != null) {
            this.getPageCache().put(DEFAULT_ORG_ID, defaultOrgId);
            this.getModel().setValue(ORG, (Object)Long.parseLong(defaultOrgId));
            log.info("\u521d\u59cb\u5316\u7ec4\u7ec7id\u4e3a\uff1a" + defaultOrgId);
        }
        this.getPageCache().put(BIZ_APP_NUMBER, scheme.getDynamicObject("bizapp").getString(NUMBER));
        this.setProgressCaliber(scheme.getString("defaultcaliber"));
        this.setItemEntryValues(this.getNotCompleteIndex());
        this.setEntrySchedule();
        this.setGuideProgress();
        this.createComboItems();
    }

    private void createComboItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        ComboItem comboItem1 = new ComboItem();
        comboItem1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6709\u6570\u636e", (String)"InitGuideFormPlugin_20", (String)"bos-ext-imsc", (Object[])new Object[0])));
        comboItem1.setValue("A");
        comboItem1.setImageKey("/icons/pc/label/gyl_ysj_50_20.png");
        comboItems.add(comboItem1);
        ComboItem comboItem2 = new ComboItem();
        comboItem2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"InitGuideFormPlugin_21", (String)"bos-ext-imsc", (Object[])new Object[0])));
        comboItem2.setValue("B");
        comboItem2.setImageKey("/icons/pc/label/gyl_wsj_50_20.png");
        comboItems.add(comboItem2);
        ComboItem comboItem3 = new ComboItem();
        comboItem3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"InitGuideFormPlugin_22", (String)"bos-ext-imsc", (Object[])new Object[0])));
        comboItem3.setValue("");
        comboItems.add(comboItem3);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(FIELD_HASDATA);
        comboEdit.setComboItems(comboItems);
    }

    private void setProgressCaliber(String defaultCaliber) {
        if (BOTH_TASK.equals(defaultCaliber)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ALL_PROGRESS_FLEX, STEP_PROGRESS_FLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_BAR, SCHEDULE});
            this.getView().getPageCache().put("defaultcaliber", BOTH_TASK);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ALL_PROGRESS_FLEX, STEP_PROGRESS_FLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESS_BAR, SCHEDULE});
            if ("B".equals(defaultCaliber)) {
                this.getView().getPageCache().put("defaultcaliber", "B");
            } else {
                this.getView().getPageCache().put("defaultcaliber", "A");
            }
        }
    }

    private void setGuideProgress() {
        ProgressBar barAp = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        ProgressBar allProgress = (ProgressBar)this.getView().getControl(ALL_PROGRESS);
        ProgressBar allMustProgress = (ProgressBar)this.getView().getControl(ALL_MUST_PROGRESS);
        Label allLabel = (Label)this.getControl(ALL_LABEL);
        Label allMustLabel = (Label)this.getControl(ALL_MUST_LABEL);
        Object preView = this.getView().getFormShowParameter().getCustomParam(PREVIEW);
        if (!Objects.isNull(preView)) {
            barAp.setPercent(0);
            allProgress.setPercent(0);
            allMustProgress.setPercent(0);
            return;
        }
        Map<String, List<Object>> map = this.getItemsIdMap();
        List<Object> allItemsId = map.get(ALL_ITEMS_ID);
        List<Object> mustItemsId = map.get(MUST_ITEMS_ID);
        QFilter allFilter = new QFilter(INITIAL_SCHEME_ENTRY_ID, "in", allItemsId);
        QFilter mustFilter = new QFilter(INITIAL_SCHEME_ENTRY_ID, "in", mustItemsId);
        String defaultOrgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
        if (defaultOrgId != null) {
            QFilter tempFilter = new QFilter(DIMENSION, "=", (Object)defaultOrgId);
            allFilter.and(tempFilter);
            mustFilter.and(tempFilter);
        }
        int mustFnItemsSize = 0;
        DynamicObjectCollection allFnEntryIds = QueryServiceHelper.query((String)IMIC_PROGRESSUNIT, (String)INITIAL_SCHEME_ENTRY_ID, (QFilter[])allFilter.toArray(), null, (int)-1);
        for (DynamicObject fnEntry : allFnEntryIds) {
            if (!mustItemsId.contains(fnEntry.get(INITIAL_SCHEME_ENTRY_ID))) continue;
            ++mustFnItemsSize;
        }
        BigDecimal allItemsNum = new BigDecimal(allItemsId.size());
        BigDecimal fnItemsNum = new BigDecimal(allFnEntryIds.size());
        BigDecimal allMustItemsNum = new BigDecimal(mustItemsId.size());
        BigDecimal fnMustItemsNum = new BigDecimal(mustFnItemsSize);
        int allPercent = fnItemsNum.divide(allItemsNum, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue();
        int mustPercent = !allMustItemsNum.equals(BigDecimal.ZERO) ? fnMustItemsNum.divide(allMustItemsNum, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue() : 100;
        String defaultCaliber = this.getView().getPageCache().get("defaultcaliber");
        if ("B".equals(defaultCaliber)) {
            barAp.setPercent(mustPercent);
        } else {
            barAp.setPercent(allPercent);
        }
        allProgress.setPercent(allPercent);
        allMustProgress.setPercent(mustPercent);
        allLabel.setText(allPercent + "%");
        allMustLabel.setText(mustPercent + "%");
    }

    private Map<String, List<Object>> getItemsIdMap() {
        DynamicObject scheme = this.getSchemeForForm();
        DynamicObjectCollection itemGroups = scheme.getDynamicObjectCollection(ITEM_GROUP);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(2);
        ArrayList allItemsId = new ArrayList(8);
        ArrayList<Object> mustItemsId = new ArrayList<Object>(8);
        for (DynamicObject itemGroup : itemGroups) {
            DynamicObjectCollection schemeItems = itemGroup.getDynamicObjectCollection(INITENTRY_ITEMS);
            for (DynamicObject item : schemeItems) {
                if (!Boolean.TRUE.equals(item.getBoolean(INIT_CONFIG_MUST_SET) && Boolean.TRUE.equals(item.getBoolean(ITEM_ENABLED)))) continue;
                mustItemsId.add(item.get("id"));
            }
            allItemsId.addAll(schemeItems.stream().filter(y -> y.getBoolean(ITEM_ENABLED)).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        map.put(ALL_ITEMS_ID, allItemsId);
        map.put(MUST_ITEMS_ID, mustItemsId);
        return map;
    }

    private void setWizardStepValue() {
        String stepCurrentIndex;
        List<List<Object>> itemEntryIdsList;
        List<Object> itemsId;
        Wizard wizardAp = (Wizard)this.getControl(WIZARDAP);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(WIZARDAP, "visualStyle", (Object)1);
        DynamicObject scheme = this.getSchemeForForm();
        DynamicObjectCollection itemGroupCard = scheme.getDynamicObjectCollection(ITEM_GROUP);
        this.removeDisEnableItemGroup(itemGroupCard);
        Map<String, List<Object>> map = this.getItemsIdMap();
        String defaultCaliber = this.getView().getPageCache().get("defaultcaliber");
        if ("B".equals(defaultCaliber)) {
            itemsId = map.get(MUST_ITEMS_ID);
            itemEntryIdsList = this.buildItemEntryIdsList(scheme, true);
        } else {
            itemsId = map.get(ALL_ITEMS_ID);
            itemEntryIdsList = this.buildItemEntryIdsList(scheme, false);
        }
        QFilter qFilters = new QFilter("id", "is not null", (Object)" ");
        String defaultOrgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
        if (defaultOrgId != null) {
            qFilters.and(new QFilter(DIMENSION, "=", (Object)defaultOrgId));
        }
        qFilters.and(new QFilter(INITIAL_SCHEME_ENTRY_ID, "in", itemsId));
        DynamicObjectCollection allRecords = QueryServiceHelper.query((String)IMIC_PROGRESSUNIT, (String)"id, initialschemeentryid", (QFilter[])qFilters.toArray());
        Map<Integer, Integer> countMap = this.getItemGroupCompItemsMap(itemEntryIdsList, allRecords);
        ArrayList<StepsOption> stepsOptionList = new ArrayList<StepsOption>(10);
        Object preView = this.getView().getFormShowParameter().getCustomParam(PREVIEW);
        HashMap<Integer, String> statusMapping = new HashMap<Integer, String>(8);
        int tempIndex = 0;
        int currentIndex = -1;
        for (DynamicObject oneStep : itemGroupCard) {
            String stepStatus;
            StepsOption stepsOption = new StepsOption();
            String stepName = oneStep.getLocaleString("stepname").getLocaleValue();
            stepsOption.setTitle(new LocaleString(stepName));
            if (!Objects.isNull(preView)) {
                stepsOptionList.add(stepsOption);
                continue;
            }
            List<Object> itemsList = itemEntryIdsList.get(tempIndex);
            Integer completeCount = countMap.get(tempIndex);
            if (completeCount.intValue() == itemsList.size()) {
                stepStatus = "finish";
            } else if (completeCount == 0) {
                stepStatus = "wait";
                currentIndex = currentIndex == -1 ? tempIndex : currentIndex;
            } else {
                stepStatus = "process";
                currentIndex = currentIndex == -1 ? tempIndex : currentIndex;
            }
            stepsOption.setStatus(stepStatus);
            statusMapping.put(tempIndex, stepStatus);
            ++tempIndex;
            stepsOptionList.add(stepsOption);
        }
        this.sendRequestToView(stepsOptionList);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        int n = currentIndex = currentIndex == -1 ? stepsOptionList.size() - 1 : currentIndex;
        if (!Objects.isNull(preView)) {
            currentIndex = 0;
        }
        if ((stepCurrentIndex = this.getView().getPageCache().get("stepCurrentIndex")) != null) {
            currentIndex = Integer.parseInt(stepCurrentIndex) >= stepsOptionList.size() ? stepsOptionList.size() - 1 : Integer.parseInt(stepCurrentIndex);
        }
        this.getView().getPageCache().put("stepCurrentIndex", String.valueOf(currentIndex));
        currentStepMap.put("currentStep", currentIndex);
        if (currentIndex == -1) {
            currentStepMap.put(CURRENT_STATUS, "finish");
        } else {
            currentStepMap.put(CURRENT_STATUS, statusMapping.get(currentIndex));
        }
        wizardAp.setWizardCurrentStep(currentStepMap);
    }

    private List<List<Object>> buildItemEntryIdsList(DynamicObject scheme, boolean isMustSet) {
        ArrayList<List<Object>> itemEntryIdsList = new ArrayList<List<Object>>(10);
        DynamicObjectCollection itemGroupCard = scheme.getDynamicObjectCollection(ITEM_GROUP);
        for (DynamicObject itemGroup : itemGroupCard) {
            DynamicObjectCollection schemeItems = itemGroup.getDynamicObjectCollection(INITENTRY_ITEMS);
            List<Object> itemEntryIds = new ArrayList(2);
            itemEntryIds = isMustSet ? schemeItems.stream().filter(item -> item.getBoolean(INIT_CONFIG_MUST_SET)).filter(l -> l.getBoolean(ITEM_ENABLED)).map(DataEntityBase::getPkValue).collect(Collectors.toList()) : schemeItems.stream().filter(l -> l.getBoolean(ITEM_ENABLED)).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            itemEntryIdsList.add(itemEntryIds);
        }
        return itemEntryIdsList;
    }

    private void removeDisEnableItemGroup(DynamicObjectCollection itemGroupCard) {
        ArrayList<DynamicObject> deleteStep = new ArrayList<DynamicObject>(10);
        for (DynamicObject oneStep : itemGroupCard) {
            DynamicObjectCollection itemsEntry = oneStep.getDynamicObjectCollection(INITENTRY_ITEMS);
            int temp = 0;
            for (DynamicObject row : itemsEntry) {
                boolean itemIsEnable = row.getBoolean(ITEM_ENABLED);
                if (itemIsEnable) continue;
                ++temp;
            }
            if (temp < itemsEntry.size()) continue;
            deleteStep.add(oneStep);
        }
        itemGroupCard.removeAll(deleteStep);
    }

    private Map<Integer, Integer> getItemGroupCompItemsMap(List<List<Object>> itemEntryIdsList, DynamicObjectCollection allRecords) {
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>(2);
        for (int i = 0; i < itemEntryIdsList.size(); ++i) {
            List<Object> oneStepIdList = itemEntryIdsList.get(i);
            int count = 0;
            for (DynamicObject allRecord : allRecords) {
                Long entryId = allRecord.getLong(INITIAL_SCHEME_ENTRY_ID);
                if (!oneStepIdList.contains(entryId)) continue;
                ++count;
            }
            countMap.put(i, count);
        }
        return countMap;
    }

    private void sendRequestToView(List<StepsOption> stepsOptionList) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(WIZARDAP, "setWizardStepsOptions", new Object[]{stepsOptionList.stream().map(stepsOption -> {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("title", stepsOption.getTitle());
            if (stepsOption.getStatus() != null) {
                map.put("status", stepsOption.getStatus());
            }
            return map;
        }).collect(Collectors.toList())});
    }

    private void setItemEntryValues(int rowIndex) {
        DynamicObject scheme = this.getSchemeForForm();
        DynamicObjectCollection itemGroup = scheme.getDynamicObjectCollection(ITEM_GROUP);
        this.removeDisEnableItemGroup(itemGroup);
        int index = rowIndex == -1 || rowIndex >= itemGroup.size() ? itemGroup.size() - 1 : rowIndex;
        DynamicObject selectWizard = (DynamicObject)itemGroup.get(index);
        DynamicObjectCollection schemeItems = selectWizard.getDynamicObjectCollection(INITENTRY_ITEMS);
        ArrayList<DynamicObject> deleteItems = new ArrayList<DynamicObject>(10);
        for (DynamicObject schemeItem : schemeItems) {
            boolean itemEnabled = schemeItem.getBoolean(ITEM_ENABLED);
            if (itemEnabled) continue;
            deleteItems.add(schemeItem);
        }
        schemeItems.removeAll(deleteItems);
        this.getModel().deleteEntryData(INIT_SUB_ITEMS_ENTRY);
        this.getModel().deleteEntryData(INITITEMENTRY_CARD);
        this.setListEntryValue(schemeItems);
        this.setCardEntryValue(schemeItems);
        this.setHasData(schemeItems);
        Object isPreView = this.getView().getFormShowParameter().getCustomParam(PREVIEW);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INITITEMENTRY_CARD);
        if (!Objects.isNull(isPreView)) {
            for (int i = 0; i < schemeItems.size(); ++i) {
                this.getModel().setValue(COMPLETE_STATUS, (Object)"B", i);
                cardEntry.setChildVisible(false, i, new String[]{"finish_card"});
                cardEntry.setChildVisible(true, i, new String[]{"unfinish_card"});
                this.getModel().setValue(COMPLETEDUSER, null, i);
                this.getModel().setValue(COMPLETEDTIME, null, i);
            }
        } else {
            ArrayList itemEntryIds = new ArrayList(10);
            schemeItems.forEach(l -> itemEntryIds.add(l.getPkValue()));
            QFilter qFilter = new QFilter(INITIAL_SCHEME_ENTRY_ID, "in", itemEntryIds);
            String defaultOrgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
            if (defaultOrgId != null) {
                qFilter.and(new QFilter(DIMENSION, "=", (Object)defaultOrgId));
            }
            DynamicObject[] existUnit = BusinessDataServiceHelper.load((String)IMIC_PROGRESSUNIT, (String)"completeduser,completedtime,initialschemeentryid", (QFilter[])qFilter.toArray());
            HashMap entryIdDyMap = new HashMap(8);
            Arrays.stream(existUnit).forEach(l -> entryIdDyMap.put(l.getLong("initialschemeentryid_id"), l));
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(INIT_SUB_ITEMS_ENTRY);
            ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(10);
            for (int i = 0; i < schemeItems.size(); ++i) {
                DynamicObject schemeItem = (DynamicObject)schemeItems.get(i);
                DynamicObject progressUnit = (DynamicObject)entryIdDyMap.get(schemeItem.getPkValue());
                if (progressUnit != null) {
                    this.getModel().setValue(COMPLETE_STATUS, (Object)"A", i);
                    cardEntry.setChildVisible(false, i, new String[]{"unfinish_card"});
                    cardEntry.setChildVisible(true, i, new String[]{"finish_card"});
                    this.getModel().setValue(COMPLETEDUSER, progressUnit.get(COMPLETEDUSER), i);
                    this.getModel().setValue(COMPLETEDTIME, progressUnit.get(COMPLETEDTIME), i);
                } else {
                    cardEntry.setChildVisible(false, i, new String[]{"finish_card"});
                    cardEntry.setChildVisible(true, i, new String[]{"unfinish_card"});
                }
                cellStyleList.add(this.setCellColor(COMPLETE_STATUS, i, progressUnit != null));
            }
            grid.setCellStyle(cellStyleList);
        }
    }

    private void setCardEntryValue(DynamicObjectCollection schemeItems) {
        for (DynamicObject schemeItem : schemeItems) {
            int subEntryRow = this.getModel().createNewEntryRow(INITITEMENTRY_CARD);
            this.getModel().setValue("itemname_card", (Object)schemeItem.getLocaleString("itemname"), subEntryRow);
            DynamicObject item = schemeItem.getDynamicObject(INIT_ITEMS);
            if (item != null) {
                this.getModel().setValue("inititems_card", (Object)item.getString(NAME), subEntryRow);
            }
            this.getModel().setValue("mustset_card", schemeItem.get(INIT_CONFIG_MUST_SET), subEntryRow);
            this.getModel().setValue("description_card", (Object)schemeItem.getLocaleString("initconfigdescription"), subEntryRow);
            CardEntry cardEntry = (CardEntry)this.getView().getControl(INITITEMENTRY_CARD);
            cardEntry.setChildVisible(false, subEntryRow, new String[]{"select_card"});
            cardEntry.setChildVisible(true, subEntryRow, new String[]{"unselect_card"});
            String entryUrl = schemeItem.getString("initconfigurl");
            cardEntry.setChildVisible(StringUtils.isNotBlank((CharSequence)entryUrl), subEntryRow, new String[]{"url_icon_card"});
        }
    }

    private void setListEntryValue(DynamicObjectCollection schemeItems) {
        for (DynamicObject schemeItem : schemeItems) {
            int subEntryRow = this.getModel().createNewEntryRow(INIT_SUB_ITEMS_ENTRY);
            this.getModel().setValue("itementryid", schemeItem.getPkValue(), subEntryRow);
            this.getModel().setValue("itemname", (Object)schemeItem.getLocaleString("itemname"), subEntryRow);
            DynamicObject item = schemeItem.getDynamicObject(INIT_ITEMS);
            this.getModel().setValue(INIT_ITEMS, (Object)item, subEntryRow);
            String pageParam = schemeItem.getString("pageparam");
            this.getModel().setValue("pageparam", (Object)pageParam, subEntryRow);
            if (item != null) {
                JSONObject paramJson;
                String caption;
                String itemName = item.getLocaleString(NAME).getLocaleValue();
                if (StringUtils.isNotBlank((CharSequence)pageParam) && StringUtils.isNotBlank((CharSequence)(caption = (String)(paramJson = JSON.parseObject((String)pageParam)).get((Object)"caption")))) {
                    itemName = caption;
                }
                item.set(NAME, (Object)new LocaleString(itemName));
                this.getModel().setValue("inititemname", (Object)itemName, subEntryRow);
            }
            this.getModel().setValue(MUST_SET, schemeItem.get(INIT_CONFIG_MUST_SET), subEntryRow);
            this.getModel().setValue("initconfigdescription", (Object)schemeItem.getLocaleString("initconfigdescription"), subEntryRow);
            String entryUrl = schemeItem.getString("initconfigurl");
            if (!StringUtils.isNotBlank((CharSequence)entryUrl)) continue;
            this.getModel().setValue("actualurl", (Object)entryUrl, subEntryRow);
        }
    }

    private int getNotCompleteIndex() {
        List<List<Object>> itemEntryIdsList;
        List<Object> itemsId;
        Object preView = this.getView().getFormShowParameter().getCustomParam(PREVIEW);
        DynamicObject scheme = this.getSchemeForForm();
        DynamicObjectCollection itemGroups = scheme.getDynamicObjectCollection(ITEM_GROUP);
        if (!Objects.isNull(preView)) {
            for (int i = 0; i < itemGroups.size(); ++i) {
                DynamicObjectCollection itemsRows = ((DynamicObject)itemGroups.get(i)).getDynamicObjectCollection(INITENTRY_ITEMS);
                for (DynamicObject itemsRow : itemsRows) {
                    boolean itemEnabled = itemsRow.getBoolean(ITEM_ENABLED);
                    if (!itemEnabled) continue;
                    return i;
                }
            }
        }
        this.removeDisEnableItemGroup(itemGroups);
        Map<String, List<Object>> map = this.getItemsIdMap();
        String defaultCaliber = this.getView().getPageCache().get("defaultcaliber");
        if ("B".equals(defaultCaliber)) {
            itemsId = map.get(MUST_ITEMS_ID);
            itemEntryIdsList = this.buildItemEntryIdsList(scheme, true);
        } else {
            itemsId = map.get(ALL_ITEMS_ID);
            itemEntryIdsList = this.buildItemEntryIdsList(scheme, false);
        }
        QFilter qFilters = new QFilter("id", "is not null", (Object)" ");
        String defaultOrgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
        if (defaultOrgId != null) {
            qFilters.and(new QFilter(DIMENSION, "=", (Object)defaultOrgId));
        }
        qFilters.and(new QFilter(INITIAL_SCHEME_ENTRY_ID, "in", itemsId));
        DynamicObjectCollection allRecords = QueryServiceHelper.query((String)IMIC_PROGRESSUNIT, (String)"id, initialschemeentryid", (QFilter[])qFilters.toArray());
        Map<Integer, Integer> countMap = this.getItemGroupCompItemsMap(itemEntryIdsList, allRecords);
        for (Map.Entry<Integer, Integer> countEntry : countMap.entrySet()) {
            Integer key = countEntry.getKey();
            Integer value = countEntry.getValue();
            if (value >= itemEntryIdsList.get(key).size()) continue;
            return key;
        }
        return -1;
    }

    private void setHasData(DynamicObjectCollection schemeItems) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INITITEMENTRY_CARD);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(INIT_SUB_ITEMS_ENTRY);
        ArrayList<CellStyle> csList = new ArrayList<CellStyle>(10);
        for (int subEntryRow = 0; subEntryRow < schemeItems.size(); ++subEntryRow) {
            String modelType;
            DynamicObject schemeItemRow = (DynamicObject)schemeItems.get(subEntryRow);
            DynamicObject item = schemeItemRow.getDynamicObject(INIT_ITEMS);
            String dataJudgeBasis = schemeItemRow.getString("datajudgebasisdesc_tag");
            String queryEntity = "";
            String queryBoundField = "";
            String filterCon = "";
            boolean isQueryHasData = true;
            boolean isQueryCtrlstrtg = false;
            Boolean customizeConfig = null;
            String interfaceConfig = "";
            if (item != null && (StringUtils.equals((CharSequence)"BillFormModel", (CharSequence)(modelType = item.getString("modeltype"))) || StringUtils.equals((CharSequence)"BaseFormModel", (CharSequence)modelType))) {
                queryEntity = item.getString(NUMBER);
            }
            if (StringUtils.isNotBlank((CharSequence)dataJudgeBasis)) {
                JSONObject paramJson = JSON.parseObject((String)dataJudgeBasis);
                Boolean isQueryHasDataJson = paramJson.getBoolean("isqueryinititemhasdata");
                isQueryHasData = isQueryHasDataJson == null || isQueryHasDataJson != false;
                String queryEntityJson = paramJson.getString("queryentity");
                if (StringUtils.isNotBlank((CharSequence)queryEntityJson)) {
                    queryEntity = queryEntityJson;
                }
                customizeConfig = paramJson.getBoolean("customizeconfig");
                interfaceConfig = paramJson.getString("interfaceconfig");
                Boolean isQueryCtrlstrtgJson = paramJson.getBoolean("isbdctrlstrtgqueryhasdata");
                isQueryCtrlstrtg = isQueryCtrlstrtgJson != null && isQueryCtrlstrtgJson != false;
                queryBoundField = paramJson.getString("queryboundfield");
                filterCon = paramJson.getString("filtercondition");
            }
            if (StringUtils.isBlank((CharSequence)queryEntity) || !isQueryHasData) {
                this.getModel().setValue(FIELD_HASDATA, null, subEntryRow);
                cardEntry.setChildVisible(false, subEntryRow, new String[]{"hasdata_card", "notdata_card"});
                continue;
            }
            String realEntityId = FormMetadataCache.getFormConfig((String)queryEntity).getEntityTypeId();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)realEntityId);
            queryEntity = entityType.getName();
            if (StringUtils.isBlank((CharSequence)entityType.getAlias())) {
                this.getModel().setValue(FIELD_HASDATA, (Object)"B", subEntryRow);
                cardEntry.setChildVisible(false, subEntryRow, new String[]{"hasdata_card"});
                continue;
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            Boolean exists = null;
            String orgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
            if (Boolean.TRUE.equals(customizeConfig)) {
                log.info("\u81ea\u5b9a\u4e49\u5fae\u670d\u52a1\u5b57\u7b26\u4e32\u4fe1\u606f\uff1a{}", (Object)interfaceConfig);
                Matcher matcher = PATTERN.matcher(interfaceConfig);
                if (matcher.find()) {
                    String[] parts = matcher.group(1).split("\\.");
                    String cloudId = parts[0];
                    String appId = parts[1];
                    String serverName = parts[2];
                    String method = parts[3];
                    try {
                        exists = (Boolean)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serverName, (String)method, (Object[])new Object[]{queryEntity, Long.parseLong(orgId)});
                    }
                    catch (Exception ex) {
                        this.getModel().setValue(FIELD_HASDATA, null, subEntryRow);
                        cardEntry.setChildVisible(false, subEntryRow, new String[]{"hasdata_card", "notdata_card"});
                        log.error("\u901a\u8fc7\u5fae\u670d\u52a1\u67e5\u8be2\u662f\u5426\u6709\u6570\u636e\u51fa\u9519" + ex.getMessage(), (Throwable)ex);
                    }
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)orgId)) {
                    if (isQueryCtrlstrtg) {
                        qFilterList.add(BaseDataServiceHelper.getBaseDataFilter((String)queryEntity, (Long)Long.parseLong(orgId)));
                    } else if (StringUtils.isNotBlank((CharSequence)queryBoundField)) {
                        qFilterList.add(new QFilter(queryBoundField, "=", (Object)Long.parseLong(orgId)));
                    }
                }
                FilterCondition filterCondition = null;
                if (StringUtils.isNotBlank((CharSequence)filterCon)) {
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterCon, FilterCondition.class);
                }
                if (filterCondition != null) {
                    FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
                    filterBuilder.buildFilter();
                    qFilterList.add(filterBuilder.getQFilter());
                }
                exists = QueryServiceHelper.exists((String)queryEntity, (QFilter[])qFilterList.toArray(new QFilter[0]));
            }
            if (exists == null) continue;
            String hasData = Boolean.TRUE.equals(exists) ? "A" : "B";
            this.getModel().setValue(FIELD_HASDATA, (Object)hasData, subEntryRow);
            csList.add(this.setCellColor(FIELD_HASDATA, subEntryRow, exists));
            if (Boolean.TRUE.equals(exists)) {
                cardEntry.setChildVisible(false, subEntryRow, new String[]{"notdata_card"});
                continue;
            }
            cardEntry.setChildVisible(false, subEntryRow, new String[]{"hasdata_card"});
        }
        grid.setCellStyle(csList);
    }

    private CellStyle setCellColor(String fieldKey, int subEntryRow, Boolean exists) {
        CellStyle cs = new CellStyle();
        if (Boolean.TRUE.equals(exists)) {
            cs.setForeColor(COLOR_GREEN);
        } else {
            cs.setForeColor(COLOR_ORANGE);
        }
        cs.setFieldKey(fieldKey);
        cs.setRow(subEntryRow);
        return cs;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.hideConfigUrlAp();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setWizardStepValue();
        this.setDimensionHide();
        this.setListOrCardHide();
        this.setSelectCount(0);
        Label total = (Label)this.getView().getControl("total");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INIT_SUB_ITEMS_ENTRY);
        total.setText(String.valueOf(entryEntity.size()));
        this.getView().setVisible(Boolean.FALSE, new String[]{UN_SELECT});
    }

    private void hideConfigUrlAp() {
        EntryGrid importResultGrid = (EntryGrid)this.getControl(INIT_SUB_ITEMS_ENTRY);
        ArrayList<String> opeIds = new ArrayList<String>();
        opeIds.add("configurl");
        DynamicObjectCollection importResultEntry = this.getModel().getEntryEntity(INIT_SUB_ITEMS_ENTRY);
        int index = 0;
        for (DynamicObject result : importResultEntry) {
            String actualUrl = result.getString("actualurl");
            if (StringUtils.isBlank((CharSequence)actualUrl)) {
                importResultGrid.hideOperateItems("operationcolumn", index, opeIds);
            }
            ++index;
        }
    }

    private void setSelectCount(int selectCount) {
        Label label = (Label)this.getView().getControl("select");
        label.setText(String.valueOf(selectCount));
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection entryEntity;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int[] entrySelectRows = this.getEntrySelectRows();
        this.setSelectLabelVisible(entrySelectRows.length < (entryEntity = this.getModel().getEntryEntity(INITITEMENTRY_CARD)).size() ? Boolean.TRUE : Boolean.FALSE);
        if (StringUtils.equals((CharSequence)INIT_SUB_ITEMS_ENTRY, (CharSequence)entryGrid.getKey())) {
            this.setSelectCount(entrySelectRows.length);
        } else if (StringUtils.equals((CharSequence)INITITEMENTRY_CARD, (CharSequence)entryGrid.getKey())) {
            this.setCardEntrySelectRows(entrySelectRows);
        }
    }

    private void setCardEntrySelectRows(int[] entrySelectRows) {
        this.setSelectCount(entrySelectRows.length);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INITITEMENTRY_CARD);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(INITITEMENTRY_CARD);
        for (int rowIndex : entrySelectRows) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"unselect_card"});
            cardEntry.setChildVisible(true, rowIndex, new String[]{"select_card"});
        }
        List arrList = Arrays.stream(entrySelectRows).boxed().collect(Collectors.toList());
        List unselect = IntStream.range(0, entryEntity.size()).filter(y -> !arrList.contains(y)).boxed().collect(Collectors.toList());
        for (Integer rowIndex : unselect) {
            cardEntry.setChildVisible(true, rowIndex.intValue(), new String[]{"unselect_card"});
            cardEntry.setChildVisible(false, rowIndex.intValue(), new String[]{"select_card"});
        }
    }

    private void setListOrCardHide() {
        String defaultStyle = this.getView().getPageCache().get(VIEW_STYLE);
        if (StringUtils.equals((CharSequence)defaultStyle, (CharSequence)"list")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"list_blue", "card_white", INIT_SUB_ITEMS_ENTRY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"list_white", "card_blue", INITITEMENTRY_CARD});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"list_white", "card_blue", INITITEMENTRY_CARD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"list_blue", "card_white", INIT_SUB_ITEMS_ENTRY});
        }
    }

    private DynamicObject getSchemeForForm() {
        DynamicObject value = (DynamicObject)this.getModel().getValue(INITIAL_SCHEME);
        Object pk = value.getPkValue();
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)IMIC_INITIAL_SCHEME);
    }

    private int setEntrySchedule() {
        DynamicObjectCollection subEntryData = this.getModel().getDataEntity(true).getDynamicObjectCollection(INIT_SUB_ITEMS_ENTRY);
        ProgressBar stepProgress = (ProgressBar)this.getView().getControl(STEP_PROGRESS);
        ProgressBar stepMustProgress = (ProgressBar)this.getView().getControl(STEP_MUST_PROGRESS);
        Label stepLabel = (Label)this.getControl(STEP_LABEL);
        Label stepMustLabel = (Label)this.getControl(STEP_MUST_LABEL);
        Label schedule = (Label)this.getView().getControl(SCHEDULE);
        int allNum = subEntryData.size();
        int allMustNum = 0;
        int fnNum = 0;
        int fnMustNum = 0;
        log.info("\u5f53\u524d\u6b65\u9aa4\u603b\u6761\u6570 {}", (Object)allNum);
        if (allNum == 0) {
            return allNum;
        }
        for (DynamicObject subEntryDatum : subEntryData) {
            String isComplete = subEntryDatum.getString(COMPLETE_STATUS);
            boolean isMust = subEntryDatum.getBoolean(MUST_SET);
            if (StringUtils.equals((CharSequence)isComplete, (CharSequence)"A")) {
                ++fnNum;
            }
            if (!isMust) continue;
            if (StringUtils.equals((CharSequence)isComplete, (CharSequence)"A")) {
                ++fnMustNum;
            }
            ++allMustNum;
        }
        log.info("\u5f53\u524d\u6b65\u9aa4\u5b8c\u6210\u6761\u6570 {}", (Object)fnNum);
        BigDecimal allNumBig = new BigDecimal(allNum);
        BigDecimal fnNumBig = new BigDecimal(fnNum);
        BigDecimal allMustNumBig = new BigDecimal(allMustNum);
        BigDecimal fnMustNumBig = new BigDecimal(fnMustNum);
        int percent = fnNumBig.divide(allNumBig, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue();
        int mustPercent = !allMustNumBig.equals(BigDecimal.ZERO) ? fnMustNumBig.divide(allMustNumBig, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).intValue() : 100;
        stepProgress.setPercent(percent);
        stepMustProgress.setPercent(mustPercent);
        stepLabel.setText(percent + "%");
        stepMustLabel.setText(mustPercent + "%");
        String defaultCaliber = this.getView().getPageCache().get("defaultcaliber");
        if ("B".equals(defaultCaliber)) {
            schedule.setText(mustPercent + "%");
            return mustPercent;
        }
        schedule.setText(percent + "%");
        return percent;
    }

    private void setDimensionHide() {
        DynamicObject initialScheme = this.getSchemeForForm();
        boolean useDimension = initialScheme.getBoolean(USEDIMENSION);
        if (useDimension) {
            this.getView().setVisible(Boolean.TRUE, new String[]{DIMENSION, ORG, OP_BATCHMARKCOMPLETED, OP_BATCHMARKUNCOMPLETED});
            DynamicObject dimensionType = initialScheme.getDynamicObject("dimensiontype");
            String typeNumber = dimensionType.getString(NUMBER);
            if (StringUtils.equals((CharSequence)typeNumber, (CharSequence)BOS_ORG)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{DIMENSION});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{ORG});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIMENSION, ORG, OP_BATCHMARKCOMPLETED, OP_BATCHMARKUNCOMPLETED});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newOrg;
        boolean success;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (StringUtils.equals((CharSequence)name, (CharSequence)ORG) && newValue instanceof DynamicObject && !(success = this.orgUpdateAction(String.valueOf((newOrg = (DynamicObject)newValue).getPkValue())))) {
            this.getModel().setValue(ORG, oldValue);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"card_white")) {
            this.getView().getPageCache().put(VIEW_STYLE, "card");
            this.setListOrCardHide();
            this.setSelectCount(0);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INITITEMENTRY_CARD);
            int[] select = IntStream.range(0, entryEntity.size()).toArray();
            CardEntry cardEntry = (CardEntry)this.getView().getControl(INITITEMENTRY_CARD);
            for (int rowIndex : select) {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"select_card"});
                cardEntry.setChildVisible(true, rowIndex, new String[]{"unselect_card"});
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"list_white")) {
            this.getView().getPageCache().put(VIEW_STYLE, "list");
            this.setListOrCardHide();
            this.setSelectCount(0);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"url_icon_card")) {
            int cardEntryFocusRow = this.getCardEntryFocusRow();
            String actualUrl = (String)this.getModel().getValue("actualurl", cardEntryFocusRow);
            if (StringUtils.isNotBlank((CharSequence)actualUrl)) {
                this.getView().openUrl(actualUrl);
            }
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)ALL_SELECT)) {
            EntryGrid entryGrid = this.getEntryGrid();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INIT_SUB_ITEMS_ENTRY);
            int[] select = IntStream.range(0, entryEntity.size()).toArray();
            entryGrid.selectRows(select, 0);
            this.setSelectCount(entryEntity.size());
            this.setSelectLabelVisible(Boolean.FALSE);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)UN_SELECT)) {
            EntryGrid entryGrid = this.getEntryGrid();
            entryGrid.selectRows(new int[0], 0);
            this.setSelectCount(0);
            if (entryGrid instanceof CardEntry) {
                this.setCardEntrySelectRows(new int[0]);
            }
            this.setSelectLabelVisible(Boolean.TRUE);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"select_card")) {
            int[] entrySelectRows = this.getEntrySelectRows();
            int focusRow = this.getEntryGrid().getEntryState().getFocusRow();
            List rowList = Arrays.stream(entrySelectRows).boxed().filter(y -> y != focusRow).collect(Collectors.toList());
            rowList = rowList.stream().filter(i -> i != focusRow).collect(Collectors.toList());
            int[] newSelectRows = rowList.stream().mapToInt(Integer::intValue).toArray();
            this.getEntryGrid().selectRows(newSelectRows, 0);
            this.setCardEntrySelectRows(newSelectRows);
        }
    }

    private void setSelectLabelVisible(Boolean isShow) {
        this.getView().setVisible(isShow, new String[]{ALL_SELECT});
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{UN_SELECT});
    }

    private EntryGrid getEntryGrid() {
        String style = this.getView().getPageCache().get(VIEW_STYLE);
        EntryGrid entryGrid = StringUtils.equals((CharSequence)style, (CharSequence)"list") ? (EntryGrid)this.getView().getControl(INIT_SUB_ITEMS_ENTRY) : (EntryGrid)this.getView().getControl(INITITEMENTRY_CARD);
        return entryGrid;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String key = source.getOperateKey();
        int[] entrySelectRows = this.getEntrySelectRows();
        switch (key) {
            case "markcomplete": 
            case "markuncomplete": 
            case "batchmarkcomplete": 
            case "batchmarkuncomplete": {
                boolean validate = this.validate(entrySelectRows);
                if (validate) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean validate(int[] entrySelectRows) {
        boolean isModify = this.schemeWhetherModify();
        if (isModify) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u6216\u65b9\u6848\u5206\u914d\u8bb0\u5f55\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u52a0\u8f7d\u3002", (String)"InitGuideFormPlugin_12", (String)"bos-ext-imsc", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("closePage", (IFormPlugin)this));
            return false;
        }
        Object initOrg = this.getModel().getValue(ORG);
        String defaultOrgId = this.getView().getPageCache().get(DEFAULT_ORG_ID);
        String tip = "";
        if (Objects.isNull(initOrg) && Objects.nonNull(defaultOrgId)) {
            tip = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u7ec4\u7ec7\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u8fdb\u884c\u6807\u8bb0\uff0c\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u7ec4\u7ec7\u3002", (String)"InitGuideFormPlugin_13", (String)"bos-ext-imsc", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            return false;
        }
        if (entrySelectRows.length == 0) {
            tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u4efb\u52a1\u6e05\u5355\u5217\u8868\u6570\u636e\u3002", (String)"InitGuideFormPlugin_2", (String)"bos-ext-imsc", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        DynamicObject scheme = this.getSchemeForForm();
        int[] entrySelectRows = this.getEntrySelectRows();
        boolean isOrg = scheme.getBoolean(USEDIMENSION);
        String dimensionId = isOrg ? this.getView().getPageCache().get(DEFAULT_ORG_ID) : scheme.getDynamicObject("bizapp").getPkValue().toString();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)MARK_COMPLETE) && args.getOperationResult().isSuccess()) {
            ArrayList<Object> params = new ArrayList<Object>(10);
            List<Long> itemEntryIdList = this.getSelectRowsItemIds(entrySelectRows, "A");
            params.add(scheme.getPkValue());
            params.add(itemEntryIdList);
            params.add(isOrg);
            params.add(dimensionId);
            params.add(UserServiceHelper.getCurrentUserId());
            params.add(new Date());
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"imic", (String)"markService", (String)"markComplete", (Object[])params.toArray());
            this.afterMark(result, true);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)MARK_UN_COMPLETE) && args.getOperationResult().isSuccess()) {
            List<Long> itemEntryIdList = this.getSelectRowsItemIds(entrySelectRows, "B");
            ArrayList<Object> params = new ArrayList<Object>(10);
            params.add(scheme.getPkValue());
            params.add(itemEntryIdList);
            params.add(dimensionId);
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"imic", (String)"markService", (String)"markUnComplete", (Object[])params.toArray());
            this.afterMark(result, false);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refresh")) {
            boolean isModify = this.schemeWhetherModify();
            if (isModify) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u6216\u65b9\u6848\u5206\u914d\u8bb0\u5f55\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u52a0\u8f7d\u3002", (String)"InitGuideFormPlugin_12", (String)"bos-ext-imsc", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("closePage", (IFormPlugin)this));
                return;
            }
            this.setWizardStepValue();
            String stepCurrentIndex = this.getView().getPageCache().get("stepCurrentIndex");
            this.setItemEntryValues(Integer.parseInt(stepCurrentIndex));
            this.setCurrentStepAndProgress();
            this.setSelectCount(0);
            this.hideConfigUrlAp();
            this.setProgressCaliber(scheme.getString("defaultcaliber"));
            this.setDimensionHide();
            this.setSelectLabelVisible(Boolean.TRUE);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"configurl")) {
            String url = (String)this.getModel().getValue("actualurl", this.getItemEntryFocusRow());
            this.getView().openUrl(url);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OP_BATCHMARKCOMPLETED) || StringUtils.equals((CharSequence)operateKey, (CharSequence)OP_BATCHMARKUNCOMPLETED)) {
            ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"imic_orgscheme", (boolean)true, (int)0, (boolean)true);
            String permItemId = StringUtils.equals((CharSequence)operateKey, (CharSequence)OP_BATCHMARKCOMPLETED) ? "3FWRQ6W3J9=V" : "3FWRS3L87R36";
            this.setOrgFormShowParameter(formShowParameter, permItemId, true);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private List<Long> getSelectRowsItemIds(int[] entrySelectRows, String complete) {
        ArrayList<Long> itemEntryIdList = new ArrayList<Long>(10);
        DynamicObjectCollection itemEntity = this.getModel().getEntryEntity(INIT_SUB_ITEMS_ENTRY);
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>(10);
        for (int entrySelectRow : entrySelectRows) {
            DynamicObject entryRow = (DynamicObject)itemEntity.get(entrySelectRow);
            String isComplete = entryRow.getString(COMPLETE_STATUS);
            if (StringUtils.equals((CharSequence)isComplete, (CharSequence)complete)) continue;
            rowIndexList.add(entrySelectRow);
        }
        Object object = rowIndexList.iterator();
        while (object.hasNext()) {
            int entrySelectRow = (Integer)object.next();
            Object itemEntryId = this.getModel().getValue("itementryid", entrySelectRow);
            itemEntryIdList.add((Long)itemEntryId);
        }
        return itemEntryIdList;
    }

    private void afterMark(JSONObject result, boolean isComplete) {
        boolean flag = result.getBoolean("flag");
        if (flag) {
            this.getView().invokeOperation("refresh");
            String tip = isComplete ? ResManager.loadKDString((String)"\u6807\u8bb0\u6210\u529f\u3002", (String)"InitGuideFormPlugin_11", (String)"bos-ext-imsc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bb0\u6210\u529f\u3002", (String)"InitGuideFormPlugin_14", (String)"bos-ext-imsc", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tip);
        } else {
            String tip = String.format(ResManager.loadKDString((String)"%s\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5", (String)"InitGuideFormPlugin_7", (String)"bos-ext-imsc", (Object[])new Object[0]), result.getString("errorMsg"));
            this.getView().showErrorNotification(tip);
        }
    }

    private void afterBatchMark(Map<Long, JSONObject> resultMap, boolean isComplete) {
        block2: {
            Iterator<Map.Entry<Long, JSONObject>> iterator = resultMap.entrySet().iterator();
            if (!iterator.hasNext()) break block2;
            Map.Entry<Long, JSONObject> mapEntry = iterator.next();
            boolean flag = mapEntry.getValue().getBoolean("flag");
            if (flag) {
                this.getView().invokeOperation("refresh");
                String tip = isComplete ? ResManager.loadKDString((String)"\u6279\u91cf\u6807\u8bb0\u6210\u529f\u3002", (String)"InitGuideFormPlugin_15", (String)"bos-ext-imsc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6d88\u6210\u529f\u3002", (String)"InitGuideFormPlugin_16", (String)"bos-ext-imsc", (Object[])new Object[0]);
                this.getView().showSuccessNotification(tip);
            } else {
                String tip = isComplete ? ResManager.loadKDString((String)"\u6279\u91cf\u6807\u8bb0\u5931\u8d25", (String)"InitGuideFormPlugin_17", (String)"bos-ext-imsc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6d88\u5931\u8d25", (String)"InitGuideFormPlugin_18", (String)"bos-ext-imsc", (Object[])new Object[0]);
                tip = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5", (String)"InitGuideFormPlugin_19", (String)"bos-ext-imsc", (Object[])new Object[0]), tip, mapEntry.getValue().getString("errorMsg"));
                this.getView().showErrorNotification(tip);
            }
        }
    }

    private void setCurrentStepAndProgress() {
        int schedule = this.setEntrySchedule();
        Wizard wizardAp = (Wizard)this.getControl(WIZARDAP);
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        String stepCurrentIndex = this.getPageCache().get("stepCurrentIndex");
        currentStepMap.put("currentStep", Integer.valueOf(stepCurrentIndex));
        Object preview = this.getView().getFormShowParameter().getCustomParam(PREVIEW);
        if (Objects.isNull(preview)) {
            if (schedule == 0) {
                currentStepMap.put(CURRENT_STATUS, "wait");
            } else if (schedule == 100) {
                currentStepMap.put(CURRENT_STATUS, "finish");
            } else {
                currentStepMap.put(CURRENT_STATUS, "process");
            }
        } else {
            currentStepMap.put(CURRENT_STATUS, "process");
        }
        wizardAp.setWizardCurrentStep(currentStepMap);
        this.setGuideProgress();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldKey = evt.getFieldName();
        int rowIndex = this.getItemEntryFocusRow();
        if ("inititemname".equals(fieldKey)) {
            this.openInitItemForm(rowIndex);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"inititems_card")) {
            this.openInitItemForm(this.getCardEntryFocusRow());
        }
    }

    private void openInitItemForm(int rowIndex) {
        DynamicObject initItems = (DynamicObject)this.getModel().getValue(INIT_ITEMS, rowIndex);
        if (initItems != null) {
            String orgId;
            String formNumber = initItems.getString(NUMBER);
            String pageParamStr = (String)this.getModel().getValue("pageparam", rowIndex);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            HashMap<String, String> customParams = new HashMap<String, String>(2);
            if (!StringUtils.isBlank((CharSequence)pageParamStr)) {
                String caption;
                Map pageParam = (Map)SerializationUtils.fromJsonString((String)pageParamStr, Map.class);
                String paramsentry = (String)pageParam.get("paramsentry");
                if (!StringUtils.isBlank((CharSequence)paramsentry)) {
                    Map formParams = (Map)SerializationUtils.fromJsonString((String)paramsentry, Map.class);
                    customParams.putAll(formParams);
                }
                if (StringUtils.isNotBlank((CharSequence)(caption = (String)pageParam.get("caption")))) {
                    customParams.put("caption", caption);
                }
                customParams.put("filtercondition", (String)pageParam.get("filtercondition"));
                map.put("parametertype", pageParam.get("parametertype"));
                map.put("opentype", pageParam.get("opentype"));
            }
            if (StringUtils.isNotBlank((CharSequence)(orgId = this.getView().getPageCache().get(DEFAULT_ORG_ID)))) {
                customParams.put("imicdimension_bos_org", orgId);
            }
            map.put("parameter", customParams);
            map.put("view", this.getView());
            map.put("formnumber", formNumber);
            OpenPageUtil.openConfigPage(this.getView().getFormShowParameter().getAppId(), map);
        }
    }

    private int getItemEntryFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(INIT_SUB_ITEMS_ENTRY);
        return entryGrid.getEntryState().getFocusRow();
    }

    private int getCardEntryFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(INITITEMENTRY_CARD);
        return entryGrid.getEntryState().getFocusRow();
    }

    private int[] getEntrySelectRows() {
        return this.getEntryGrid().getSelectRows();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)ORG)) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            this.setOrgFormShowParameter(formShowParameter, "47150e89000000ac", false);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "orgClose"));
        }
    }

    private List<Long> getHasOrgPermIds(HasPermOrgResult userHasPermOrgs) {
        List<Long> filterOrgs = new ArrayList<Long>(10);
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            filterOrgs.addAll(userHasPermOrgs.getHasPermOrgs());
        } else {
            List idList = QueryServiceHelper.queryPrimaryKeys((String)BOS_ORG, null, null, (int)-1);
            filterOrgs = idList.stream().map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
        }
        return filterOrgs;
    }

    private List<String> getViewTypeNumberList(DynamicObject scheme) {
        ArrayList<String> orgViewTypeNumberList = new ArrayList<String>(10);
        DynamicObjectCollection mulOrgViewType = scheme.getDynamicObjectCollection("mulorgviewtype");
        if (mulOrgViewType != null && !mulOrgViewType.isEmpty()) {
            mulOrgViewType.forEach(l -> orgViewTypeNumberList.add(l.getDynamicObject("fbasedataid").getString("fnumber")));
        } else {
            DynamicObject orgViewType = scheme.getDynamicObject("orgviewtype");
            if (orgViewType != null) {
                String orgViewTypeNumber = orgViewType.getString("fnumber");
                orgViewTypeNumberList.add(orgViewTypeNumber);
            }
        }
        return orgViewTypeNumberList;
    }

    private void setOrgFormShowParameter(ListShowParameter formShowParameter, String permItemId, boolean isBatch) {
        QFilter filter;
        DynamicObject bosOrgBiz;
        long curUserId = UserServiceHelper.getCurrentUserId();
        String appId = AppMetadataCache.getAppInfoByNumber((String)this.getPageCache().get(BIZ_APP_NUMBER)).getId();
        String formId = this.getView().getFormShowParameter().getFormId();
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)curUserId, (String)appId, (String)formId, (String)permItemId);
        DynamicObject initialScheme = this.getSchemeForForm();
        List<Long> filterOrgs = this.getHasOrgPermIds(userHasPermOrgs);
        formShowParameter.setCustomParam("islockfunc", (Object)true);
        formShowParameter.setCustomParam("defaultcaliber", (Object)DynamicObjectUtils.getString(initialScheme, "defaultcaliber"));
        formShowParameter.setCustomParam("initSchemeId", this.getView().getFormShowParameter().getCustomParam("initSchemeId"));
        formShowParameter.setCustomParam("isBatch", (Object)isBatch);
        boolean isAssign = DynamicObjectUtils.getBoolean(initialScheme, USEDIMENSION) && !DynamicObjectUtils.getBoolean(initialScheme, "isalluse");
        List<String> orgViewTypeNumberList = this.getViewTypeNumberList(initialScheme);
        List<Long> intersection = this.getOrgIdsByOrgViewNumbers(filterOrgs, orgViewTypeNumberList, isAssign);
        if (orgViewTypeNumberList.size() == 1 && (bosOrgBiz = BusinessDataServiceHelper.loadSingle((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])(filter = new QFilter("fnumber", "=", (Object)orgViewTypeNumberList.get(0))).toArray())) != null) {
            formShowParameter.setCustomParam("orgFuncId", (Object)bosOrgBiz.getString("fnumber"));
        }
        boolean usedimension = DynamicObjectUtils.getBoolean(initialScheme, USEDIMENSION);
        formShowParameter.setCustomParam(USEDIMENSION, (Object)usedimension);
        if (usedimension) {
            formShowParameter.setCustomParam(F7_ORGIDS, intersection);
        }
        formShowParameter.setBillFormId("imic_orgscheme");
        formShowParameter.addCustPlugin("kd.bos.ext.imsc.imic.OrgSchemeList");
        formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", intersection));
    }

    private List<Long> getOrgIdsByOrgViewNumbers(List<Long> filterOrgs, List<String> orgViewTypeNumberList, boolean isAssgin) {
        Set<Long> orgIdSet;
        if (orgViewTypeNumberList.isEmpty()) {
            return filterOrgs;
        }
        QFilter viewTypeFilter = new QFilter(NUMBER, "in", orgViewTypeNumberList);
        Map viewsObj = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])viewTypeFilter.toArray());
        QFilter viewFilter = new QFilter("structure.view", "in", viewsObj.keySet());
        if (isAssgin && !(orgIdSet = this.getAssignOrgSet()).isEmpty()) {
            viewFilter.and(new QFilter("id", "in", orgIdSet));
        }
        List orgIds = QueryServiceHelper.queryPrimaryKeys((String)BOS_ORG, (QFilter[])viewFilter.toArray(), null, (int)-1);
        List longsInB = orgIds.stream().filter(item -> item instanceof Long).map(Long.class::cast).collect(Collectors.toList());
        return filterOrgs.stream().filter(longsInB::contains).collect(Collectors.toList());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection rows;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"orgClose") && evt.getReturnData() != null) {
            String tip = ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u5c06\u91cd\u65b0\u52a0\u8f7d\u521d\u59cb\u5316\u9875\u9762\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u64cd\u4f5c\u3002", (String)"InitGuideFormPlugin_8", (String)"bos-ext-imsc", (Object[])new Object[0]);
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            this.getPageCache().put("orgSelect", primaryKeyValue.toString());
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("orgConfirm", (IFormPlugin)this));
        } else if (OP_BATCHMARKCOMPLETED.equals(actionId)) {
            ListSelectedRowCollection rows2 = (ListSelectedRowCollection)evt.getReturnData();
            if (rows2 != null && !rows2.isEmpty()) {
                ArrayList<Object> params = new ArrayList<Object>(10);
                int[] entrySelectRows = this.getEntrySelectRows();
                DynamicObject scheme = this.getSchemeForForm();
                ArrayList<Long> itemEntryIdList = new ArrayList<Long>(10);
                for (int entrySelectRow : entrySelectRows) {
                    Object itemEntryId = this.getModel().getValue("itementryid", entrySelectRow);
                    itemEntryIdList.add((Long)itemEntryId);
                }
                params.add(scheme.getPkValue());
                params.add(itemEntryIdList);
                boolean isOrg = scheme.getBoolean(USEDIMENSION);
                params.add(isOrg);
                List orgIdList = rows2.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                params.add(orgIdList);
                params.add(UserServiceHelper.getCurrentUserId());
                params.add(KDDateUtils.now());
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"imic", (String)"markService", (String)"batchMarkComplete", (Object[])params.toArray());
                this.afterBatchMark(resultMap, true);
            }
        } else if (OP_BATCHMARKUNCOMPLETED.equals(actionId) && (rows = (ListSelectedRowCollection)evt.getReturnData()) != null && !rows.isEmpty()) {
            int[] entrySelectRows = this.getEntrySelectRows();
            ArrayList<Long> itemEntryIdList = new ArrayList<Long>(10);
            for (int entrySelectRow : entrySelectRows) {
                Object itemEntryId = this.getModel().getValue("itementryid", entrySelectRow);
                itemEntryIdList.add((Long)itemEntryId);
            }
            ArrayList<Object> params = new ArrayList<Object>(10);
            DynamicObject scheme = this.getSchemeForForm();
            params.add(scheme.getPkValue());
            params.add(itemEntryIdList);
            List orgIdList = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            params.add(orgIdList);
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"imic", (String)"markService", (String)"batchMarkUnComplete", (Object[])params.toArray());
            this.afterBatchMark(resultMap, false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"orgConfirm") && e.getResult() == MessageBoxResult.Yes) {
            String orgSelect = this.getPageCache().get("orgSelect");
            this.orgUpdateAction(orgSelect);
        } else if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"closePage")) {
            this.getView().close();
        }
    }

    private boolean orgUpdateAction(String orgSelect) {
        String bizAppNumber = this.getPageCache().get(BIZ_APP_NUMBER);
        DynamicObject schemeByOrg = this.getSchemeByOrg(bizAppNumber, Long.parseLong(orgSelect));
        if (schemeByOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u672a\u627e\u5230\u521d\u59cb\u5316\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u5b9e\u65bd\u670d\u52a1\u4e91-\u521d\u59cb\u5316\u7ba1\u7406\u4e2d\u5fc3\u4e2d\u8fdb\u884c\u521d\u59cb\u5316\u65b9\u6848\u8bbe\u7f6e\u3002", (String)"InitGuideFormPlugin_9", (String)"bos-ext-imsc", (Object[])new Object[0]));
            return false;
        }
        this.getModel().setValue(INITIAL_SCHEME, (Object)schemeByOrg);
        this.getModel().setValue(ORG, (Object)Long.parseLong(orgSelect));
        this.getView().getPageCache().put(DEFAULT_ORG_ID, orgSelect);
        this.getView().getPageCache().put("schemeFirstModifyTime", String.valueOf(schemeByOrg.getDate("modifytime").getTime()));
        this.getView().getPageCache().put("assignOrgSet", JSON.toJSONString(this.getAssignOrgSet()));
        this.getView().getPageCache().remove("stepCurrentIndex");
        this.setWizardStepValue();
        this.setListOrCardHide();
        String stepCurrentIndex = this.getView().getPageCache().get("stepCurrentIndex");
        this.setItemEntryValues(Integer.parseInt(stepCurrentIndex));
        this.setCurrentStepAndProgress();
        this.getView().updateView();
        return true;
    }

    private DynamicObject getSchemeByOrg(String appNumber, long orgId) {
        QFilter orgFilter;
        QFilter enableFilter;
        DynamicObject currentScheme = this.getSchemeForForm();
        boolean usedimension = currentScheme.getBoolean(USEDIMENSION);
        boolean isShare = currentScheme.getBoolean("isalluse");
        if (!usedimension || isShare) {
            return currentScheme;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNumber);
        QFilter appFilter = new QFilter("initialscheme.bizapp", "=", (Object)appInfo.getId());
        DynamicObject orgAllot = QueryServiceHelper.queryOne((String)IMIC_ASSIGNRECORD, (String)INITIAL_SCHEME, (QFilter[])new QFilter[]{appFilter, enableFilter = new QFilter("initialscheme.enable", "=", (Object)Boolean.TRUE), orgFilter = new QFilter(ORG, "=", (Object)orgId)});
        if (orgAllot != null) {
            Long schemeId = orgAllot.getLong(INITIAL_SCHEME);
            return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)IMIC_INITIAL_SCHEME);
        }
        return null;
    }

    public void update(StepEvent e) {
        int stepIndex = e.getValue();
        boolean isModify = this.schemeWhetherModify();
        if (isModify) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u6216\u65b9\u6848\u5206\u914d\u8bb0\u5f55\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u52a0\u8f7d\u3002", (String)"InitGuideFormPlugin_12", (String)"bos-ext-imsc", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("closePage", (IFormPlugin)this));
            return;
        }
        this.setItemEntryValues(stepIndex);
        Wizard wizardAp = (Wizard)this.getControl(WIZARDAP);
        this.getView().getPageCache().put("stepCurrentIndex", String.valueOf(stepIndex));
        HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
        int schedule = this.setEntrySchedule();
        currentStepMap.put("currentStep", stepIndex);
        if (schedule == 0) {
            currentStepMap.put(CURRENT_STATUS, "wait");
        } else if (schedule == 100) {
            currentStepMap.put(CURRENT_STATUS, "finish");
        } else {
            currentStepMap.put(CURRENT_STATUS, "process");
        }
        wizardAp.setWizardCurrentStep(currentStepMap);
        this.getView().updateView();
    }

    private boolean schemeWhetherModify() {
        DynamicObject schemeForForm;
        long modifyTime;
        String schemeFirstModifyTime = this.getView().getPageCache().get("schemeFirstModifyTime");
        long schemeFirstModifyTineLong = Long.parseLong(schemeFirstModifyTime);
        if (schemeFirstModifyTineLong == (modifyTime = (schemeForForm = this.getSchemeForForm()).getDate("modifytime").getTime())) {
            String assignOrgSetStr = this.getView().getPageCache().get("assignOrgSet");
            Set assignOrgSetFromCache = (Set)JSON.parseObject((String)assignOrgSetStr, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            Set<Long> assignOrgSetFromScheme = this.getAssignOrgSet();
            return assignOrgSetFromCache.size() != assignOrgSetFromScheme.size() || !assignOrgSetFromCache.containsAll(assignOrgSetFromScheme);
        }
        return true;
    }

    private Set<Long> getAssignOrgSet() {
        DynamicObject scheme = this.getSchemeForForm();
        long schemeId = DynamicObjectUtils.getPkValue(scheme);
        QFilter allotSchemeFilter = new QFilter(INITIAL_SCHEME, "=", (Object)schemeId);
        DynamicObjectCollection loginOrgAllotColl = QueryServiceHelper.query((String)IMIC_ASSIGNRECORD, (String)ORG, (QFilter[])allotSchemeFilter.toArray());
        return loginOrgAllotColl.stream().map(o -> o.getLong(ORG)).collect(Collectors.toSet());
    }

    public void pageRelease(EventObject e) {
        Object isPreView;
        super.pageRelease(e);
        IPageCache pageCache = this.getView().getPageCache();
        String appNumber = pageCache.get(BIZ_APP_NUMBER);
        long curUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject initGuideRecord = this.getInitGuideRecord(appNumber, curUserId);
        if (initGuideRecord == null) {
            initGuideRecord = BusinessDataServiceHelper.newDynamicObject((String)"imic_initguide_record");
        }
        initGuideRecord.set("user", (Object)UserServiceHelper.getCurrentUserId());
        initGuideRecord.set("bizappnumber", (Object)appNumber);
        initGuideRecord.set("style", (Object)pageCache.get(VIEW_STYLE));
        if (Objects.nonNull(pageCache.get(DEFAULT_ORG_ID))) {
            initGuideRecord.set(ORG, (Object)Long.parseLong(pageCache.get(DEFAULT_ORG_ID)));
        }
        if (Objects.isNull(isPreView = this.getView().getFormShowParameter().getCustomParam(PREVIEW))) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"imic_initguide_record");
            SaveServiceHelper.save((IDataEntityType)type, (Object[])new Object[]{initGuideRecord});
        }
    }
}

