/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.ricc.form.listext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.imsc.ricc.form.formext.ListenToSavePlugin;
import kd.bos.ext.imsc.ricc.form.listext.DynamicListPlugin;
import kd.bos.ext.imsc.ricc.util.FormOpenUtil;
import kd.bos.ext.imsc.ricc.util.SelectedIdsAdapter;
import kd.bos.ext.imsc.ricc.util.SysParamHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class DynamicButtonListPlugin
extends DynamicListPlugin {
    private static final String ADDPACKET_TO_IMPORTPARAM = "addPacketToImportParam";
    private static final String FASTTRANSFER_TO_IMPORTPARAM = "fastTransferToImportParam";
    private static final String OPENBILLMAP = "openBillMap";
    private static final String TOOLBARAP = "toolbarap";
    private static final String FASTTRANSFER_KEY = "fasttransfer";
    private static final String ADDPACKET_KEY = "addpacket";
    private static final String NEW_BOTP_KEY = "new_botp";
    private static final Map<String, String> EXCEPTION_FORM_MAP = new HashMap<String, String>();
    private static final String CODE_RULE_CONFIRM = "coderuleConfirm";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{ADDPACKET_KEY, NEW_BOTP_KEY, FASTTRANSFER_KEY, TOOLBARAP});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if (ADDPACKET_KEY.equals(key) || FASTTRANSFER_KEY.equals(key)) {
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("riccFormId");
            ListSelectedRowCollection selectedRows = SelectedIdsAdapter.getSelectedRows(formId, this.getView());
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4f20\u8f93\u7684\u6570\u636e\uff01", (String)"DynamicButtonListPlugin_0", (String)"bos-ext-imsc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String importType = (String)this.getView().getFormShowParameter().getCustomParam("importType");
            if ("excel".equals(importType) && !SysParamHelper.isOpenImportTemplateId()) {
                this.getView().showErrorNotification(SysParamHelper.getImportTemplateTips());
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        if (ADDPACKET_KEY.equalsIgnoreCase(itemKey) || FASTTRANSFER_KEY.equals(itemKey)) {
            boolean isOverPackLimit;
            String custParamPage = (String)view.getFormShowParameter().getCustomParam("custParamPage");
            if (custParamPage != null && !"".equals(custParamPage)) {
                this.openImportParamsForm(custParamPage, itemKey);
                return;
            }
            String formId = (String)view.getFormShowParameter().getCustomParam("riccFormId");
            ListSelectedRowCollection dataRows = SelectedIdsAdapter.getSelectedRows(formId, view);
            int packDataLimit = SysParamHelper.getPackDataLimit();
            boolean bl = isOverPackLimit = dataRows.size() > packDataLimit;
            if (isOverPackLimit) {
                String msgTpl = ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u5931\u8d25\uff0c\u4e3a\u4fdd\u969c\u7cfb\u7edf\u7a33\u5b9a\u6027\uff0c\u5355\u6b21\u6dfb\u52a0\u4f20\u8f93\u6570\u636e\u6570\u91cf\u4e0d\u5f97\u8d85\u8fc7%d\u6761\uff0c\u8bf7\u5206\u6279\u6dfb\u52a0\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u4e2d\u8c03\u6574\u9650\u5236", (String)"DynamicButtonListPlugin_1", (String)"bos-ext-imsc", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(msgTpl, packDataLimit));
                return;
            }
            String dataListPageId = view.getPageId();
            String pluginName = this.getPluginName();
            if (formId.equals("bos_coderule")) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(CODE_RULE_CONFIRM, (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e3a\u7cfb\u7edf\u91cd\u8981\u914d\u7f6e\uff0c\u4f20\u8f93\u65f6\u5c06\u4f7f\u7528\u7f16\u7801\u89c4\u5219\u5185\u7801\u8fdb\u884c\u5339\u914d\uff0c\u5efa\u8bae\u4ec5\u4f20\u8f93\u9700\u8981\u7684\u89c4\u5219\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u662f\u5426\u4f20\u8f93\uff1f", (String)"DynamicButtonListPlugin_10", (String)"bos-ext-imsc", (Object[])new Object[0]);
                this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, null, listener, null, itemKey);
                return;
            }
            if (ADDPACKET_KEY.equalsIgnoreCase(itemKey)) {
                FormOpenUtil.openAddPacketForm(dataRows, dataListPageId, null, view, pluginName);
            } else if (FASTTRANSFER_KEY.equals(itemKey)) {
                FormOpenUtil.openAddTransferForm(dataRows, dataListPageId, null, view, pluginName);
            }
        } else if (NEW_BOTP_KEY.equalsIgnoreCase(itemKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("botp_newconvertpath");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW_BOTP_KEY));
            this.getView().showForm(formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        if (callBackId.equals(CODE_RULE_CONFIRM)) {
            String itemKey = messageBoxClosedEvent.getCustomVaule();
            IFormView view = this.getView();
            String formId = (String)view.getFormShowParameter().getCustomParam("riccFormId");
            ListSelectedRowCollection dataRows = SelectedIdsAdapter.getSelectedRows(formId, this.getView());
            String pluginName = this.getPluginName();
            String dataListPageId = view.getPageId();
            if (ADDPACKET_KEY.equalsIgnoreCase(itemKey)) {
                FormOpenUtil.openAddPacketForm(dataRows, dataListPageId, null, view, pluginName);
            } else if (FASTTRANSFER_KEY.equals(itemKey)) {
                FormOpenUtil.openAddTransferForm(dataRows, dataListPageId, null, view, pluginName);
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter billShowParam = e.getParameter();
        if (this.canAddPacket() && this.supportAddToPacket()) {
            billShowParam.addCustPlugin(ListenToSavePlugin.class.getName());
        }
        ListSelectedRow selectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        Object selectId = ((IListView)this.getView()).getFocusRowPkId();
        billShowParam.setCustomParam("riccSelectedId", selectId);
        if (selectedRow != null) {
            billShowParam.setCustomParam("riccSelectedNumber", (Object)selectedRow.getNumber());
            billShowParam.setCustomParam("riccSelectedName", (Object)selectedRow.getName());
        }
        billShowParam.setCustomParam("createOrg", (Object)this.getPageCache().get("org"));
        billShowParam.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        super.beforeShowBill(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("ignoreHyperLink", "true");
        Container toolbar = (Container)this.getView().getControl(TOOLBARAP);
        if (!Objects.isNull(toolbar)) {
            ArrayList<Map> items = new ArrayList<Map>();
            String hiddenButton = (String)this.getView().getFormShowParameter().getCustomParam("hiddenbutton");
            if (StringUtils.isNotBlank((CharSequence)hiddenButton)) {
                String[] buttons;
                for (String button : buttons = hiddenButton.split(",")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{button});
                }
            }
            if ("botp_crlist".equals(this.getView().getFormShowParameter().getCustomParam("riccFormId"))) {
                BarItemAp newBotp = new BarItemAp();
                newBotp.setId(NEW_BOTP_KEY);
                newBotp.setKey(NEW_BOTP_KEY);
                newBotp.setName(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e", (String)"DynamicButtonListPlugin_3", (String)"bos-ext-imsc", (Object[])new Object[0])));
                Map controlNew = newBotp.createControl();
                items.add(controlNew);
            }
            BarItemAp addDataPacket = new BarItemAp();
            addDataPacket.setId(ADDPACKET_KEY);
            addDataPacket.setKey(ADDPACKET_KEY);
            addDataPacket.setOperationStyle(Integer.valueOf(1));
            addDataPacket.setName(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305", (String)"DynamicButtonListPlugin_4", (String)"bos-ext-imsc", (Object[])new Object[0])));
            BarItemAp fastTransfer = new BarItemAp();
            fastTransfer.setId(FASTTRANSFER_KEY);
            fastTransfer.setKey(FASTTRANSFER_KEY);
            fastTransfer.setOperationStyle(Integer.valueOf(1));
            fastTransfer.setName(new LocaleString(ResManager.loadKDString((String)"\u5feb\u901f\u4f20\u8f93", (String)"DynamicButtonListPlugin_5", (String)"bos-ext-imsc", (Object[])new Object[0])));
            boolean canAddPacket = this.canAddPacket();
            boolean supportAddToPacket = this.supportAddToPacket();
            SysParamHelper.setBtnLockTips(addDataPacket, canAddPacket, supportAddToPacket);
            SysParamHelper.setBtnLockTips(fastTransfer, canAddPacket, supportAddToPacket);
            Map addPacketControl = addDataPacket.createControl();
            Map fastTransferControl = fastTransfer.createControl();
            items.add(addPacketControl);
            items.add(fastTransferControl);
            toolbar.addControls(items);
            this.getView().setEnable(Boolean.valueOf(canAddPacket && supportAddToPacket), new String[]{ADDPACKET_KEY, FASTTRANSFER_KEY});
        }
    }

    private boolean canAddPacket() {
        Object canAddPacket = this.getView().getFormShowParameter().getCustomParam("canAddPacket");
        if (canAddPacket != null) {
            return (Boolean)canAddPacket;
        }
        return false;
    }

    private boolean supportAddToPacket() {
        Object supportAddToPacket = this.getView().getFormShowParameter().getCustomParam("supportAddToPacket");
        if (supportAddToPacket != null) {
            return (Boolean)supportAddToPacket;
        }
        return false;
    }

    private void openImportParamsForm(String custParamPage, String itemKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(custParamPage);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        if ("ricc_vchimportparam".equals(custParamPage)) {
            formShowParameter.setAppId("ricc");
            try {
                Class clazz = TypesContainer.getOrRegister((String)"kd.fi.ai.formplugin.ImportVchTemplatePlugin");
                Method method = clazz.getMethod("beforeF7Select", BeforeF7SelectEvent.class);
                FieldEdit fieldEdit = new FieldEdit();
                fieldEdit.setKey("org");
                BeforeF7SelectEvent beforeF7SelectEvent = new BeforeF7SelectEvent(fieldEdit, 0, null);
                beforeF7SelectEvent.setFormShowParameter((FormShowParameter)new ListShowParameter());
                method.invoke(clazz.newInstance(), beforeF7SelectEvent);
                beforeF7SelectEvent.getCustomQFilters();
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                List qfilterList = filterParam.getQFilters();
                formShowParameter.setCustomParam("vch_filter", (Object)((QFilter)qfilterList.get(0)).toSerializedString());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.log.error("PacketImportParamsFormPlugin.beforeF7Select error: " + e);
                formShowParameter.setCustomParam("vch_filter", (Object)"");
            }
        }
        CloseCallBack callBack = null;
        if (ADDPACKET_KEY.equalsIgnoreCase(itemKey)) {
            callBack = new CloseCallBack((IFormPlugin)this, ADDPACKET_TO_IMPORTPARAM);
        } else if (FASTTRANSFER_KEY.equals(itemKey)) {
            callBack = new CloseCallBack((IFormPlugin)this, FASTTRANSFER_TO_IMPORTPARAM);
        }
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (NEW_BOTP_KEY.equalsIgnoreCase(actionId)) {
            this.afterShowNewBotpForm(closedCallBackEvent);
        } else if ("addPacketClose".equalsIgnoreCase(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if ("success".equals(returnData)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f\u3002", (String)"DynamicButtonListPlugin_8", (String)"bos-ext-imsc", (Object[])new Object[0]));
            }
        } else if (ADDPACKET_TO_IMPORTPARAM.equals(actionId) || FASTTRANSFER_TO_IMPORTPARAM.equals(actionId)) {
            Map custParam = (Map)closedCallBackEvent.getReturnData();
            if (custParam == null) {
                this.log.error("\u5bfc\u5165\u53c2\u6570\u52a8\u6001\u8868\u5355\u56de\u8c03\u53c2\u6570\u4e3a\u7a7a");
                return;
            }
            IFormView view = this.getView();
            String formId = (String)view.getFormShowParameter().getCustomParam("riccFormId");
            ListSelectedRowCollection dataRows = SelectedIdsAdapter.getSelectedRows(formId, view);
            String dataListPageId = view.getPageId();
            String pluginName = this.getPluginName();
            if (ADDPACKET_TO_IMPORTPARAM.equalsIgnoreCase(actionId)) {
                FormOpenUtil.openAddPacketForm(dataRows, dataListPageId, custParam, view, pluginName);
            } else {
                FormOpenUtil.openAddTransferForm(dataRows, dataListPageId, custParam, view, pluginName);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("riccFormId");
        if ("new".equals(operateKey) && "botp_writebackrule".equals(formId)) {
            args.setCancel(true);
            formId = EXCEPTION_FORM_MAP.get(formId);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            this.openForm(formId, "", formShowParameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("riccFormId");
        String openFormId = EXCEPTION_FORM_MAP.get(formId);
        if (openFormId != null) {
            args.setCancel(true);
            Object ruleId = ((IListView)this.getView()).getFocusRowPkId();
            if ("wf_processconfig_scheme".equalsIgnoreCase(openFormId) || "bpm_processmanage".equalsIgnoreCase(openFormId)) {
                this.openDynamicSchemeConfig(Long.valueOf(ruleId.toString()), openFormId);
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setCustomParam("ruleid", ruleId);
                this.openForm(openFormId, ruleId, showParameter);
            }
        }
        if (formId.equals("bos_billtype")) {
            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
    }

    private void afterShowNewBotpForm(ClosedCallBackEvent closedCallBackEvent) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params != null) {
            boolean isTargetBillNotEmpty;
            String sourceBill = (String)params.get("SourceBill");
            String targetBill = (String)params.get("TargetBill");
            boolean isSourceBillNotEmpty = sourceBill != null && sourceBill.trim().length() > 0;
            boolean bl = isTargetBillNotEmpty = targetBill != null && targetBill.trim().length() > 0;
            if (isSourceBillNotEmpty && isTargetBillNotEmpty) {
                FormShowParameter showParameter = this.openConvertRuleForm("", sourceBill, targetBill);
                this.openForm("botp_convertrule", "", showParameter);
            }
        }
    }

    private void openDynamicSchemeConfig(Long id, String formid) {
        String idStr = String.valueOf(id);
        try {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setShowTitle(false);
            showParameter.setCustomParam("procDefId", (Object)id);
            showParameter.setClientParam("procDefId", (Object)idStr);
            ProcessDefinitionEntity model = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(id, "wf_processdefinition", "type");
            if (ModelType.BizFlow.name().equals(model.getType())) {
                showParameter.setCustomParam("model_type", (Object)"BizFlowModel");
            } else {
                showParameter.setCustomParam("model_type", (Object)"WorkflowModel");
            }
            ListSelectedRow selectedRow = ((IListView)this.getView()).getCurrentSelectedRowInfo();
            showParameter.setCustomParam("riccSelectedNumber", (Object)selectedRow.getNumber());
            showParameter.setCustomParam("riccSelectedName", (Object)selectedRow.getName());
            this.openForm(formid, id, showParameter);
        }
        catch (Exception e) {
            this.log.error("\u6253\u5f00\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            String msgTpl = ResManager.loadKDString((String)"\u6253\u5f00\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u914d\u7f6e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DynamicButtonListPlugin_9", (String)"bos-ext-imsc", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(msgTpl, e.getMessage()));
        }
    }

    private RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }

    private FormShowParameter openConvertRuleForm(Object ruleId, String sourceBill, String targetBill) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("SourceBill", (Object)sourceBill);
        showParameter.setCustomParam("TargetBill", (Object)targetBill);
        showParameter.setCustomParam("ruleId", ruleId);
        showParameter.getCustomParams().put("checkRightAppId", "bpm");
        return showParameter;
    }

    private void openForm(String formId, Object selectId, FormShowParameter formShowParameter) {
        String openBillMapStr = this.getPageCache().get(OPENBILLMAP);
        Map<String, String> openBillMap = openBillMapStr != null ? (Map)SerializationUtils.fromJsonString((String)openBillMapStr, Map.class) : new HashMap();
        String idStr = ("".equals(selectId.toString()) ? "NEW_" : selectId.toString()) + formId;
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)openBillMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getViewNoPlugin(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        formShowParameter.setFormId(formId);
        formShowParameter.addCustPlugin(ListenToSavePlugin.class.getName());
        formShowParameter.getOpenStyle().setShowType(this.getView().getFormShowParameter().getFormConfig().getShowType());
        if (ShowType.Modal == this.getView().getFormShowParameter().getFormConfig().getShowType()) {
            formShowParameter.setParentPageId(this.getView().getPageId());
        }
        formShowParameter.setCustomParam("guideName", this.getView().getFormShowParameter().getCustomParam("guideName"));
        formShowParameter.setCustomParam("guideId", this.getView().getFormShowParameter().getCustomParam("guideId"));
        formShowParameter.setCustomParam("riccFormId", this.getView().getFormShowParameter().getCustomParam("riccFormId"));
        formShowParameter.setCustomParam("riccSelectedId", selectId);
        formShowParameter.setCustomParam("packettype", (Object)"1");
        formShowParameter.setCustomParam("createOrg", (Object)this.getPageCache().get("org"));
        this.getView().showForm(formShowParameter);
        pageId = formShowParameter.getPageId();
        openBillMap.put(idStr, pageId);
        this.getPageCache().put(OPENBILLMAP, SerializationUtils.toJsonString(openBillMap));
    }

    static {
        EXCEPTION_FORM_MAP.put("botp_writebackrule", "botp_writebackruleedit");
        EXCEPTION_FORM_MAP.put("wf_processdefinition", "wf_processconfig_scheme");
        EXCEPTION_FORM_MAP.put("bpm_processmanage", "wf_processconfig_scheme");
        EXCEPTION_FORM_MAP.put("perm_operationruleassign", "perm_operationrule_edit");
    }
}

