/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperateProgress;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceDataLoadHandler;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceDispatcher;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceTrigger;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceBean;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceDataLoadHandlerBuilder;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceExecutePeriod;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceTrigger;

public class MmcServiceDispatcher
implements IMmcServiceDispatcher {
    private Map<String, Object> operateMeta;
    private MainEntityType billEntityType;
    private OperateProgress operateProgress;
    private OperateOption option;
    private String nowApp;
    private List<MmcServiceBean> beans;
    private List<IMmcServiceTrigger> triggers;

    public MmcServiceDispatcher(Map<String, Object> operateMeta, MainEntityType billEntityType, OperateProgress operateProgress, OperateOption option) {
        this.operateMeta = operateMeta;
        this.billEntityType = billEntityType;
        this.operateProgress = operateProgress;
        this.option = option;
        this.loadNowApp();
    }

    private String loadNowApp() {
        if (this.nowApp == null) {
            IMmcServiceDataLoadHandler handler = MmcServiceDataLoadHandlerBuilder.getInstance();
            String billid = this.billEntityType.getName();
            this.nowApp = handler.loadAppid(billid);
        }
        return this.nowApp;
    }

    private List<MmcServiceBean> workerDatas() {
        if (this.beans == null) {
            IMmcServiceDataLoadHandler handler = MmcServiceDataLoadHandlerBuilder.getInstance();
            String opnum = (String)this.operateMeta.get("key");
            String billid = this.billEntityType.getName();
            this.beans = handler.loadWorkerBean(billid, opnum);
        }
        return this.beans;
    }

    private List<IMmcServiceTrigger> triggers() {
        if (this.triggers == null) {
            List<MmcServiceBean> datas = this.workerDatas();
            this.triggers = new ArrayList<IMmcServiceTrigger>();
            for (MmcServiceBean bean : datas) {
                MmcServiceTrigger trigger = new MmcServiceTrigger(this.loadNowApp(), bean, this.option, this.operateProgress, this.operateMeta, this.billEntityType);
                this.triggers.add(trigger);
            }
        }
        return this.triggers;
    }

    private void normRun(MmcServiceExecutePeriod period, Object args) {
        List<IMmcServiceTrigger> tgs = this.triggers();
        for (IMmcServiceTrigger trigger : tgs) {
            trigger.trigger(period, args);
        }
    }

    @Override
    public void initOpResult(OperationResult result) {
        List<IMmcServiceTrigger> tgs = this.triggers();
        for (IMmcServiceTrigger trigger : tgs) {
            trigger.initOpResult(result);
        }
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        this.normRun(MmcServiceExecutePeriod.ONPREPARE, e);
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        this.normRun(MmcServiceExecutePeriod.ONADDVALIDATORS, e);
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.normRun(MmcServiceExecutePeriod.BEFOREEXECUTE, e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.normRun(MmcServiceExecutePeriod.BEGINOPERATION, e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.normRun(MmcServiceExecutePeriod.ENDOPERATION, e);
    }

    @Override
    public void rollbackOperation(RollbackOperationArgs e) {
        this.normRun(MmcServiceExecutePeriod.ROLLBACK, e);
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.normRun(MmcServiceExecutePeriod.AFTEREXECUTE, e);
    }
}

