/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DataConfigValidator
extends AbstractValidator {
    private static final String ENTITY = "msplan_dataconfig";
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;

    public void validate() {
        Map<String, String> fields = this.getFields();
        if (fields == null) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        for (Map.Entry<String, String> field : fields.entrySet()) {
            String key = field.getKey();
            String value = field.getValue();
            String[] keyArr = key.split("\\.");
            String[] valueArr = value.split("\\.");
            block6: for (ExtendedDataEntity data : dataEntities) {
                DynamicObject obj = data.getDataEntity();
                switch (keyArr.length) {
                    case 1: {
                        this.showMessage1(key, value, data, obj);
                        continue block6;
                    }
                    case 2: {
                        this.showMessage2(keyArr, valueArr, data, obj);
                        continue block6;
                    }
                    case 3: {
                        this.showMessage3(keyArr, valueArr, data, obj);
                        continue block6;
                    }
                }
            }
        }
    }

    private void showMessage3(String[] keyArr, String[] valueArr, ExtendedDataEntity data, DynamicObject obj) {
        DynamicObjectCollection col = obj.getDynamicObjectCollection(keyArr[0]);
        col.forEach(entry -> {
            DynamicObjectCollection subCol = entry.getDynamicObjectCollection(keyArr[1]);
            subCol.forEach(subEntry -> {
                if (StringUtils.isBlank((Object)subEntry.get(keyArr[2]))) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c,\u201c%4$s\u201d\u7b2c%5$s\u884c\u3002", (String)"DataConfigValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]), valueArr[2], valueArr[0], entry.get("seq"), valueArr[1], subEntry.get("seq")));
                }
            });
        });
    }

    private void showMessage2(String[] keyArr, String[] valueArr, ExtendedDataEntity data, DynamicObject obj) {
        DynamicObjectCollection col = obj.getDynamicObjectCollection(keyArr[0]);
        col.forEach(entry -> {
            if (StringUtils.isBlank((Object)entry.get(keyArr[1]))) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c%3$s\u201d\u3002", (String)"DataConfigValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]), valueArr[0], entry.get("seq"), valueArr[1]));
            }
        });
    }

    private void showMessage1(String key, String value, ExtendedDataEntity data, DynamicObject obj) {
        if (StringUtils.isBlank((Object)obj.get(key))) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u3002", (String)"DataConfigValidator_0", (String)"bos-ext-mmc", (Object[])new Object[0]), value));
        }
    }

    private Map<String, String> getFields() {
        QFilter qfDatabase;
        QFilter qfMustInput;
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)"1");
        String layoutSolution = this.getLayoutSolution();
        QFilter qfLayoutSolution = new QFilter("layoutsolution", "=", (Object)layoutSolution);
        QFilter[] qfArr = new QFilter[]{qfStatus, qfEnable, qfLayoutSolution, qfMustInput = new QFilter("entryentity.mustinput", "=", (Object)"1"), qfDatabase = new QFilter("entryentity.isdatabase", "=", (Object)"1")};
        DynamicObject[] dyArr = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,classpath,appid,servicename,methodname,entryentity.fieldkey,entryentity.allfieldkey,entryentity.fieldname,entryentity.mustinput,entryentity.isdatabase", (QFilter[])qfArr, (String)"modifytime asc");
        if (dyArr.length == 0) {
            return null;
        }
        DynamicObject obj = null;
        for (DynamicObject dy : dyArr) {
            boolean flag;
            if (!dy.getString("classpath").isEmpty() && !(flag = ((Boolean)DispatchServiceHelper.invokeService((String)dy.getString("classpath"), (String)dy.getString("appid"), (String)dy.getString("servicename"), (String)dy.getString("methodname"), (Object[])new Object[0])).booleanValue())) continue;
            obj = dy;
        }
        DynamicObjectCollection query = obj.getDynamicObjectCollection("entryentity");
        HashMap<String, String> map = new HashMap<String, String>(query.size());
        for (DynamicObject o : query) {
            if (!o.getBoolean("mustinput") || !o.getBoolean("isdatabase") || StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)o.getString("allfieldkey")))) continue;
            map.put(o.getString("allfieldkey"), o.getString("fieldname"));
        }
        return map;
    }

    private String getLayoutSolution() {
        return this.getOption().containsVariable("layoutsolution") ? this.getOption().getVariableValue("layoutsolution") : "";
    }
}

