/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;

public class GetDefaultProcessroute
extends AbstractFuncParamPlugIn {
    private static final String Key_Org = "org";
    private static final String Key_Material = "material";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{Key_Org});
        this.addClickListeners(new String[]{Key_Material});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)Key_Org)) {
            this.showSelectFieldForm(Key_Org, true, false);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)Key_Material)) {
            this.showSelectFieldForm(Key_Material, false, true);
        }
    }

    private void showSelectFieldForm(String sourceCtrlKey, boolean onlyShowOrg, boolean nolyShowMaterial) {
        String formId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        if (onlyShowOrg) {
            formId = fieldNodes.getId();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            this.removeNotOrgNode(fieldNodes, dataEntityType);
        } else if (nolyShowMaterial) {
            formId = fieldNodes.getId();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            this.removeNotMaterialNode(fieldNodes, dataEntityType);
        }
        String nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void removeNotOrgNode(TreeNode treeNode, MainEntityType dataEntityType) {
        List children = treeNode.getChildren();
        String nodeId = treeNode.getId();
        if (children != null && !children.isEmpty()) {
            DynamicProperty property = this.getProperty(nodeId, dataEntityType);
            if (property instanceof OrgProp) {
                treeNode.setChildren(null);
            } else {
                for (TreeNode child : children) {
                    this.removeNotOrgNode(child, dataEntityType);
                }
                ListIterator listIterator = children.listIterator();
                while (listIterator.hasNext()) {
                    Object data = ((TreeNode)listIterator.next()).getData();
                    if (!"toremove".equals(data)) continue;
                    listIterator.remove();
                }
                if (children.isEmpty()) {
                    this.removeNotOrgNode(treeNode, dataEntityType);
                }
            }
        } else {
            String[] split = nodeId.split("[.]");
            DynamicProperty property = this.getProperty(split[0], dataEntityType);
            if (!(property instanceof OrgProp)) {
                treeNode.setData((Object)"toremove");
            }
        }
    }

    private void removeNotMaterialNode(TreeNode treeNode, MainEntityType dataEntityType) {
        List children = treeNode.getChildren();
        String nodeId = treeNode.getId();
        if (children != null && !children.isEmpty()) {
            DynamicProperty property = this.getProperty(nodeId, dataEntityType);
            if (property instanceof MaterielProp) {
                treeNode.setChildren(null);
            } else {
                for (TreeNode child : children) {
                    this.removeNotMaterialNode(child, dataEntityType);
                }
                ListIterator listIterator = children.listIterator();
                while (listIterator.hasNext()) {
                    Object data = ((TreeNode)listIterator.next()).getData();
                    if (!"toremove".equals(data)) continue;
                    listIterator.remove();
                }
                if (children.isEmpty()) {
                    this.removeNotMaterialNode(treeNode, dataEntityType);
                }
            }
        } else {
            String[] split = nodeId.split("[.]");
            DynamicProperty property = this.getProperty(split[0], dataEntityType);
            if (!(property instanceof MaterielProp)) {
                treeNode.setData((Object)"toremove");
            }
        }
    }

    private DynamicProperty getProperty(String propName, MainEntityType dt) {
        DynamicProperty property = dt.getProperty(propName);
        if (property == null) {
            DataEntityPropertyCollection properties = dt.getProperties();
            for (IDataEntityProperty pro : properties) {
                if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
                EntryProp entryProp = (EntryProp)pro;
                property = entryProp._collectionItemPropertyType.getProperty(propName);
                if (property == null) continue;
                return property;
            }
        }
        return property;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_Org)) {
            this.getModel().setValue(Key_Org, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_Material)) {
            this.getModel().setValue(Key_Material, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String org = (String)this.getModel().getValue(Key_Org);
        String material = (String)this.getModel().getValue(Key_Material);
        if (StringUtils.isBlank((CharSequence)org)) {
            msgBuilder.append("\u8bf7\u586b\u5199\u7ec4\u7ec7");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)material)) {
            msgBuilder.append("\u8bf7\u586b\u5199\u7269\u6599");
            return false;
        }
        return true;
    }

    public String getSetting() {
        String orgId = (String)this.getModel().getValue(Key_Org);
        String mateiralid = (String)this.getModel().getValue(Key_Material);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = "0";
        }
        if (StringUtils.isBlank((CharSequence)mateiralid)) {
            mateiralid = "0";
        }
        String setting = String.format("%s(%s, %s)", this.getFuncId(), orgId, mateiralid);
        return setting;
    }
}

