/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.api.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.es.api.common.BosEsErrorCode;
import kd.bos.ext.hr.es.me.dao.AISearchEsConfigService;
import kd.bos.ext.hr.es.me.dao.EntityEsConfigService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class EsCommonUtils {
    private static final Log LOGGER = LogFactory.getLog(EsCommonUtils.class);
    private static final String AI_SEARCH_INDEX_SUFFIX = "aiq";

    public static String getIndexNamePrefix(String region) {
        String index = EsCommonUtils.getServerConfig(region).get("index");
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        if (StringUtils.isEmpty((String)accountId)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{"getAccountIdtr error:" + accountId});
        }
        if (StringUtils.isEmpty((String)tenantId)) {
            return index + "_" + accountId.toLowerCase().replace("_", "");
        }
        return (index + "_" + tenantId + "_" + accountId.replace("_", "")).toLowerCase();
    }

    public static String getIndexAliasName(String region, String queryEntityName) {
        return EsCommonUtils.getIndexNamePrefix(region) + "_" + queryEntityName;
    }

    public static String getIndexName(String region, String queryEntityName) {
        DynamicObject dyReleaseInfo = EntityEsConfigService.getEsSyncSchemeConfig(queryEntityName);
        int version = 1;
        if (dyReleaseInfo != null) {
            version = dyReleaseInfo.getInt("version");
        }
        return EsCommonUtils.getIndexName(region, queryEntityName, version);
    }

    public static String getAIQIndexName(String region, String queryEntityName) {
        DynamicObject dyReleaseInfo = AISearchEsConfigService.queryAISearchEsConfig(queryEntityName);
        int version = 1;
        if (dyReleaseInfo != null) {
            version = dyReleaseInfo.getInt("version");
        }
        return EsCommonUtils.getAIQIndexName(region, queryEntityName, version);
    }

    public static String getAIQIndexAliasName(String region, String queryEntityName) {
        StringBuilder sb = new StringBuilder();
        sb.append(EsCommonUtils.getIndexNamePrefix(region));
        sb.append("_");
        sb.append(queryEntityName);
        sb.append("_");
        sb.append(AI_SEARCH_INDEX_SUFFIX);
        return sb.toString();
    }

    public static String getAIQIndexName(String region, String queryEntityName, int version) {
        StringBuilder sb = new StringBuilder();
        sb.append(EsCommonUtils.getIndexNamePrefix(region));
        sb.append("_");
        sb.append(queryEntityName);
        sb.append("_");
        sb.append(AI_SEARCH_INDEX_SUFFIX);
        sb.append("_");
        sb.append(version);
        return sb.toString();
    }

    public static String getIndexName(String region, String queryEntityName, int version) {
        return EsCommonUtils.getIndexNamePrefix(region) + "_" + queryEntityName + "_" + String.valueOf(version);
    }

    public static Map<String, Object> getIndexSettings(String region) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Map<String, String> configMap = EsCommonUtils.getServerConfig(region);
        result.put("index.mapping.total_fields.limit", Integer.valueOf(configMap.get("index.mapping.total_fields.limit")));
        result.put("index.mapping.nested_fields.limit", Integer.valueOf(configMap.get("index.mapping.nested_fields.limit")));
        result.put("number_of_replicas", Integer.valueOf(configMap.get("number_of_replicas")));
        result.put("number_of_shards", Integer.valueOf(configMap.get("number_of_shards")));
        result.put("index.max_result_window", Integer.valueOf(configMap.get("index.max_result_window")));
        result.put("analysis.filter.company_stopwords.type", configMap.get("analysis.filter.company_stopwords.type"));
        result.put("analysis.filter.company_stopwords.stopwords", configMap.get("analysis.filter.company_stopwords.stopwords"));
        result.put("analysis.analyzer.reverse_analyzer.type", configMap.get("analysis.analyzer.reverse_analyzer.type"));
        result.put("analysis.analyzer.reverse_analyzer.tokenizer", configMap.get("analysis.analyzer.reverse_analyzer.tokenizer"));
        result.put("analysis.analyzer.reverse_analyzer.filter", configMap.get("analysis.analyzer.reverse_analyzer.filter"));
        result.put("analysis.analyzer.company_analyzer.type", configMap.get("analysis.analyzer.company_analyzer.type"));
        result.put("analysis.analyzer.company_analyzer.tokenizer", configMap.get("analysis.analyzer.company_analyzer.tokenizer"));
        result.put("analysis.analyzer.company_analyzer.filter", configMap.get("analysis.analyzer.company_analyzer.filter"));
        return result;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String getIdByEntityNamePkId(String entityName, Object pkId) {
        return entityName + String.valueOf(pkId);
    }

    public static String getLangPN(String propertyName, Lang lang) {
        String result = "";
        result = lang == null ? propertyName : propertyName + "_" + lang.toString().toLowerCase();
        return result;
    }

    public static boolean containsUppercase(String str) {
        Pattern p = Pattern.compile("[A-Z]");
        return p.matcher(str).find();
    }

    public static String getPinyinPN(String propertyName) {
        return propertyName + "_" + "py";
    }

    public static int getMaxMatchSize() {
        String sizeStr = System.getProperty("es.maxmatchsize", "1000");
        return Integer.parseInt(sizeStr);
    }

    public static Map<String, String> getServerConfig(String region) throws KDException {
        Map<String, String> result = null;
        try {
            result = EsCommonUtils.getServerConfigByMc(region);
        }
        catch (Exception ex) {
            LOGGER.error("getServerConfigByMc error.", (Throwable)ex);
        }
        if (result == null) {
            LOGGER.info("getServerConfigByMc result is null,go to getServerConfigByDb.");
            result = EsCommonUtils.getServerConfigByDb(region);
        } else {
            LOGGER.info("getServerConfigByMc result success,return mc config.");
        }
        return result;
    }

    private static Map<String, String> getServerConfigByMc(String region) throws KDException {
        String passwordEncStr;
        String schema;
        String urls;
        String accountId = RequestContext.get().getAccountId();
        String paramKey = String.format("es_biz_%s_list", accountId);
        String esConfigStr = System.getProperty(paramKey);
        if (StringUtils.isEmpty((String)esConfigStr)) {
            LOGGER.info("getServerConfigByMc fail,getProperty is null,paramKey:{}.", (Object)paramKey);
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)esConfigStr);
        JSONObject jsonObject = EsCommonUtils.getEsConfigByNumber(jsonArray, region);
        if (jsonObject == null) {
            LOGGER.info("getServerConfigByMc fail,number:{} es config not exist.", (Object)region);
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)18);
        String ipStr = jsonObject.getString("host");
        if (StringUtils.isEmpty((String)ipStr)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{paramKey + " configuration error: ip can't be empty."});
        }
        result.put("ip", ipStr.trim().toLowerCase());
        String portStr = jsonObject.getString("port");
        if (StringUtils.isEmpty((String)portStr)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{paramKey + " configuration error: port can't be empty."});
        }
        result.put("port", portStr.trim().toLowerCase());
        result.put("httpport", portStr.trim().toLowerCase());
        String username = jsonObject.getString("userName");
        if (username != null) {
            result.put("username", username);
        }
        if ((urls = jsonObject.getString("urls")) != null) {
            result.put("urls", urls);
        }
        if ((schema = EsCommonUtils.getJsonPropertyWithDef(jsonObject, "schema", "http")) != null) {
            result.put("schema", schema);
        }
        if ((passwordEncStr = jsonObject.getString("passwd")) != null) {
            String password = EncrypterFactory.getEncrypter().decode(passwordEncStr);
            result.put("password", password);
        }
        JSONObject paramObject = jsonObject.getJSONObject("params");
        String enableStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "enable", "true");
        result.put("enable", enableStr.trim().toLowerCase());
        String indexStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "index", region);
        result.put("index", indexStr.trim().toLowerCase());
        String clusterNameStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "clustername", "kd-application");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "index.mapping.total_fields.limit", String.valueOf(8000));
        result.put("index.mapping.total_fields.limit", totalFieldsStr);
        String shardsNumberStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "number_of_shards", String.valueOf(5));
        result.put("number_of_shards", shardsNumberStr);
        String perlicasNumverStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "number_of_replicas", String.valueOf(2));
        result.put("number_of_replicas", perlicasNumverStr);
        String refreshIntervalStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "index.refresh_interval", String.valueOf(60));
        result.put("index.refresh_interval", refreshIntervalStr);
        String maxResultStr = EsCommonUtils.getJsonPropertyWithDef(paramObject, "index.max_result_window", String.valueOf(1000000));
        result.put("index.max_result_window", maxResultStr);
        String stopwordsType = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.filter.company_stopwords.type", String.valueOf("stop"));
        result.put("analysis.filter.company_stopwords.type", stopwordsType);
        String stopwords = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.filter.company_stopwords.stopwords", String.valueOf("("));
        result.put("analysis.filter.company_stopwords.stopwords", stopwords);
        String reverseAnalyzerType = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.reverse_analyzer.type", String.valueOf("custom"));
        result.put("analysis.analyzer.reverse_analyzer.type", reverseAnalyzerType);
        String reverseAnalyzerTokenizer = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.reverse_analyzer.tokenizer", String.valueOf("keyword"));
        result.put("analysis.analyzer.reverse_analyzer.tokenizer", reverseAnalyzerTokenizer);
        String reverseAnalyzerFilter = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.reverse_analyzer.filter", String.valueOf("lowercase"));
        result.put("analysis.analyzer.reverse_analyzer.filter", reverseAnalyzerFilter);
        String companyAnalyzerType = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.company_analyzer.type", String.valueOf("custom"));
        result.put("analysis.analyzer.company_analyzer.type", companyAnalyzerType);
        String companyAnalyzerTokenizer = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.company_analyzer.tokenizer", "standard");
        result.put("analysis.analyzer.company_analyzer.tokenizer", companyAnalyzerTokenizer);
        String nestList = EsCommonUtils.getJsonPropertyWithDef(paramObject, "index.mapping.nested_fields.limit", "100");
        result.put("index.mapping.nested_fields.limit", nestList);
        String companyAnalyzerFilter = EsCommonUtils.getJsonPropertyWithDef(paramObject, "analysis.analyzer.company_analyzer.filter", String.valueOf("company_stopwords"));
        result.put("analysis.analyzer.company_analyzer.filter", companyAnalyzerFilter);
        return result;
    }

    private static JSONObject getEsConfigByNumber(JSONArray jsonArray, String region) {
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        for (int idx = 0; idx < jsonArray.size(); ++idx) {
            JSONObject jsonObject = jsonArray.getJSONObject(idx);
            String number = jsonObject.getString("number");
            if (!region.equals(number)) continue;
            return jsonObject;
        }
        return null;
    }

    private static String getJsonPropertyWithDef(JSONObject jsonObject, String key, String defValue) {
        if (!jsonObject.containsKey((Object)key)) {
            return defValue;
        }
        return jsonObject.getString(key);
    }

    public static Map<String, String> getServerConfigByDb(String region) {
        String encPwd;
        String key = "elasticsearch.server." + region;
        DynamicObject esConfigDyo = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSQueryService", (String)"getEsConfigDyo", (Object[])new Object[0]);
        if (esConfigDyo == null) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{key + " the fulltext service is not configured."});
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)18);
        String ipStr = esConfigDyo.getString("ip");
        if (StringUtils.isEmpty((String)ipStr)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{key + " configuration error: ip can't be empty."});
        }
        result.put("ip", ipStr.trim().toLowerCase());
        String portStr = esConfigDyo.getString("port");
        if (StringUtils.isEmpty((String)portStr)) {
            throw new KDException(BosEsErrorCode.esException, new Object[]{key + " configuration error: port can't be empty."});
        }
        result.put("port", portStr.trim().toLowerCase());
        result.put("httpport", portStr.trim().toLowerCase());
        String username = esConfigDyo.getString("username");
        if (username != null) {
            result.put("username", username);
        }
        if (StringUtils.isNotEmpty((String)(encPwd = esConfigDyo.getString("password")))) {
            String password = EncrypterFactory.getEncrypter().decode(encPwd);
            result.put("password", password);
        }
        result.put("schema", "http");
        result.put("enable", "true");
        result.put("index", region);
        result.put("clustername", "kd-application");
        result.put("index.mapping.total_fields.limit", String.valueOf(8000));
        result.put("number_of_shards", String.valueOf(5));
        result.put("number_of_replicas", String.valueOf(2));
        result.put("index.refresh_interval", String.valueOf(60));
        result.put("index.max_result_window", String.valueOf(1000000));
        result.put("analysis.filter.company_stopwords.type", "stop");
        result.put("analysis.filter.company_stopwords.stopwords", "(");
        result.put("analysis.analyzer.reverse_analyzer.type", "custom");
        result.put("analysis.analyzer.reverse_analyzer.tokenizer", "keyword");
        result.put("analysis.analyzer.reverse_analyzer.filter", "lowercase");
        result.put("analysis.analyzer.company_analyzer.type", "custom");
        result.put("analysis.analyzer.company_analyzer.tokenizer", "standard");
        result.put("analysis.analyzer.company_analyzer.filter", "company_stopwords");
        result.put("index.mapping.nested_fields.limit", String.valueOf(100));
        return result;
    }

    public static String joinStr(String[] strs, String joinStr) {
        if (strs == null) {
            return null;
        }
        StringBuilder strSb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                strSb.append(joinStr);
            }
            strSb.append(strs[i]);
        }
        return strSb.toString();
    }

    public static boolean bracketMatch(String exp) {
        if (exp.length() == 0) {
            return false;
        }
        Stack<Character> stack = new Stack<Character>();
        block4: for (int i = 0; i < exp.length(); ++i) {
            char ch = exp.charAt(i);
            switch (ch) {
                case '(': {
                    stack.push(Character.valueOf(ch));
                    continue block4;
                }
                case ')': {
                    if (!stack.empty()) {
                        stack.pop();
                        continue block4;
                    }
                    return false;
                }
            }
        }
        return stack.empty();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }
}

