/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.es.api.common.util.EsCommonUtils;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.me.common.EsStrageBaseHelper;
import kd.bos.ext.hr.es.me.constants.EnumDataChangeType;
import kd.bos.ext.hr.es.me.dao.AISearchEsConfigService;
import kd.bos.ext.hr.es.me.importdata.impl.AIQEsBatchImportData;
import kd.bos.ext.hr.es.me.importdata.impl.AIQEsIncrementDataProcess;
import kd.bos.ext.hr.es.me.utils.AsynDeleteIndex;
import kd.bos.ext.hr.exception.ExtHrErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections.CollectionUtils;

public class AISearchESSyncMapper
implements Mapper {
    private static final Log logger = LogFactory.getLog(AISearchESSyncMapper.class);
    protected static ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"AISearchESSyncMapper-DeleteIndex-Thread", (int)1, (int)2);
    private String multientityname;

    public List<RowInfo> preHandle(List<RowInfo> rowInfoList) {
        String strSymbol;
        if (CollectionUtils.isEmpty(rowInfoList) || StringUtils.isEmpty((CharSequence)this.multientityname)) {
            return null;
        }
        RowInfo firstRowInfo = rowInfoList.get(0);
        if (firstRowInfo == null) {
            return null;
        }
        String tableName = firstRowInfo.getTable();
        int length = tableName.length();
        if (length > 3 && "_".equals(strSymbol = tableName.substring(length - 2, length - 1))) {
            return null;
        }
        String dataChangeType = firstRowInfo.getType();
        String entityNumber = firstRowInfo.getEntityNumber();
        if (entityNumber == null) {
            entityNumber = this.getMultiEntity().getMainEntityNumber(null);
        }
        boolean isBatchImportData = true;
        ArrayList<Object> idList = new ArrayList<Object>();
        for (RowInfo rowInfo : rowInfoList) {
            if (isBatchImportData && !EnumDataChangeType.NEW.getType().equals(dataChangeType)) {
                isBatchImportData = false;
            }
            idList.add(rowInfo.getKeyObject());
        }
        try {
            if (CollectionUtils.isNotEmpty(idList)) {
                if (isBatchImportData && idList.size() > 1) {
                    AIQEsBatchImportData aiqEsBatchImportData = AIQEsBatchImportData.getInstance();
                    aiqEsBatchImportData.batchImportData(this.multientityname, idList);
                    logger.info("HRSmartSearch batchImportData success! queryentityname:{}, datachangetype:{}, batch size:{}", new Object[]{this.multientityname, dataChangeType, idList.size()});
                } else {
                    AIQEsIncrementDataProcess esIncrementDataProcess = AIQEsIncrementDataProcess.getInstance();
                    esIncrementDataProcess.proccessMessageToEs(this.multientityname, entityNumber, dataChangeType, idList);
                    logger.info("HRSmartSearch IncrementImportData success! queryentityname:{}, datachangetype:{}, entitynumber:{}, id:{}", new Object[]{this.multientityname, dataChangeType, entityNumber, idList.get(0)});
                }
            }
        }
        catch (Exception exc) {
            logger.error("HRSmartSearch importData Exception,queryentityname:{}, isBatchImportData{}, error:{}", new Object[]{this.multientityname, isBatchImportData, exc.getMessage()});
            throw new KDBizException(exc.getMessage());
        }
        return null;
    }

    public Map<?, ?> convert2Es(String str, RowInfo rowInfo) {
        return null;
    }

    public String getKeyId(RowInfo rowInfo) {
        return null;
    }

    public String getIndexName(String str) {
        return null;
    }

    public String getESDataType() {
        return null;
    }

    public void setRegion(String str) {
    }

    public String getFieldStoredName(String str, String s1) {
        return null;
    }

    public MultiEntity getMultiEntity() {
        return new MyMultiEntity();
    }

    public void endInit(String opType, String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)this.multientityname) || StringUtils.isEmpty((CharSequence)opType)) {
            return;
        }
        if (!opType.equals("insert")) {
            return;
        }
        EsStorage storage = EsStrageBaseHelper.init();
        String aliasName = EsCommonUtils.getAIQIndexAliasName("hr", this.multientityname);
        DynamicObject dyReleaseInfo = AISearchEsConfigService.queryAISearchEsConfig(this.multientityname);
        int version = dyReleaseInfo.getInt("version");
        String indexName = EsCommonUtils.getAIQIndexName("hr", this.multientityname, version);
        storage.removeAndAddAliases(indexName, aliasName);
        try {
            try (TXHandle handle = TX.requiresNew();){
                AISearchEsConfigService.esBatchImported(this.multientityname);
            }
            logger.info("HRSmartSearch esimportdata success, queryentityname:{}", (Object)this.multientityname);
            String indexPrefix = EsCommonUtils.getAIQIndexAliasName("hr", this.multientityname);
            executorService.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new AsynDeleteIndex(storage, indexPrefix, version)));
        }
        catch (Exception e) {
            logger.error("HRSmartSearch update config status exception, queryentityname:{}, exc{}", (Object)this.multientityname, (Object)e.getMessage());
            throw new KDException(ExtHrErrorCode.extHrException, new Object[]{"update esconfig status error!"});
        }
    }

    class MyMultiEntity
    implements MultiEntity {
        MyMultiEntity() {
        }

        public String getMainEntityNumber(String entityNumber) {
            String queryFormId = MetadataDao.getIdByNumber((String)AISearchESSyncMapper.this.multientityname, (MetaCategory)MetaCategory.Form);
            if (StringUtils.isEmpty((CharSequence)queryFormId)) {
                return null;
            }
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
            QueryEntity queryEntity = (QueryEntity)entityMeta.getRootEntity();
            return queryEntity.getEntityName();
        }

        public boolean isMainEntity(String entityNumber) {
            if (StringUtils.isEmpty((CharSequence)entityNumber)) {
                return false;
            }
            return entityNumber.equals(this.getMainEntityNumber(entityNumber));
        }
    }
}

