/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.importdata.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.ext.hr.es.api.EsBatchValue;
import kd.bos.ext.hr.es.api.common.util.EsCommonUtils;
import kd.bos.ext.hr.es.api.storage.EsFilterField;
import kd.bos.ext.hr.es.api.storage.EsResultVo;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.me.common.AIQEsStrageBaseHelper;
import kd.bos.ext.hr.es.me.common.EncryptionBusinessDataServiceHelper;
import kd.bos.ext.hr.es.me.common.EsStrageBaseHelper;
import kd.bos.ext.hr.es.me.constants.EnumDataChangeType;
import kd.bos.ext.hr.es.me.constants.EnumEntityRelationType;
import kd.bos.ext.hr.es.me.dao.AISearchEsConfigService;
import kd.bos.ext.hr.es.me.importdata.IEsIncrementDataProcess;
import kd.bos.ext.hr.es.me.vo.QueryEntityRelationVO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class AIQEsIncrementDataProcess
implements IEsIncrementDataProcess {
    private static final Log logger = LogFactory.getLog(AIQEsIncrementDataProcess.class);
    private static volatile AIQEsIncrementDataProcess esIncrementDataProcess = null;

    private AIQEsIncrementDataProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AIQEsIncrementDataProcess getInstance() {
        if (esIncrementDataProcess != null) return esIncrementDataProcess;
        Class<AIQEsIncrementDataProcess> clazz = AIQEsIncrementDataProcess.class;
        synchronized (AIQEsIncrementDataProcess.class) {
            if (esIncrementDataProcess != null) return esIncrementDataProcess;
            esIncrementDataProcess = new AIQEsIncrementDataProcess();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esIncrementDataProcess;
        }
    }

    @Override
    public void proccessMessageToEs(String queryEntityName, String entityName, String dataChangeType, List<Object> idList) {
        EsStorage storage = EsStrageBaseHelper.init();
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty((String)dataChangeType) || StringUtils.isEmpty((String)queryEntityName)) {
            logger.error("Synchronizing ES data error,parameters 'queryEntityName': {}, or 'dataChangeType': {}, or 'entityName': {} is null!", new Object[]{queryEntityName, dataChangeType, entityName});
            return;
        }
        DynamicObject dyReleaseInfo = AISearchEsConfigService.queryAISearchEsConfig(queryEntityName);
        if (dyReleaseInfo == null) {
            logger.error("Synchronizing ES data error,can not find ES Deployment information! 'queryEntityName': {} ", (Object)queryEntityName);
            return;
        }
        QueryEntityRelationVO queryEntityRelationVO = this.getQueryEntityRelation(dyReleaseInfo, queryEntityName, entityName);
        if (queryEntityRelationVO == null) {
            return;
        }
        Object objStatus = dyReleaseInfo.get("initstate");
        if (objStatus == null) {
            logger.error("Synchronizing ES data error, ES Deployment information error, field 'status' is null! 'queryEntityName': {} ", (Object)queryEntityName);
            return;
        }
        String status = (String)objStatus;
        if (!status.equals("2")) {
            return;
        }
        for (Object objId : idList) {
            if (objId == null) {
                logger.error("Synchronizing ES data error, business id is null! queryEntityName: {} ", (Object)queryEntityName);
                continue;
            }
            int version = dyReleaseInfo.getInt("version");
            String indexName = EsCommonUtils.getAIQIndexName("hr", queryEntityName, version);
            this.processEsData(storage, queryEntityRelationVO, entityName, dataChangeType, objId, indexName);
        }
    }

    private void processEsData(EsStorage storage, QueryEntityRelationVO queryEntityRelationVO, String entityName, String dataChangeType, Object id, String indexName) {
        String entityRelationType = queryEntityRelationVO.getRelationType();
        QueryEntity queryEntity = queryEntityRelationVO.getQueryType();
        if (queryEntity == null) {
            return;
        }
        List<Object> ids = this.getEsDocmentIds(storage, queryEntity, indexName, entityName, id, entityRelationType, dataChangeType);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        for (Object mainEntityId : ids) {
            if (EnumDataChangeType.DELETE.getType().equals(dataChangeType)) {
                EsStrageBaseHelper.deleteEsDataByMainEntityId(storage, indexName, "t_data", String.valueOf(mainEntityId));
            }
            if (EnumDataChangeType.DELETE.getType().equals(dataChangeType) && EnumEntityRelationType.MAIN.getType().equals(entityRelationType)) continue;
            this.saveData(queryEntity, storage, indexName, ids);
        }
    }

    private void saveData(QueryEntity queryType, EsStorage storage, String indexName, List<Object> ids) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)queryType.getEntityName());
        DynamicObject[] dynamicObjects = EncryptionBusinessDataServiceHelper.loadDynamicObjectsByPks(ids.toArray(), (DynamicObjectType)dt);
        List<EsBatchValue> batchValue = AIQEsStrageBaseHelper.buildAIQBatchValue(queryType, dynamicObjects, null);
        if (CollectionUtils.isEmpty(batchValue)) {
            return;
        }
        storage.batchSave(indexName, "t_data", batchValue.toArray(new EsBatchValue[batchValue.size()]));
    }

    private void saveData(QueryEntity queryType, EsStorage storage, String indexName, List<Object> ids, Object id) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)queryType.getEntityName());
        DynamicObject[] dynamicObjects = EncryptionBusinessDataServiceHelper.loadDynamicObjectsByPks(ids.toArray(), (DynamicObjectType)dt);
        List<EsBatchValue> batchValue = AIQEsStrageBaseHelper.buildAIQBatchValue(queryType, dynamicObjects, id);
        if (CollectionUtils.isEmpty(batchValue)) {
            return;
        }
        storage.batchSave(indexName, "t_data", batchValue.toArray(new EsBatchValue[batchValue.size()]));
    }

    private QueryEntityRelationVO getQueryEntityRelation(DynamicObject dyReleaseInfo, String queryEntityName, String entityName) {
        QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity(queryEntityName);
        if (queryEntity == null) {
            logger.error("Synchronizing ES data error,can not find entity metadata, queryEntityName: {} ", (Object)queryEntityName);
            return null;
        }
        QueryEntityRelationVO queryEntityRelationVO = new QueryEntityRelationVO();
        queryEntityRelationVO.setQueryEntityName(queryEntityName);
        queryEntityRelationVO.setEntityName(entityName);
        queryEntityRelationVO.setQueryType(queryEntity);
        if (entityName.equals(queryEntity.getEntityName())) {
            queryEntityRelationVO.setRelationType(EnumEntityRelationType.MAIN.getType());
            return queryEntityRelationVO;
        }
        Set<String> oneToManyEntity = AISearchEsConfigService.getOneToManyEntity(dyReleaseInfo);
        Map<String, String> arrayDisplayProp = AISearchEsConfigService.getArrayDisplayProp(dyReleaseInfo);
        if (oneToManyEntity.contains(entityName) || arrayDisplayProp.containsKey(entityName)) {
            queryEntityRelationVO.setRelationType(EnumEntityRelationType.ONE_TO_MANY.getType());
        } else {
            queryEntityRelationVO.setRelationType(EnumEntityRelationType.ONE_TO_ONE.getType());
        }
        return queryEntityRelationVO;
    }

    public List<Object> getEsDocmentIds(EsStorage storage, QueryEntity queryEntity, String indexName, String entityName, Object idValue, String entityRelationType, String dataChangeType) {
        String mainEntityName = queryEntity.getEntityName();
        if (StringUtils.isEmpty((String)entityName) || idValue == null || StringUtils.isEmpty((String)mainEntityName)) {
            return null;
        }
        if (entityRelationType.equals(EnumEntityRelationType.MAIN.getType())) {
            ArrayList<Object> idList = new ArrayList<Object>();
            idList.add(idValue);
            return idList;
        }
        Object fkIdValue = null;
        String fkIDKey = null;
        Set<String> oneToManyEntitys = AISearchEsConfigService.getOneToManyEntity(queryEntity.getKey());
        for (QuerySourceJoinRelation relation : queryEntity.getJoinRelations()) {
            List listQSConditionRow = relation.getCondition();
            for (QSConditionRow qSConditionRow : listQSConditionRow) {
                QSIdentifierExpr rightItem = (QSIdentifierExpr)qSConditionRow.getRightItem();
                QSIdentifierExpr leftItem = (QSIdentifierExpr)qSConditionRow.getLeftItem();
                if (rightItem == null) continue;
                String rightEntityName = rightItem.getExpr();
                String compareOp = qSConditionRow.getCompareOp();
                if (!"=".equals(compareOp) || !rightEntityName.startsWith(entityName + ".") || StringUtils.isEmpty((String)rightEntityName) || !rightEntityName.startsWith(entityName + ".")) continue;
                if (rightEntityName.equals(entityName + ".id")) {
                    fkIdValue = idValue;
                } else {
                    String fkID = rightEntityName.replaceAll(entityName + ".", "");
                    if (EnumDataChangeType.DELETE.getType().equals(dataChangeType)) {
                        ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>();
                        String path = null;
                        if (oneToManyEntitys.contains(entityName)) {
                            path = entityName;
                        }
                        EsFilterField esFilterField = new EsFilterField(path, entityName + ".id", "=", idValue);
                        listEsFilterField.add(esFilterField);
                        String[] selectFieldArr = new String[]{"id"};
                        EsResultVo esResultVo = storage.query(indexName, null, selectFieldArr, listEsFilterField, null, true, 0, 1);
                        List<Map<String, Object>> listIdResult = esResultVo.getResultData();
                        if (CollectionUtils.isEmpty(listIdResult) && listIdResult.size() != 1) {
                            return null;
                        }
                        Map<String, Object> map = listIdResult.get(0);
                        Object objId = map.get("id");
                        if (objId == null) {
                            return null;
                        }
                        fkIdValue = objId;
                    } else {
                        QFilter subEntityJoinFilter = new QFilter("id", "=", idValue);
                        DynamicObject[] subjoinEntityArray = BusinessDataServiceHelper.load((String)entityName, (String)fkID, (QFilter[])new QFilter[]{subEntityJoinFilter});
                        if (subjoinEntityArray == null || subjoinEntityArray.length < 1) {
                            return null;
                        }
                        DynamicObject joinObject = subjoinEntityArray[0];
                        if (joinObject == null) {
                            return null;
                        }
                        Object nestObject = joinObject.get(fkID);
                        if (nestObject == null) {
                            return null;
                        }
                        fkIdValue = nestObject instanceof DynamicObject ? ((DynamicObject)nestObject).get("id") : nestObject;
                    }
                }
                if (fkIdValue != null) {
                    fkIDKey = leftItem.getExpr();
                }
                if (!StringUtils.isNotEmpty(fkIDKey) || fkIdValue != null) continue;
                break;
            }
            if (!StringUtils.isNotEmpty(fkIDKey) || fkIdValue != null) continue;
            break;
        }
        return this.getMainEntityIdsByFK(mainEntityName, entityRelationType, fkIDKey, fkIdValue);
    }

    private List<Object> getMainEntityIdsByFK(String mainEntityName, String entityRelationType, String fkIDKey, Object fkIdValue) {
        if (StringUtils.isEmpty((String)fkIDKey) || fkIdValue == null) {
            return null;
        }
        QFilter joinFilter = new QFilter(fkIDKey, "=", fkIdValue);
        DynamicObject[] joinEntityArray = BusinessDataServiceHelper.load((String)mainEntityName, (String)"id", (QFilter[])new QFilter[]{joinFilter});
        if (joinEntityArray == null || joinEntityArray.length < 1) {
            return null;
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        if (entityRelationType.equals(EnumEntityRelationType.MANY_TO_ONE.getType())) {
            for (DynamicObject joinObject : joinEntityArray) {
                idList.add(joinObject.get("id"));
            }
        } else {
            DynamicObject joinObject = joinEntityArray[0];
            idList.add(joinObject.get("id"));
        }
        return idList;
    }
}

