/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.filter;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import kd.bos.base.AbstractBasedataController;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.util.query.DateTimeUtils;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class AdminOrgHisF7FastFilter
extends AbstractBasedataController {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgHisF7FastFilter.class);
    private static final String SEARCH_DATE = "searchdate";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        super.buildBaseDataCoreFilter(event);
        ListShowParameter listShowParameter = event.getListShowParameter();
        QFilter versionFilter = this.getVersionFilter(listShowParameter);
        if (versionFilter != null) {
            listShowParameter.getListFilterParameter().getQFilters().add(versionFilter);
        }
    }

    protected QFilter getVersionFilter(ListShowParameter listShowParameter) {
        Date searchDate;
        Map customParams = listShowParameter.getCustomParams();
        if (customParams.containsKey(SEARCH_DATE) && (searchDate = this.getSearchDate(listShowParameter)) != null) {
            return new QFilter("iscurrentversion", "=", (Object)"0").and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"})).and(new QFilter("bsed", "<=", (Object)searchDate)).and(new QFilter("bsled", ">=", (Object)searchDate));
        }
        return null;
    }

    private Date getSearchDate(ListShowParameter listShowParameter) {
        Map customParams = listShowParameter.getCustomParams();
        if (customParams.containsKey(SEARCH_DATE)) {
            Object searchDate = customParams.get(SEARCH_DATE);
            if (searchDate instanceof Date) {
                return (Date)searchDate;
            }
            if (searchDate instanceof String) {
                try {
                    return DateTimeUtils.parseDate((String)searchDate);
                }
                catch (ParseException e) {
                    LOGGER.info("AdminOrgHisF7FastFilter buildBaseDataCoreFilter date format error!");
                    throw new KDBizException("data format error!");
                }
            }
        }
        return null;
    }
}

