/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.func;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSBatchFunction;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.ext.hr.func.helper.DimensionHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetDimensionVal
implements BOSUDFunction,
BOSBatchFunction {
    private static final Log LOGGER = LogFactory.getLog(GetDimensionVal.class);
    private ExpressionContext expContext;

    public GetDimensionVal() {
    }

    public GetDimensionVal(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext arg0) {
        return new GetDimensionVal(this.expContext);
    }

    public String getName() {
        return "GetDimensionVal";
    }

    public Object call(Object ... arg) {
        if (arg == null || arg.length == 0 || arg[0].equals("") || arg[0] == null) {
            return null;
        }
        if (arg.length <= 1) {
            return null;
        }
        long currentEntryId = Long.parseLong(arg[0].toString());
        String index = arg[1].toString();
        LOGGER.info("GetDimensionVal call ######### currentEntryId : {} and  index : {}", (Object)currentEntryId, (Object)index);
        return this.queryDimensionVal(currentEntryId, index);
    }

    public Map<BatchFuncRunParam, Object> batchCall(Set<BatchFuncRunParam> param) {
        HashMap<BatchFuncRunParam, Object> resultMap = new HashMap<BatchFuncRunParam, Object>(param.size());
        List<Long> entryIdList = DimensionHelper.getEntryIds(param);
        LOGGER.info("GetDimensionVal batchCall entryIdList size : {}", (Object)entryIdList.size());
        if (!entryIdList.isEmpty()) {
            Map<Long, Long> costBillEntryAndSetUpConstIdMap = DimensionHelper.getCostBillEntryAndSetUpConstIdMap(entryIdList);
            Collection<Long> values = costBillEntryAndSetUpConstIdMap.values();
            ArrayList<Long> costSetUpConstIdList = new ArrayList<Long>(new HashSet<Long>(values));
            LOGGER.info("GetDimensionVal batchCall costSetUpConstIdList size : {}", (Object)costSetUpConstIdList.size());
            Map<Long, DynamicObject> costSetUpConstIdMap = DimensionHelper.getCostSetupConstIdMap(costSetUpConstIdList);
            this.putValResult(param, resultMap, costBillEntryAndSetUpConstIdMap, costSetUpConstIdMap);
        }
        return resultMap;
    }

    private void putValResult(Set<BatchFuncRunParam> param, Map<BatchFuncRunParam, Object> resultMap, Map<Long, Long> costBillEntryAndSetUpConstIdMap, Map<Long, DynamicObject> costSetUpConstIdMap) {
        for (BatchFuncRunParam next : param) {
            Object currentEntryIdObj;
            Object[] paramVal = next.getFuncParamVals();
            if (paramVal == null || paramVal.length <= 1 || ObjectUtils.isEmpty((Object)(currentEntryIdObj = paramVal[0]))) continue;
            long currentEntryId = Long.parseLong(currentEntryIdObj.toString());
            String index = paramVal[1].toString();
            Long costSetupConstId = costBillEntryAndSetUpConstIdMap.get(currentEntryId);
            LOGGER.info("GetDimensionVal putValResult costSetupConstId ######### currentEntryId : {} and  index : {} and costSetupConstId : {}", new Object[]{currentEntryId, index, costSetupConstId});
            DynamicObject costSetUpConstDy = costSetUpConstIdMap.get(costSetupConstId);
            if (costSetUpConstDy == null) continue;
            String costSetUpConstVal = DimensionHelper.getCostSetupVal(index, costSetUpConstDy);
            Long id = this.convertId(costSetUpConstVal);
            resultMap.put(next, id);
            LOGGER.info("GetDimensionVal putValResult id ######### currentEntryId : {} and  index : {} and id : {} and costSetUpConstVal : {}", new Object[]{currentEntryId, index, id, costSetUpConstVal});
        }
    }

    private Long queryDimensionVal(long currentEntryId, String index) {
        long costSetupConstId = DimensionHelper.getcostSetupConstId(currentEntryId);
        LOGGER.info("GetDimensionVal queryDimensionVal costSetupConstId ######### currentEntryId : {} and  index : {} and costSetupConstId : {}", new Object[]{currentEntryId, index, costSetupConstId});
        return this.getId(currentEntryId, index, costSetupConstId);
    }

    private Long getId(long currentEntryId, String index, long costSetupConstId) {
        DynamicObject costSetUpConstDy = QueryServiceHelper.queryOne((String)"pcs_costsetupconst", (String)DimensionHelper.getFileds("1"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costSetupConstId)});
        if (costSetUpConstDy == null) {
            return 0L;
        }
        String costSetUpConstVal = DimensionHelper.getCostSetupVal(index, costSetUpConstDy);
        Long id = this.convertId(costSetUpConstVal);
        LOGGER.info("GetDimensionVal getId id ######### currentEntryId : {} and  index : {} and id : {} and costSetUpConstVal : {}", new Object[]{currentEntryId, index, id, costSetUpConstVal});
        return id;
    }

    private Long convertId(String costSetUpConstValVal) {
        Long id = 0L;
        if (StringUtils.isNotEmpty((CharSequence)costSetUpConstValVal) && !StringUtils.equals((CharSequence)costSetUpConstValVal, (CharSequence)" ")) {
            try {
                id = Long.valueOf(costSetUpConstValVal);
            }
            catch (NumberFormatException e) {
                LOGGER.error("GetDimensionVal convertId error :", (Object)e.getMessage());
            }
        }
        return id;
    }
}

