/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.func.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DimensionHelper {
    private static final Log LOGGER = LogFactory.getLog(DimensionHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getcostSetupConstId(long entryId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FCOSTSETUPCONSTID CONSTID FROM T_PCS_ALLOTBILLENTRY ");
        sb.append(" WHERE FENTRYID = " + entryId);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.bos.ext.fi.func.GetDimensionVal", (DBRoute)DBRoute.of((String)"swc"), (String)sb.toString(), (Object[])null);){
            Iterator dataSetIterator = dataSet.iterator();
            if (!dataSetIterator.hasNext()) return 0L;
            Row row = (Row)dataSetIterator.next();
            Long constId = row.getLong("CONSTID");
            long l = constId;
            return l;
        }
        catch (Exception e) {
            LOGGER.error("DimensionHelper getcostSetupConstId error :", (Object)e.getMessage());
        }
        return 0L;
    }

    public static Map<Long, Long> getCostBillEntryAndSetUpConstIdMap(List<Long> entryIdList) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FENTRYID ENTRYID,FCOSTSETUPCONSTID CONSTID FROM T_PCS_ALLOTBILLENTRY ");
        sb.append(" WHERE FENTRYID in (");
        for (int i = 0; i < entryIdList.size(); ++i) {
            sb.append('?');
            if (i + 1 >= entryIdList.size()) continue;
            sb.append(',');
        }
        sb.append(" ) ");
        HashMap<Long, Long> costSetupConstIdMap = new HashMap<Long, Long>(entryIdList.size());
        try (DataSet dataSet = DB.queryDataSet((String)"kd.bos.ext.fi.func.GetDimensionVal.getConstIdMap", (DBRoute)DBRoute.of((String)"swc"), (String)sb.toString(), (Object[])entryIdList.toArray(new Object[0]));){
            for (Row row : dataSet) {
                Long entryId = row.getLong("ENTRYID");
                Long constId = row.getLong("CONSTID");
                costSetupConstIdMap.put(entryId, constId);
            }
        }
        return costSetupConstIdMap;
    }

    public static String getCostSetupVal(String index, DynamicObject costSetUpConstDy) {
        String costSetUpConstVal = costSetUpConstDy.getString("segment" + index);
        if (costSetUpConstVal != null && costSetUpConstVal.indexOf("||") > 0) {
            costSetUpConstVal = costSetUpConstVal.substring(0, costSetUpConstVal.indexOf("||"));
        }
        return costSetUpConstVal;
    }

    public static String getEntityNumber(DynamicObject costDimensionObj) {
        String valueType = costDimensionObj.getString("valuetype");
        return "1".equals(valueType) ? costDimensionObj.getString("valuesource.number") : "bos_assistantdata_detail";
    }

    public static String getEntityNumberBatch(DynamicObject costDimensionObj) {
        String valueType = costDimensionObj.getString("costdimension.valuetype");
        return "1".equals(valueType) ? costDimensionObj.getString("costdimension.valuesource.number") : "bos_assistantdata_detail";
    }

    public static String getFileds(String type) {
        StringBuilder builder = new StringBuilder();
        builder.append("id,coststru.id,");
        if (type.equals("2")) {
            builder.append("coststru,");
        }
        for (int i = 1; i < 31; ++i) {
            builder.append("segment" + i + ",");
        }
        return builder.subSequence(0, builder.length() - 1).toString();
    }

    public static List<Long> getEntryIds(Set<BatchFuncRunParam> param) {
        HashSet<Long> entryIds = new HashSet<Long>(param.size());
        for (BatchFuncRunParam arg : param) {
            Object[] paramVal = arg.getFuncParamVals();
            if (paramVal == null || paramVal.length <= 0 || paramVal[0] == null) continue;
            entryIds.add(Long.parseLong(paramVal[0].toString()));
        }
        ArrayList<Long> entryIdList = new ArrayList<Long>(entryIds);
        return entryIdList;
    }

    public static Map<Long, DynamicObject> getCostSetupConstIdMap(List<Long> costSetUpConstIdList) {
        HashMap<Long, DynamicObject> setUpConstIdMap = new HashMap<Long, DynamicObject>(costSetUpConstIdList.size());
        if (CollectionUtils.isEmpty(costSetUpConstIdList)) {
            return setUpConstIdMap;
        }
        DynamicObjectCollection costSetUpConstColl = QueryServiceHelper.query((String)"pcs_costsetupconst", (String)DimensionHelper.getFileds("1"), (QFilter[])new QFilter[]{new QFilter("id", "in", costSetUpConstIdList)});
        for (DynamicObject costSetUpConstDy : costSetUpConstColl) {
            long id = costSetUpConstDy.getLong("id");
            setUpConstIdMap.put(id, costSetUpConstDy);
        }
        return setUpConstIdMap;
    }

    public static Map<Long, DynamicObject> getCostStruIdMap(List<Long> costStruIdList) {
        DynamicObject[] costStruArray;
        HashMap<Long, DynamicObject> costStruIdMap = new HashMap<Long, DynamicObject>(costStruIdList.size());
        if (CollectionUtils.isEmpty(costStruIdList)) {
            return costStruIdMap;
        }
        for (DynamicObject costStruDy : costStruArray = BusinessDataServiceHelper.load((String)"lcs_coststru", (String)"id,dimensionentry,costdimension,storageset,costdimension.valuetype,costdimension.displayproperty,costdimension.valuesource,costdimension.assistant,storageset.number", (QFilter[])new QFilter[]{new QFilter("id", "in", costStruIdList)})) {
            long id = costStruDy.getLong("id");
            costStruIdMap.put(id, costStruDy);
        }
        return costStruIdMap;
    }
}

