/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RosterInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleRosterConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class RuleUtil {
    private static Log LOGGER = LogFactory.getLog(RuleUtil.class);

    private static String getEntityNumber(String entityNumber, String field) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(field);
        if (prop instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)prop;
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            return orgProp.getBaseEntityId();
        }
        if (prop instanceof BasedataProp) {
            return ((BasedataProp)prop).getBaseEntityId();
        }
        if (prop instanceof MulBasedataProp) {
            return ((MulBasedataProp)prop).getBaseEntityId();
        }
        return entityNumber;
    }

    public static String getNewestConditionValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        try {
            RuleConditionInfo info = (RuleConditionInfo)SerializationUtils.fromJsonString((String)value, RuleConditionInfo.class);
            List<ConditionInfo> conditionInfoList = info.getConditionList();
            if (null != conditionInfoList && conditionInfoList.size() > 0) {
                for (ConditionInfo conditionInfo : conditionInfoList) {
                    boolean isDynamicObject = ParamTypeEnum.DYNAMICOBJECT.getValue().equals(conditionInfo.getParamType());
                    boolean isBasedata = ParamTypeEnum.BASEDATA.getValue().equals(conditionInfo.getParamType());
                    boolean isValue = "2".equals(conditionInfo.getValueType());
                    boolean isTarget = "3".equals(conditionInfo.getValueType());
                    String conditionValue = conditionInfo.getValue();
                    if ((isDynamicObject || isBasedata) && isValue) {
                        QFilter filter;
                        DynamicProperty prop;
                        BasedataEntityType mainEntityType;
                        String objectId = conditionInfo.getObjectId();
                        String[] ids = null;
                        if (StringUtils.isNotEmpty((CharSequence)objectId)) {
                            ids = objectId.split(",");
                        } else if (StringUtils.isNotEmpty((CharSequence)conditionValue)) {
                            ids = conditionValue.split(",");
                        }
                        if (null == ids || ids.length == 0) continue;
                        String entityNumber = conditionInfo.getParam();
                        String[] entitys = entityNumber.split("\\.");
                        if (StringUtils.isNotEmpty((CharSequence)conditionInfo.getBaseDataNumber())) {
                            entityNumber = conditionInfo.getBaseDataNumber();
                        } else if (entitys.length == 6) {
                            entityNumber = RuleUtil.getEntityNumber(entitys[3], entitys[4]);
                        } else if (entitys.length == 5) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (DynamicProperty)mainEntityType.getAllFields().get(entitys[2]);
                            if (prop instanceof BasedataProp) {
                                entityNumber = ((BasedataProp)prop).getBaseEntityId();
                            } else if (prop instanceof MulBasedataProp) {
                                entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
                            }
                            entityNumber = RuleUtil.getEntityNumber(entityNumber, entitys[3]);
                        } else if (entitys.length == 4) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (BasedataProp)mainEntityType.getAllFields().get(entitys[2]);
                            entityNumber = prop.getBaseEntityId();
                        } else {
                            entityNumber = entitys.length == 3 ? entitys[1] : entitys[0];
                        }
                        mainEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
                        boolean longId = mainEntityType.getPrimaryKey() instanceof LongProp;
                        if (longId) {
                            List longIds = Arrays.stream(ids).map(Long::parseLong).collect(Collectors.toList());
                            filter = new QFilter("id", "in", longIds);
                        } else {
                            filter = new QFilter("id", "in", (Object)ids);
                        }
                        String name = mainEntityType.getNameProperty();
                        DynamicObjectCollection colls = QueryServiceHelper.query((String)entityNumber, (String)name, (QFilter[])new QFilter[]{filter});
                        if (null == colls || colls.isEmpty()) {
                            conditionInfo.setDisplayValue("");
                            conditionInfo.setValue("");
                            conditionInfo.setObjectId("");
                            conditionInfo.setObjectNumber("");
                            continue;
                        }
                        ArrayList<String> displayName = new ArrayList<String>(ids.length);
                        for (String id2 : ids) {
                            for (DynamicObject dy2 : colls) {
                                if (longId) {
                                    if (Long.parseLong(id2) != dy2.getLong("id")) continue;
                                    displayName.add(dy2.getString(name));
                                    continue;
                                }
                                if (!id2.equals(dy2.getString("id"))) continue;
                                displayName.add(dy2.getString(name));
                            }
                        }
                        String displayValue = Joiner.on((String)",").join(displayName);
                        if (StringUtils.isEmpty((CharSequence)displayValue)) {
                            LOGGER.warn("displayValue is empty! {}", (Object)conditionInfo.toString());
                        }
                        conditionInfo.setDisplayValue(displayValue);
                        continue;
                    }
                    if (!isTarget) continue;
                    String[] ids = conditionValue.split(",");
                    List targetIds = Arrays.stream(ids).map(id -> Long.parseLong(id.substring(id.lastIndexOf("_") + 1))).collect(Collectors.toList());
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)"brm_target", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)});
                    String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString("name")).collect(Collectors.toList()));
                    conditionInfo.setDisplayValue(displayValue);
                }
            }
            return SerializationUtils.toJsonString((Object)info);
        }
        catch (Exception exception) {
            LOGGER.error("parse error!", (Throwable)exception);
            return value;
        }
    }

    public static String getNewestResultValue(String value) {
        try {
            RuleResultInfo info = (RuleResultInfo)SerializationUtils.fromJsonString((String)value, RuleResultInfo.class);
            List<ResultInfo> conditionInfoList = info.getResultList();
            if (null != conditionInfoList && conditionInfoList.size() > 0) {
                for (ResultInfo conditionInfo : conditionInfoList) {
                    String[] ids;
                    boolean isDynamicObject = ParamTypeEnum.DYNAMICOBJECT.getValue().equals(conditionInfo.getParamType());
                    boolean isBasedata = ParamTypeEnum.BASEDATA.getValue().equals(conditionInfo.getParamType());
                    boolean isValue = "2".equals(conditionInfo.getValueType());
                    boolean isTarget = "3".equals(conditionInfo.getValueType());
                    String conditionValue = conditionInfo.getValue();
                    if ((isDynamicObject || isBasedata) && isValue) {
                        QFilter filter;
                        MainEntityType mainEntityType;
                        if (StringUtils.isEmpty((CharSequence)conditionValue)) continue;
                        ids = conditionValue.split(",");
                        String entityNumber = conditionInfo.getParam();
                        String[] entitys = entityNumber.split("\\.");
                        if (entitys.length == 4) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            BasedataProp prop = (BasedataProp)mainEntityType.getAllFields().get(entitys[2]);
                            entityNumber = prop.getBaseEntityId();
                        } else {
                            entityNumber = entitys.length == 3 ? entitys[1] : entitys[0];
                        }
                        mainEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
                        if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                            List longIds = Arrays.stream(ids).map(Long::parseLong).collect(Collectors.toList());
                            filter = new QFilter("id", "in", longIds);
                        } else {
                            filter = new QFilter("id", "in", (Object)ids);
                        }
                        String name = mainEntityType.getNameProperty();
                        DynamicObjectCollection colls = QueryServiceHelper.query((String)entityNumber, (String)name, (QFilter[])new QFilter[]{filter});
                        String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString(name)).collect(Collectors.toList()));
                        conditionInfo.setDisplayValue(displayValue);
                        continue;
                    }
                    if (!isTarget) continue;
                    ids = conditionValue.split(",");
                    List targetIds = Arrays.stream(ids).map(id -> Long.parseLong(id.substring(id.lastIndexOf("_") + 1))).collect(Collectors.toList());
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)"brm_target", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)});
                    String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString("name")).collect(Collectors.toList()));
                    conditionInfo.setDisplayValue(displayValue);
                }
            }
            return SerializationUtils.toJsonString((Object)info);
        }
        catch (Exception exception) {
            LOGGER.error("parse error!", (Throwable)exception);
            return value;
        }
    }

    public static String getNewestRosterConditionValue(String value) {
        try {
            RuleRosterConditionInfo info = (RuleRosterConditionInfo)SerializationUtils.fromJsonString((String)value, RuleRosterConditionInfo.class);
            List<RosterInfo> conditionInfoList = info.getRosterList();
            if (null != conditionInfoList && conditionInfoList.size() > 0) {
                for (RosterInfo conditionInfo : conditionInfoList) {
                    String[] ids = conditionInfo.getValue().split(",");
                    List targetIds = Arrays.stream(ids).map(id -> Long.parseLong(id.substring(id.lastIndexOf("_") + 1))).collect(Collectors.toList());
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)"brm_special_list", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)});
                    String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString("name")).collect(Collectors.toList()));
                    conditionInfo.setDisplayValue(displayValue);
                }
            }
            return SerializationUtils.toJsonString((Object)info);
        }
        catch (Exception exception) {
            LOGGER.error("parse error!", (Throwable)exception);
            return value;
        }
    }
}

