/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.service.operation;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.service.operation.Save;

public class SubmitEffect
extends Save {
    private String billStatusFieldKey = "billstatus";
    private String AUDITOR = "auditor";
    private String AUDITDATE = "auditdate";
    protected String oldAuditStatusValue = "";
    protected String oldBillStatusValue = "";

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add("auditstatus");
        fieldKeys.add(this.billStatusFieldKey);
        fieldKeys.add(this.AUDITOR);
        fieldKeys.add(this.AUDITDATE);
    }

    protected String getLogOperateName(DynamicObject dynamicObject) {
        return ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)"SubmitEffect_0", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        if (StringUtils.isNotBlank((CharSequence)"auditstatus") && objs.length == 1) {
            this.oldAuditStatusValue = (String)objs[0].get("auditstatus");
            this.oldBillStatusValue = (String)objs[0].get(this.billStatusFieldKey);
        }
        super.beforeCallOperationTransaction(objs);
    }

    protected void rollback(DynamicObject[] objs, Exception ex) {
        super.rollback(objs, ex);
        this.updateAuditStauts(objs, this.oldAuditStatusValue);
        this.updateBillStauts(objs, this.oldBillStatusValue);
        for (DynamicObject obj : objs) {
            obj.set(this.AUDITDATE, null);
            obj.set(this.AUDITOR, (Object)0L);
        }
    }

    protected void afterUpdateBillStatus(DynamicObject[] objs) {
        super.afterUpdateBillStatus(objs);
        this.updateAuditStauts(objs, "C");
        this.updateBillStauts(objs, "C");
        this.updateAuditor(objs);
    }

    private void updateAuditor(DynamicObject[] objs) {
        Date date = new Date();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject obj : objs) {
            obj.set(this.AUDITDATE, (Object)date);
            obj.set(this.AUDITOR, (Object)currUserId);
        }
    }

    private void updateAuditStauts(DynamicObject[] objs, String auditStatus) {
        for (DynamicObject obj : objs) {
            obj.set("auditstatus", (Object)auditStatus);
        }
    }

    private void updateBillStauts(DynamicObject[] objs, String billStatus) {
        for (DynamicObject obj : objs) {
            obj.set(this.billStatusFieldKey, (Object)billStatus);
        }
    }
}

