/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.ext.hr.web.util.SafeUriUtil;
import kd.bos.ext.hr.web.vo.HrUserSessionVO;
import kd.bos.instance.Instance;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class SafeUriFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(SafeUriFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = HrFilterUtil.getURI(servletRequest);
        try {
            String urlQuery;
            boolean isSafeUriDo;
            String paramA = request.getParameter("a");
            boolean bl = isSafeUriDo = requestURI.startsWith("/hr") && StringUtils.isNotEmpty((String)paramA);
            if (!isSafeUriDo) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            boolean isSafeUri = SafeUriUtil.isSafeUri(requestURI);
            if (!isSafeUri) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            this.createGuestContext(request);
            String accountId = RequestContext.get().getAccountId();
            String uri = requestURI + "?a=" + accountId;
            LOGGER.info("querySafeUrlService start,uri={}", (Object)uri);
            SafeUrlDTO safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"shortToLong", (Object[])new Object[]{uri});
            LOGGER.info("querySafeUrlService end,safeUrlDTO={}", (Object)safeUrlDTO);
            Date expiryTime = safeUrlDTO.getExpiryTime();
            String originUrl = safeUrlDTO.getOriginUrl();
            if (originUrl.contains("/mobile.html")) {
                URL netURL = new URL(originUrl);
                urlQuery = netURL.getQuery();
            } else {
                urlQuery = originUrl;
            }
            Map queryParamMap = Splitter.onPattern((String)"&").trimResults().withKeyValueSeparator("=").split((CharSequence)urlQuery);
            String loginConfigNumber = (String)queryParamMap.get("loginConfigNumber");
            String bizUserId = (String)queryParamMap.get("bizUserId");
            String bizCustomParam = (String)queryParamMap.get("bizCustomParam");
            String formId = HrFilterUtil.getClientUrlExpiryFormId(request, loginConfigNumber);
            String expiryPageUrl = HrFilterUtil.getFormUrlByGuest(request, accountId, formId, loginConfigNumber);
            if (StringUtils.isEmpty((String)safeUrlDTO.getOriginUrl())) {
                response.sendRedirect(expiryPageUrl);
                return;
            }
            boolean isAfter = expiryTime.after(new Date());
            if (!isAfter) {
                LOGGER.info("uri is expired,uri={}", (Object)uri);
                response.sendRedirect(expiryPageUrl);
                return;
            }
            LOGGER.info("Got originUrl: [{}], urlQuery: [{}], queryParamMap: [{}].", new Object[]{originUrl, urlQuery, queryParamMap});
            if (StringUtils.isEmpty((String)loginConfigNumber)) {
                response.sendRedirect(originUrl);
                return;
            }
            LoginConfigDTO loginConfigDTO = (LoginConfigDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"getHrLoginConfig", (Object[])new Object[]{loginConfigNumber});
            if (loginConfigDTO == null) {
                response.getWriter().write("loginConfig not found,number=" + URLEncoder.encode(loginConfigNumber, StandardCharsets.UTF_8.toString()));
                response.getWriter().flush();
                return;
            }
            String url2 = this.getLoginPageUrl(request, loginConfigDTO, queryParamMap, loginConfigNumber);
            Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
            if (hrUserCookie == null) {
                response.sendRedirect(url2);
                return;
            }
            String cookieValue = hrUserCookie.getValue();
            HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, cookieValue);
            if (hrUserSessionVO == null) {
                HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                response.sendRedirect(url2);
            } else if (!(hrUserSessionVO.getAccountId().equals(accountId) && hrUserSessionVO.getLoginConfigNumber().equals(loginConfigNumber) && hrUserSessionVO.getBizUserId().equals(bizUserId))) {
                HrFilterUtil.removeCookieAndSession(request, response, hrUserCookie.getName(), cookieValue);
                response.sendRedirect(url2);
            } else {
                String url3 = this.getBizFormPageUrl(request, accountId, loginConfigNumber, hrUserSessionVO.getBizFormId(), bizUserId, bizCustomParam);
                response.sendRedirect(url3);
            }
        }
        catch (Exception ex) {
            LOGGER.error("SafeUriFilterError:", (Throwable)ex);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01\n", (String)"LoginFilter_3", (String)"bos-login", (Object[])new Object[0]) + ex.getMessage()});
            String resp = LoginUtils.getLoginResponse((String)String.valueOf(kd.getErrorCode().getCode()), (String)kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception var52) {
                throw ex;
            }
        }
    }

    private String getLoginPageUrl(HttpServletRequest request, LoginConfigDTO loginConfigDTO, Map<String, String> queryParamMap, String loginConfigNumber) {
        String language;
        Map paramMap;
        String params;
        String loginFormId = HrFilterUtil.getClientCommonLoginFormId(request, loginConfigNumber);
        String redirectFormId = loginFormId.equals("hbss_commonloginpc") ? loginConfigDTO.getPcRedirectFormId() : loginConfigDTO.getRedirectFormId();
        String queryParam = "&loginConfigNumber=" + loginConfigDTO.getLoginConfigNumber() + "&bizFormId=" + redirectFormId + "&bizUserId=" + queryParamMap.get("bizUserId");
        String bizUserId = queryParamMap.get("bizUserId");
        String bizCustomParam = queryParamMap.get("bizCustomParam");
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        Account currentCenter = HrFilterUtil.getCurrentAccount(request);
        String langCode = loginConfigDTO.getLangCode();
        String htmlUriParam = HrGuestUrlUtil.getMobileHtmlUrl(currentCenter.getAccountId(), loginConfigDTO.getLoginConfigNumber(), bizUserId, bizCustomParam);
        SafeUrlDTO safeUrlDTO = (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{htmlUriParam});
        if (null != safeUrlDTO && null != (params = safeUrlDTO.getParams()) && !"".equals(params.trim()) && null != (paramMap = (Map)SerializationUtils.fromJsonString((String)params, Map.class)) && paramMap.containsKey("language")) {
            langCode = (String)paramMap.get("language");
        }
        if (StringUtils.isNotEmpty((String)(language = HrFilterUtil.xssEncode(request.getParameter("language"))))) {
            langCode = LoginLangUtils.getLoginLanguage((HttpServletRequest)request).toString();
        }
        return HrFilterUtil.getFormUrlByGuest(request, currentCenter.getAccountId(), loginFormId, loginConfigNumber) + queryParam + "&language=" + langCode;
    }

    private String getBizFormPageUrl(HttpServletRequest request, String accountId, String loginConfigNumber, String formId, String bizUserId, String bizCustomParam) {
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizUserId=" + bizUserId;
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        return HrFilterUtil.getFormUrlByGuest(request, accountId, formId, loginConfigNumber) + queryParam + "&language=" + RequestContext.get().getLang().toString();
    }

    private void createGuestContext(HttpServletRequest request) {
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        String accountId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"a");
        Account currentCenter = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        Lang lang = LoginLangUtils.getLang((String)LoginUtils.getParamerter((HttpServletRequest)request, (String)"l"));
        String address = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
        String sessionId = LoginUtils.getGuestSessionId((String)currentCenter.getAccountId(), (String)currentCenter.getTenantId(), (Lang)lang, (String)address);
        SessionInfo si = SessionUtils.getGuestSessionData((String)Instance.getClusterName(), (String)currentCenter.getTenantId(), (String)currentCenter.getAccountId(), (Lang)lang);
        RequestContextCreator.create((HttpServletRequest)request, (String)sessionId, (SessionInfo)si);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

