/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.ext.dhc.factory.PublisherFactory;
import kd.bos.ext.fi.operation.dhc.SupportOpTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;

public class DataSynchronizationOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(DataSynchronizationOpAction.class);
    private static final String APPID_DHC = "0HAJN6NF6DOV";
    private static final String EXC_TYPE = "1";
    public static final String DHC_EXCEPTION_RECORD = "dhc_exceptionrecord";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!this.getOperationResult().isSuccess()) {
            log.info("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1a" + e.getOperationKey() + "\uff0cisSuccess=false");
            return;
        }
        DynamicObject[] dynArr = e.getDataEntities();
        if (dynArr.length == 0) {
            log.error("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1a\u672a\u83b7\u53d6\u5355\u636e\u5b9e\u4f53\u6570\u636e");
            return;
        }
        String formMetaId = dynArr[0].getDataEntityType().getName();
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject dyn : dynArr) {
            ids.add(dyn.getPkValue());
        }
        log.info("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1,\u5b9e\u4f53\u6807\u8bc6\uff1a" + formMetaId + ",\u4e3b\u952e\u96c6\u5408\uff1a" + ids);
        AppParam param = new AppParam(APPID_DHC, Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Object dataSynService = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"datasynservice");
        if (dataSynService == null) {
            log.info("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1adataSynService is null,\u5b9e\u4f53\u6807\u8bc6\uff1a" + formMetaId + ",\u4e3b\u952e\u96c6\u5408\uff1a" + ids);
            return;
        }
        if (dataSynService instanceof Boolean && !((Boolean)dataSynService).booleanValue()) {
            log.info("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1adataSynService is false,\u5b9e\u4f53\u6807\u8bc6\uff1a" + formMetaId + ",\u4e3b\u952e\u96c6\u5408\uff1a" + ids);
            return;
        }
        String operation = e.getOperationKey();
        SupportOpTypeEnum supportOpType = this.matchSupportOpType(operation, formMetaId);
        if (supportOpType == null) {
            log.info(String.format("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1a\u4e0d\u652f\u6301%1s\u5355\u7684%2s\u64cd\u4f5c\uff0c\u4ec5\u652f\u6301\uff1a\u4fdd\u5b58\u3001\u5220\u9664\u3001\u63d0\u4ea4\u3001\u63d0\u4ea4\u53ca\u65b0\u589e\u3001\u64a4\u9500\u3001\u5ba1\u6838\u3001\u53cd\u5ba1\u68387\u79cd\u7c7b\u578b\u64cd\u4f5c\u3002", formMetaId, operation));
            return;
        }
        List<Map<String, Object>> msgList = this.buildMqMessage(formMetaId, ids, supportOpType);
        this.publishMessage(msgList);
    }

    private SupportOpTypeEnum matchSupportOpType(String opNumber, String entityNumber) {
        Map operateMap;
        SupportOpTypeEnum dhcSupportType = SupportOpTypeEnum.getDhcSupportType(opNumber);
        if (dhcSupportType != null) {
            return dhcSupportType;
        }
        try {
            operateMap = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)opNumber);
        }
        catch (Exception ex) {
            log.error(String.format("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff1a\u5728\u5b9e\u4f53%1s\u4e0a\u67e5\u627e\u64cd\u4f5c\u670d\u52a1\u914d\u7f6e\u64cd\u4f5c%2s\u5931\u8d25\u3002", entityNumber, opNumber), (Throwable)ex);
            return null;
        }
        String operateType = (String)operateMap.get("type");
        return SupportOpTypeEnum.getDhcSupportType(operateType);
    }

    private List<Map<String, Object>> buildMqMessage(String entityNumber, List<Object> ids, SupportOpTypeEnum opType) {
        ArrayList<Map<String, Object>> msgList = new ArrayList<Map<String, Object>>(2);
        HashMap<String, Object> msg = new HashMap<String, Object>(8);
        msg.put("formMetaId", entityNumber);
        msg.put("ids", ids);
        String mqHandleOp = SupportOpTypeEnum.OP_DELETE == opType ? "delete" : (SupportOpTypeEnum.OP_SAVE == opType || SupportOpTypeEnum.OP_SUBMIT == opType || SupportOpTypeEnum.OP_SUBMIT_AND_NEW == opType ? "save" : "unsubmit");
        msg.put("operation", mqHandleOp);
        msgList.add(msg);
        if ("fa_dispatch".equals(entityNumber)) {
            String extMqHandleOp = null;
            if (SupportOpTypeEnum.OP_AUDIT == opType) {
                extMqHandleOp = "save";
            } else if (SupportOpTypeEnum.OP_UNAUDIT == opType) {
                extMqHandleOp = "delete";
            }
            if (extMqHandleOp != null) {
                HashMap<String, Object> extBizMsg = new HashMap<String, Object>(8);
                extBizMsg.put("formMetaId", "fa_dispatch_in");
                extBizMsg.put("ids", ids);
                extBizMsg.put("operation", extMqHandleOp);
                msgList.add(extBizMsg);
            }
        }
        return msgList;
    }

    private void publishMessage(List<Map<String, Object>> msgList) {
        MessagePublisher pub = PublisherFactory.getDataSynchronizationPub();
        for (Map<String, Object> msg : msgList) {
            try {
                log.info("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\u670d\u52a1\uff0c\u53d1\u9001mq\u6d88\u606f\uff1a" + msg);
                pub.publish(msg);
            }
            catch (Exception ex) {
                log.error("\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\uff1a\u8c03\u7528MQ\u5931\u8d25,\u6d88\u606f\u5185\u5bb9\uff1a" + msg, (Throwable)ex);
                this.recordErrorException(msg, "publishMessage", ex);
            }
        }
        pub.close();
    }

    private void recordErrorException(Map<String, Object> dataMap, String methodName, Exception e) {
        String entityName = (String)dataMap.get("formMetaId");
        List ids = (List)dataMap.get("ids");
        if (StringUtils.isEmpty((String)entityName) || ids == null || ids.size() < 1) {
            return;
        }
        List pkIds = ids.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toList());
        String className = ((Object)((Object)this)).getClass().getName();
        String stackTrace = DataSynchronizationOpAction.getStackTrace(e);
        String traceId = RequestContext.get().getTraceId();
        String numberProperty = DataSynchronizationOpAction.getNumberProperty(entityName);
        String argument = SerializationUtils.toJsonString(dataMap);
        String excReason = String.format(ResManager.loadKDString((String)"\u4eba\u4eba\u62a5\u8d26\u6570\u636e\u540c\u6b65\uff1a%s\u8c03\u7528MQ\u5931\u8d25\u3002", (String)"DataSynchronizationOpAction_0", (String)"bos-ext-ssc", (Object[])new Object[0]), methodName);
        DynamicObject[] recordExcepts = new DynamicObject[pkIds.size()];
        for (int i2 = 0; i2 < pkIds.size(); ++i2) {
            Long billPkId = (Long)pkIds.get(i2);
            DynamicObject recordExcept = BusinessDataServiceHelper.newDynamicObject((String)DHC_EXCEPTION_RECORD);
            recordExcept.set("exctype", (Object)EXC_TYPE);
            recordExcept.set("billtype", (Object)entityName);
            recordExcept.set("billid", (Object)billPkId);
            recordExcept.set("billnumber", (Object)this.getBillNo(billPkId, entityName, numberProperty));
            recordExcept.set("classname", (Object)className);
            recordExcept.set("methodname", (Object)methodName);
            recordExcept.set("traceid", (Object)traceId);
            recordExcept.set("excreason", (Object)excReason);
            recordExcept.set("excreason_tag", (Object)stackTrace);
            recordExcept.set("excargument_tag", (Object)argument);
            recordExcept.set("exccreatetime", (Object)new Date());
            recordExcept.set("canretry", (Object)true);
            recordExcept.set("state", (Object)"0");
            recordExcepts[i2] = recordExcept;
        }
        try {
            SaveServiceHelper.save((DynamicObject[])recordExcepts);
        }
        catch (Exception e2) {
            log.error("kd.fi.dhc.util.RecordExceptionUtil.saveRecordExcept \u2014- \u65b0\u589e\u5f02\u5e38\u8bb0\u5f55\u51fa\u9519", (Throwable)e2);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder("Exception:");
        if (throwable != null) {
            StackTraceElement[] elements;
            stringBuilder.append(throwable.getMessage()).append('\n');
            for (StackTraceElement e : elements = throwable.getStackTrace()) {
                stringBuilder.append('\t').append(e).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private String getBillNo(Long billId, String entityNumber, String numberFieldKey) {
        if (entityNumber == null || numberFieldKey == null) {
            return "";
        }
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)numberFieldKey);
        return billData.getString(numberFieldKey);
    }

    public static String getNumberProperty(String entityNumber) {
        String numberProperty = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)dataEntityType;
            numberProperty = bdType.getNumberProperty();
        } else if (dataEntityType instanceof BillEntityType) {
            BillEntityType bdType = (BillEntityType)dataEntityType;
            numberProperty = bdType.getBillNo();
        }
        return numberProperty;
    }
}

