/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.ssc.enums.TaskPoolTypeEnum;
import kd.bos.ext.ssc.enums.TaskStateEnum;
import kd.bos.ext.ssc.pojo.RemainingTimeInfo;
import kd.bos.ext.ssc.pojo.SimpleJob;
import kd.bos.ext.ssc.pojo.SimpleJobStateTime;
import kd.bos.ext.ssc.service.IRemainingTimeService;
import kd.bos.ext.ssc.service.RemainingTimeServiceImpl;
import kd.bos.ext.ssc.util.CalWorkDateUtil;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class CalRemainingTime {
    private static final Log logger = LogFactory.getLog(CalRemainingTime.class);
    private RemainingTimeInfo remainingTimeInfo = null;
    private static final String T_TK_TASK = "task_task";
    private Map<Long, CalWorkDateUtil> instanceMap = new HashMap<Long, CalWorkDateUtil>();

    public void calRemainingTime(List<Long> jobIds, String callSource) {
        try (DataSet dataset = this.getCalculateJob(jobIds, null);){
            this.calRemainingTimeExt(dataset, false, callSource, null);
        }
    }

    private DataSet getCalculateJob(List<Long> jobIds, List<QFilter> qFilter) {
        if (qFilter == null) {
            qFilter = new ArrayList<QFilter>();
        }
        if (jobIds != null) {
            qFilter.add(new QFilter("id", "in", jobIds));
        }
        ORM orm = ORM.create();
        String taskBillSelectField = "id,entryentitylevel.priority priority,entryentitylevel.timeliness timeliness,entryentitylevel.warningtime warntime";
        DataSet taskBillSet = orm.queryDataSet("ssc.getCreateRule", "task_taskbill_child", taskBillSelectField, null);
        String taskSelectField = "id,receivetime,tasklevelid.id,tasktypeid.id,sscid,billtype.entryentity.tasktype childtasktype,billtype.entryentity.childpkid childpkid,firstreceivetime";
        DataSet taskSet = orm.queryDataSet("ssc.getCalculateJob", T_TK_TASK, taskSelectField, qFilter.toArray(new QFilter[0])).filter("tasktypeid.id = childtasktype");
        DataSet taskSetJoinTaskBillSet = taskSet.join(taskBillSet).on("childpkid", "id").select(new String[]{"id", "receivetime", "tasklevelid.id", "sscid", "firstreceivetime"}, new String[]{"priority", "timeliness", "warntime"}).finish().filter("tasklevelid.id = priority");
        return taskSetJoinTaskBillSet;
    }

    public Map<Long, RemainingTimeInfo> calRemainingTimeExt(DataSet taskData, boolean isQuality, String callSource, Map<String, Object> paramMap) {
        RemainingTimeServiceImpl remainingTimeService = new RemainingTimeServiceImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)remainingTimeService, IRemainingTimeService.class, (String)"kd.ssc.task.common.workcalendar.CalRemainingTime.calRemainingTimeExt");
        HashMap<Long, RemainingTimeInfo> remainingTimeInfoMap = new HashMap<Long, RemainingTimeInfo>(8);
        List remainingTimeInfoMapList = pluginProxy.callReplaceIfPresent(p -> p.calRemainingTime(taskData, isQuality, callSource, paramMap));
        if (CollectionUtils.isNotEmpty((Collection)remainingTimeInfoMapList)) {
            for (Map map : remainingTimeInfoMapList) {
                if (map == null || map.size() <= 0) continue;
                remainingTimeInfoMap.putAll(map);
            }
        }
        return remainingTimeInfoMap;
    }

    public Map<Long, RemainingTimeInfo> getReminderTimeMap(Map<Long, SimpleJob> jobId_simpleJob, Map<Long, List<SimpleJobStateTime>> jobId_simpleJobStateChangeList) {
        HashMap<Long, RemainingTimeInfo> jobId_reminderTime = new HashMap<Long, RemainingTimeInfo>(16);
        if (jobId_simpleJob == null || jobId_simpleJob.isEmpty()) {
            return jobId_reminderTime;
        }
        Collection<SimpleJob> values = jobId_simpleJob.values();
        Date calWorkDateUtilEndTime = values.isEmpty() || values.stream().anyMatch(p -> p.getCompleteTime() == null) ? new Date() : (Date)values.stream().max(Comparator.comparing(SimpleJob::getCompleteTime)).map(SimpleJob::getCompleteTime).orElseGet(() -> new Timestamp(System.currentTimeMillis()));
        for (Map.Entry<Long, SimpleJob> entry : jobId_simpleJob.entrySet()) {
            this.remainingTimeInfo = new RemainingTimeInfo();
            long jobId = entry.getKey();
            SimpleJob simpleJob = entry.getValue();
            List<SimpleJobStateTime> simpleJobStateTimes = jobId_simpleJobStateChangeList.get(jobId);
            Date endDate = simpleJob.getCompleteTime() == null ? new Date() : simpleJob.getCompleteTime();
            CalWorkDateUtil util = null;
            try {
                util = this.instanceMap.get(simpleJob.getShareCenterId());
                if (util == null) {
                    Date startDate = this.getStartDateOfSSC(simpleJob.getShareCenterId());
                    util = CalWorkDateUtil.getInstance(simpleJob.getShareCenterId(), startDate, calWorkDateUtilEndTime, "ssc");
                    this.instanceMap.put(simpleJob.getShareCenterId(), util);
                }
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5171\u4eab\u4e2d\u5fc3\u51fa\u9519\uff01\u4efb\u52a1ID" + jobId + "==\u9519\u8bef\u4fe1\u606f\uff1a" + Arrays.toString(e.getStackTrace()));
            }
            if (util == null) continue;
            try {
                long stateChangeCost;
                BigDecimal taskDuration = simpleJob.getTaskduration();
                if (taskDuration == null) continue;
                long limitTime = (long)(taskDuration.doubleValue() * 60.0);
                long costTime_rec = util.calWorkTime(simpleJob, simpleJob.getReceiveTime(), endDate);
                long allCostTime = costTime_rec - (stateChangeCost = this.getStateChangeCost(simpleJob, simpleJobStateTimes, util));
                if (allCostTime < 1L) {
                    allCostTime = 1L;
                }
                long remainTime = limitTime - allCostTime;
                this.remainingTimeInfo.setReminderTime(new BigDecimal(remainTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP));
                this.remainingTimeInfo.setCostWorkTime(taskDuration.subtract(this.remainingTimeInfo.getReminderTime()));
                Timestamp firstreceiveTime = simpleJob.getFirstreceiveTime();
                if (firstreceiveTime != null) {
                    long costTime_firstRec = util.calWorkTime(simpleJob, firstreceiveTime, endDate);
                    long firstAllCostTime = costTime_firstRec - stateChangeCost;
                    if (firstAllCostTime < 1L) {
                        firstAllCostTime = 1L;
                    }
                    this.remainingTimeInfo.setFirstCostWorkTime(new BigDecimal(firstAllCostTime).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP));
                }
                BigDecimal tipLimit = simpleJob.getTipLimit();
                BigDecimal remainTime2 = this.remainingTimeInfo.getReminderTime();
                String expireState = remainTime2.compareTo(new BigDecimal("0")) <= 0 ? "2" : (tipLimit != null && remainTime2.compareTo(tipLimit) < 0 ? "3" : "1");
                this.remainingTimeInfo.setExpireState(expireState);
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1:" + jobId + "\u8ba1\u7b97\u5269\u4f59\u65f6\u95f4\u65f6\u51fa\u9519==\u9519\u8bef\u4fe1\u606f\uff1a" + e.getCause(), (Throwable)e);
                continue;
            }
            jobId_reminderTime.put(jobId, this.remainingTimeInfo);
        }
        return jobId_reminderTime;
    }

    private Date getStartDateOfSSC(Long sscId) {
        Date startDate = null;
        QFilter filter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        filter.and(new QFilter("sscid", "=", (Object)sscId));
        filter.and(QFilter.isNotNull((String)"receivetime"));
        DynamicObjectCollection list = QueryServiceHelper.query((String)T_TK_TASK, (String)"id,receivetime", (QFilter[])new QFilter[]{filter}, (String)"receivetime", (int)1);
        if (!list.isEmpty()) {
            startDate = ((DynamicObject)list.get(0)).getDate("receivetime");
        }
        return startDate;
    }

    private long getStateChangeCost(SimpleJob simpleJob, List<SimpleJobStateTime> listSimpleJobStateTime, CalWorkDateUtil util) {
        if (listSimpleJobStateTime == null || listSimpleJobStateTime.isEmpty()) {
            return 0L;
        }
        listSimpleJobStateTime.sort(Comparator.comparing(SimpleJobStateTime::getChangeTime));
        long stateChangeCost = 0L;
        int len = listSimpleJobStateTime.size();
        for (int i = 0; i < len - 1; ++i) {
            stateChangeCost += this.getOneCost(simpleJob, listSimpleJobStateTime.get(i), listSimpleJobStateTime.get(i + 1), util);
        }
        SimpleJobStateTime simpleJobState = listSimpleJobStateTime.get(listSimpleJobStateTime.size() - 1);
        String newJobState = simpleJobState.getNewJobState();
        if (TaskStateEnum.PAUSE.getValue().equals(newJobState) || TaskStateEnum.PAUSE_CHECKING.getValue().equals(newJobState) || TaskStateEnum.PAUSE_RECTIFYING.getValue().equals(newJobState) || TaskStateEnum.PAUSE_REVIEW.getValue().equals(newJobState) || TaskStateEnum.RESCAN.getValue().equals(newJobState)) {
            stateChangeCost += util.calWorkTime(simpleJob, simpleJobState.getChangeTime(), new Date(System.currentTimeMillis()));
        }
        return stateChangeCost;
    }

    private long getOneCost(SimpleJob simpleJob, SimpleJobStateTime stateObj, SimpleJobStateTime nextStateObj, CalWorkDateUtil util) {
        boolean condition8;
        long costTime = 0L;
        String oldState = stateObj.getOldJobState();
        String newState = stateObj.getNewJobState();
        String oldNextState = nextStateObj.getOldJobState();
        String newNextState = nextStateObj.getNewJobState();
        boolean condition1 = TaskStateEnum.TO_BE_AUDIT.getValue().equals(oldState) && TaskStateEnum.PAUSE.getValue().equals(newState) && TaskStateEnum.PAUSE.getValue().equals(oldNextState) && TaskStateEnum.TO_BE_AUDIT.getValue().equals(newNextState);
        boolean condition2 = TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(oldState) && TaskStateEnum.PAUSE.getValue().equals(newState) && TaskStateEnum.PAUSE.getValue().equals(oldNextState) && TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(newNextState);
        boolean condition3 = TaskStateEnum.TO_BE_AUDIT.getValue().equals(oldState) && TaskStateEnum.RESCAN.getValue().equals(newState) && TaskStateEnum.RESCAN.getValue().equals(oldNextState) && TaskStateEnum.TO_BE_AUDIT.getValue().equals(newNextState);
        boolean condition4 = TaskStateEnum.TO_BE_AUDIT.getValue().equals(oldState) && TaskStateEnum.RESCAN.getValue().equals(newState) && TaskStateEnum.RESCAN.getValue().equals(oldNextState) && TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(newNextState);
        boolean condition5 = TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(oldState) && TaskStateEnum.RESCAN.getValue().equals(newState) && TaskStateEnum.RESCAN.getValue().equals(oldNextState) && TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(newNextState);
        boolean condition6 = TaskStateEnum.PAUSE.getValue().equals(oldState) && TaskStateEnum.PAUSE.getValue().equals(newState) && TaskStateEnum.PAUSE.getValue().equals(oldNextState) && TaskStateEnum.TO_BE_AUDIT.getValue().equals(newNextState);
        boolean condition7 = TaskStateEnum.RESCAN.getValue().equals(oldState) && TaskStateEnum.RESCAN.getValue().equals(newState) && TaskStateEnum.RESCAN.getValue().equals(oldNextState) && TaskStateEnum.TO_BE_AUDIT.getValue().equals(newNextState);
        boolean bl = condition8 = TaskStateEnum.RESCAN.getValue().equals(oldState) && TaskStateEnum.RESCAN.getValue().equals(newState) && TaskStateEnum.RESCAN.getValue().equals(oldNextState) && TaskStateEnum.REUPLOAD_IMAGE.getValue().equals(newNextState);
        if (condition1 || condition2 || condition3 || condition4 || condition5 || condition6 || condition7 || condition8) {
            costTime = util.calWorkTime(simpleJob, stateObj.getChangeTime(), nextStateObj.getChangeTime());
        }
        return costTime;
    }

    public void updateToDB(Map<Long, RemainingTimeInfo> remainingTime) {
        if (remainingTime.isEmpty()) {
            return;
        }
        String sql = "update t_tk_task set FRestTime=?,FExpireState=? where fid=?";
        ArrayList params = new ArrayList(10);
        remainingTime.entrySet().forEach(entry -> {
            long jobId = (Long)entry.getKey();
            RemainingTimeInfo remainingTimeInfo = (RemainingTimeInfo)entry.getValue();
            params.add(new Object[]{remainingTimeInfo.getReminderTime(), remainingTimeInfo.getExpireState(), jobId});
            if (params.size() % 500 == 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)sql, (List)params);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                    }
                }
                params.clear();
            }
        });
        if (params.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)sql, params);
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
        }
    }

    public void parseJobData(Map<Long, SimpleJob> jobId_simpleJob, Map<Long, List<SimpleJobStateTime>> jobId_simpleJobStateChangeList, DataSet jobData, boolean isQuality) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        RowMeta rowMeta = jobData.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        jobData.forEach(row -> {
            long jobId = row.getLong("id");
            Timestamp receiveTime = row.getTimestamp("receivetime");
            Timestamp firstreceivetime = null;
            BigDecimal taskduration = row.getBigDecimal("timeliness");
            BigDecimal tipLimit = row.getBigDecimal("warntime");
            if (isQuality && row.getBoolean("issmart").booleanValue()) {
                taskduration = row.getBigDecimal("smarttimeliness");
                tipLimit = row.getBigDecimal("smartwarntime");
            }
            if (!isQuality && ArrayUtils.contains((Object[])fieldNames, (Object)"firstreceivetime")) {
                firstreceivetime = row.getTimestamp("firstreceivetime");
            }
            long sscId = row.getLong("sscid");
            jobId_simpleJob.put(jobId, new SimpleJob(receiveTime, tipLimit, taskduration, sscId, firstreceivetime));
            idList.add(jobId);
        });
        if (jobId_simpleJob.isEmpty()) {
            return;
        }
        logger.info("\u4efb\u52a1\u6570\uff1a" + idList.size());
        DynamicObjectCollection jobStatusChangeData = this.getJobStatusChangeData(idList);
        SimpleJob simpleJob = null;
        for (DynamicObject row2 : jobStatusChangeData) {
            Long job_id = row2.getLong("jobid");
            List<SimpleJobStateTime> list = jobId_simpleJobStateChangeList.get(job_id);
            if (list == null) {
                simpleJob = jobId_simpleJob.get(job_id);
                list = new ArrayList<SimpleJobStateTime>();
                jobId_simpleJobStateChangeList.put(job_id, list);
            }
            if (simpleJob == null) continue;
            Timestamp receiveTime = simpleJob.getReceiveTime();
            Date stateChangeTime = row2.getDate("changetime");
            if (receiveTime == null || stateChangeTime == null || receiveTime.getTime() > stateChangeTime.getTime()) continue;
            String oldStatus = row2.getString("oldjobstate");
            String newStatus = row2.getString("newjobstate");
            list.add(new SimpleJobStateTime(new Timestamp(stateChangeTime.getTime()), oldStatus, newStatus));
        }
    }

    private DynamicObjectCollection getJobStatusChangeData(List<Long> jobId) {
        QFilter filter = new QFilter("jobid", "in", jobId);
        String selectField = "jobid,oldjobstate,newjobstate,changetime";
        String orderby = "jobid,changetime";
        return QueryServiceHelper.query((String)"ssc.getJobStatusChangeData", (String)"task_statechange", (String)selectField, (QFilter[])new QFilter[]{filter}, (String)orderby);
    }

    public void updateToDB2(Map<Long, RemainingTimeInfo> remainingTime) {
        if (remainingTime == null || remainingTime.isEmpty()) {
            return;
        }
        String sql = "update t_tk_task set FRestTime=?,FExpireState=?,FCostWaitTime=? where fid=?";
        String qsql = "update t_tk_task_q set ffirstcostwaittime=? where fid=?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        ArrayList<Object[]> qparams = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, RemainingTimeInfo> entry : remainingTime.entrySet()) {
            long jobId = entry.getKey();
            RemainingTimeInfo remainingTimeInfo = entry.getValue();
            Object[] param = new Object[]{remainingTimeInfo.getReminderTime(), remainingTimeInfo.getExpireState(), remainingTimeInfo.getCostWorkTime(), jobId};
            Object[] qparam = new Object[]{remainingTimeInfo.getFirstCostWorkTime(), jobId};
            params.add(param);
            qparams.add(qparam);
            if (params.size() % 500 != 0) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)sql, params);
            DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)qsql, qparams);
            params.clear();
            qparams.clear();
        }
        if (params.size() > 0) {
            try (TXHandle h = TX.required();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)sql, params);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"ssc"), (String)qsql, qparams);
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
        }
    }
}

