/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workflow.listener;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;

public class UpdateAuditMsgListener
implements IWorkflowPlugin {
    private static Log log = LogFactory.getLog(UpdateAuditMsgListener.class);

    public List<IApprovalRecordItem> formatFlowRecords(List<IApprovalRecordItem> items) {
        log.info("\u4fee\u6539\u5ba1\u6279\u8bb0\u5f55");
        if (items == null || items.isEmpty()) {
            return items;
        }
        String itemsObject = "";
        try {
            itemsObject = JSONUtils.toString(items);
        }
        catch (IOException e) {
            log.info("\u53c2\u6570\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        log.info("\u4fee\u6539\u524d\u5ba1\u6279\u8bb0\u5f55: " + itemsObject);
        if (!this.thirdCommenCheck(items)) {
            log.info("\u5ba1\u6279\u8bb0\u5f55\u6ca1\u6709\u7b2c\u4e09\u65b9\u8bb0\u5f55");
            if (!UpdateAuditMsgListener.getSSCConfigParam("formatFlowRecordNewApi")) {
                items = this.formatFlowRecordsOrgin(items);
            }
            return items;
        }
        Iterator<IApprovalRecordItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            IApprovalRecordItem recordItem = iterator.next();
            if (!StringUtils.equals((CharSequence)recordItem.getSource(), (CharSequence)"comment")) continue;
            iterator.remove();
        }
        boolean recordSortDesc = WfConfigurationUtil.getRecordSortDesc();
        try {
            if (recordSortDesc) {
                items.sort((s2, s1) -> this.strToDate(s1.getTime()).compareTo(this.strToDate(s2.getTime())));
            } else {
                items.sort((s1, s2) -> this.strToDate(s1.getTime()).compareTo(this.strToDate(s2.getTime())));
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38,\u8d70\u539f\u59cb\u65f6\u95f4\u6392\u5e8f");
        }
        try {
            itemsObject = JSONUtils.toString(items);
        }
        catch (IOException e) {
            log.error("\u53c2\u6570\u5e8f\u5217\u5316\u5f02\u5e38");
        }
        log.info("\u4fee\u6539\u540e\u5ba1\u6279\u8bb0\u5f55: " + itemsObject);
        return items;
    }

    private boolean thirdCommenCheck(List<IApprovalRecordItem> items) {
        long count = items.stream().filter(item -> StringUtils.equals((CharSequence)item.getSource(), (CharSequence)"thirdComment")).count();
        return count > 0L;
    }

    private Date strToDate(String str) {
        SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = longformat.parse(str);
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
        }
        return date;
    }

    private List<IApprovalRecordItem> formatFlowRecordsOrgin(List<IApprovalRecordItem> items) {
        List modifiedItems;
        boolean modified;
        log.info("\u4fee\u6539\u5ba1\u6279\u8bb0\u5f55\u65e7\u63a5\u53e3");
        if (items == null || items.isEmpty()) {
            return items;
        }
        Long billId = 0L;
        Long workflowId = 0L;
        String activityId = "";
        IApprovalRecordItem item = null;
        try {
            item = items.get(0);
            billId = Long.valueOf(item.getBusinessKey());
            workflowId = Long.valueOf(item.getTaskId());
            activityId = item.getActivityId();
        }
        catch (NumberFormatException e) {
            log.error(String.format("UpdateAuditMsgListener.formatFlowRecords: \u5165\u53c2\u6709\u8bef => billId: %d, workflowId: %d, activityId: %s", billId, workflowId, activityId), (Throwable)e);
            return items;
        }
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"modifyWfAuditMsgNew", (Object[])new Object[]{billId, workflowId, activityId});
            modified = result.getOrDefault("callSucceed", Boolean.FALSE);
            modifiedItems = (List)result.get("callResult");
        }
        catch (Exception e) {
            log.error("UpdateAuditMsgListener.formatFlowRecords: \u4fee\u6539\u5ba1\u6279\u8bb0\u5f55\u65e7\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return items;
        }
        log.info("\u63a5\u53e3\u8c03\u7528\u7ed3\u679c: " + modified);
        if (!modified || modifiedItems == null || modifiedItems.isEmpty()) {
            return items;
        }
        IApprovalRecordItem imageItem = null;
        boolean imageUnready = false;
        try {
            for (IApprovalRecordItem sitem : items) {
                if (sitem.getResult() == null || !sitem.getResult().contains(ResManager.loadKDString((String)"\u5f71\u50cf", (String)"", (String)"", (Object[])new Object[0]))) continue;
                imageItem = sitem;
                if (!sitem.getResult().equals(ResManager.loadKDString((String)"\u5f85\u5f71\u50cf\u4e0a\u4f20", (String)"", (String)"", (Object[])new Object[0]))) continue;
                imageUnready = true;
            }
        }
        catch (Exception e) {
            log.error("UpdateAuditMsgListener.formatFlowRecords: \u83b7\u53d6\u5f71\u50cf\u5ba1\u6279\u8bb0\u5f55\u65e7\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return items;
        }
        if (imageItem != null) {
            modifiedItems.add(1, imageItem);
            if (imageUnready) {
                Iterator iterator = modifiedItems.iterator();
                while (iterator.hasNext()) {
                    IApprovalRecordItem scanItem = (IApprovalRecordItem)iterator.next();
                    if (scanItem.getResult() == null || !scanItem.getResult().equals(ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"", (String)"", (Object[])new Object[0]))) continue;
                    iterator.remove();
                }
            }
        }
        log.info("\u4fee\u6539\u540e\u5ba1\u6279\u8bb0\u5f55: " + modifiedItems.toString());
        return modifiedItems;
    }

    public static boolean getSSCConfigParam(String key) {
        Object paramvalue;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)key)});
        return dynamicObject == null || !"false".equals(paramvalue = dynamicObject.get("paramvalue"));
    }
}

