/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fbd.entitymap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class EntityMapNoneBotpPushAction
extends AbstractOpBizRuleAction {
    private static Log logger = LogFactory.getLog(EntityMapNoneBotpPushAction.class);
    private Map<String, DynamicObject> entityMapInfo = new HashMap<String, DynamicObject>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("billstatus");
        fields.add("billno");
        Map<String, DynamicObject> entityMap = this.getEntityMap();
        if (entityMap != null && entityMap.size() > 0) {
            fields.addAll(this.billEntityType.getAllFields().keySet());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Map<String, DynamicObject> entityMaps = this.getEntityMap();
        if (entityMaps == null || entityMaps.size() < 1) {
            return;
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        try {
            for (DynamicObject tagDataEntity : dataEntities) {
                HashMap<String, Long> msBatchParams = new HashMap<String, Long>(dataEntities.length);
                for (Map.Entry<String, DynamicObject> entry : entityMaps.entrySet()) {
                    String bizType = entry.getKey();
                    DynamicObject entityMap = entry.getValue();
                    boolean isCycExe = entityMap.getBoolean("iscycexe");
                    if (!isCycExe && "save".equals(this.operateMeta.get("key")) && tagDataEntity.getDataEntityState().getFromDatabase()) {
                        logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction isNotCycExe bizId={}", tagDataEntity.getPkValue());
                        continue;
                    }
                    Long entityMapId = entityMap.getLong("id");
                    if (this.judgeIsMatchCondition(entityMap, tagDataEntity)) {
                        msBatchParams.put(bizType, entityMapId);
                        continue;
                    }
                    logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction IsNotMatchCondition bizId={}", tagDataEntity.getPkValue());
                }
                if (msBatchParams.size() <= 0) continue;
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"EntityMapMServiceImpl", (String)"execute", (Object[])new Object[]{tagDataEntity, msBatchParams});
            }
        }
        catch (Exception ex) {
            logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction exec error :{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            logger.error((Throwable)ex);
        }
    }

    private Map<String, DynamicObject> getEntityMap() {
        if (this.entityMapInfo == null || this.entityMapInfo.size() < 1) {
            QFilter newQFilter = new QFilter("tagentity.number", "=", (Object)this.billEntityType.getName()).and("biztype", "in", Arrays.asList("nonebotp", "attachment", "change")).and("checkop", "like", (Object)("%" + this.operateMeta.get("key") + "%")).and("enable", "=", (Object)"1");
            try {
                DynamicObjectCollection results = QueryServiceHelper.query((String)"fbd_entitymapmodel", (String)"id,datafilter,biztype,iscycexe,datafilter_tag,entryentity.targetfield", (QFilter[])newQFilter.toArray());
                if (results != null && !results.isEmpty()) {
                    HashMap<String, DynamicObject> bizResults = new HashMap<String, DynamicObject>(16);
                    Map<String, List<DynamicObject>> biztypeMaps = results.stream().collect(Collectors.groupingBy(o -> o.getString("biztype")));
                    for (Map.Entry<String, List<DynamicObject>> entry : biztypeMaps.entrySet()) {
                        String bizType = entry.getKey();
                        List<DynamicObject> bizTypeDos = entry.getValue();
                        if (Arrays.asList("nonebotp", "change").contains(bizType) && bizTypeDos.stream().map(o -> o.getString("entryentity.targetfield")).allMatch(StringUtils::isBlank)) {
                            logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction result: entryentity.targetfield is empty, cannot do this biz");
                            continue;
                        }
                        Set idSets = bizTypeDos.stream().map(o -> o.get("id")).collect(Collectors.toSet());
                        if (idSets.size() == 1) {
                            bizResults.put(bizType, bizTypeDos.get(0));
                            continue;
                        }
                        logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction result: biztype ={} dataIds ={} is not only one , cannot do this biz", (Object)bizType, idSets);
                    }
                    this.entityMapInfo = bizResults;
                    return this.entityMapInfo;
                }
                logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction query is empty");
            }
            catch (Exception e) {
                logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction  query and deal error :{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.error((Throwable)e);
            }
        }
        return this.entityMapInfo;
    }

    private boolean judgeIsMatchCondition(DynamicObject entityMap, DynamicObject bill) {
        String filterStr = entityMap.getString("datafilter_tag");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            try {
                CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
                ConditionFactory conditionFactory = new ConditionFactory();
                conditionFactory.init(targetCondition, bill.getDataEntityType().getName());
                DynamicObject obj = conditionFactory.convertToPlainObject(bill, conditionFactory.getAllFields(targetCondition));
                return conditionFactory.isMatchCondition(obj);
            }
            catch (Exception e) {
                logger.info("fbd_entitymapmodel EntityMapNoneBotpPushAction judgeIsMatchCondition error :{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.error((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

