/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fcs;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.model.PayAccessCheckResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.MutexServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PayAccessAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(PayAccessAction.class);
    private static final List<String> CHECK_RESULT = Arrays.asList("no_repeat", "pass");
    private static final String PAYACCESSCHECKRESULT = "payAccessCheckResult";
    private static final String DESTBILLNOPAYACCESS = "destBillNoPayAccess";
    private static final String HASPAYACCESSRECORDSET = "hasPayAccessRecordSet";
    public static final String REPEATCTRL = "repeatctrl";
    private List<String> requestIds;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        DynamicObjectCollection payAccess = this.queryPayAccess(this.billEntityType.getName());
        QFilter qFilter = new QFilter("ctrlentity.number", "=", (Object)this.billEntityType.getName());
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection checkctrl = QueryServiceHelper.query((String)"fcs_checkctrl", (String)"srcbillidfield,entryentity.targetamtfield", (QFilter[])qFilter.toArray());
        Set fieldSet = payAccess.stream().filter(s -> EmptyUtil.isNoEmpty(s.getString("destlkpkfield"))).map(s -> s.getString("destlkpkfield")).collect(Collectors.toSet());
        fieldSet.addAll(checkctrl.stream().filter(s -> EmptyUtil.isNoEmpty(s.getString("srcbillidfield"))).map(s -> s.getString("srcbillidfield")).collect(Collectors.toSet()));
        fieldSet.addAll(checkctrl.stream().filter(s -> EmptyUtil.isNoEmpty(s.getString("entryentity.targetamtfield"))).map(s -> s.getString("entryentity.targetamtfield")).collect(Collectors.toSet()));
        fields.addAll(fieldSet);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block8: {
                    try {
                        if (this.dataEntities.length > 0) {
                            logger.info(this.dataEntities[0].getDataEntity().getDynamicObjectType().getDisplayName() + "call PayAccessAction");
                        }
                        boolean isFullNodeCtrl = PayAccessAction.isFullNodeCtrl();
                        String entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
                        boolean isBlackList = PayAccessAction.isInBlackList(entityName);
                        if (!isFullNodeCtrl && !isBlackList) {
                            DynamicObjectCollection payAccess = PayAccessAction.this.queryPayAccess(PayAccessAction.this.billEntityType.getName());
                            boolean isEmptyPayAccess = EmptyUtil.isEmpty(payAccess);
                            logger.info("Action:\u652f\u4ed8\u8282\u70b9\uff0c\u76ee\u6807\u5355\u4e0d\u5728\u9ed1\u540d\u5355\u5185,\u4e0d\u8d70\u68c0\u67e5\u94fe\u8def\u903b\u8f91\u3002" + isEmptyPayAccess);
                            if (isEmptyPayAccess) {
                                this.getOption().setVariableValue(PayAccessAction.PAYACCESSCHECKRESULT, PayAccessAction.DESTBILLNOPAYACCESS);
                                return;
                            }
                        }
                        DynamicObjectCollection colls = new DynamicObjectCollection();
                        Set idSet = Arrays.stream(this.dataEntities).map(v -> v.getDataEntity().getPkValue()).collect(Collectors.toSet());
                        Set hasPayAccessRecordIdSet = PayAccessAction.getHasPayAccessRecordIdSet(idSet);
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            boolean hasNoRecord;
                            if ("delete".equals(this.getOperateKey())) continue;
                            DynamicObject bill = dataEntity.getDataEntity();
                            boolean bl = hasNoRecord = !hasPayAccessRecordIdSet.contains(bill.getLong("id"));
                            if (!hasNoRecord) continue;
                            colls.add((Object)bill);
                        }
                        this.getOption().setVariableValue(PayAccessAction.HASPAYACCESSRECORDSET, JSON.toJSONString((Object)hasPayAccessRecordIdSet));
                        if (colls.size() > 0) {
                            Map checkResult = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"payAccessService", (String)"checkPayAccess", (Object[])new Object[]{colls.toArray((Object[])new DynamicObject[0]), this.getOption().getVariables(), isFullNodeCtrl, isBlackList});
                            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                                PayAccessCheckResult result;
                                Object id = dataEntity.getDataEntity().getPkValue();
                                if (!checkResult.containsKey(id) || !EmptyUtil.isNoEmpty((result = (PayAccessCheckResult)JSON.parseObject((String)((String)checkResult.get(id)), PayAccessCheckResult.class)).getCheckResult()) || CHECK_RESULT.contains(result.getCheckResult())) continue;
                                this.addErrorMessage(dataEntity, result.getCheckResult());
                            }
                            this.getOption().setVariableValue(PayAccessAction.PAYACCESSCHECKRESULT, JSON.toJSONString((Object)checkResult));
                        }
                    }
                    catch (Exception ex) {
                        logger.info(ex.getMessage(), (Object)ex);
                        if (!(ex instanceof KDBizException)) break block8;
                        throw ex;
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block6: {
            super.endOperationTransaction(e);
            try {
                logger.info("variables:{" + this.getOption().getVariables().keySet() + "->" + this.getOption().getVariables().values() + "}");
                if (this.getOption().getVariables().containsKey(PAYACCESSCHECKRESULT) && DESTBILLNOPAYACCESS.equals(this.getOption().getVariableValue(PAYACCESSCHECKRESULT))) {
                    return;
                }
                String operationKey = e.getOperationKey();
                if ("delete".equals(operationKey)) {
                    Set idSet = Arrays.stream(e.getDataEntities()).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                    DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"payAccessService", (String)"deletePayAccess", (Object[])new Object[]{idSet});
                } else {
                    DynamicObject[] bills = this.filterNoCheckRepeatBill(e.getDataEntities());
                    if (bills.length > 0) {
                        this.requestIds = (List)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"payAccessService", (String)"savePayAccessAndCheckRepeat", (Object[])new Object[]{bills, operationKey, this.getOption().getVariables()});
                    }
                }
            }
            catch (Exception ex) {
                logger.info(ex.getMessage(), (Object)ex);
                if (!(ex instanceof KDBizException)) break block6;
                throw ex;
            }
        }
    }

    private DynamicObject[] filterNoCheckRepeatBill(DynamicObject[] bills) {
        DynamicObjectCollection newCol = new DynamicObjectCollection();
        if (this.getOption().getVariables().containsKey(PAYACCESSCHECKRESULT)) {
            String payAccessCheckResult = (String)this.getOption().getVariables().get(PAYACCESSCHECKRESULT);
            Map resultMap = (Map)JSON.parseObject((String)payAccessCheckResult, Map.class);
            String hasPayAccessRecordIdSet = this.getOption().getVariableValue(HASPAYACCESSRECORDSET);
            Set PayAccessRecordIdSet = (Set)JSON.parseObject((String)hasPayAccessRecordIdSet, Set.class);
            for (DynamicObject bill : bills) {
                Object id = bill.getPkValue();
                if (resultMap.containsKey(0) || resultMap.containsKey(id)) {
                    Object getId = 0;
                    if (resultMap.containsKey(id)) {
                        getId = id;
                    }
                    logger.info("Map\u4e2d\u4f20\u5165\u7684Key:getId={},0\u8868\u793a\u7b2c\u4e00\u6b21\u65b0\u589e", getId);
                    PayAccessCheckResult result = (PayAccessCheckResult)JSON.parseObject((String)resultMap.get(getId).toString(), PayAccessCheckResult.class);
                    if ("no_repeat".equals(result.getCheckResult()) || EmptyUtil.isNoEmpty(result.getCheckResult()) && !CHECK_RESULT.contains(result.getCheckResult())) {
                        logger.info(id + ": no_repeat");
                        continue;
                    }
                    newCol.add((Object)bill);
                    continue;
                }
                if (!PayAccessRecordIdSet.contains(id)) continue;
                newCol.add((Object)bill);
            }
            return (DynamicObject[])newCol.toArray((Object[])new DynamicObject[0]);
        }
        return bills;
    }

    private static Set<Long> getHasPayAccessRecordIdSet(Set<Object> pks) {
        QFilter qFilter = new QFilter("destbillpkid", "in", pks);
        Map payAccessRecord = BusinessDataServiceHelper.loadFromCache((String)"fcs_payaccess_record", (QFilter[])qFilter.toArray());
        return payAccessRecord.values().stream().map(v -> v.getLong("destbillpkid")).collect(Collectors.toSet());
    }

    private static boolean isFullNodeCtrl() {
        DynamicObject ctrlNode = PayAccessAction.getPayAccessNode();
        if (ctrlNode != null) {
            return ctrlNode.getBoolean("isfulllink");
        }
        return false;
    }

    private static DynamicObject getPayAccessNode() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess_set", (QFilter[])qFilter.toArray());
    }

    private static boolean isInBlackList(String destEntity) {
        DynamicObject entity = PayAccessAction.getBlackListByEntity(destEntity);
        return EmptyUtil.isNoEmpty(entity);
    }

    private static DynamicObject getBlackListByEntity(String destEntity) {
        QFilter qFilter = new QFilter("destentity.number", "=", (Object)destEntity);
        qFilter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fcs_payaccess_blacklist", (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection queryPayAccess(String entityName) {
        QFilter qFilter = new QFilter("destentity.number", "=", (Object)entityName);
        qFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"fcs_payaccess", (String)"destlkpkfield", (QFilter[])qFilter.toArray());
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.requestIds != null && this.requestIds.size() > 0) {
            MutexServiceHelper.batchRelease(this.requestIds, this.billEntityType.getName(), REPEATCTRL);
            logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(this.requestIds));
        }
    }
}

