/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;

public class SyncTableManager {
    private static SyncTableManager instance;
    private final Map<String, Boolean> initMap = new HashMap<String, Boolean>(8);
    private static final String TABLE_SUFFIX = "_fpmsyn";
    private static final String CREATE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s')CREATE TABLE %s (FID BIGINT DEFAULT 0 NOT NULL,FSYNC INT DEFAULT 0 NOT NULL,FVERSION INT DEFAULT 1 NOT NULL,FMODIFY_TIME DATETIME);";
    private static final String PK_INDEX_SQL = "EXEC P_ALTERPK 'PK_%s', '%s', 'FID', '1';";
    private static final String INDEX_SQL = " IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s_FID_SYNC') CREATE INDEX %s_FID_SYNC ON %s ( FID ,FSYNC );";
    private static final String INSERT_SQL = "insert into %s(FID, FSYNC, FVERSION, FMODIFY_TIME) values(?, ?, ?, ?);";
    private static final String UPDATE_SQL = "update %s set FSYNC = ?, FVERSION = FVERSION + 1, FMODIFY_TIME = ? where FID in (%s);";
    private static final String SNYC_SQL = "update %s set FSYNC = ? where FID = ? and FVERSION <= ? and FSYNC = ?;";
    private static final String QUERY_SQL = "select FID, FSYNC, FVERSION, FMODIFY_TIME from %s where FID in (%s);";
    private static final String QUERY_DISCARD_SQL = "select FID, FSYNC, FVERSION, FMODIFY_TIME from %s where FSYNC = ?;";
    private static final String QUERY_DISCARD_ID_SQL = "select FID from %s where FID in (%s) and FSYNC in (%s);";

    private SyncTableManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SyncTableManager getInstance() {
        if (instance != null) return instance;
        Class<SyncTableManager> clazz = SyncTableManager.class;
        synchronized (SyncTableManager.class) {
            if (instance != null) return instance;
            instance = new SyncTableManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initTable(String routeKey, String tableName) {
        if (routeKey != null && !this.isInit(routeKey, tableName)) {
            this.doInitTable(routeKey, tableName);
        } else {
            if (routeKey == null) {
                throw new KDBizException("SyncTable init failed, route key is null.");
            }
            if (tableName == null) {
                throw new KDBizException("SyncTable init failed, tableName is null.");
            }
        }
    }

    public List<SyncData> querySyncData(String routeKey, String tableName, List<Long> idList) {
        this.initTable(routeKey, tableName);
        DataSet dataSet = DB.queryDataSet((String)SyncTableManager.class.getName(), (DBRoute)DBRoute.of((String)routeKey), (String)this.getQuerySql(tableName, idList));
        ArrayList<SyncData> syncDataList = new ArrayList<SyncData>(8);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            syncDataList.add(this.rowToData(row));
        }
        return syncDataList;
    }

    public List<SyncData> queryDiscardInfo(String routeKey, String tableName) {
        this.initTable(routeKey, tableName);
        DataSet dataSet = DB.queryDataSet((String)SyncTableManager.class.getName(), (DBRoute)DBRoute.of((String)routeKey), (String)this.getQueryDiscardSql(tableName), (Object[])new Object[]{2});
        ArrayList<SyncData> discardIdList = new ArrayList<SyncData>(8);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            discardIdList.add(this.rowToData(row));
        }
        return discardIdList;
    }

    private SyncData rowToData(Row row) {
        SyncData syncData = new SyncData();
        syncData.setId(row.getLong("FID"));
        syncData.setVersion(row.getInteger("FVERSION"));
        syncData.setStatus(row.getInteger("FSYNC"));
        syncData.setModifyTime(row.getDate("FMODIFY_TIME"));
        return syncData;
    }

    public List<Long> queryDiscardId(String routeKey, String tableName, List<Long> idList) {
        this.initTable(routeKey, tableName);
        DataSet dataSet = DB.queryDataSet((String)SyncTableManager.class.getName(), (DBRoute)DBRoute.of((String)routeKey), (String)this.getQueryDiscardSql(tableName, idList, Arrays.asList(2, 3)), null);
        ArrayList<Long> discardIdList = new ArrayList<Long>(8);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            discardIdList.add(row.getLong("FID"));
        }
        return discardIdList;
    }

    public void insertSyncRecords(String routeKey, String tableName, int syncStatus, List<Long> idList) {
        this.initTable(routeKey, tableName);
        if (idList == null || idList.size() == 0) {
            return;
        }
        Date now = new Date();
        List paramList = idList.stream().map(o -> new Object[]{o, syncStatus, 1, now}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)this.getInsertSql(tableName), paramList);
    }

    public void updateSyncRecords(String routeKey, String tableName, List<Long> idList, int status) {
        this.initTable(routeKey, tableName);
        if (idList == null || idList.size() == 0) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getUpdateSql(tableName, idList), (Object[])new Object[]{status, new Date()});
    }

    public void syncRecord(String routeKey, String tableName, List<SyncData> syncDataList, int statusBefore, int statusAfter) {
        this.initTable(routeKey, tableName);
        if (syncDataList == null || syncDataList.size() == 0) {
            return;
        }
        List paramList = syncDataList.stream().map(o -> new Object[]{statusAfter, o.getId(), o.getVersion(), statusBefore}).collect(Collectors.toList());
        DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)this.getSyncSql(tableName), paramList);
    }

    private boolean isInit(String routeKey, String tableName) {
        return this.initMap.getOrDefault(this.getKey(routeKey, tableName), false);
    }

    private String getKey(String routeKey, String tableName) {
        return routeKey + "!" + tableName;
    }

    private synchronized void doInitTable(String routeKey, String tableName) {
        if (!this.isInit(routeKey, tableName)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)this.getTableName(tableName));
                    if (!exists) {
                        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getCreateSql(tableName));
                        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getPkIndexSql(tableName));
                        DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)this.getIndexSql(tableName));
                    }
                    this.initMap.put(routeKey, Boolean.TRUE);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private String getCreateSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(CREATE_SQL, syncTableName, syncTableName);
    }

    private String getPkIndexSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(PK_INDEX_SQL, syncTableName, syncTableName);
    }

    private String getIndexSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(INDEX_SQL, syncTableName, syncTableName, syncTableName);
    }

    private String getInsertSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(INSERT_SQL, syncTableName);
    }

    private String getUpdateSql(String tableName, List<Long> idList) {
        String syncTableName = this.getTableName(tableName);
        return String.format(UPDATE_SQL, syncTableName, this.getInIdParameter(idList));
    }

    private String getQuerySql(String tableName, List<Long> idList) {
        String syncTableName = this.getTableName(tableName);
        return String.format(QUERY_SQL, syncTableName, this.getInIdParameter(idList));
    }

    private String getQueryDiscardSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(QUERY_DISCARD_SQL, syncTableName);
    }

    private String getQueryDiscardSql(String tableName, List<Long> idList, List<Integer> statusList) {
        String syncTableName = this.getTableName(tableName);
        return String.format(QUERY_DISCARD_ID_SQL, syncTableName, this.getInIdParameter(idList), this.getInIdParameter(statusList));
    }

    private String getSyncSql(String tableName) {
        String syncTableName = this.getTableName(tableName);
        return String.format(SNYC_SQL, syncTableName);
    }

    private <T> String getInIdParameter(List<T> ctrRecordList) {
        return ctrRecordList.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private String getTableName(String tableName) {
        return (tableName + TABLE_SUFFIX).toUpperCase();
    }
}

