/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.ifm;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.tmc.enums.BillStrategyEnum;
import kd.bos.ext.tmc.enums.LimitWayEnum;
import kd.bos.ext.tmc.model.StrategyCheckResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InnerStrategyValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(InnerStrategyValidator.class);

    public void validate() {
        long startTime = System.currentTimeMillis();
        logger.info("InnerStrategyValidator\u6267\u884c\u6821\u9a8c\u5355\u636e\u63a7\u5236\u7b56\u7565start\uff1a{} ms", (Object)startTime);
        String operateKey = this.getOperateKey();
        String entityNumber = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        Map<Object, DynamicObject> strategySetting = this.queryStrategySetting(operateKey, entityNumber);
        HashMap<String, StrategyCheckResult> resultMap = new HashMap<String, StrategyCheckResult>(16);
        for (ExtendedDataEntity dataEntitie : this.dataEntities) {
            DynamicObject bill = dataEntitie.getDataEntity();
            for (DynamicObject billStrategy : strategySetting.values()) {
                String currencyPropVal;
                String amountPropVal;
                boolean isMatchCondition = this.judgeIsMatchCondition(billStrategy, bill);
                if (!isMatchCondition) continue;
                String acctPropVal = billStrategy.getString("inneracctpropval");
                if (EmptyUtil.isAnyoneEmpty(acctPropVal, amountPropVal = billStrategy.getString("checkfieldval"), currencyPropVal = billStrategy.getString("checkcurrencyprop"))) {
                    this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u8d26\u6237\u7ba1\u7406\u7b56\u7565\u5bf9\u5e94\u7684\u5355\u636e\u63a7\u5236\u7b56\u7565\u201c%s\u201d\u5b58\u5728\u5b57\u6bb5\u503c\u7f3a\u5931\uff0c\u8bf7\u5148\u5230\u5f00\u53d1\u5e73\u53f0\u5143\u6570\u636e\u201difm_strategysetting\u201c\u9884\u89c8\u5217\u8868\u540e\u7ef4\u62a4\u5b8c\u6574\u3002", (String)"AM-E-554125", (String)"bos-ext-tmc", (Object[])new Object[]{billStrategy.getString("name")}));
                    continue;
                }
                DynamicObject billCurrency = bill.getDynamicObject(currencyPropVal);
                if (acctPropVal.contains(".") && amountPropVal.contains(".")) {
                    String entryPropStr = acctPropVal.split("\\.")[0];
                    String entryAcctFiledPropStr = acctPropVal.split("\\.")[1];
                    String entryFiledAmtPropStr = amountPropVal.split("\\.")[1];
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryPropStr);
                    Map<DynamicObject, BigDecimal> groupMap = entrys.stream().filter(s -> EmptyUtil.isNoEmpty(s.getDynamicObject(entryAcctFiledPropStr))).collect(Collectors.groupingBy(a -> a.getDynamicObject(entryAcctFiledPropStr), Collectors.mapping(m -> m.getBigDecimal(entryFiledAmtPropStr), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
                    for (Map.Entry<DynamicObject, BigDecimal> map : groupMap.entrySet()) {
                        DynamicObject billAccount = map.getKey();
                        BigDecimal billAmount = map.getValue();
                        if (BigDecimal.ZERO.compareTo(billAmount) == 0 || EmptyUtil.isEmpty(billCurrency)) {
                            logger.info("InnerStrategyValidator:\u8d26\u53f7\u3001\u91d1\u989d\u3001\u5e01\u522b\u5b58\u5728\u7a7a\u503c\uff0c\u8df3\u8fc7\u6821\u9a8c");
                            continue;
                        }
                        StrategyCheckResult checkResult = this.getStrategyCheckResult(resultMap, billStrategy, billAccount, billCurrency, bill);
                        this.validateStrategy(dataEntitie, checkResult, billAccount, billAmount, bill);
                    }
                    continue;
                }
                if (acctPropVal.contains(".") || amountPropVal.contains(".")) continue;
                DynamicObject billAccount = bill.getDynamicObject(acctPropVal);
                BigDecimal billAmount = bill.getBigDecimal(amountPropVal);
                if (EmptyUtil.isEmpty(billAccount) || BigDecimal.ZERO.compareTo(billAmount) == 0 || EmptyUtil.isEmpty(billCurrency)) {
                    logger.info("InnerStrategyValidator:\u8d26\u53f7\u3001\u91d1\u989d\u3001\u5e01\u522b\u5b58\u5728\u7a7a\u503c\uff0c\u8df3\u8fc7\u6821\u9a8c");
                    continue;
                }
                StrategyCheckResult checkResult = this.getStrategyCheckResult(resultMap, billStrategy, billAccount, billCurrency, bill);
                this.validateStrategy(dataEntitie, checkResult, billAccount, billAmount, bill);
            }
        }
        logger.info("InnerStrategyValidator\u6267\u884c\u6821\u9a8c\u5355\u636e\u63a7\u5236\u7b56\u7565end\uff1a{} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private StrategyCheckResult getStrategyCheckResult(Map<String, StrategyCheckResult> resultMap, DynamicObject billStrategy, DynamicObject billAccount, DynamicObject billCurrency, DynamicObject bill) {
        Object billStrategyId = billStrategy.getPkValue();
        String accountNumber = this.getAccountNumber(billAccount);
        String currencyNumber = billCurrency.getString("number");
        String mapKey = billStrategyId + "#" + accountNumber + "#" + currencyNumber;
        StrategyCheckResult checkResult = resultMap.getOrDefault(mapKey, new StrategyCheckResult());
        boolean checkDone = checkResult.isCheckDone();
        if (checkDone) {
            return checkResult;
        }
        DynamicObject strategy = this.queryAmStrategy(billAccount, billCurrency);
        if (strategy == null) {
            checkResult.setCheckDone(Boolean.TRUE);
            resultMap.put(mapKey, checkResult);
            return checkResult;
        }
        long billAccountId = billAccount.getLong("id");
        long billCurrencyId = billCurrency.getLong("id");
        boolean isLimitStrgy = strategy.getBoolean("islimitstrgy");
        for (BillStrategyEnum billStrategyEnum : BillStrategyEnum.values()) {
            String detail;
            String entryProp = billStrategyEnum.getEntryProp();
            boolean isCheck = false;
            if (BillStrategyEnum.OVERENTRY.getEntryProp().equals(entryProp)) {
                isCheck = strategy.getBoolean("isoverstrgy");
            } else if (BillStrategyEnum.LIMITENTRY.getEntryProp().equals(entryProp)) {
                boolean isPayLimit = strategy.getBoolean("ispaylimit");
                isCheck = isLimitStrgy && isPayLimit;
            } else if (BillStrategyEnum.KEEPENTRY.getEntryProp().equals(entryProp)) {
                boolean isBalLimit = strategy.getBoolean("isballimit");
                boolean bl = isCheck = isLimitStrgy && isBalLimit;
            }
            if (!isCheck) {
                logger.info(entryProp + "InnerStrategyValidator:\u6ca1\u6709\u5f00\u542f\u900f\u652f\u6216\u5f00\u542f\u8d26\u6237\u652f\u4ed8\u9650\u989d\u6216\u8d26\u6237\u7559\u5b58\u9650\u989d");
                continue;
            }
            boolean same = this.isSameOp(strategy, entryProp, billStrategyId);
            logger.info("InnerStrategyValidator:\u68c0\u9a8c\u5206\u5f55:{}\uff0c\u5355\u636e\u63a7\u5236\u7b56\u7565\u540d\u79f0:{}\uff0c\u64cd\u4f5c\u662f\u5426\u76f8\u540c:{}\uff0c\u8d26\u6237\u7ba1\u7406\u7b56\u7565\u7f16\u7801\uff1a{}", new Object[]{entryProp, billStrategy.getString("name"), same, strategy.getString("number")});
            if (!same) continue;
            Long billId = bill.getLong("id");
            DynamicObject modelType = billStrategy.getDynamicObject("modeltype");
            DynamicObject balanceModel = billStrategy.getDynamicObject("balancemodel");
            if (EmptyUtil.isNoEmpty(balanceModel)) {
                detail = modelType.getString("detail");
                boolean checkAmt = true;
                if (EmptyUtil.isNoEmpty(detail)) {
                    String limitAmtProp = LimitWayEnum.getLimitAmtProp(detail);
                    BigDecimal amt = strategy.getBigDecimal(limitAmtProp);
                    boolean bl = checkAmt = BigDecimal.ZERO.compareTo(amt) < 0;
                }
                if (checkAmt) {
                    Pair<Set<Long>, BigDecimal> balance = this.invokeServiceGetBalance(billStrategy, billAccountId, billCurrencyId);
                    checkResult.setBalanceModelName(balanceModel.getString("name"));
                    checkResult.setCheckBalance(Boolean.TRUE);
                    checkResult.setBalance((BigDecimal)balance.getRight());
                    checkResult.setBillIds((Set)balance.getLeft());
                    checkResult.setControlType(entryProp);
                    checkResult.setOverWorn(strategy.getBoolean("isoverworn"));
                    checkResult.setLimitWay(detail);
                }
            }
            if (!BillStrategyEnum.LIMITENTRY.getEntryProp().equals(entryProp)) continue;
            detail = modelType.getString("detail");
            boolean checkCount = true;
            if (EmptyUtil.isNoEmpty(detail)) {
                String limitCountProp;
                int count;
                checkCount = LimitWayEnum.SINGLE.getValue().equals(detail) ? false : (count = strategy.getInt(limitCountProp = LimitWayEnum.getLimitCountProp(detail))) > 0;
            }
            DynamicObject countModel = billStrategy.getDynamicObject("countmodel");
            if (!checkCount || !EmptyUtil.isNoEmpty(countModel)) continue;
            int count = this.invokeServiceGetCount(billStrategy, billAccountId, billCurrencyId, billId);
            checkResult.setCountModelName(countModel.getString("name"));
            checkResult.setCheckCount(Boolean.TRUE);
            checkResult.setLimitCount(count);
            checkResult.setControlType(entryProp);
        }
        checkResult.setCheckDone(Boolean.TRUE);
        resultMap.put(mapKey, checkResult);
        return checkResult;
    }

    private String getAccountNumber(DynamicObject billAccount) {
        if ("ifm_inneracct".equals(billAccount.getDynamicObjectType().getName())) {
            return billAccount.getString("number");
        }
        return billAccount.getString("bankaccountnumber");
    }

    private void validateStrategy(ExtendedDataEntity dataEntitie, StrategyCheckResult checkResult, DynamicObject billAccount, BigDecimal billAmount, DynamicObject bill) {
        boolean checkCount;
        boolean checkBalance = checkResult.isCheckBalance();
        if (checkBalance) {
            String accountNumber = this.getAccountNumber(billAccount);
            String controlType = checkResult.getControlType();
            BigDecimal balance = checkResult.getBalance();
            Long billId = bill.getLong("id");
            Set<Long> billIds = checkResult.getBillIds();
            if (billIds.contains(billId)) {
                balance = balance.add(billAmount);
            }
            logger.info("InnerStrategyValidator:\u63a7\u5236\u7c7b\u578b{},\u5f53\u524d\u91d1\u989d{},\u4f59\u989d{}", new Object[]{controlType, billAmount, balance});
            if (billAmount.compareTo(balance) > 0) {
                BigDecimal overAmt = billAmount.subtract(balance);
                if (BillStrategyEnum.OVERENTRY.getEntryProp().equals(controlType)) {
                    boolean overWorn = checkResult.isOverWorn();
                    if (overWorn) {
                        this.addWarningMessage(dataEntitie, String.format(ResManager.loadKDString((String)"%1$s\u8d26\u6237\u7684\u53ef\u7528\u4f59\u989d\u4e3a%2$s\uff0c\u672c\u5355\u53d7\u7406\u540e\u5c06\u5bfc\u81f4\u8d26\u6237\u900f\u652f%3$s\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"InnerStrategyValidator_0", (String)"bos-ext-tmc", (Object[])new Object[0]), accountNumber, balance.stripTrailingZeros().toPlainString(), overAmt.stripTrailingZeros().toPlainString()));
                    } else {
                        this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"%1$s\u8d26\u6237\u7684\u53ef\u7528\u4f59\u989d\u4e3a%2$s,\u672c\u5355\u53d7\u7406\u540e\u5c06\u5bfc\u81f4\u8d26\u6237\u900f\u652f%3$s\u3002", (String)"InnerStrategyValidator_1", (String)"bos-ext-tmc", (Object[])new Object[0]), accountNumber, balance.stripTrailingZeros().toPlainString(), overAmt.stripTrailingZeros().toPlainString()));
                    }
                } else if (BillStrategyEnum.LIMITENTRY.getEntryProp().equals(controlType)) {
                    this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"%1$s\u8d26\u6237\u7684%2$s\u53ef\u7528\u91d1\u989d\u4e3a%3$s,\u672c\u5355\u53d7\u7406\u540e\u5c06\u5bfc\u81f4\u8d26\u6237\u8d85\u8fc7%2$s%4$s\u3002", (String)"InnerStrategyValidator_2", (String)"bos-ext-tmc", (Object[])new Object[0]), accountNumber, checkResult.getBalanceModelName(), balance.stripTrailingZeros().toPlainString(), overAmt.stripTrailingZeros().toPlainString()));
                } else if (BillStrategyEnum.KEEPENTRY.getEntryProp().equals(controlType)) {
                    this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"%1$s\u8d26\u6237\u7684\u6700\u4f4e\u7559\u5b58\u91d1\u989d\u4e3a%2$s,\u672c\u5355\u53d7\u7406\u540e\u5c06\u5bfc\u81f4\u8d26\u6237\u8d85\u8fc7\u6700\u4f4e\u7559\u5b58\u9650\u989d%3$s\u3002", (String)"InnerStrategyValidator_3", (String)"bos-ext-tmc", (Object[])new Object[0]), accountNumber, balance.stripTrailingZeros().toPlainString(), overAmt.stripTrailingZeros().toPlainString()));
                }
            } else if (!LimitWayEnum.SINGLE.getValue().equals(checkResult.getLimitWay())) {
                checkResult.setBalance(balance.subtract(billAmount));
            }
        }
        if (checkCount = checkResult.isCheckCount()) {
            int limitCount = checkResult.getLimitCount();
            if (limitCount == 0) {
                String accountNumber = this.getAccountNumber(billAccount);
                this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"%1$s\u8d26\u6237\u7684%2$s\u5269\u4f59%3$s,\u672c\u5355\u53d7\u7406\u540e\u5c06\u5bfc\u81f4\u8d26\u6237\u8d85\u8fc7%2$s%4$s\u7b14\u3002", (String)"InnerStrategyValidator_4", (String)"bos-ext-tmc", (Object[])new Object[0]), accountNumber, checkResult.getCountModelName(), limitCount, 1));
            } else {
                checkResult.setLimitCount(limitCount - 1);
            }
        }
    }

    private boolean isSameOp(DynamicObject strategy, String entryProp, Object billStrategyId) {
        DynamicObject entry;
        String operateKey = this.getOperateKey();
        DynamicObjectCollection entrys = strategy.getDynamicObjectCollection(entryProp);
        if (entrys.size() > 0 && (entry = (DynamicObject)entrys.stream().filter(s -> EmptyUtil.isNoEmpty(s.getDynamicObject(BillStrategyEnum.getBillStrategyProp(entryProp))) && s.getDynamicObject(BillStrategyEnum.getBillStrategyProp(entryProp)).getPkValue().equals(billStrategyId)).findFirst().orElse(null)) != null) {
            String checkOp = entry.getString(BillStrategyEnum.getCheckOpProp(entryProp));
            Set checkOpSet = Arrays.stream(checkOp.split(",")).collect(Collectors.toSet());
            if (!checkOpSet.contains(operateKey)) {
                logger.info("InnerStrategyValidator:\u5f53\u524d\u6267\u884c\u64cd\u4f5c:{}\uff0c\u4e0d\u5728\u63a7\u5236\u8303\u56f4\u5185", (Object)operateKey);
                return false;
            }
            return true;
        }
        return false;
    }

    private Pair<Set<Long>, BigDecimal> invokeServiceGetBalance(DynamicObject billStrategy, long billAccountId, long billCurrencyId) {
        DynamicObject balanceModel = billStrategy.getDynamicObject("balancemodel");
        return (Pair)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getBalanceModelIdsAndAmount", (Object[])new Object[]{balanceModel.getLong("id"), billAccountId, billCurrencyId});
    }

    private int invokeServiceGetCount(DynamicObject billStrategy, long billAccountId, long billCurrencyId, Long billId) {
        DynamicObject countModel = billStrategy.getDynamicObject("countmodel");
        return (Integer)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getCountModelNum", (Object[])new Object[]{countModel.getLong("id"), billAccountId, billCurrencyId, billId});
    }

    private DynamicObject queryAmStrategy(DynamicObject billAccount, DynamicObject billCurrency) {
        DynamicObject acctOrBank;
        QFilter acctFilter = new QFilter("id", "=", billAccount.getPkValue());
        if ("ifm_inneracct".equals(billAccount.getDynamicObjectType().getName())) {
            acctFilter.and("mgrstratg.currency.id", "=", billCurrency.getPkValue());
            acctOrBank = QueryServiceHelper.queryOne((String)"ifm_inneracct", (String)"id,mgrstratg.id as strategyid", (QFilter[])acctFilter.toArray());
        } else {
            acctFilter.and("strategy.currency.id", "=", billCurrency.getPkValue());
            acctOrBank = QueryServiceHelper.queryOne((String)"bd_accountbanks", (String)"id,strategy.id as strategyid", (QFilter[])acctFilter.toArray());
        }
        if (EmptyUtil.isEmpty(acctOrBank)) {
            logger.info("InnerStrategyValidator:\u67e5\u8be2\u8d26\u6237\u7ba1\u63a7\u7b56\u7565\u6761\u4ef6:{}", (Object)acctFilter);
            logger.info("InnerStrategyValidator:\u67e5\u8be2\u4e0d\u5230\u8d26\u6237\u7ba1\u63a7\u7b56\u7565,\u8d26\u53f7:{}\uff0c\u5e01\u522b:{}", billAccount.getPkValue(), billCurrency.getPkValue());
            return null;
        }
        long strategyId = acctOrBank.getLong("strategyid");
        QFilter amFilter = new QFilter("id", "=", (Object)strategyId);
        amFilter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"am_strategy", (QFilter[])amFilter.toArray());
    }

    private Map<Object, DynamicObject> queryStrategySetting(String operateKey, String entityName) {
        QFilter filter = new QFilter("bizbill.number", "=", (Object)entityName);
        filter.and("checkop", "like", (Object)("%" + operateKey + "%"));
        filter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"ifm_strategysetting", (String)"id,name,bizbill,inneracctpropval,checkfieldval,checkop,datafilter,datafilter_tag,balancemodel,modeltype,countmodel,strategyrange,checkcurrencyprop", (QFilter[])filter.toArray());
    }

    private boolean judgeIsMatchCondition(DynamicObject strategy, DynamicObject bill) {
        String filterStr = strategy.getString("datafilter_tag");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            ConditionFactory factory = new ConditionFactory();
            return factory.isMatchCondition(condition, bill);
        }
        return true;
    }
}

