/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.operate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.utils.commitToBe.CommitToBeFactory;
import kd.bos.ext.tmc.utils.commitToBe.ICommitToBeService;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CommitToBe
extends DefaultEntityOperate
implements ICloseCallBack {
    private static Log logger = LogFactory.getLog(CommitToBe.class);
    private Boolean isNeedPwd = false;

    public void initialize(Map<String, Object> arg0) {
        String paramValue;
        super.initialize(arg0);
        Map custParamObj = (Map)arg0.get("parameter");
        if (EmptyUtil.isNoEmpty(custParamObj) && StringUtils.isNotBlank((CharSequence)(paramValue = (String)custParamObj.get("parameter")))) {
            Map param = (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
            this.isNeedPwd = (Boolean)param.get("isneedpwd");
        }
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        this.getOption().setVariableValue("batchop_batchsize", String.valueOf(1000));
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        boolean isCheckPassCA = this.getOption().containsVariable("isCheckPassCA");
        Boolean isPassCA = this.isNeedPassword();
        if (isPassCA.booleanValue() && !isCheckPassCA) {
            Long userPK = RequestContext.get().getCurrUserId();
            QFilter[] qFilters = new QFilter[]{new QFilter("user", "=", (Object)userPK)};
            DynamicObjectCollection bankPassword = QueryServiceHelper.query((String)"cas_banketppwd", (String)"id,user,password", (QFilter[])qFilters);
            if (bankPassword != null && bankPassword.size() > 0) {
                this.showPwdForm(Boolean.FALSE);
            } else {
                this.showPwdForm(Boolean.TRUE);
            }
            return false;
        }
        return true;
    }

    protected Boolean isNeedPassword() {
        QFilter payWriteNumber;
        DynamicObject payWriteConfig;
        Boolean isNeedPassWord = Boolean.FALSE;
        if (this.isNeedPwd.booleanValue() && (payWriteConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{payWriteNumber = new QFilter("number", "=", (Object)"fi.cas.pass.ca")})) != null && "true".equals(payWriteConfig.getString("configvalue"))) {
            isNeedPassWord = Boolean.TRUE;
        }
        return isNeedPassWord;
    }

    public OperationResult invokeOperation() {
        logger.info("\u63d0\u4ea4\u94f6\u4f01\u64cd\u4f5c\u5f00\u59cb\uff1a" + System.currentTimeMillis());
        OperationResult operationResult = super.invokeOperation();
        List payBillIdList = operationResult.getSuccessPkIds();
        if (payBillIdList.size() > 0) {
            ArrayList<Pair<Long, Long>> successPairs = new ArrayList<Pair<Long, Long>>();
            payBillIdList.forEach(o -> successPairs.add(Pair.of((Object)((JSONObject)o).getLong("payBillId"), (Object)((JSONObject)o).getLong("bankBillId"))));
            try {
                ICommitToBeService service = CommitToBeFactory.getService(successPairs, this.getEntityId(), this.getView());
                service.executeOperate(operationResult);
            }
            catch (Exception e) {
                operationResult.setShowMessage(false);
                this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
                if (this.getView() instanceof IListView) {
                    ((ListView)this.getView()).refresh();
                }
                this.getView().invokeOperation("refresh");
            }
        }
        return operationResult;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map data;
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_PWD_CALLBACK")) {
            Map data2 = (Map)evt.getReturnData();
            String randomIdx = evt.getView().getPageCache().get("randomIdx");
            String opkey = evt.getView().getPageCache().get("realopkey");
            if (data2 != null && "1".equals(data2.get("loginpass")) && randomIdx.equals(data2.get("randomIdx"))) {
                OperateOption option = EmptyUtil.isEmpty(evt.getView().getPageCache().get("oldoption")) ? OperateOption.create() : (OperateOption)SerializationUtils.deSerializeFromBase64((String)evt.getView().getPageCache().get("oldoption"));
                option.setVariableValue("isCheckPassCA", "isCheckPassCA");
                option.setVariableValue("isValidated", "1");
                evt.getView().invokeOperation(opkey, option);
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"KEY_NEWPWD_CALLBACK") && (data = (Map)evt.getReturnData()) != null && "1".equals(data.get("initpass"))) {
            evt.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bc6\u7801\u6210\u529f\uff01", (String)"CommitToBe_1", (String)"bos-ext-tmc", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void showPwdForm(Boolean isNew) {
        String callbackId;
        String formId;
        long currentTimeMillis = System.currentTimeMillis();
        if (isNew.booleanValue()) {
            formId = "cas_bankpwdsetting";
            callbackId = "KEY_NEWPWD_CALLBACK";
        } else {
            formId = "cas_bankinputpwd";
            callbackId = "KEY_PWD_CALLBACK";
            this.getView().getPageCache().put("randomIdx", String.valueOf(currentTimeMillis));
            this.getView().getPageCache().put("realopkey", this.getOperateKey());
            this.getView().getPageCache().put("oldoption", SerializationUtils.serializeToBase64((Object)this.getOption()));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCustomParam("randomIdx", (Object)String.valueOf(currentTimeMillis));
        parameter.setCloseCallBack(new CloseCallBack(CommitToBe.class.getName(), callbackId));
        this.getView().showForm(parameter);
    }
}

