/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.dao.FormDesignDao;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.model.ScheduleProposalExecInfo;
import kd.bos.ext.tmc.task.AbstractScheduleExecute;
import kd.bos.ext.tmc.task.ScheduleExecuteContext;
import kd.bos.ext.tmc.utils.ScheduleExecuteUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ScheduleOperationExecute
extends AbstractScheduleExecute {
    private static final int THREAD_TOTAL = 20;
    private static final int THREAD_DATA_LIMIT = 1000;
    private static final int THREAD_DATA_LIMIT_TOTAL = 10000;
    private final Object syncObj = new Object();
    private int processThreadCount = 0;
    private static final ThreadPool threadPoolIntellPlan = ThreadPools.newFixedThreadPool((String)"tmc/fcs/scheduleOperation", (int)5);

    public ScheduleOperationExecute(ScheduleExecuteContext ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() {
        try {
            ScheduleExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
            Long scheduleSchemaId = exceOperInfo.getSchemaId();
            Date execstartdate = this.ctx.getExecstartdate();
            long sumLogId = this.ctx.getSumLogId();
            logger.info(scheduleSchemaId + "\u5f00\u59cb\u83b7\u53d6\u76ee\u6807\u6570\u636e...");
            List<QFilter> dataFilter = this.getExceDataCollectionFilter();
            logger.info("\u8fc7\u6ee4\u6761\u4ef6:" + dataFilter);
            Set idSet = QueryServiceHelper.queryPrimaryKeys((String)exceOperInfo.getBussiness(), (QFilter[])dataFilter.toArray(new QFilter[0]), (String)"id", (int)-1).stream().map(t -> (Long)t).collect(Collectors.toSet());
            int count = idSet.size();
            ScheduleProposalExecInfo execInfo = this.ctx.getSchemeExecInfo();
            execInfo.appendRecordTC(count);
            try {
                logger.info(scheduleSchemaId + "\u76ee\u6807\u6570\u636e" + count);
                if (idSet.size() == 0) {
                    logger.info("\u4efb\u52a1\u8c03\u5ea6\u4e3b\u7ebf\u7a0b\u9000\u51fa--\u6279\u5904\u7406\u6570\u636e:0");
                    String bussinessName = FormDesignDao.getDesignFormName(exceOperInfo.getBussiness());
                    String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u8be5\u65b9\u6848\u3010%1$s%2$s\u3011\u64cd\u4f5c\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"ScheduleOperationExecute_1", (String)"bos-ext-tmc", (Object[])new Object[0]), bussinessName, exceOperInfo.getOperName());
                    exceOperInfo.setExecDetails(msg);
                    exceOperInfo.setExecuteStatus(ScheduleExecuteStatus.FAIL);
                    return;
                }
                if (count > 10000) {
                    ArrayList<Future<ScheduleExecuteStatus>> resultAll = new ArrayList<Future<ScheduleExecuteStatus>>();
                    Iterator msg = this.syncObj;
                    synchronized (msg) {
                        ArrayList arrayList = new ArrayList(idSet);
                        int batchCount = (int)Math.ceil((double)count * 1.0 / 1000.0);
                        for (int batchIndex = 0; batchIndex < batchCount; ++batchIndex) {
                            if (this.processThreadCount >= 20) {
                                logger.info("\u4efb\u52a1\u8c03\u5ea6\u4e3b\u7ebf\u7a0b\u7b49\u5f85");
                                this.syncObj.wait();
                            }
                            List<Long> curBatch = 1000 * (batchIndex + 1) < count ? arrayList.subList(1000 * batchIndex, 1000 * (batchIndex + 1)) : arrayList.subList(1000 * batchIndex, count);
                            logger.info("1000\u4e00\u6279\u4efb\u52a1\u8c03\u5ea6\u4e3b\u7ebf\u7a0b\u5f00\u59cb\u5206\u53d1\u5b50\u7ebf\u7a0b");
                            this.threadCountAdd();
                            Future<ScheduleExecuteStatus> future = this.mutiThreadExecOperation(scheduleSchemaId, count, execstartdate, exceOperInfo, this, curBatch, this.getBatchSize(exceOperInfo), this.syncObj, sumLogId);
                            resultAll.add(future);
                            if (ScheduleExecuteUtil.isStopExcute(this.ctx.getSchemeExecInfo())) break;
                        }
                    }
                    for (Future future : resultAll) {
                        ScheduleExecuteStatus resultMap = (ScheduleExecuteStatus)((Object)future.get());
                        if (ScheduleExecuteStatus.FAIL != resultMap) continue;
                        this.ctx.getSchemeExecInfo().getExceOperInfo().setExecuteStatus(ScheduleExecuteStatus.FAIL);
                    }
                } else {
                    ArrayList<Long> idList = new ArrayList<Long>(idSet);
                    ScheduleExecuteStatus scheduleExecuteStatus = this.exeOperation(idList, scheduleSchemaId, count, execstartdate, exceOperInfo, this.getBatchSize(exceOperInfo));
                    this.ctx.getSchemeExecInfo().getExceOperInfo().setExecuteStatus(scheduleExecuteStatus);
                    this.ctx.getSchemeExecInfo().setExecuteStatus(scheduleExecuteStatus);
                }
                logger.info("\u4efb\u52a1\u8c03\u5ea6\u4e3b\u7ebf\u7a0b\u8fd0\u884c\u5b8c\u6210");
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected OperationResult invokeOperation(Object[] ids, OperateOption option) {
        ScheduleExceOperInfo exceOperInfo = this.ctx.getSchemeExecInfo().getExceOperInfo();
        return OperationServiceHelper.executeOperate((String)exceOperInfo.getOper(), (String)exceOperInfo.getBussiness(), (Object[])ids, (OperateOption)option);
    }

    private Future<ScheduleExecuteStatus> mutiThreadExecOperation(Long scheduleSchemaId, int count, Date execstartdate, ScheduleExceOperInfo exceOperInfo, ScheduleOperationExecute execPlan, List<Long> newList, int pointsDataLimit, Object syncObj, Long sumLogId) {
        class OperationRunnable
        implements Callable {
            private Long scheduleSchemaId;
            private int count;
            private Date execstartdate;
            private ScheduleExceOperInfo exceOperInfo;
            private List<Long> newList;
            private int pointsDataLimit;
            private ScheduleOperationExecute execPlan;
            private final Object syncObj;
            private Long sumLogId;

            public OperationRunnable(Long scheduleSchemaId, int count, Date execstartdate, ScheduleExceOperInfo exceOperInfo, List<Long> newList, int pointsDataLimit, ScheduleOperationExecute execPlan, Object syncObj, Long sumLogId) {
                this.scheduleSchemaId = scheduleSchemaId;
                this.count = count;
                this.execstartdate = execstartdate;
                this.exceOperInfo = exceOperInfo;
                this.newList = newList;
                this.pointsDataLimit = pointsDataLimit;
                this.execPlan = execPlan;
                this.syncObj = syncObj;
                this.sumLogId = sumLogId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ScheduleExecuteStatus call() {
                ScheduleExecuteStatus executeStatus = ScheduleExecuteStatus.SUCCESS;
                try {
                    RequestContext.get().setTraceId(ScheduleOperationExecute.this.ctx.getTraceId());
                    logger.info("\u4efb\u52a1\u8c03\u5ea6\u8fdb\u5165\u5355\u4e2a\u7ebf\u7a0b\u8c03\u5ea6:{};traceId:{}", (Object)this.scheduleSchemaId, (Object)ScheduleOperationExecute.this.ctx.getTraceId());
                    long startTime = System.currentTimeMillis();
                    executeStatus = ScheduleOperationExecute.this.exeOperation(this.newList, this.scheduleSchemaId, this.count, this.execstartdate, this.exceOperInfo, this.pointsDataLimit);
                    logger.info("\u4efb\u52a1\u8c03\u5ea6\u8fdb\u884c\u7684\u7ebf\u7a0b\u6570:{}", (Object)this.execPlan.processThreadCount);
                    logger.info("\u4efb\u52a1\u8c03\u5ea6\u5b8c\u6210\u5355\u4e2a\u7ebf\u7a0b\u8c03\u5ea6: {};\u8017\u65f6:{}ms", (Object)this.scheduleSchemaId, (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Exception e) {
                    logger.error("\u4efb\u52a1\u8c03\u5ea6\u5355\u4e2a\u7ebf\u7a0b\u53d1\u751f\u62a5\u9519:" + e);
                }
                finally {
                    this.execPlan.threadCountSub();
                    int halfThreads = 10;
                    if (this.execPlan.processThreadCount == halfThreads) {
                        Object object = this.syncObj;
                        synchronized (object) {
                            logger.info("\u4efb\u52a1\u8c03\u5ea6\u4e3b\u7ebf\u7a0b\u5524\u9192");
                            this.syncObj.notifyAll();
                        }
                    }
                }
                return executeStatus;
            }
        }
        OperationRunnable runnable = new OperationRunnable(scheduleSchemaId, count, execstartdate, exceOperInfo, newList, pointsDataLimit, execPlan, syncObj, sumLogId);
        return threadPoolIntellPlan.submit((Callable)runnable);
    }

    protected ScheduleExecuteStatus exeOperation(List<Long> operAllData, long scheduleSchemaId, int count, Date execstartdate, ScheduleExceOperInfo exceOperInfo, int batchSize) {
        ScheduleExecuteStatus operstatus = ScheduleExecuteStatus.SUCCESS;
        StringBuffer errorMessage = new StringBuffer();
        List processObj = null;
        logger.info("\u6279\u91cf\u6267\u884c\uff1ascheduleSchemaId\uff1a{}, batchSize: {}", (Object)scheduleSchemaId, (Object)batchSize);
        HashSet<ScheduleExecuteStatus> operStatusSet = new HashSet<ScheduleExecuteStatus>(3);
        for (int i = 0; i < operAllData.size(); ++i) {
            processObj = Optional.ofNullable(processObj).orElseGet(ArrayList::new);
            processObj.add(operAllData.get(i));
            if (processObj.size() != batchSize && i != operAllData.size() - 1) continue;
            operstatus = this.startExecOperation(scheduleSchemaId, count, execstartdate, errorMessage, processObj, false);
            processObj = null;
            operStatusSet.add(operstatus);
        }
        if (operStatusSet.contains((Object)ScheduleExecuteStatus.STOP)) {
            operstatus = ScheduleExecuteStatus.STOP;
        } else if (operStatusSet.contains((Object)ScheduleExecuteStatus.FAIL)) {
            operstatus = ScheduleExecuteStatus.FAIL;
        }
        exceOperInfo.setExecDetails(errorMessage.toString());
        return operstatus;
    }

    public synchronized void threadCountAdd() {
        ++this.processThreadCount;
    }

    public synchronized void threadCountSub() {
        --this.processThreadCount;
    }

    private int getBatchSize(ScheduleExceOperInfo exceOperInfo) {
        if (exceOperInfo.isSingle()) {
            return 1;
        }
        return exceOperInfo.getEachbatchsize();
    }
}

