/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.commitToBe.ctbservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.tmc.utils.commitToBe.AbstractCommitToBeService;
import kd.bos.ext.tmc.utils.commitToBe.enums.BillStatusEnum;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class PayBillCTBService
extends AbstractCommitToBeService {
    @Override
    protected String getOrgProp() {
        return "org";
    }

    @Override
    protected String getEntityTable() {
        return "T_CAS_PaymentBill";
    }

    @Override
    protected String getBillEntity() {
        return "cas_paybill";
    }

    @Override
    protected String getBankBillEntity() {
        return "bei_bankpaybill";
    }

    @Override
    protected String selectField() {
        return "bankpayingid,iscommitbe,billstatus,bankpaystatus,commitbetime,cashier,org";
    }

    @Override
    protected void rollback(List<Pair<Long, String>> rollbackPayBillIdList) {
        ArrayList<DynamicObject> rollbackPayBillList = new ArrayList<DynamicObject>(rollbackPayBillIdList.size());
        for (Pair<Long, String> result : rollbackPayBillIdList) {
            DynamicObject payBill = this.payBillList.stream().filter(o -> o.getPkValue().equals(result.getLeft())).findFirst().orElse(null);
            if (payBill == null) continue;
            payBill.set("bankpayingid", null);
            payBill.set("iscommitbe", (Object)"0");
            payBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            payBill.set("bankpaystatus", null);
            payBill.set("commitbetime", null);
            payBill.set("cashier", null);
            rollbackPayBillList.add(payBill);
        }
        if (rollbackPayBillList.size() > 0) {
            try (TXHandle handle = TX.requiresNew();){
                try {
                    SaveServiceHelper.update((DynamicObject[])rollbackPayBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
        }
    }

    @Override
    protected void doSignSuccess(List<Object> successIdList) {
        Long payBillId;
        ArrayList<DynamicObject> successPayBillList = new ArrayList<DynamicObject>();
        for (Map.Entry entry : this.payBillToBankBillMap.entrySet()) {
            payBillId = null;
            for (Object bankId : successIdList) {
                if (!((Long)entry.getValue()).equals(bankId)) continue;
                payBillId = (Long)entry.getKey();
            }
            for (DynamicObject payBill : this.payBillList) {
                if (!payBill.getPkValue().equals(payBillId)) continue;
                successPayBillList.add(payBill);
            }
        }
        for (DynamicObject payBill : successPayBillList) {
            payBillId = (Long)payBill.getPkValue();
            payBill.set("bankpayingid", this.payBillToBankBillMap.get(payBillId));
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SaveServiceHelper.update((DynamicObject[])successPayBillList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                handle.markRollback();
                throw e;
            }
        }
    }
}

