/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.operation.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CostCenterFillOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(CostCenterFillOpAction.class);
    private static final Integer BATCH_SIZE = 500;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block8: {
            DynamicObject[] dataEntities = e.getDataEntities();
            try {
                String entityName;
                Map<String, List<Pair<String, String>>> result;
                if (dataEntities == null || dataEntities.length <= 0 || (result = this.callCostCenterConfig(entityName = dataEntities[0].getDataEntityType().getName(), 0L)) == null || result.isEmpty()) break block8;
                Date date = new Date();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
                String versionControl = mainEntityType.getVersionControl();
                for (Map.Entry<String, List<Pair<String, String>>> fillKeyMappingEntry : result.entrySet()) {
                    String fillKey = fillKeyMappingEntry.getKey();
                    if (StringUtils.isEmpty((CharSequence)fillKey)) continue;
                    List<List<DynamicObject>> splitList = this.splitArray(dataEntities);
                    for (List<DynamicObject> batchDataEntities : splitList) {
                        logger.info("\u5f85\u586b\u5145\u5b57\u6bb5:{}\u672c\u6279\u6570\u636e\u5305\u4e2a\u6570:{}", (Object)fillKey, (Object)batchDataEntities.size());
                        if (!this.checkNeedFill(fillKey, batchDataEntities).booleanValue()) continue;
                        logger.info("\u6570\u636e\u5305\u68c0\u67e5\u7ed3\u679c\u9700\u8981\u586b\u5145");
                        ArrayList<Pair<List<List<Pair<Long, String>>>, Date>> batchData = new ArrayList<Pair<List<List<Pair<Long, String>>>, Date>>(dataEntities.length);
                        for (DynamicObject dataEntity : batchDataEntities) {
                            List<List<Pair<Long, String>>> data = this.buildInterfaceParam(fillKeyMappingEntry.getValue(), dataEntity);
                            if (data.isEmpty()) continue;
                            try {
                                if (StringUtils.isNotBlank((CharSequence)versionControl)) {
                                    date = dataEntity.getDate(versionControl);
                                }
                            }
                            catch (Exception exception) {
                                logger.info("\u53d6\u7248\u672c\u63a7\u5236\u5b57\u6bb5\u62a5\u9519,entityName:{},\u7248\u672c\u63a7\u5236\u5b57\u6bb5\u540d\u79f0:{}", (Object)entityName, (Object)versionControl);
                            }
                            batchData.add((Pair<List<List<Pair<Long, String>>>, Date>)Pair.of(data, (Object)date));
                        }
                        Map<String, Object> ccResult = this.callCostCenterMapping(batchData);
                        this.resolveInterfaceResult(ccResult, fillKey, batchDataEntities);
                    }
                }
            }
            catch (Exception exception) {
                logger.info("\u6210\u672c\u4e2d\u5fc3\u586b\u503c\u670d\u52a1\u51fa\u73b0\u9519\u8bef:{}", (Object)exception.getMessage());
            }
        }
    }

    private List<List<DynamicObject>> splitArray(DynamicObject[] dataEntities) {
        List<DynamicObject> dataEntityList = Arrays.asList(dataEntities);
        return ListUtils.partition(dataEntityList, (int)BATCH_SIZE);
    }

    private void resolveInterfaceResult(Map<String, Object> ccResult, String fillKey, List<DynamicObject> dataEntityList) {
        if (ccResult != null && !ccResult.isEmpty()) {
            boolean success = (Boolean)ccResult.get("success");
            if (success) {
                Object values = ccResult.get("data");
                if (values != null) {
                    if (values instanceof List) {
                        List idCcIdNameList = (List)values;
                        this.fillCostCenterVal(fillKey, idCcIdNameList, dataEntityList);
                    } else {
                        logger.info("\u8fd4\u56de\u503c\u7c7b\u578b\u4e0d\u6b63\u786e");
                    }
                }
            } else {
                logger.info(String.valueOf(ccResult.get("message")));
            }
        }
    }

    private List<List<Pair<Long, String>>> buildInterfaceParam(List<Pair<String, String>> value, DynamicObject dataEntity) {
        ArrayList<List<Pair<Long, String>>> data = new ArrayList<List<Pair<Long, String>>>();
        for (Pair<String, String> mapping : value) {
            String sourceKey = (String)mapping.getKey();
            if (StringUtils.isEmpty((CharSequence)sourceKey)) continue;
            String sourceType = (String)mapping.getValue();
            String[] sourceKeyArray = StringUtils.split((String)sourceKey, (String)".");
            List<List<Pair<Long, String>>> configData = this.prepareMappingParam(sourceKeyArray, sourceType, dataEntity);
            if (configData.isEmpty()) continue;
            data.addAll(configData);
        }
        return data;
    }

    private Boolean checkNeedFill(String fillKey, List<DynamicObject> batchDataEntities) {
        String[] fillKeyArray = StringUtils.split((String)fillKey, (String)".");
        for (DynamicObject dataEntity : batchDataEntities) {
            if (fillKeyArray == null) continue;
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            dynamicObjectCollection.add((Object)dataEntity);
            ArrayList<DynamicObjectCollection> allData = new ArrayList<DynamicObjectCollection>();
            allData.add(dynamicObjectCollection);
            for (int i = 0; i < fillKeyArray.length; ++i) {
                if (i != fillKeyArray.length - 1) {
                    ArrayList<DynamicObjectCollection> temp = new ArrayList<DynamicObjectCollection>();
                    for (DynamicObjectCollection collection : allData) {
                        for (DynamicObject dynamicObject : collection) {
                            temp.add(dynamicObject.getDynamicObjectCollection(fillKeyArray[i]));
                        }
                    }
                    allData = temp;
                    continue;
                }
                for (DynamicObjectCollection collection : allData) {
                    for (DynamicObject dynamicObject : collection) {
                        Object object = dynamicObject.get(fillKeyArray[i]);
                        if (object != null) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Map<String, List<Pair<String, String>>> callCostCenterConfig(String entityName, Long billType) {
        Map<String, List<Object>> result = new HashMap<String, List<Pair<String, String>>>(8);
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"CostCenterService", (String)"getMappingFieldByEntity", (Object[])new Object[]{entityName, billType});
        }
        catch (Exception e) {
            logger.info("\u8c03\u7528\u6210\u672c\u4e2d\u5fc3\u63a5\u53e3\u53d6\u6210\u672c\u4e2d\u5fc3\u53d6\u503c\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)e);
        }
        return result;
    }

    public Map<String, Object> callCostCenterMapping(List<Pair<List<List<Pair<Long, String>>>, Date>> data) {
        Map<String, Object> ccResult = new HashMap<String, Object>(8);
        try {
            ccResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"CostCenterService", (String)"getCostCenterByMappingParam", (Object[])new Object[]{data});
        }
        catch (Exception exception) {
            logger.info("\u8c03\u7528\u6210\u672c\u4e2d\u5fc3\u63a5\u53e3\u53d6\u6210\u672c\u4e2d\u5fc3\u53d6\u503c\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)exception);
        }
        return ccResult;
    }

    public List<List<Pair<Long, String>>> prepareMappingParam(String[] sourceKeyArray, String sourceType, DynamicObject dataEntity) {
        ArrayList<List<Pair<Long, String>>> configData = new ArrayList<List<Pair<Long, String>>>();
        if (sourceKeyArray != null && sourceKeyArray.length > 0) {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            dynamicObjectCollection.add((Object)dataEntity);
            ArrayList<DynamicObjectCollection> allData = new ArrayList<DynamicObjectCollection>();
            allData.add(dynamicObjectCollection);
            for (int i = 0; i < sourceKeyArray.length; ++i) {
                if (i != sourceKeyArray.length - 1) {
                    ArrayList<DynamicObjectCollection> temp = new ArrayList<DynamicObjectCollection>();
                    for (DynamicObjectCollection collection : allData) {
                        for (DynamicObject dynamicObject : collection) {
                            temp.add(dynamicObject.getDynamicObjectCollection(sourceKeyArray[i]));
                        }
                    }
                    allData = temp;
                    continue;
                }
                if (allData == null || allData.size() <= 0) continue;
                for (DynamicObjectCollection collection : allData) {
                    for (DynamicObject dynamicObject : collection) {
                        ArrayList<Pair> entryVal = new ArrayList<Pair>();
                        Object singleData = dynamicObject.get(sourceKeyArray[i]);
                        if (singleData instanceof Long) {
                            entryVal.add(Pair.of((Object)((Long)singleData), (Object)sourceType));
                        } else if (singleData instanceof DynamicObject) {
                            entryVal.add(Pair.of((Object)((DynamicObject)singleData).getLong("id"), (Object)sourceType));
                        }
                        configData.add(entryVal);
                    }
                }
            }
        }
        return configData;
    }

    private void fillCostCenterVal(String fillKey, List<List<Pair<Long, String>>> idCcIdNamesList, List<DynamicObject> dataEntities) {
        for (int k = 0; k < dataEntities.size(); ++k) {
            DynamicObject dataEntity = dataEntities.get(k);
            if (k < idCcIdNamesList.size()) {
                List<Pair<Long, String>> valList = idCcIdNamesList.get(k);
                String[] fillKeyArray = StringUtils.split((String)fillKey, (String)".");
                if (fillKeyArray == null) continue;
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                dynamicObjectCollection.add((Object)dataEntity);
                ArrayList<DynamicObjectCollection> allData = new ArrayList<DynamicObjectCollection>();
                allData.add(dynamicObjectCollection);
                for (int i = 0; i < fillKeyArray.length; ++i) {
                    if (i != fillKeyArray.length - 1) {
                        ArrayList<DynamicObjectCollection> temp = new ArrayList<DynamicObjectCollection>();
                        for (DynamicObjectCollection collection : allData) {
                            for (DynamicObject dynamicObject : collection) {
                                temp.add(dynamicObject.getDynamicObjectCollection(fillKeyArray[i]));
                            }
                        }
                        allData = temp;
                        continue;
                    }
                    for (DynamicObjectCollection collection : allData) {
                        for (int j = 0; j < collection.size(); ++j) {
                            Object target;
                            DynamicObject costCenter;
                            Pair<Long, String> idName;
                            if (j < valList.size()) {
                                idName = valList.get(j);
                                costCenter = BusinessDataServiceHelper.newDynamicObject((String)"bos_costcenter");
                                costCenter.set("id", idName.getKey());
                                costCenter.set("name", idName.getValue());
                                target = ((DynamicObject)collection.get(j)).get(fillKeyArray[i]);
                                if (idName.getKey() == null || Long.parseLong(String.valueOf(idName.getKey())) == 0L || target != null || ((DynamicObject)collection.get(j)).getDynamicObject(fillKeyArray[i]) != null) continue;
                                ((DynamicObject)collection.get(j)).set(fillKeyArray[i], (Object)costCenter);
                                continue;
                            }
                            idName = valList.get(valList.size() - 1);
                            costCenter = BusinessDataServiceHelper.newDynamicObject((String)"bos_costcenter");
                            costCenter.set("id", idName.getKey());
                            costCenter.set("name", idName.getValue());
                            target = ((DynamicObject)collection.get(j)).get(fillKeyArray[i]);
                            if (idName.getKey() == null || Long.parseLong(String.valueOf(idName.getKey())) == 0L || target != null || ((DynamicObject)collection.get(j)).getDynamicObject(fillKeyArray[i]) != null) continue;
                            ((DynamicObject)collection.get(j)).set(fillKeyArray[i], (Object)costCenter);
                        }
                    }
                }
                continue;
            }
            logger.info("\u8fd4\u56de\u5f85\u586b\u5145\u7684\u6570\u7ec4\u957f\u5ea6\u4e0e\u5f85\u586b\u5145\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4");
        }
    }
}

