package kd.bos.ext.taxc.vo;

import java.math.BigDecimal;

/**
 * @ClassName: TaxLineVo
 * @Description: 税行
 * @author: linhd
 * @create: 2021-03-30 14:28
 **/
public class TaxLineVo {
    /**
     *  税种
     */
    private Long taxType;
    /**
     * 税码
     */
    private Long taxCode;
    /**
     * 税率
     */
    private Long taxRate;

    /**
     * 税率(%)
     */
    private BigDecimal taxRatePercent;

    /**
     * 抵消标识
     */
    private String offsetLogo;

    /**
     * 优先级
     */
    private Integer order;

    /**
     * 默认税码标识
     */
    private Integer defaultTaxCode;

    public TaxLineVo() {
    }

    public TaxLineVo(Long taxType, Long taxCode, Long taxRate, BigDecimal taxRatePercent, String offsetLogo, Integer order, Integer defaultTaxCode) {
        this.taxType = taxType;
        this.taxCode = taxCode;
        this.taxRate = taxRate;
        this.taxRatePercent = taxRatePercent;
        this.offsetLogo = offsetLogo;
        this.order = order;
        this.defaultTaxCode = defaultTaxCode;
    }

    public Integer getDefaultTaxCode() {
        return defaultTaxCode;
    }

    public void setDefaultTaxCode(Integer defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
    }

    public Long getTaxType() {
        return taxType;
    }

    public void setTaxType(Long taxType) {
        this.taxType = taxType;
    }

    public Long getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(Long taxCode) {
        this.taxCode = taxCode;
    }

    public Long getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Long taxRate) {
        this.taxRate = taxRate;
    }

    public String getOffsetLogo() {
        return offsetLogo;
    }

    public void setOffsetLogo(String offsetLogo) {
        this.offsetLogo = offsetLogo;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public BigDecimal getTaxRatePercent() {
        return taxRatePercent;
    }

    public void setTaxRatePercent(BigDecimal taxRatePercent) {
        this.taxRatePercent = taxRatePercent;
    }

    @Override
    public String toString() {
        return "TaxLineVo{" +
                "taxType=" + taxType +
                ", taxCode=" + taxCode +
                ", taxRate=" + taxRate +
                ", taxRatePercent=" + taxRatePercent +
                ", offsetLogo='" + offsetLogo + '\'' +
                ", order=" + order +
                ", defaultTaxCode=" + defaultTaxCode +
                '}';
    }
}
