package kd.bos.ext.imc.formplugin.operation.bizrule;

import java.util.EventObject;
import java.util.List;
import java.util.Map.Entry;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.imc.common.opration.OpConfigParam;
import kd.bos.ext.imc.formplugin.operation.InvoiceOPUtils;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;
import kd.bos.metadata.entity.operation.OpBizRuleElement;

public class SaveInvoiceConfigParamPlugin extends AbstractOpBizRuleParameterEdit {
	
	@Override
	public void afterCreateNewData(EventObject arg0) {
		OpBizRuleElement opbiz = this.getOpBizRule();
		if (opbiz != null && StringUtils.isNotBlank(opbiz.getParameter())) {
			JSONObject json = JSONObject.parseObject(opbiz.getParameter());
			this.getModel().getDataEntityType().getProperties();
			for (Entry<String, Object> entry : json.entrySet()) {
				IDataEntityProperty prop = this.getModel().getProperty(entry.getKey());
				if (prop != null && !(prop instanceof EntryProp)) {
					this.getModel().setValue((String) entry.getKey(), entry.getValue());
				}
			}
		}
		
		//初始化
		ComboEdit combo = getControl(OpConfigParam.CONFIG_INVOICEENTRY);
		List<ComboItem> items = Lists.newArrayList();
		JSONObject entryKeyCombo = new JSONObject();
		InvoiceOPUtils.billInfo(items, entryKeyCombo, getView());
		if(items == null || items.size() == 1) {
			
		}else {
			combo.setComboItems(items);
		}
		this.getPageCache().put(OpConfigParam.CONFIG_ENTRY_ENTRYKEY_CACHE, entryKeyCombo.toJSONString());
		//初始化分录
		String entryKey = (String)this.getModel().getValue(OpConfigParam.CONFIG_INVOICEENTRY);
		if(StringUtils.isBlank(entryKey)) {
			//隐藏分录
			this.getView().setVisible(Boolean.FALSE, "adv_entry");
		}else{
			InvoiceOPUtils.refreshKeyEntry(getView(), entryKey);
			if (opbiz != null && StringUtils.isNotBlank(opbiz.getParameter())) {
				JSONObject json = JSONObject.parseObject(opbiz.getParameter());
				//处理分录
				JSONArray jsonArr = json.getJSONArray("entryentity");
				if(jsonArr != null && !jsonArr.isEmpty()) {
					this.getModel().batchCreateNewEntryRow("entryentity", jsonArr.size());
					for (int i = 0; i < jsonArr.size(); i++) {
						JSONObject entryInfo = (JSONObject)jsonArr.get(i);
						this.getModel().setValue("entrykey", entryInfo.get("entrykey"), entryInfo.getIntValue("index"));
						this.getModel().setValue("invoicekey", entryInfo.get("invoicekey"), entryInfo.getIntValue("index"));
					}
				}
			}
		}
	}
	
	@Override
	public void propertyChanged(PropertyChangedArgs e) {
		String key = e.getProperty().getName();
		switch (key) {
		case OpConfigParam.CONFIG_INVOICEENTRY:
			String value = (String)e.getChangeSet()[0].getNewValue();
			if(StringUtils.isBlank(value)) {
				//显示分录
				this.getView().setVisible(Boolean.FALSE, "adv_entry");
				return;
			}
			//显示分录
			this.getView().setVisible(Boolean.TRUE, "adv_entry");
			getModel().deleteEntryData(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
			InvoiceOPUtils.refreshKeyEntry(getView(), value);
			break;
		default:
			break;
		}
	}
	
	@Override
	public String getParameter() {
		DynamicObject entity = this.getModel().getDataEntity(true);
		JSONObject param = new JSONObject();
		if(entity.getDynamicObject("bill_type") != null) {
			param.put("bill_type", entity.getDynamicObject("bill_type").getLong("id"));
		}
		if(StringUtils.isNotBlank(entity.getString("bill_no"))) {
			param.put("bill_no", entity.getString("bill_no"));
		}
		if(StringUtils.isNotBlank(entity.getString("bill_id"))) {
			param.put("bill_id", entity.getString("bill_id"));
		}
		if(StringUtils.isNotBlank(entity.getString("entity_id"))) {
			param.put("entity_id", entity.getString("entity_id"));
		}
		if(StringUtils.isNotBlank(entity.getString("org_id"))) {
			param.put("org_id", entity.getString("org_id"));
		}
		
		if(StringUtils.isNotBlank(entity.getString("bill_user"))) {
			param.put("bill_user", entity.getString("bill_user"));
		}
		if(entity.getBoolean("verify_flag")) {
			param.put("verify_flag", "1");
		}else {
			param.put("verify_flag", "0");
		}
		if(entity.getBoolean("only_print")) {
			param.put("only_print", "1");
		}else {
			param.put("only_print", "0");
		}
		if(entity.getBoolean(InvoiceOpParamContant.UPDATEATTACHRELATION)) {
			param.put(InvoiceOpParamContant.UPDATEATTACHRELATION, "1");
		}else {
			param.put(InvoiceOpParamContant.UPDATEATTACHRELATION, "0");
		}
		if(StringUtils.isNotBlank(entity.getString("attachpanelkey"))) {
			param.put("attachpanelkey", entity.getString("attachpanelkey"));
		}
		if(StringUtils.isNotBlank(entity.getString("status"))) {
			param.put("status", entity.getString("status"));
		}
		if(StringUtils.isNotBlank(entity.getString("invoiceentry"))) {
			param.put("invoiceentry", entity.getString("invoiceentry"));
		}
		if(StringUtils.isNotBlank(entity.getString("print"))) {
			param.put("print", entity.getString("print"));
		}
		if(StringUtils.isNotBlank(entity.getString("bill_company"))) {
			param.put("bill_company", entity.getString("bill_company"));
		}
		if(StringUtils.isNotBlank(entity.getString("bill_imageno"))) {
			param.put("bill_imageno", entity.getString("bill_imageno"));
		}
		DynamicObjectCollection entryKeyColl = entity.getDynamicObjectCollection("entryentity");
		JSONArray relectInfo = new JSONArray();
		for (int i = 0; i < entryKeyColl.size(); i++) {
			DynamicObject entry = entryKeyColl.get(i);
			JSONObject info = new JSONObject();
			relectInfo.add(info);
			info.put("entrykey", entry.get("entrykey"));
			info.put("invoicekey", entry.get("invoicekey"));
			info.put("index", i);
		}
		if(!relectInfo.isEmpty()) {
			param.put("entryentity", relectInfo);
		}
		return param.toJSONString();
	}
}
