package kd.bos.ext.imc.operation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import com.google.common.collect.Sets;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ShowInvoiceOperate extends AbstractInvoiceFormOperate {

	@Override
	List<String> getCustomConfigParam() {
		return Lists.newArrayList(InvoiceOpParamContant.BILLID, InvoiceOpParamContant.ENTITYID
				, InvoiceOpParamContant.SERIAL, InvoiceOpParamContant.RELEVANCE_EXPENSE_ID);
	}
	
	@Override
	void setPageInfo(FormShowParameter param) { 
		if(this.getView() instanceof IMobileView) {
			param.getOpenStyle().setShowType(ShowType.Floating);
			param.setFormId(InvoiceOpParamContant.RIM_INVOICE_LIST_MOBILE);
		}else {
			param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
			param.setFormId(InvoiceOpParamContant.RIM_VIEW_INVOICE);
		}
	}

	@Override
	protected void extConfig(Map<String, Object> configParam, JSONObject param) {
		super.extConfig(configParam, param);
		if(StringUtils.isBlank(configParam.get("relevanceExpenseId"))){
			String targetEntityId = param.getString("target_entity_id");
			long billId = Long.parseLong((String)configParam.get("billId"));
			Set<Long> ids = Sets.newHashSet();
			if(StringUtils.equals("1",param.getString("tar_flag"))){
				Map<String, HashSet<Long>> targetBills = BFTrackerServiceHelper.findTargetBills((String) configParam.get("entityId"), new Long[]{billId });
				if(StringUtils.isNotBlank(targetEntityId)){
					HashSet<Long> longs = targetBills.get(targetEntityId);
					if(longs != null){
						ids.addAll(longs);
					}
				}
			}
			if(StringUtils.equals("1",param.getString("src_flag"))){
				Map<String, HashSet<Long>> sourceBills = BFTrackerServiceHelper.findSourceBills((String) configParam.get("entityId"), new Long[]{billId});
				if(StringUtils.isNotBlank(targetEntityId)){
					HashSet<Long> longs = sourceBills.get(targetEntityId);
					if(longs != null){
						ids.addAll(longs);
					}
				}
			}
			String relevanceExpenseId = ids.stream().map(v -> Long.toString(v)).collect(Collectors.joining(","));
			configParam.put("relevanceExpenseId",relevanceExpenseId);
		}
	}

	@Override
	protected void extCustom(Map<String, Object> customParams, Map<String, Object> configParam) {
		//首先检查是否在操作中传递参数
		Map<String, String> opVariables = this.getOption().getVariables();
		String serials = opVariables.get(InvoiceOpParamContant.SERIAL);
		List<String> serialList = Lists.newArrayList();
		if(serials != null) {
			if(serials.indexOf(",") != -1) {
				serialList.addAll(Arrays.stream(serials.split(",")).collect(Collectors.toList()));
			}else {
				serialList.add(serials);
			}
		}else {
			String serialKey = (String)configParam.get(InvoiceOpParamContant.SERIAL);
			if(serialKey != null) {
				int index = serialKey.lastIndexOf(".");
				if(index != -1) {
					String entryKey = serialKey.substring(0,index);
					String realFieldKey = serialKey.substring(index+1);
					if(this.getView().getModel().getDataEntityType().getProperty(entryKey) == null) {
						if(this.getView().getModel().getDataEntityType().getProperty(realFieldKey) != null) {
							String headSerials = (String)this.getView().getModel().getValue(realFieldKey);
							if(headSerials.indexOf(",") != -1) {
								serialList.addAll(Arrays.stream(headSerials.split(",")).collect(Collectors.toList()));
							}else {
								serialList.add(headSerials);
							}
						}
					}else {
						DynamicObjectCollection entrys = this.getView().getModel().getEntryEntity(entryKey);
						for (DynamicObject entry : entrys) {
							serialList.add(entry.getString(realFieldKey));
						}
					}
				}
			}
		}
		if(!serialList.isEmpty()) {
			customParams.put(InvoiceOpParamContant.SERIAL, serialList);
		}
	}
}
