package kd.bos.ext.imc.operation.bizrule;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DelInvoiceAction extends AbstractOpBizRuleAction {
	private static Log logger = LogFactory.getLog(SaveInvoiceAction.class);
	
	@Override
	public void endOperationTransaction(EndOperationTransactionArgs e) {
		DynamicObject[] dataEntities = e.getDataEntities();
		String errorInfoFormat = ResManager.loadKDString("执行失败，原因：%s", "DelInvoiceAction_0", "bos-ext-imc");
		for (DynamicObject dataEntity : dataEntities) {
			try {
				excuteService(dataEntity);
			}catch(ImcRimInvoiceBizException e1) {
				String errorInfo = String.format(errorInfoFormat, e.getOperationKey(), e1.getMessage());
				logger.error(errorInfo, e1);
				throw new KDBizException(e1, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
			}catch (Exception e2) {
				String errorInfo = String.format(errorInfoFormat, e.getOperationKey(), e2.getMessage());
				logger.error(errorInfo, e2);
				throw new KDBizException(e2, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
			}
		}
	}
	
	private void excuteService(DynamicObject dataEntity) throws ImcRimInvoiceBizException {
		if(dataEntity.getPkValue() == null) {
			return;
		}
		
		//首先检查是否在操作中传递参数
 		Map<String, String> opVariables = this.getOption().getVariables();
		logger.info("【发票操作】传入参数：{}",opVariables);
		
		String entryId = opVariables.get("entityId");
		if(entryId == null) {
			entryId = dataEntity.getDynamicObjectType().getName();
		}
		String billId = opVariables.get("billId");
		if(billId == null) {
			billId = dataEntity.getPkValue().toString();
		}
		
		//获取初始化参数信息
		Map<String, Object> param = Maps.newHashMapWithExpectedSize(8);
		param.put("entityId", entryId);
		param.put("billId", billId);
		
		logger.info("更新发票云状态，请求参数：{}", JSON.toJSONString(param));
		JSONObject result = DispatchServiceHelper.invokeBizService("imc", "rim", "FpzsService", "delete", new Object[]{param});
		logger.info("更新发票云状态， 返回结果：{}", JSON.toJSONString(result));
		if(!StringUtils.equals((String)result.getString("errcode"), "0000")) {
			throw new ImcRimInvoiceBizException("保存发票关系失败，"+result.get("description")+"，请联系管理员");
		}
	}
}
