package kd.bos.ext.imc.operation.util;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

/**
 * @ClassName CacheHelper
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/25 17:06
 * @Version 1.0
 */
public class CacheHelper {
    private static Log logger = LogFactory.getLog(CacheHelper.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("imc");

    public static String getCachePrefix(){
        String fix= RequestContext.get().getTenantId() + '_' + RequestContext.get().getAccountId() + '_';
        return fix;
    }

    /**
     *
     * @param key
     * @param content
     * @param timeOut 单位是秒
     */
    public static void put(String key, String content, int timeOut) {
        cache.put(getCachePrefix() + key, content, timeOut);
    }

    public static void put(String key, String content) {
        cache.put(getCachePrefix() + key, content);
    }

    public static String get(String key) {
        String cacheKey = getCachePrefix() + key;
        logger.info("rim缓存key:{}",cacheKey);
        return cache.get(cacheKey);
    }

    public static void remove(String key) {
        cache.remove(getCachePrefix() + key);
    }
}
