/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import kd.bos.bal.business.core.BalRepairManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

public class BalCheckTaskConsumer
implements MessageConsumer,
Runnable {
    private Object taskMsg;

    private String getTaskKey(DynamicObject taskInfo) {
        String taskType = taskInfo.getString("parenttask.tasktype");
        String seqInfo = taskInfo.getString("sparseseq.id") + "_" + taskInfo.getLong("fromid");
        String billId = taskInfo.getString("bill.id");
        String ruleId = taskInfo.getString("rule.id");
        switch (taskType) {
            case "A": 
            case "F": {
                return "A_" + seqInfo;
            }
            case "B": 
            case "G": {
                return "B_" + seqInfo + "_" + ruleId;
            }
            case "D": 
            case "I": {
                return "D_" + seqInfo + "_" + billId;
            }
            case "C": 
            case "H": {
                return "C_" + seqInfo;
            }
            case "J": {
                return "E_" + seqInfo + "_" + ruleId;
            }
            case "E": {
                return "F_" + seqInfo;
            }
        }
        throw new KDBizException("taskType: " + taskType + " not support");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        block95: {
            DynamicObject taskInfo;
            block93: {
                TaskMsg msg;
                block89: {
                    block90: {
                        block86: {
                            block87: {
                                taskInfo = null;
                                if (param instanceof TaskMsg) break block86;
                                if (acker == null) break block87;
                                acker.ack(messageId);
                            }
                            if (taskInfo != null) {
                                try (TXHandle tx = TX.requiresNew();){
                                    taskInfo.set("runstatus", (Object)"2");
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                                }
                            }
                            return;
                        }
                        msg = (TaskMsg)param;
                        taskInfo = BusinessDataServiceHelper.loadSingle((Object)msg.getTaskId(), (String)"bal_check_repair_task");
                        if (taskInfo != null) break block89;
                        BalLogUtil.info("TaskMsg not exsist:" + param, new Object[0]);
                        if (acker == null) break block90;
                        acker.ack(messageId);
                    }
                    if (taskInfo != null) {
                        try (TXHandle tx = TX.requiresNew();){
                            taskInfo.set("runstatus", (Object)"2");
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                        }
                    }
                    return;
                }
                try {
                    String ponitKey = this.getTaskKey(taskInfo);
                    String lockKey = "bal_" + ponitKey;
                    try (DLock lock = DLock.create((String)lockKey);){
                        if (lock.tryLock()) {
                            taskInfo.set("tasktraceid", (Object)TraceIdUtil.getCurrentTraceIdString());
                            taskInfo.set("errormsg_tag", null);
                            taskInfo.set("param_tag", null);
                            this.setPointKey(taskInfo, ponitKey);
                            BalRepairManager.handleRepairTaskMsg(taskInfo, msg);
                        } else {
                            String errorMsg = ResManager.loadKDString((String)"DLock={0}\u83b7\u53d6\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u88ab\u4ed6\u4eba\u53d1\u8d77\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u5237\u65b0\u7ed3\u679c\u6216\u51e0\u5206\u949f\u540e\u91cd\u8bd5\u3002", (String)"BalCheckTaskConsumer_1", (String)"bos-biz-balance", (Object[])new Object[]{lockKey});
                            taskInfo.set("errormsg_tag", (Object)errorMsg);
                            taskInfo.set("status", (Object)"E");
                            BalLogUtil.info("BalCheckTaskConsumer getlock faild : " + lockKey, new Object[0]);
                        }
                    }
                    if (acker == null) break block93;
                }
                catch (Throwable e) {
                    block94: {
                        try {
                            BalLogUtil.error("BalCheckTaskConsumer.onMessage error", e);
                            if (taskInfo != null) {
                                taskInfo.set("status", (Object)"E");
                                taskInfo.set("errormsg_tag", (Object)BalLogUtil.parseMsg(e, 1600));
                            }
                            if (acker == null) break block94;
                        }
                        catch (Throwable throwable) {
                            if (acker != null) {
                                acker.ack(messageId);
                            }
                            if (taskInfo != null) {
                                try (TXHandle tx = TX.requiresNew();){
                                    taskInfo.set("runstatus", (Object)"2");
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                                }
                            }
                            throw throwable;
                        }
                        acker.ack(messageId);
                    }
                    if (taskInfo == null) break block95;
                    try (TXHandle tx = TX.requiresNew();){
                        taskInfo.set("runstatus", (Object)"2");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                        break block95;
                    }
                }
                acker.ack(messageId);
            }
            if (taskInfo != null) {
                try (TXHandle tx = TX.requiresNew();){
                    taskInfo.set("runstatus", (Object)"2");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
                }
            }
        }
    }

    private void setPointKey(DynamicObject taskInfo, String key) {
        String opRange = taskInfo.getString("parenttask.oprange");
        if ("A".equals(opRange)) {
            taskInfo.set("pointkey", (Object)key);
        }
    }

    public BalCheckTaskConsumer() {
    }

    public BalCheckTaskConsumer(Object taskMsg) {
        this.taskMsg = taskMsg;
    }

    @Override
    public void run() {
        BalLogUtil.info("BalCheckTaskConsumer.mockMsg start", new Object[0]);
        this.onMessage(this.taskMsg, "", true, null);
    }
}

