/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import kd.bos.bal.business.consumer.BalMsgUtil;
import kd.bos.bal.business.consumer.BalSemaphore;
import kd.bos.bal.business.consumer.TxMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class BalTxUpdateConsumer
implements MessageConsumer,
Runnable {
    private Object jsonMsg;

    private TxMsg buildTxMsg(Object param) {
        if (param instanceof String) {
            try {
                JSONObject json = JSON.parseObject((String)((String)param));
                DBRoute db = DBRoute.of((String)json.getString("db"));
                String[] idStrs = json.getString("txs").split(",");
                HashSet<Long> allTxs = new HashSet<Long>(100);
                for (String idStr : idStrs) {
                    allTxs.add(Long.valueOf(idStr));
                }
                BalanceTB bal = BalanceTB.getBalanceTB(json.getString("bal"));
                return new TxMsg(bal, db, allTxs);
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalTxUpdateConsumer", String.valueOf(param), "buildTxMsg", e);
            }
        } else {
            BalLogUtil.info("BalTxUpdateConsumer.collectTxs illegal param = " + (param == null ? "null" : param.getClass().getName()), new Object[0]);
        }
        return null;
    }

    public BalTxUpdateConsumer() {
    }

    public BalTxUpdateConsumer(Object jsonMsg) {
        this.jsonMsg = jsonMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        boolean applied = false;
        try {
            BalLogUtil.info("BalTxUpdateConsumer.onMessage start: " + param, new Object[0]);
            TxMsg txMsg = this.buildTxMsg(param);
            if (txMsg == null) {
                return;
            }
            applied = this.applyHandle(txMsg);
            if (acker != null && !applied) {
                BalMsgUtil.rePublish(param, "bal.tx_update");
            }
            BalLogUtil.info("BalTxUpdateConsumer.onMessage end, applied = " + applied, new Object[0]);
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxUpdateConsumer", "applied = " + applied + ", param = " + param, "onMessage", e);
        }
        finally {
            if (acker != null) {
                acker.ack(messageId);
            }
        }
    }

    private boolean applyHandle(TxMsg txMsg) {
        String balName = txMsg.bal.getName();
        int semaphoreLimit = BalConfig.loadBalConfig(balName).getTxMsgSemaphore();
        String semaphoreKey = RequestContext.getOrCreate().getAccountId() + "_TxMsg_" + balName;
        try (BalSemaphore semaphore = BalMsgUtil.getOrCreate(semaphoreKey);){
            if (semaphore.acquire(semaphoreLimit)) {
                this.tryHandleTxMsg(txMsg);
                boolean bl = true;
                return bl;
            }
            BalLogUtil.warn("BalTxUpdateConsumer.applyHandle over limit: semaphoreKey={}, current={}, limit={} ", semaphoreKey, semaphore.getCurrentCount(), semaphoreLimit);
        }
        return false;
    }

    private void tryHandleTxMsg(TxMsg txMsg) {
        try {
            BalEngineUtil.handleTxMsg(txMsg);
        }
        catch (Throwable e) {
            if (BalLogUtil.isDeadkLockError(e)) {
                BalLogUtil.error("BalTxUpdateConsumer has DeadLock : auto retry", e);
                BalEngineUtil.handleTxMsg(txMsg);
            }
            throw e;
        }
    }

    @Override
    public void run() {
        BalLogUtil.info("BalTxUpdateConsumer.run start", new Object[0]);
        this.onMessage(this.jsonMsg, "", true, null);
    }
}

