/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.StringUtils;

class BalKeyHandle {
    BalKeyHandle() {
    }

    static void reSetKey(BalanceTB balanceTb) {
        BalLogUtil.info("BalKeyHandle.reSetKey start", new Object[0]);
        List<String> keyCols = balanceTb.getKeyCols();
        StringBuilder cols = new StringBuilder();
        cols.append("id");
        cols.append(',').append("keycol");
        cols.append(',').append(StringUtils.join(keyCols, (String)","));
        HashSet<Long> deleteId = new HashSet<Long>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object[]> spParams = new ArrayList<Object[]>();
        try (DataSet balanceData = QueryServiceHelper.queryDataSet((String)BalKeyHandle.class.getName(), (String)balanceTb.getName(), (String)cols.toString(), null, null);){
            String key = null;
            String oldKey = null;
            HashSet<String> exsistKey = new HashSet<String>();
            Long id = null;
            boolean addSuccess = true;
            for (Row row : balanceData) {
                key = BalKeyHandle.calKeyStr(row, keyCols);
                oldKey = row.getString("keycol");
                id = row.getLong("id");
                addSuccess = exsistKey.add(key);
                if (addSuccess && !key.equals(oldKey)) {
                    params.add(new Object[]{key, id});
                    spParams.add(new Object[]{key, oldKey});
                    continue;
                }
                if (addSuccess) continue;
                deleteId.add(id);
            }
        }
        if (!deleteId.isEmpty()) {
            DeleteServiceHelper.delete((String)balanceTb.getName(), (QFilter[])new QFilter("id", "in", deleteId).toArray());
        }
        if (!params.isEmpty()) {
            StringBuilder updateSql = new StringBuilder(" UPDATE ");
            updateSql.append(balanceTb.getTb());
            updateSql.append(" SET ").append("fkeycol").append(" = ? WHERE ").append("fid").append(" = ? ");
            DB.executeBatch((DBRoute)balanceTb.getDbRoute(), (String)updateSql.toString(), params);
            updateSql = new StringBuilder(" UPDATE ");
            updateSql.append(balanceTb.getSnapshotTb());
            updateSql.append(" SET ").append("fkeycol").append(" = ? WHERE ").append("fkeycol").append(" = ? ");
            DB.executeBatch((DBRoute)balanceTb.getDbRoute(), (String)updateSql.toString(), spParams);
        }
    }

    static String calKeyStr(Row row, List<String> keyCols) {
        StringBuilder sb = new StringBuilder();
        for (String keyCol : keyCols) {
            Object value = row.get(keyCol);
            if (BalEngineUtil.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
        }
        return BalKeyHandle.getKeyStr(sb.toString());
    }

    static String getKeyStr(String message) {
        return BalKeyHandle.getSHA256Base64Str(message);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException(String.format("BalanceUtil:[%s] args:[%s]", e1.getMessage(), message));
        }
    }
}

